/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import java.io.IOException;
import java.io.InputStream;

class InputStreamImpl
extends InputStream {
    InputByteStream ibs;
    protected int mark = 0;

    public InputStreamImpl(InputByteStream inputByteStream) {
        this.ibs = inputByteStream;
    }

    public int available() throws IOException {
        return (int)(this.ibs.bytesAvailable() <= Integer.MAX_VALUE ? this.ibs.bytesAvailable() : Integer.MAX_VALUE);
    }

    public void mark(int n) {
        this.mark = n;
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        this.ibs.seek(this.mark);
    }

    public long skip(long l) throws IOException {
        l = Math.min(l, this.ibs.length());
        this.ibs.seek(this.ibs.getPosition() + l);
        return l;
    }

    public void close() throws IOException {
        if (this.ibs != null) {
            this.ibs.close();
            this.ibs = null;
        }
    }

    public int read() throws IOException {
        return this.ibs.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.ibs.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }
}

