/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayMap
implements Map {
    private ArrayList mKeys;
    private ArrayList mValues;
    private HashMap mKeysMapping;
    private int mCurIndex;

    public ArrayMap(int n) {
        this.mKeys = new ArrayList(n);
        this.mValues = new ArrayList(n);
        this.mKeysMapping = new HashMap(n * 2);
        this.mCurIndex = 0;
    }

    public ArrayMap() {
        this(100);
    }

    public int size() {
        return this.mCurIndex;
    }

    public void clear() {
        this.mCurIndex = 0;
        this.mKeys.clear();
        this.mValues.clear();
        this.mKeysMapping.clear();
    }

    public boolean isEmpty() {
        return this.mCurIndex == 0;
    }

    public boolean containsKey(Object object) {
        return this.mKeysMapping.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mValues.contains(object);
    }

    public Collection values() {
        return this.mValues;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return new ArrayEntrySet();
    }

    public Set keySet() {
        return new ArrayKeySet();
    }

    public Object get(Object object) {
        Integer n = (Integer)this.mKeysMapping.get(object);
        if (n == null) {
            return null;
        }
        return this.mValues.get(n);
    }

    public Object remove(Object object) {
        Integer n = (Integer)this.mKeysMapping.get(object);
        if (n == null) {
            return null;
        }
        Object e = this.mValues.get(n);
        this.mKeysMapping.remove(object);
        this.mKeys.remove(n);
        this.mValues.remove(n);
        --this.mCurIndex;
        for (int i = n.intValue(); i < this.mCurIndex; ++i) {
            this.mKeysMapping.put(this.mKeys.get(i), new Integer(i));
        }
        return e;
    }

    public Object put(Object object, Object object2) {
        Integer n = (Integer)this.mKeysMapping.get(object);
        Object var4_4 = null;
        if (n != null) {
            var4_4 = this.mValues.get(n);
            this.mValues.set(n, object2);
        } else {
            Integer n2 = new Integer(this.mCurIndex);
            this.mKeysMapping.put(object, n2);
            this.mKeys.add(this.mCurIndex, object);
            this.mValues.add(this.mCurIndex++, object2);
        }
        return var4_4;
    }

    private class ArrayEntrySet
    implements Set {
        ArrayEntrySet() {
        }

        public int size() {
            return ArrayMap.this.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        public Object[] toArray() {
            Object[] objectArray = new Object[ArrayMap.this.size()];
            for (int i = 0; i < ArrayMap.this.size(); ++i) {
                objectArray[i] = new Entry(i);
            }
            return objectArray;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Object object2 = ((Entry)object).getKey();
            Object object3 = ArrayMap.this.get(object2);
            if (object3 == null) {
                return false;
            }
            return ArrayMap.this.get(object3).equals(((Entry)object).getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Object object2 = ((Entry)object).getKey();
            if (!ArrayMap.this.containsKey(object2)) {
                return false;
            }
            ArrayMap.this.remove(object);
            return true;
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            if (collection == null) {
                return false;
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public Object[] toArray(Object[] objectArray) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator {
        int mPos = 0;

        EntryIterator() {
        }

        public boolean hasNext() {
            return this.mPos < ArrayMap.this.size();
        }

        public Object next() {
            return new Entry(this.mPos++);
        }

        public void remove() {
            if (this.mPos < 1) {
                throw new IllegalStateException();
            }
            Entry entry = new Entry(--this.mPos);
            Object object = entry.getKey();
            ArrayMap.this.remove(object);
        }
    }

    private class KeyIterator
    implements Iterator {
        int mPos = 0;

        KeyIterator() {
        }

        public boolean hasNext() {
            return this.mPos < ArrayMap.this.size();
        }

        public Object next() {
            return ArrayMap.this.mKeys.get(this.mPos++);
        }

        public void remove() {
            if (this.mPos < 1) {
                throw new IllegalStateException();
            }
            Object e = ArrayMap.this.mKeys.get(--this.mPos);
            ArrayMap.this.remove(e);
        }
    }

    private class ArrayKeySet
    implements Set {
        ArrayKeySet() {
        }

        public int size() {
            return ArrayMap.this.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        public Object[] toArray() {
            return ArrayMap.this.mKeys.toArray();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return ArrayMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            if (!ArrayMap.this.containsKey(object)) {
                return false;
            }
            ArrayMap.this.remove(object);
            return true;
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection collection) {
            return ArrayMap.this.mKeys.containsAll(collection);
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public Object[] toArray(Object[] objectArray) {
            return ArrayMap.this.mKeys.toArray(objectArray);
        }
    }

    public class Entry
    implements Map.Entry {
        int mMapPos;
        Object mKey;
        Object mValue;

        Entry(int n) {
            this.mMapPos = n;
            this.mKey = ArrayMap.this.mKeys.get(this.mMapPos);
            this.mValue = ArrayMap.this.mValues.get(this.mMapPos);
        }

        public Object getKey() {
            return this.mKey;
        }

        public Object getValue() {
            return this.mValue;
        }

        public Object setValue(Object object) {
            Object object2 = this.mValue;
            this.mValue = object;
            if (ArrayMap.this.containsKey(this.mKey)) {
                ArrayMap.this.put(this.mKey, object);
            }
            return object2;
        }
    }
}

