/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LazyRandomAccessFileByteWriter
implements ByteWriter {
    private File file;
    private ByteWriter byteWriter;
    private boolean openFailed = false;

    public LazyRandomAccessFileByteWriter(File file) throws IOException {
        if (file == null) {
            throw new IOException("File is not valid.");
        }
        this.file = file;
    }

    public int read(long l) throws IOException {
        return this.getByteWriter().read(l);
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        return this.getByteWriter().read(l, byArray, n, n2);
    }

    public long length() throws IOException {
        return this.getByteWriter().length();
    }

    public void close() throws IOException {
        if (this.byteWriter != null) {
            this.byteWriter.close();
        }
        this.byteWriter = null;
        this.file = null;
    }

    private ByteWriter getByteWriter() throws IOException {
        if (this.byteWriter != null) {
            return this.byteWriter;
        }
        if (this.openFailed) {
            throw new IOException("Unable to open file.");
        }
        try {
            RandomAccessFile randomAccessFile;
            try {
                randomAccessFile = new RandomAccessFile(this.file, "r");
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Unable to open the RandomAccessFile for the File " + this.file);
                iOException.initCause(exception);
                throw iOException;
            }
            this.byteWriter = new RandomAccessFileByteWriter(randomAccessFile);
        }
        catch (IOException iOException) {
            this.openFailed = true;
        }
        return this.byteWriter;
    }

    public void write(long l, int n) throws IOException {
        this.getByteWriter().write(l, n);
    }

    public void write(long l, byte[] byArray, int n, int n2) throws IOException {
        this.getByteWriter().write(l, byArray, n, n2);
    }

    public void flush() throws IOException {
        this.getByteWriter().flush();
    }
}

