/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class ByteBufferByteWriter
implements ByteWriter {
    private ByteBuffer buffer;

    public ByteBufferByteWriter(ByteBuffer byteBuffer) throws IOException {
        this.buffer = byteBuffer;
    }

    public ByteBufferByteWriter(byte[] byArray) throws IOException {
        this(ByteBuffer.wrap(byArray));
    }

    public void write(long l, byte[] byArray, int n, int n2) throws IOException {
        try {
            if (l > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Attempt to position beyond the buffer size.");
            }
            this.buffer.position((int)l);
            this.buffer.put(byArray, n, n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            IOException iOException = new IOException();
            iOException.initCause(bufferOverflowException);
            throw iOException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IOException iOException = new IOException();
            iOException.initCause(indexOutOfBoundsException);
            throw iOException;
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            IOException iOException = new IOException();
            iOException.initCause(readOnlyBufferException);
            throw iOException;
        }
    }

    public void write(long l, int n) throws IOException {
        try {
            if (l > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Attempt to position beyond the buffer size.");
            }
            this.buffer.put((int)l, (byte)n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            IOException iOException = new IOException();
            iOException.initCause(bufferOverflowException);
            throw iOException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IOException iOException = new IOException();
            iOException.initCause(indexOutOfBoundsException);
            throw iOException;
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            IOException iOException = new IOException();
            iOException.initCause(readOnlyBufferException);
            throw iOException;
        }
    }

    public long length() throws IOException {
        return this.buffer.limit();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public int read(long l) throws IOException {
        if (l < 0L || l >= (long)this.buffer.limit()) {
            return -1;
        }
        return this.buffer.get((int)l) & 0xFF;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        if (l < 0L || l >= (long)this.buffer.limit()) {
            return -1;
        }
        this.buffer.position((int)l);
        n2 = (int)Math.min((long)n2, (long)this.buffer.limit() - l);
        this.buffer.get(byArray, n, n2);
        return n2;
    }
}

