/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ByteArrayByteWriter
implements ByteWriter {
    private byte[] mCurBuffer;
    private ArrayList mBufferArray;
    private int mCurIndex;
    private int mCurBase;
    private int mCurTop;
    private int mLength;
    private static final int mMinBufSize = 32;
    private int mMinBufBit;
    private static final int mMaxBufSize = 262144;
    private int mMaxBufBit;
    private int mTotalSize;

    public ByteArrayByteWriter() {
        this(0);
    }

    public ByteArrayByteWriter(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayByteWriter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.mCurBuffer = new byte[32];
        this.mBufferArray = new ArrayList();
        this.mBufferArray.add(this.mCurBuffer);
        this.mCurIndex = 0;
        this.mCurBase = 0;
        this.mCurTop = 32;
        this.mLength = 0;
        int n2 = 32;
        int n3 = 0;
        while (n2 != 0) {
            n2 >>= 1;
            ++n3;
        }
        this.mMinBufBit = n3 - 1;
        n2 = 262144;
        n3 = 0;
        while (n2 != 0) {
            n2 >>= 1;
            ++n3;
        }
        this.mMaxBufBit = n3 - 1;
        this.mTotalSize = 32;
    }

    public ByteArrayByteWriter(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Bad array parameters - offset = " + n + ", length = " + n2);
        }
        this.mCurBuffer = byArray;
        this.mCurBase = -n;
        this.mCurTop = n2;
        this.mLength = n2;
    }

    public ByteArrayByteWriter(ArrayList arrayList, int n) {
        this.mCurIndex = 0;
        this.mCurBuffer = (byte[])arrayList.get(this.mCurIndex);
        this.mBufferArray = arrayList;
        this.mCurBase = 0;
        this.mCurTop = Math.min(n, this.mCurBuffer.length);
        this.mLength = n;
        int n2 = 32;
        int n3 = 0;
        while (n2 != 0) {
            n2 >>= 1;
            ++n3;
        }
        this.mMinBufBit = n3 - 1;
        n2 = 262144;
        n3 = 0;
        while (n2 != 0) {
            n2 >>= 1;
            ++n3;
        }
        this.mMaxBufBit = n3 - 1;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.mLength];
        int n = 0;
        int n2 = 0;
        while (n2 < this.mLength) {
            byte[] byArray2 = (byte[])this.mBufferArray.get(n);
            int n3 = Math.min(this.mLength - n2, byArray2.length);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            ++n;
        }
        return byArray;
    }

    public void write(long l, int n) throws IOException {
        if (l < (long)this.mCurBase || l >= (long)this.mCurTop) {
            if (l < 0L || l >= Integer.MAX_VALUE) {
                throw new IOException("Attempt to position outside the buffer.");
            }
            if (l >= (long)this.mTotalSize) {
                this.resizeBuffer(l + 1L);
            }
            this.reloadBuffer(l);
        }
        if (l >= (long)this.mLength) {
            this.mLength = (int)l + 1;
        }
        this.mCurBuffer[(int)l - this.mCurBase] = (byte)n;
    }

    public void write(long l, byte[] byArray, int n, int n2) throws IOException {
        if (l < 0L || l + (long)n2 > Integer.MAX_VALUE) {
            throw new IOException("Attempt to position outside the buffer.");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Invalid offset/length on the array.");
        }
        if (n2 == 0) {
            return;
        }
        if (l + (long)n2 > (long)this.mLength) {
            this.mLength = (int)l + n2;
        }
        if (l >= (long)this.mCurBase && l + (long)n2 <= (long)this.mCurTop) {
            System.arraycopy(byArray, n, this.mCurBuffer, (int)l - this.mCurBase, n2);
        } else {
            if (l + (long)n2 > (long)this.mTotalSize) {
                this.resizeBuffer(l + (long)n2);
            }
            if (l < (long)this.mCurBase || l >= (long)this.mCurTop) {
                this.reloadBuffer(l);
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = Math.min(n2 - n3, this.mCurTop - (int)l);
                System.arraycopy(byArray, n, this.mCurBuffer, (int)l - this.mCurBase, n4);
                l += (long)n4;
                n += n4;
                if ((n3 += n4) >= n2) continue;
                ++this.mCurIndex;
                this.mCurBase = this.mCurTop;
                this.mCurBuffer = (byte[])this.mBufferArray.get(this.mCurIndex);
                this.mCurTop = this.mCurBase + this.mCurBuffer.length;
            }
        }
    }

    private void reloadBuffer(long l) {
        if (l < 32L) {
            this.mCurIndex = 0;
            this.mCurBase = 0;
        } else if (l == (long)this.mCurTop) {
            ++this.mCurIndex;
            this.mCurBase = this.mCurTop;
        } else if (l >= 262144L) {
            this.mCurIndex = (int)l / 262144 + this.mMaxBufBit - this.mMinBufBit;
            this.mCurBase = (int)l & 0xFFFC0000;
        } else {
            int n = this.mMaxBufBit - this.mMinBufBit + 1;
            int n2 = (int)l << 31 - this.mMaxBufBit;
            while (--n != 0 && ((n2 <<= 1) & Integer.MIN_VALUE) == 0) {
            }
            this.mCurIndex = n;
            this.mCurBase = 1 << n + this.mMinBufBit - 1 & 0xFFFFFFE0;
        }
        this.mCurBuffer = (byte[])this.mBufferArray.get(this.mCurIndex);
        this.mCurTop = this.mCurBase + this.mCurBuffer.length;
    }

    private void resizeBuffer(long l) throws IOException {
        while ((long)this.mTotalSize < l) {
            int n = 0;
            int n2 = this.mBufferArray.size();
            n = n2 < 2 ? 32 : ((n = ((byte[])this.mBufferArray.get(n2 - 1)).length) < 262144 ? (n *= 2) : 262144);
            this.mBufferArray.add(new byte[n]);
            this.mTotalSize += n;
        }
    }

    public long length() throws IOException {
        return this.mLength;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public String toString() {
        return new String();
    }

    public int read(long l) throws IOException {
        if (l < 0L || l >= (long)this.mLength) {
            return -1;
        }
        if (l < (long)this.mCurBase || l >= (long)this.mCurTop) {
            this.reloadBuffer(l);
        }
        return this.mCurBuffer[(int)l - this.mCurBase] & 0xFF;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        if (l < 0L || l >= (long)this.mLength) {
            return -1;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Invalid offset/length on the array.");
        }
        if (n2 == 0) {
            return 0;
        }
        n2 = (int)Math.min((long)n2, (long)this.mLength - l);
        if (l >= (long)this.mCurBase && l + (long)n2 <= (long)this.mCurTop) {
            System.arraycopy(this.mCurBuffer, (int)l - this.mCurBase, byArray, n, n2);
        } else {
            if (l < (long)this.mCurBase || l >= (long)this.mCurTop) {
                this.reloadBuffer(l);
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = Math.min(n2 - n3, this.mCurTop - (int)l);
                System.arraycopy(this.mCurBuffer, (int)l - this.mCurBase, byArray, n, n4);
                l += (long)n4;
                n += n4;
                if ((n3 += n4) >= n2) continue;
                ++this.mCurIndex;
                this.mCurBase = this.mCurTop;
                this.mCurBuffer = (byte[])this.mBufferArray.get(this.mCurIndex);
                this.mCurTop = Math.min(this.mLength, this.mCurBase + this.mCurBuffer.length);
            }
        }
        return n2;
    }
}

