/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Random;

public final class UUID {
    private static String mFakeMACAddress = null;
    private static Random mSeeder = null;

    private UUID() {
    }

    public static String createUUID() {
        Object object;
        Object object2;
        byte[] byArray;
        if (mFakeMACAddress == null) {
            byArray = new byte[6];
            mSeeder.nextBytes(byArray);
            object2 = new BigInteger(1, byArray);
            object = ((BigInteger)object2).toString(16);
            mFakeMACAddress = UUID.padHex((String)object, 12) + (String)object;
        }
        byArray = new byte[4];
        object2 = new byte[2];
        object = new byte[2];
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        mSeeder.nextBytes(byArray);
        mSeeder.nextBytes((byte[])object2);
        mSeeder.nextBytes((byte[])object);
        mSeeder.nextBytes(byArray2);
        mSeeder.nextBytes(byArray3);
        byArray2[0] = (byte)(byArray2[0] & 0x3F);
        byArray2[0] = (byte)(byArray2[0] | 0x50);
        object[0] = (byte)(object[0] & 0xF);
        object[0] = (byte)(object[0] | 0x28);
        StringBuffer stringBuffer = new StringBuffer(41);
        stringBuffer.append("uuid:");
        stringBuffer.append(UUID.hexFormat(UUID.getInt(byArray), 8));
        stringBuffer.append("-");
        stringBuffer.append(UUID.hexFormat(UUID.getInt((byte[])object2), 4));
        stringBuffer.append("-");
        stringBuffer.append(UUID.hexFormat(UUID.getInt(object), 4));
        stringBuffer.append("-");
        stringBuffer.append(UUID.hexFormat(UUID.getInt(byArray2), 2));
        stringBuffer.append(UUID.hexFormat(UUID.getInt(byArray3), 2));
        stringBuffer.append("-");
        stringBuffer.append(mFakeMACAddress);
        return stringBuffer.toString();
    }

    private static int getInt(byte[] byArray) {
        int n = 0;
        int n2 = 8 * (byArray.length - 1);
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = byArray[n3] & 0xFF;
            n += n4 << n2;
            n2 -= 8;
            ++n3;
        }
        return n;
    }

    private static String hexFormat(int n, int n2) {
        String string = Integer.toHexString(n);
        return UUID.padHex(string, n2) + string;
    }

    private static String padHex(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < n) {
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            mSeeder = SecureRandom.getInstance("FIPS186PRNG", "JsafeJCE");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            mSeeder = new SecureRandom();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            mSeeder = new SecureRandom();
        }
    }
}

