/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RangedInputStream
extends CountingInputStream {
    private final long length;
    private boolean closed;

    public RangedInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.length = l;
    }

    public int read() throws IOException {
        if (this.closed || this.getOffset() == this.length) {
            return -1;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed || this.getOffset() == this.length) {
            return -1;
        }
        n2 = (int)Math.min(this.length - this.getOffset(), (long)n2);
        return super.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        l = Math.min(this.length - this.getOffset(), l);
        return super.skip(l);
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

