/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ExtendedDataInputStream
extends DataInputStream {
    public ExtendedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long readUnsignedInt() throws IOException {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            int n = this.read();
            if (n == -1) {
                throw new EOFException("Unexpected end of stream.");
            }
            l = (l << 8) + (long)(n & 0xFF);
        }
        return l;
    }

    public int readUnsigned3ByteInt() throws IOException {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = this.read();
            if (n2 == -1) {
                throw new EOFException("Unexpected end of stream.");
            }
            n = (n << 8) + (n2 & 0xFF);
        }
        return n;
    }

    public void skipFully(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            long l3 = super.skip(l);
            if (l3 == 0L) {
                throw new EOFException("Unable to skip.");
            }
            l -= l3;
            l2 += l3;
        }
    }
}

