/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TagSearchingOutputStream
extends FilterOutputStream {
    byte[] tag;
    Callback callback;
    boolean look = true;
    int inTag = 0;

    public TagSearchingOutputStream(OutputStream out, byte[] tag, Callback callback) throws IOException {
        super(out);
        if (tag == null || callback == null) {
            throw new IOException("Invalid parameters to the constructor.");
        }
        this.tag = (byte[])tag.clone();
        this.callback = callback;
    }

    public void write(int b) throws IOException {
        if (!this.checkForTag((byte)b)) {
            if (this.inTag != 0) {
                this.writeBytes(this.tag, this.inTag);
                this.inTag = 0;
            }
            if (!this.checkForTag((byte)b)) {
                super.write(b);
            }
        }
    }

    public void close() throws IOException {
        if (this.inTag != 0) {
            this.writeBytes(this.tag, this.inTag);
            this.inTag = 0;
        }
        super.close();
    }

    private boolean checkForTag(byte b) throws IOException {
        if (b == this.tag[this.inTag]) {
            ++this.inTag;
            if (this.inTag >= this.tag.length) {
                if (this.tagFound()) {
                    this.writeBytes(this.tag, this.tag.length);
                }
                this.inTag = 0;
            }
            return true;
        }
        return false;
    }

    private void writeBytes(byte[] b, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            super.write(b[i]);
        }
    }

    private boolean tagFound() throws IOException {
        return this.callback.tagFound(this);
    }

    public static interface Callback {
        public boolean tagFound(TagSearchingOutputStream var1) throws IOException;
    }
}

