/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationFilter;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.API;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Compiler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class Optimizer {
    public static void main(String[] args) {
        flex2.compiler.API.useAS3();
        flex2.compiler.API.usePathResolver();
        LocalizationManager l10n = new LocalizationManager();
        l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)l10n);
        flex2.compiler.API.useConsoleLogger();
        Object[] configVars = new String[]{"help", "version", "load-config", "input", "output", "compiler.keep-as3-metadata"};
        Arrays.sort(configVars);
        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(OptimizerConfiguration.class, new HashMap(), new ConfigurationFilter((String[])configVars){
            private final /* synthetic */ String[] val$configVars;
            {
                this.val$configVars = val$configVars;
            }

            public boolean select(String name) {
                return Arrays.binarySearch(this.val$configVars, name) >= 0;
            }
        });
        cfgbuf.setDefaultVar("input");
        try {
            DefaultsConfigurator.loadMinimumDefaults((ConfigurationBuffer)cfgbuf);
            OptimizerConfiguration configuration = (OptimizerConfiguration)Compiler.processConfiguration((LocalizationManager)l10n, (String)"optimizer", (String[])args, (ConfigurationBuffer)cfgbuf, (Class)OptimizerConfiguration.class, (String)"input", (boolean)true);
            configuration.setKeepDebugOpcodes(false);
            configuration.setOptimize(true);
            String input = configuration.getInput();
            String output = configuration.getOutput();
            File inputFile = FileUtil.openFile((String)input);
            File outputFile = FileUtil.openFile((String)output);
            if (inputFile.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
                System.out.println(input + " (" + inputFile.length() + " bytes)");
                Movie movie = new Movie();
                TagDecoder tagDecoder = new TagDecoder((InputStream)in);
                MovieDecoder movieDecoder = new MovieDecoder(movie);
                tagDecoder.parse((TagHandler)movieDecoder);
                if (movie.version > 0) {
                    API.optimize((Movie)movie, (Configuration)configuration);
                    TagEncoder handler = new TagEncoder();
                    MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
                    encoder.export(movie);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    handler.writeTo((OutputStream)out);
                    FileUtil.writeBinaryFile((String)output, (byte[])out.toByteArray());
                    System.out.println(output + " (" + outputFile.length() + " bytes)");
                } else {
                    ThreadLocalToolkit.logError((String)l10n.getLocalizedTextString((Object)new NotAValidSwfFile(inputFile.getAbsolutePath())));
                }
            }
        }
        catch (ConfigurationException ex) {
            Compiler.processConfigurationException((ConfigurationException)ex, (String)"optimizer");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static class NotAValidSwfFile
    extends CompilerMessage.CompilerError {
        public String fileName;

        public NotAValidSwfFile(String fileName) {
            this.fileName = fileName;
        }
    }

    public static class OptimizerConfiguration
    extends CommandLineConfiguration {
        private String input = null;
        private String output = "output.swf";

        public String getInput() {
            return this.input;
        }

        public void cfgInput(ConfigurationValue val, String input) throws flex2.compiler.common.ConfigurationException {
            this.input = input;
        }

        public static ConfigurationInfo getInputInfo() {
            return new ConfigurationInfo(1, "filename"){

                public boolean isRequired() {
                    return true;
                }
            };
        }

        public String getOutput() {
            return this.output;
        }

        public void cfgOutput(ConfigurationValue val, String output) throws flex2.compiler.common.ConfigurationException {
            this.output = output;
        }

        public static ConfigurationInfo getOutputInfo() {
            return new ConfigurationInfo(1, "filename"){

                public boolean isRequired() {
                    return false;
                }
            };
        }

        public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        }
    }
}

