/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.util.Trace;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.asdoc.DocComment;
import flex2.compiler.asdoc.DocCommentTable;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTable
implements DocCommentTable {
    private LinkedHashMap<String, CommentsTable> classTable = new LinkedHashMap();
    private LinkedHashMap<String, DocComment> packageTable = new LinkedHashMap();
    private HashSet<String> tagNames = new HashSet();
    private boolean restoreBuiltinClasses = false;

    public ClassTable(boolean restoreBuiltinClasses) {
        this.tagNames.add("author");
        this.tagNames.add("copy");
        this.tagNames.add("default");
        this.tagNames.add("event");
        this.tagNames.add("eventType");
        this.tagNames.add("example");
        this.tagNames.add("helpid");
        this.tagNames.add("includeExample");
        this.tagNames.add("inheritDoc");
        this.tagNames.add("internal");
        this.tagNames.add("langversion");
        this.tagNames.add("param");
        this.tagNames.add("playerversion");
        this.tagNames.add("private");
        this.tagNames.add("productversion");
        this.tagNames.add("return");
        this.tagNames.add("review");
        this.tagNames.add("see");
        this.tagNames.add("throws");
        this.tagNames.add("tiptext");
        this.tagNames.add("toolversion");
        this.tagNames.add("description");
        this.tagNames.add("since");
        this.restoreBuiltinClasses = restoreBuiltinClasses;
    }

    public void addComments(QName name, List comments, Set<QName> inheritance, boolean exclude, Context cx, AbcClass abcClass) {
        String packageName = name.getNamespace().intern();
        String className = name.getLocalPart().intern();
        ArrayList<DocCommentNode> mainClass = new ArrayList<DocCommentNode>();
        LinkedHashMap<String, ArrayList<DocCommentNode>> otherClasses = new LinkedHashMap<String, ArrayList<DocCommentNode>>();
        LinkedHashMap otherInheritance = new LinkedHashMap();
        boolean mainDef = false;
        String otherPackage = null;
        for (int i = 0; i < comments.size(); ++i) {
            int colon;
            String debug;
            DocCommentNode current = (DocCommentNode)comments.get(i);
            String pkg = "";
            String cls = "";
            if (current.def instanceof PackageDefinitionNode) {
                mainClass.add(current);
                continue;
            }
            if (current.def instanceof ClassDefinitionNode) {
                ClassDefinitionNode cd = (ClassDefinitionNode)current.def;
                debug = cd.debug_name;
                colon = debug.indexOf(58);
                if (colon < 0) {
                    pkg = "";
                    cls = debug.intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    cls = debug.substring(colon + 1).intern();
                }
                if (cls.equals(className) && pkg.equals(packageName)) {
                    mainDef = true;
                } else {
                    if (otherPackage == null) {
                        otherPackage = pkg;
                    }
                    HashSet<QName> inherit = new HashSet<QName>();
                    otherInheritance.put(cls, inherit);
                    Namespaces inherited = cd.used_def_namespaces;
                    for (int j = 0; j < inherited.size(); ++j) {
                        QName q;
                        String s = inherited.get(j).toString().intern();
                        if (s.equals(debug) || s.equals(otherPackage) || (q = new QName(s)).getLocalPart().equals("")) continue;
                        assert (!q.getLocalPart().equals(cls) || !q.getNamespace().equals(pkg)) : "same class";
                        inherit.add(q);
                    }
                }
            } else if (current.def instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode fd = (FunctionDefinitionNode)current.def;
                debug = fd.fexpr.debug_name;
                colon = debug.indexOf(58);
                int slash = debug.indexOf(47);
                if (colon < 0) {
                    pkg = "";
                    cls = slash < 0 ? "" : debug.substring(0, slash).intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    if (slash < 0) {
                        cls = "";
                    } else if (slash < colon) {
                        pkg = "";
                        cls = debug.substring(0, slash).intern();
                    } else {
                        cls = debug.substring(colon + 1, slash).intern();
                    }
                }
            } else if (current.def instanceof VariableDefinitionNode) {
                VariableBindingNode vb = (VariableBindingNode)((VariableDefinitionNode)current.def).list.items.get(0);
                debug = vb.debug_name;
                colon = debug.indexOf(58);
                int slash = debug.indexOf(47);
                if (colon < 0) {
                    pkg = "";
                    cls = slash < 0 ? "" : debug.substring(0, slash).intern();
                } else {
                    pkg = debug.substring(0, colon).intern();
                    if (slash < 0) {
                        cls = "";
                    } else if (slash < colon) {
                        pkg = "";
                        cls = debug.substring(0, slash).intern();
                    } else {
                        cls = debug.substring(colon + 1, slash).intern();
                    }
                }
            }
            if (!pkg.equals(packageName)) {
                ArrayList<DocCommentNode> l;
                if (cls.equals("")) {
                    cls = "null";
                }
                if ((l = (ArrayList<DocCommentNode>)otherClasses.get(cls)) == null) {
                    l = new ArrayList<DocCommentNode>();
                }
                l.add(current);
                otherClasses.put(cls, l);
                continue;
            }
            mainClass.add(current);
        }
        if (mainDef) {
            this.put(name, mainClass, inheritance, exclude, cx, abcClass);
        } else {
            this.put(new QName(packageName, "null"), mainClass, inheritance, exclude, cx, abcClass);
        }
        if (otherPackage != null) {
            Iterator iter = otherClasses.keySet().iterator();
            while (iter.hasNext()) {
                String cls = ((String)iter.next()).intern();
                this.put(new QName(otherPackage, cls), (List)otherClasses.get(cls), (Set)otherInheritance.get(cls), true, cx, abcClass);
            }
        }
        if (!this.packageTable.containsKey(packageName)) {
            this.packageTable.put(packageName, null);
        }
        if (otherPackage != null && !this.packageTable.containsKey(otherPackage)) {
            this.packageTable.put(otherPackage, null);
        }
    }

    private void put(QName name, List<DocCommentNode> comments, Set<QName> inheritance, boolean exclude, Context cx, AbcClass abcClass) {
        CommentsTable table = this.classTable.get(NameFormatter.toDot(name));
        if (table == null) {
            table = new CommentsTable(name.getNamespace(), name.getLocalPart(), inheritance, exclude, cx, abcClass);
        }
        int temp = comments.size();
        for (int i = 0; i < temp; ++i) {
            DocCommentNode tempNode = comments.get(i);
            DocComment tempComment = table.addComment(tempNode);
            if (this.packageTable.get(name.getNamespace()) != null || tempComment == null || tempComment.getType() != 0) continue;
            this.packageTable.put(name.getNamespace(), tempComment);
        }
        this.classTable.put(NameFormatter.toDot(name), table);
    }

    @Override
    public List<DocComment> getAllClassComments(String className, String packageName) {
        try {
            if (packageName == null) {
                packageName = "";
            }
            if (className == null || className.equals("")) {
                className = "null";
            }
            String name = NameFormatter.toDot(new QName(packageName, className));
            CommentsTable temp = this.classTable.get(name);
            return new ArrayList<DocComment>(temp.values());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public Map<String, DocComment> getClassesAndInterfaces(String packageName) {
        return this.getCsOrIs(packageName, true, true);
    }

    private Map<String, DocComment> getCsOrIs(String packageName, boolean c, boolean i) {
        if (packageName == null) {
            packageName = "";
        }
        LinkedHashMap<String, DocComment> comments = new LinkedHashMap<String, DocComment>();
        for (String key : this.classTable.keySet()) {
            CommentsTable temp1;
            int dot = key.lastIndexOf(".");
            if (dot < 0 && packageName.equals("")) {
                temp1 = this.classTable.get(key);
                if (!temp1.isInterface() && c) {
                    comments.put(key, (DocComment)temp1.get(new KeyPair(key, 1)));
                    continue;
                }
                if (!i) continue;
                comments.put(key, (DocComment)temp1.get(new KeyPair(key, 2)));
                continue;
            }
            if (dot < 0 || !key.substring(0, dot).equals(packageName)) continue;
            temp1 = this.classTable.get(key);
            String key2 = key.substring(dot + 1);
            if (!temp1.isInterface() && c) {
                comments.put(key2, (DocComment)temp1.get(new KeyPair(key, 1)));
                continue;
            }
            if (!i) continue;
            comments.put(key2, (DocComment)temp1.get(new KeyPair(key, 2)));
        }
        return comments;
    }

    @Override
    public Map<String, DocComment> getPackages() {
        return new LinkedHashMap<String, DocComment>(this.packageTable);
    }

    private class KeyPair
    implements Comparable {
        public String name;
        public int type;
        public boolean isStatic;

        public KeyPair(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public int compareTo(Object key) {
            return (new Integer(this.type).toString() + this.name + this.isStatic).compareTo(new Integer(((KeyPair)key).type).toString() + ((KeyPair)key).name + ((KeyPair)key).isStatic);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommentsTable
    extends TreeMap<KeyPair, DocComment> {
        private static final long serialVersionUID = 5737364574357983642L;
        private boolean exclude;
        private Set<QName> inheritance;
        private Context cx;
        private boolean isInterface;
        private AbcClass abcClass;
        private List<CommentEntry> skinPartMetadataList;
        private Set<String> functionToIgnoreSet;

        public CommentsTable(String packageName, String className, Set<QName> inheritance, boolean exclude, Context cx, AbcClass abcClass) {
            this.exclude = exclude;
            this.inheritance = inheritance;
            this.cx = cx;
            this.abcClass = abcClass;
        }

        public DocComment addComment(DocCommentNode comment) {
            CommentEntry entry = new CommentEntry(comment, this.exclude);
            if (entry.key.type == 2) {
                this.isInterface = true;
            }
            if (entry.getSkinPartMetadata() != null) {
                if (this.skinPartMetadataList == null) {
                    this.skinPartMetadataList = new ArrayList<CommentEntry>();
                }
                this.skinPartMetadataList.add(entry.getSkinPartMetadata());
            }
            if (entry.functionToIgnore != null) {
                if (this.functionToIgnoreSet == null) {
                    this.functionToIgnoreSet = new HashSet<String>();
                }
                this.functionToIgnoreSet.add(entry.functionToIgnore);
            }
            if (!this.containsKey(entry.key) || comment.getId() != null && (entry.key.type == 6 || entry.key.type == 3 || entry.key.type == 4 || entry.key.type == 5) && !entry.hasUserNamespace) {
                if (entry.key.type == 1 && this.skinPartMetadataList != null) {
                    if (entry.getMetadata() == null) {
                        entry.setMetadata(this.skinPartMetadataList);
                    } else {
                        entry.getMetadata().addAll(this.skinPartMetadataList);
                    }
                }
                if (this.functionToIgnoreSet != null && (entry.key.type == 4 || entry.key.type == 5) && this.functionToIgnoreSet.contains(entry.key.name)) {
                    return null;
                }
                this.put(entry.key, entry);
                return entry;
            }
            return null;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        private Object[] findInheritDoc(KeyPair key) {
            Object[] inheritDoc = null;
            Iterator<QName> iter = this.inheritance.iterator();
            CommentsTable baseClassObj = null;
            Name baseClass = null;
            while (iter.hasNext()) {
                QName nextClass = iter.next();
                CommentsTable t = (CommentsTable)ClassTable.this.classTable.get(NameFormatter.toDot(nextClass));
                if (ClassTable.this.restoreBuiltinClasses && t == null && nextClass.getNamespace().equals("") && !"Object_ASDoc".equals(this.abcClass.getName())) {
                    nextClass = new QName("", nextClass.getLocalPart() + "_ASDoc");
                    t = (CommentsTable)ClassTable.this.classTable.get(NameFormatter.toDot(nextClass));
                }
                if (t != null) {
                    if (!t.isInterface()) {
                        baseClassObj = t;
                        baseClass = nextClass;
                        continue;
                    }
                    inheritDoc = key.type == 1 ? t.getCommentForInherit(new KeyPair(nextClass.getLocalPart(), 1)) : t.getCommentForInherit(key);
                }
                if (inheritDoc == null) continue;
                break;
            }
            if (inheritDoc == null && baseClass != null) {
                inheritDoc = key.type == 1 ? baseClassObj.getCommentForInherit(new KeyPair(baseClass.getLocalPart(), 1)) : baseClassObj.getCommentForInherit(key);
            }
            return inheritDoc;
        }

        public Object[] getCommentForInherit(KeyPair key) {
            CommentEntry temp = (CommentEntry)this.get(key);
            if (temp == null || temp.getDescription() == null || temp.hasPrivateTag()) {
                CommentEntry temp2;
                if (key.type == 5) {
                    CommentEntry temp22 = (CommentEntry)this.get(new KeyPair(key.name, 4));
                    if (temp22 != null) {
                        temp = temp22;
                    }
                } else if (key.type == 4 && (temp2 = (CommentEntry)this.get(new KeyPair(key.name, 5))) != null) {
                    temp = temp2;
                }
            }
            if (temp != null && !temp.hasPrivateTag()) {
                return temp.getInheritedDoc();
            }
            return this.findInheritDoc(key);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CommentEntry
        implements DocComment {
            private boolean exclude;
            public KeyPair key;
            private String fullname;
            private String description;
            private boolean isFinal;
            private boolean isStatic;
            private boolean isOverride;
            private String sourcefile;
            private String namespace;
            private String access;
            private boolean isDynamic;
            private String baseClass;
            private String[] interfaces;
            private String[] baseClasses;
            private String[] paramNames;
            private String[] paramTypes;
            private String[] paramDefaults;
            private String resultType;
            private String vartype;
            private boolean isConst;
            private String defaultValue;
            private List<CommentEntry> metadata;
            private String metadataType;
            private String owner;
            private String type_meta;
            private String event_meta;
            private String kind_meta;
            private String arrayType_meta;
            private String format_meta;
            private String inherit_meta;
            private String enumeration_meta;
            private String theme_meta;
            private String message_meta;
            private String replacement_meta;
            private String since_meta;
            private String variableType_meta;
            private String required_meta;
            private List<String> authorTags;
            private String copyTag;
            private String defaultTag;
            private List<String> eventTags;
            private String eventTypeTag;
            private List<String> exampleTags;
            private String helpidTag;
            private List<String> includeExampleTags;
            private boolean hasInheritTag;
            private String inheritDocTagLocation;
            private String internalTag;
            private String langversionTag;
            private List<String> paramTags;
            private List<String> playerversionTags;
            private boolean hasPrivateTag;
            private List<String> productversionTags;
            private String sinceTag;
            private String returnTag;
            private boolean hasReviewTag;
            private List<String> seeTags;
            private List<String> throwsTags;
            private String tiptextTag;
            private String toolversionTag;
            private Map<String, String> customTags;
            private boolean hasDefaultProperty = false;
            public boolean hasUserNamespace = false;
            private CommentEntry skinPartMetadata = null;
            private String functionToIgnore = null;

            public CommentEntry(DocCommentNode comment, boolean exclude) {
                this.exclude = exclude;
                this.processComment(comment);
            }

            public CommentEntry(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current, String variableType, String variableName) {
                this.createMetadataEntry(debugName, meta, isAttributeOfDefinition, current, variableType, variableName);
            }

            public CommentEntry(String debugName, MetaData meta) {
                this.inheritMetadataEntry(debugName, meta);
            }

            private void createMetadataEntry(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current, String variableType, String variableName) {
                this.key = new KeyPair("IGNORE", 7);
                this.metadataType = meta.getId();
                this.owner = debugName;
                boolean has_name = false;
                if (meta.getValues() != null) {
                    int l = meta.getValues().length;
                    for (int i = 0; i < l; ++i) {
                        Value v = meta.getValues()[i];
                        if (v == null) continue;
                        if (v instanceof MetaDataEvaluator.KeylessValue && !has_name) {
                            MetaDataEvaluator.KeylessValue ov = (MetaDataEvaluator.KeylessValue)v;
                            this.key.name = ov.obj;
                            has_name = true;
                            continue;
                        }
                        if (!(v instanceof MetaDataEvaluator.KeyValuePair)) continue;
                        MetaDataEvaluator.KeyValuePair kv = (MetaDataEvaluator.KeyValuePair)v;
                        String s = kv.key.intern();
                        if (s.equals("name")) {
                            this.key.name = kv.obj;
                            continue;
                        }
                        if (s.equals("type")) {
                            this.type_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("event")) {
                            this.event_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("kind")) {
                            this.kind_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("arrayType")) {
                            this.arrayType_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("format")) {
                            this.format_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("inherit")) {
                            this.inherit_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("enumeration")) {
                            this.enumeration_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("message") || s.equals("deprecatedMessage")) {
                            this.message_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("replacement") || s.equals("deprecatedReplacement")) {
                            this.replacement_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("since") || s.equals("deprecatedSince")) {
                            this.since_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("required")) {
                            this.required_meta = kv.obj;
                            continue;
                        }
                        if (s.equals("theme")) {
                            this.theme_meta = kv.obj;
                            continue;
                        }
                        if (!s.equals("profile")) continue;
                        this.key.name = kv.obj;
                    }
                } else if (meta.getId() != null) {
                    this.key.name = meta.getId();
                }
                if (variableType != null) {
                    this.variableType_meta = variableType;
                }
                if (variableName != null) {
                    this.key.name = variableName;
                }
                if (!isAttributeOfDefinition && current.getId() != null) {
                    this.processTags(current.getId());
                }
            }

            private void inheritMetaDataComment(String debugName, MetaData meta) {
                if (this.metadata == null) {
                    this.metadata = new ArrayList<CommentEntry>();
                }
                CommentEntry newMetadata = new CommentEntry(debugName, meta);
                this.metadata.add(newMetadata);
            }

            private void inheritMetadataEntry(String debugName, MetaData meta) {
                this.key = new KeyPair("IGNORE", 7);
                this.metadataType = meta.getID();
                this.owner = debugName;
                if (meta.count() != 0 && "DefaultProperty".equals(meta.getID())) {
                    this.key.name = meta.getValue(0);
                }
            }

            private String getAccessKindFromNS(ObjectValue ns) {
                String access_specifier;
                switch (ns.getNamespaceKind()) {
                    case 0: {
                        access_specifier = "public";
                        break;
                    }
                    case 1: {
                        access_specifier = "internal";
                        break;
                    }
                    case 3: {
                        access_specifier = "protected";
                        break;
                    }
                    case 2: {
                        access_specifier = "private";
                        break;
                    }
                    default: {
                        access_specifier = "public";
                    }
                }
                return access_specifier;
            }

            private void processPackage(PackageDefinitionNode pd) {
                this.key.type = 0;
                this.key.name = pd.name.id != null ? pd.name.id.pkg_part : "";
                this.fullname = pd.name.id != null ? pd.name.id.pkg_part + "." + pd.name.id.def_part : "";
            }

            private void processClassAndInterface(ClassDefinitionNode cd) {
                ObjectList values;
                this.key.name = cd.name.name;
                this.fullname = cd.debug_name;
                InterfaceDefinitionNode idn = null;
                if (cd instanceof InterfaceDefinitionNode) {
                    this.key.type = 2;
                    idn = (InterfaceDefinitionNode)cd;
                } else {
                    this.key.type = 1;
                }
                if (cd.cx.input != null && cd.cx.input.origin.length() != 0) {
                    this.sourcefile = cd.cx.input.origin;
                }
                this.namespace = cd.cframe.builder.classname.ns.name;
                this.access = this.getAccessKindFromNS(cd.cframe.builder.classname.ns);
                if (idn != null) {
                    if (idn.interfaces != null) {
                        values = idn.interfaces.values;
                        this.baseClasses = new String[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            ReferenceValue rv = (ReferenceValue)values.get(i);
                            Slot s = rv.getSlot(CommentsTable.this.cx, -79);
                            this.baseClasses[i] = s == null || s.getDebugName().length() == 0 ? rv.name : s.getDebugName();
                        }
                    } else {
                        this.baseClasses = new String[]{"Object"};
                    }
                } else {
                    Slot s;
                    this.baseClass = cd.baseref != null ? ((s = cd.baseref.getSlot(CommentsTable.this.cx, -79)) == null || s.getDebugName().length() == 0 ? "Object" : s.getDebugName()) : "Object";
                    if (cd.interfaces != null) {
                        values = cd.interfaces.values;
                        this.interfaces = new String[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            ReferenceValue rv = (ReferenceValue)values.get(i);
                            Slot s2 = rv.getSlot(CommentsTable.this.cx, -79);
                            this.interfaces[i] = s2 == null || s2.getDebugName().length() == 0 ? rv.name : s2.getDebugName();
                        }
                    }
                }
                AttributeListNode attrs = cd.attrs;
                if (attrs != null) {
                    this.isFinal = attrs.hasFinal;
                    this.isDynamic = attrs.hasDynamic;
                }
            }

            private void processFunction(FunctionDefinitionNode fd) {
                ParameterListNode pln;
                this.key.type = 3;
                int check1 = fd.fexpr.debug_name.indexOf("/get");
                int check2 = fd.fexpr.debug_name.indexOf("/set");
                if (check1 == fd.fexpr.debug_name.length() - 4) {
                    this.key.type = 4;
                } else if (check2 == fd.fexpr.debug_name.length() - 4) {
                    this.key.type = 5;
                }
                this.key.name = fd.name.identifier.name;
                this.fullname = fd.fexpr.debug_name;
                AttributeListNode attrs = fd.attrs;
                if (attrs != null) {
                    this.isStatic = attrs.hasStatic;
                    this.isFinal = attrs.hasFinal;
                    this.isOverride = attrs.hasOverride;
                    this.hasUserNamespace = attrs.hasUserNamespace();
                }
                if ((pln = fd.fexpr.signature.parameter) != null) {
                    int size = pln.items.size();
                    this.paramNames = new String[size];
                    this.paramTypes = new String[size];
                    this.paramDefaults = new String[size];
                    for (int i = 0; i < size; ++i) {
                        ParameterNode pn = (ParameterNode)pln.items.get(i);
                        String string = this.paramNames[i] = pn.ref != null ? pn.ref.name : "";
                        this.paramTypes[i] = pn instanceof RestParameterNode ? "restParam" : (pn.typeref != null ? this.getRefName(CommentsTable.this.cx, pn.typeref) : "*");
                        this.paramDefaults[i] = pn.init == null ? "undefined" : (pn.init instanceof LiteralNumberNode ? ((LiteralNumberNode)pn.init).value : (pn.init instanceof LiteralStringNode ? DocCommentNode.escapeXml((String)((LiteralStringNode)pn.init).value) : (pn.init instanceof LiteralNullNode ? "null" : (pn.init instanceof LiteralBooleanNode ? (((LiteralBooleanNode)pn.init).value ? "true" : "false") : "unknown"))));
                    }
                }
                if (fd.fexpr.signature.result != null) {
                    TypeExpressionNode result = (TypeExpressionNode)fd.fexpr.signature.result;
                    if (result.expr != null) {
                        MemberExpressionNode expr = (MemberExpressionNode)result.expr;
                        this.resultType = this.getRefName(CommentsTable.this.cx, expr.ref);
                    }
                } else {
                    this.resultType = fd.fexpr.signature.void_anno ? "void" : ((CommentsTable)CommentsTable.this).cx.noType().name.toString();
                }
            }

            private void processField(VariableDefinitionNode vd) {
                Slot s;
                AttributeListNode attrs;
                VariableBindingNode vb = (VariableBindingNode)vd.list.items.get(0);
                this.key.type = 6;
                this.key.name = vb.variable.identifier.name;
                this.fullname = vb.debug_name;
                if (vb.typeref != null) {
                    this.vartype = this.getRefName(CommentsTable.this.cx, vb.typeref);
                }
                if ((attrs = vd.attrs) != null) {
                    this.isStatic = attrs.hasStatic;
                    this.hasUserNamespace = attrs.hasUserNamespace();
                }
                if ((s = vb.ref.getSlot(CommentsTable.this.cx)) != null) {
                    this.isConst = s.isConst();
                }
                if (vb.initializer != null) {
                    if (vb.initializer instanceof LiteralNumberNode) {
                        this.defaultValue = ((LiteralNumberNode)vb.initializer).value;
                    } else if (vb.initializer instanceof LiteralStringNode) {
                        this.defaultValue = DocCommentNode.escapeXml((String)((LiteralStringNode)vb.initializer).value);
                    } else if (vb.initializer instanceof LiteralNullNode) {
                        this.defaultValue = "null";
                    } else if (vb.initializer instanceof LiteralBooleanNode) {
                        this.defaultValue = ((LiteralBooleanNode)vb.initializer).value ? "true" : "false";
                    } else if (vb.initializer instanceof MemberExpressionNode) {
                        MemberExpressionNode mb = (MemberExpressionNode)vb.initializer;
                        Slot vs = null;
                        vs = mb.ref != null && mb.selector.isGetExpression() ? (mb.ref != null ? mb.ref.getSlot(CommentsTable.this.cx, -79) : null) : vb.ref.getSlot(CommentsTable.this.cx, -79);
                        Value v = vs != null ? vs.getValue() : null;
                        ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                        this.defaultValue = ov != null ? ov.getValue() : "unknown";
                    } else {
                        Slot vs = vb.ref.getSlot(CommentsTable.this.cx, -79);
                        Value v = vs != null ? vs.getValue() : null;
                        ObjectValue ov = v instanceof ObjectValue ? (ObjectValue)v : null;
                        this.defaultValue = ov != null ? ov.getValue() : "unknown";
                    }
                }
            }

            public String getRefName(Context cx, ReferenceValue ref) {
                Slot s = ref.getSlot(cx, -79);
                if (s == null || s.getDebugName().length() == 0) {
                    String name = ref.name;
                    if (ref.type_params != null && s != null && s.getValue() instanceof TypeValue) {
                        TypeValue t = (TypeValue)s.getValue();
                        name = name + this.getIndexedTypeName(cx, t.indexed_type);
                    }
                    return name;
                }
                return s.getDebugName();
            }

            private String getIndexedTypeName(Context cx, TypeValue t) {
                ParameterizedName pn = t.name instanceof ParameterizedName ? (ParameterizedName)t.name : null;
                String name = "$";
                if (pn != null) {
                    name = name + t.name.name;
                    if (t.indexed_type != null) {
                        name = name + this.getIndexedTypeName(cx, t.indexed_type);
                    }
                } else {
                    name = name + t;
                }
                return name;
            }

            private void createMetaDataComment(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                if (this.metadata == null) {
                    this.metadata = new ArrayList<CommentEntry>();
                }
                CommentEntry newMetadata = new CommentEntry(debugName, meta, isAttributeOfDefinition, current, null, null);
                this.metadata.add(newMetadata);
            }

            private void processMetadata(DocCommentNode comment) {
                if (comment.def != null && comment.def.metaData != null) {
                    int numItems = comment.def.metaData.items.size();
                    for (int x = 0; x < numItems; ++x) {
                        MetaDataNode mdi;
                        Node md = (Node)comment.def.metaData.items.at(x);
                        MetaDataNode metaDataNode = mdi = md instanceof MetaDataNode ? (MetaDataNode)md : null;
                        if (mdi == null || mdi.getId() == null) continue;
                        if (mdi.getId().equals("Style") || mdi.getId().equals("Event") || mdi.getId().equals("Effect") || mdi.getId().equals("SkinState") || mdi.getId().equals("Alternative") || mdi.getId().equals("DiscouragedForProfile")) {
                            if (x + 1 < numItems) {
                                DocCommentNode metaDataComment;
                                Node next = (Node)comment.def.metaData.items.at(x + 1);
                                DocCommentNode docCommentNode = metaDataComment = next instanceof DocCommentNode ? (DocCommentNode)next : null;
                                if (metaDataComment != null) {
                                    this.createMetaDataComment(this.fullname, mdi, false, (MetaDataNode)metaDataComment);
                                    ++x;
                                    continue;
                                }
                                this.createMetaDataComment(this.fullname, mdi, true, null);
                                continue;
                            }
                            this.createMetaDataComment(this.fullname, mdi, true, null);
                            continue;
                        }
                        if (mdi.getId().equals("Bindable") || mdi.getId().equals("Deprecated") || mdi.getId().equals("Exclude")) {
                            this.createMetaDataComment(this.fullname, mdi, true, null);
                            continue;
                        }
                        if (mdi.getId().equals("DefaultProperty")) {
                            this.hasDefaultProperty = true;
                            this.createMetaDataComment(this.fullname, mdi, true, null);
                            continue;
                        }
                        if (!mdi.getId().equals("SkinPart")) continue;
                        String className = this.fullname.substring(0, this.fullname.indexOf("/"));
                        if (comment.getId() != null) {
                            this.createSkinPartMetaDataComment(className, mdi, false, (MetaDataNode)comment);
                        } else {
                            this.createSkinPartMetaDataComment(className, mdi, true, null);
                        }
                        if (this.key.type == 4 || this.key.type == 5) {
                            this.functionToIgnore = this.key.name;
                        }
                        this.key.name = "IGNORE";
                        this.key.type = -1;
                    }
                }
            }

            private void createSkinPartMetaDataComment(String debugName, MetaDataNode meta, boolean isAttributeOfDefinition, MetaDataNode current) {
                String tempVarType = this.vartype;
                if (this.key.type == 4) {
                    tempVarType = this.resultType;
                }
                this.skinPartMetadata = new CommentEntry(debugName, meta, isAttributeOfDefinition, current, tempVarType, this.key.name);
            }

            private boolean matchesAnyTag(String tagName) {
                return ClassTable.this.tagNames.contains(tagName);
            }

            private void processTags(String id) {
                int begin;
                int endCDATABefore;
                int is = id.indexOf("<description><![CDATA[");
                int ie = id.indexOf("]]></description>");
                this.description = id.substring(is + "<description><![CDATA[".length(), ie);
                int index = id.indexOf("]]></return>");
                if (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<return><![CDATA[", endCDATABefore) + "<return><![CDATA[".length();
                    this.returnTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></return>", index + 12)) > 0) {
                    ThreadLocalToolkit.getLogger().logError("More than one @return found in " + this.fullname + ".");
                }
                if ((index = id.indexOf("]]></param>")) >= 0) {
                    this.paramTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<param><![CDATA[", endCDATABefore);
                    this.paramTags.add(id.substring(begin + "<param><![CDATA[".length(), index));
                    index = id.indexOf("]]></param>", index + "]]></param>".length());
                }
                index = id.indexOf("]]></inheritDoc>");
                boolean bl = this.hasInheritTag = index > 0;
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<inheritDoc><![CDATA[", endCDATABefore) + "<inheritDoc><![CDATA[".length();
                    this.inheritDocTagLocation = id.substring(begin, index).trim();
                }
                if ((index = id.indexOf("]]></inheritDoc>", index + 16)) > 0) {
                    ThreadLocalToolkit.getLogger().logError("More than one @inheritDoc found in " + this.fullname + ".");
                }
                if ((index = id.indexOf("]]></author>")) >= 0) {
                    this.authorTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<author><![CDATA[", endCDATABefore);
                    this.authorTags.add(id.substring(begin + "<author><![CDATA[".length(), index));
                    index = id.indexOf("]]></author>", index + "]]></author>".length());
                }
                index = id.indexOf("]]></copy>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<copy><![CDATA[", endCDATABefore) + "<copy><![CDATA[".length();
                    this.copyTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></default>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<default><![CDATA[", endCDATABefore) + "<default><![CDATA[".length();
                    this.defaultTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></event>")) >= 0) {
                    this.eventTags = new ArrayList<String>();
                }
                while (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<event><![CDATA[", endCDATABefore);
                    this.eventTags.add(id.substring(begin + "<event><![CDATA[".length(), index));
                    index = id.indexOf("]]></event>", index + "]]></event>".length());
                }
                index = id.indexOf("]]></eventType>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<eventType><![CDATA[", endCDATABefore) + "<eventType><![CDATA[".length();
                    this.eventTypeTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></example>")) >= 0) {
                    this.exampleTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<example><![CDATA[", endCDATABefore);
                    this.exampleTags.add(id.substring(begin + "<example><![CDATA[".length(), index));
                    index = id.indexOf("]]></example>", index + "]]></example>".length());
                }
                index = id.indexOf("]]></helpid>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<helpid><![CDATA[", endCDATABefore) + "<helpid><![CDATA[".length();
                    this.helpidTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></includeExample>")) >= 0) {
                    this.includeExampleTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<includeExample><![CDATA[", endCDATABefore);
                    this.includeExampleTags.add(id.substring(begin + "<includeExample><![CDATA[".length(), index));
                    index = id.indexOf("]]></includeExample>", index + "]]></includeExample>".length());
                }
                index = id.indexOf("]]></internal>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<internal><![CDATA[", endCDATABefore) + "<internal><![CDATA[".length();
                    this.internalTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></langversion>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<langversion><![CDATA[", endCDATABefore) + "<langversion><![CDATA[".length();
                    this.langversionTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></playerversion>")) >= 0) {
                    this.playerversionTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<playerversion><![CDATA[", endCDATABefore);
                    this.playerversionTags.add(id.substring(begin + "<playerversion><![CDATA[".length(), index));
                    index = id.indexOf("]]></playerversion>", index + "]]></playerversion>".length());
                }
                this.hasPrivateTag = id.indexOf("]]></private>") > 0;
                index = id.indexOf("]]></productversion>");
                if (index >= 0) {
                    this.productversionTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<productversion><![CDATA[", endCDATABefore);
                    this.productversionTags.add(id.substring(begin + "<productversion><![CDATA[".length(), index));
                    index = id.indexOf("]]></productversion>", index + "]]></productversion>".length());
                }
                index = id.indexOf("]]></since>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<since><![CDATA[", endCDATABefore) + "<since><![CDATA[".length();
                    this.sinceTag = id.substring(begin, index);
                }
                this.hasReviewTag = id.indexOf("]]></review>") > 0;
                index = id.indexOf("]]></see>");
                if (index >= 0) {
                    this.seeTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<see><![CDATA[", endCDATABefore);
                    String see = id.substring(begin + "<see><![CDATA[".length(), index);
                    if (see.indexOf(60) >= 0) {
                        ThreadLocalToolkit.getLogger().logError("Do not use html in @see. Offending text: " + see + " Located at " + this.fullname + ".");
                    }
                    this.seeTags.add(see);
                    index = id.indexOf("]]></see>", index + "]]></see>".length());
                }
                index = id.indexOf("]]></throws>");
                if (index >= 0) {
                    this.throwsTags = new ArrayList<String>();
                }
                while (index >= 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<throws><![CDATA[", endCDATABefore);
                    this.throwsTags.add(id.substring(begin + "<throws><![CDATA[".length(), index));
                    index = id.indexOf("]]></throws>", index + "]]></throws>".length());
                }
                index = id.indexOf("]]></tiptext>");
                if (index > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<tiptext><![CDATA[", endCDATABefore) + "<tiptext><![CDATA[".length();
                    this.tiptextTag = id.substring(begin, index);
                }
                if ((index = id.indexOf("]]></toolversion>")) > 0) {
                    endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                    begin = id.indexOf("<toolversion><![CDATA[", endCDATABefore) + "<toolversion><![CDATA[".length();
                    this.toolversionTag = id.substring(begin, index);
                }
                index = id.indexOf("]]></");
                while (index >= 0) {
                    int endTag;
                    int beginTag = index + "]]></".length();
                    String tagName = id.substring(beginTag, endTag = id.indexOf(">", beginTag)).intern();
                    if (!this.matchesAnyTag(tagName)) {
                        if (tagName.indexOf("!") != -1) {
                            ThreadLocalToolkit.getLogger().logError("Unexpected symbol ! (" + tagName + ") found in " + this.fullname + ".");
                        }
                        if (tagName.indexOf(":") != -1) {
                            ThreadLocalToolkit.getLogger().logError("Unexpected symbol : (" + tagName + ") found in " + this.fullname + ".");
                        }
                        if (this.customTags == null) {
                            this.customTags = new LinkedHashMap<String, String>();
                        }
                        endCDATABefore = id.substring(0, index).lastIndexOf("]]>");
                        String tag = "<" + tagName + "><![CDATA[";
                        begin = id.indexOf(tag, endCDATABefore) + tag.length();
                        this.customTags.put(tagName, id.substring(begin, index));
                    }
                    index = id.indexOf("]]></", endTag + 1);
                }
            }

            private void processComment(DocCommentNode comment) {
                ClassDefinitionNode cd;
                this.key = new KeyPair("IGNORE", -1);
                this.hasDefaultProperty = false;
                if (comment.def instanceof PackageDefinitionNode) {
                    this.processPackage((PackageDefinitionNode)comment.def);
                } else if (comment.def instanceof ClassDefinitionNode) {
                    cd = (ClassDefinitionNode)comment.def;
                    this.processClassAndInterface(cd);
                } else if (comment.def instanceof FunctionDefinitionNode) {
                    this.processFunction((FunctionDefinitionNode)comment.def);
                } else if (comment.def instanceof VariableDefinitionNode) {
                    this.processField((VariableDefinitionNode)comment.def);
                } else {
                    this.key.name = "Unsupported";
                }
                if (this.key.type == -1) {
                    return;
                }
                this.key.isStatic = this.isStatic;
                if (comment.getId() != null) {
                    this.processTags(comment.getId());
                }
                if (!this.exclude && this.hasInheritTag) {
                    this.processInheritDoc();
                }
                this.processMetadata(comment);
                if (comment.def instanceof ClassDefinitionNode && CommentsTable.this.abcClass != null && !this.hasDefaultProperty) {
                    cd = (ClassDefinitionNode)comment.def;
                    List<MetaData> metadataList = CommentsTable.this.abcClass.getMetaData("DefaultProperty", true);
                    if (metadataList.size() != 0) {
                        this.inheritMetaDataComment(cd.debug_name, metadataList.get(0));
                    }
                }
            }

            private void addToComment(Object[] inheritDoc) {
                String desc = (String)inheritDoc[0];
                List para = (List)inheritDoc[1];
                String retu = (String)inheritDoc[2];
                if (desc != null) {
                    this.description = this.inheritDocTagLocation != null && this.inheritDocTagLocation.equals("before-description") ? desc + this.description : this.description + desc;
                }
                if (para != null) {
                    if (this.paramTags != null) {
                        int diff = para.size() - this.paramTags.size();
                        if (diff > 0) {
                            int size;
                            for (int i = size = this.paramTags.size(); i < size + diff; ++i) {
                                this.paramTags.add((String)para.get(i));
                            }
                        }
                    } else {
                        this.paramTags = para;
                    }
                }
                if (this.returnTag == null && retu != null) {
                    this.returnTag = retu;
                }
            }

            public Object[] getInheritedDoc() {
                Object[] inheritDoc;
                if (this.hasInheritTag && this.exclude && (inheritDoc = CommentsTable.this.findInheritDoc(this.key)) != null) {
                    this.addToComment(inheritDoc);
                }
                inheritDoc = new Object[]{this.getDescription(), this.getParamTags(), this.getReturnTag()};
                return inheritDoc;
            }

            private void processInheritDoc() {
                Object[] inheritDoc = CommentsTable.this.findInheritDoc(this.key);
                if (inheritDoc != null) {
                    this.addToComment(inheritDoc);
                    this.hasInheritTag = false;
                } else if (Trace.asdoc) {
                    System.out.println("Cannot find inherited documentation for: " + this.key.name);
                }
            }

            @Override
            public Map<String, Object> getAllTags() {
                LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
                tags.put("author", this.getAuthorTags());
                tags.put("copy", this.getCopyTag());
                tags.put("default", this.getDefaultTag());
                tags.put("event", this.getEventTags());
                tags.put("eventType", this.getEventTypeTag());
                tags.put("example", this.getExampleTags());
                tags.put("helpid", this.getHelpidTag());
                tags.put("includeExample", this.getIncludeExampleTags());
                tags.put("internal", this.getInternalTag());
                tags.put("langversion", this.getLangversionTag());
                tags.put("param", this.getParamTags());
                tags.put("playerversion", this.getPlayerversionTags());
                tags.put("productversion", this.getProductversionTags());
                tags.put("since", this.getSinceTag());
                tags.put("return", this.getReturnTag());
                tags.put("see", this.getSeeTags());
                tags.put("throws", this.getThrowsTags());
                tags.put("tiptext", this.getTiptextTag());
                tags.put("toolversion", this.getToolversionTag());
                tags.put("inheritDoc", this.hasInheritTag());
                tags.put("private", this.hasPrivateTag());
                tags.put("review", this.hasReviewTag());
                tags.put("custom", this.getCustomTags());
                return tags;
            }

            @Override
            public int getType() {
                return this.key.type;
            }

            @Override
            public String getDescription() {
                return this.description;
            }

            @Override
            public List<String> getParamTags() {
                return this.paramTags;
            }

            @Override
            public String getReturnTag() {
                return this.returnTag;
            }

            @Override
            public String getAccess() {
                return this.access;
            }

            @Override
            public String getArrayType_meta() {
                return this.arrayType_meta;
            }

            @Override
            public List<String> getAuthorTags() {
                return this.authorTags;
            }

            @Override
            public String getBaseClass() {
                return this.baseClass;
            }

            @Override
            public String[] getBaseclasses() {
                return this.baseClasses;
            }

            @Override
            public String getCopyTag() {
                return this.copyTag;
            }

            @Override
            public Map<String, String> getCustomTags() {
                return this.customTags;
            }

            @Override
            public String getDefaultTag() {
                return this.defaultTag;
            }

            @Override
            public String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public String getEnumeration_meta() {
                return this.enumeration_meta;
            }

            @Override
            public String getTheme_meta() {
                return this.theme_meta;
            }

            @Override
            public String getEvent_meta() {
                return this.event_meta;
            }

            @Override
            public String getMessage_meta() {
                return this.message_meta;
            }

            @Override
            public String getReplacement_meta() {
                return this.replacement_meta;
            }

            @Override
            public String getSince_meta() {
                return this.since_meta;
            }

            @Override
            public List<String> getEventTags() {
                return this.eventTags;
            }

            @Override
            public String getEventTypeTag() {
                return this.eventTypeTag;
            }

            @Override
            public List<String> getExampleTags() {
                return this.exampleTags;
            }

            @Override
            public String getFormat_meta() {
                return this.format_meta;
            }

            @Override
            public String getInherit_meta() {
                return this.inherit_meta;
            }

            @Override
            public String getHelpidTag() {
                return this.helpidTag;
            }

            @Override
            public List<String> getIncludeExampleTags() {
                return this.includeExampleTags;
            }

            @Override
            public String[] getInterfaces() {
                return this.interfaces;
            }

            @Override
            public String getInternalTag() {
                return this.internalTag;
            }

            @Override
            public String getKind_meta() {
                return this.kind_meta;
            }

            @Override
            public String getLangversionTag() {
                return this.langversionTag;
            }

            @Override
            public List<CommentEntry> getMetadata() {
                return this.metadata;
            }

            @Override
            public String getMetadataType() {
                return this.metadataType;
            }

            @Override
            public String getName() {
                return this.key.name;
            }

            @Override
            public String getFullname() {
                return this.fullname;
            }

            @Override
            public String getNamespace() {
                return this.namespace;
            }

            @Override
            public String getOwner() {
                return this.owner;
            }

            @Override
            public String[] getParamDefaults() {
                return this.paramDefaults;
            }

            @Override
            public String[] getParamNames() {
                return this.paramNames;
            }

            @Override
            public String[] getParamTypes() {
                return this.paramTypes;
            }

            @Override
            public List<String> getPlayerversionTags() {
                return this.playerversionTags;
            }

            @Override
            public List<String> getProductversionTags() {
                return this.productversionTags;
            }

            @Override
            public String getSinceTag() {
                return this.sinceTag;
            }

            @Override
            public String getResultType() {
                return this.resultType;
            }

            @Override
            public List<String> getSeeTags() {
                return this.seeTags;
            }

            @Override
            public String getSourceFile() {
                return this.sourcefile;
            }

            @Override
            public List<String> getThrowsTags() {
                return this.throwsTags;
            }

            @Override
            public String getTiptextTag() {
                return this.tiptextTag;
            }

            @Override
            public String getToolversionTag() {
                return this.toolversionTag;
            }

            @Override
            public String getType_meta() {
                return this.type_meta;
            }

            @Override
            public String getVartype() {
                return this.vartype;
            }

            @Override
            public boolean hasInheritTag() {
                return this.hasInheritTag;
            }

            @Override
            public boolean hasPrivateTag() {
                return this.hasPrivateTag;
            }

            @Override
            public boolean hasReviewTag() {
                return this.hasReviewTag;
            }

            @Override
            public boolean isConst() {
                return this.isConst;
            }

            @Override
            public boolean isDynamic() {
                return this.isDynamic;
            }

            @Override
            public boolean isExcluded() {
                return this.exclude;
            }

            @Override
            public boolean isFinal() {
                return this.isFinal;
            }

            @Override
            public boolean isOverride() {
                return this.isOverride;
            }

            @Override
            public boolean isStatic() {
                return this.isStatic;
            }

            public CommentEntry getSkinPartMetadata() {
                return this.skinPartMetadata;
            }

            public void setMetadata(List<CommentEntry> metadata) {
                this.metadata = metadata;
            }

            @Override
            public String getVariableType_meta() {
                return this.variableType_meta;
            }

            @Override
            public String getRequired_meta() {
                return this.required_meta;
            }
        }
    }
}

