/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.StyleDeclaration;
import flash.css.StyleProperty;
import flash.css.StyleSelector;
import flash.css.StyleSheet;
import flash.fonts.FontManager;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.common.PathResolver;
import flex2.compiler.css.Import;
import flex2.compiler.css.ParseError;
import flex2.compiler.css.Reference;
import flex2.compiler.css.StyleDef;
import flex2.compiler.css.StyleModule;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.io.VirtualZipFile;
import flex2.compiler.mxml.MxmlCompiler;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesContainer
extends StyleModule {
    private static final String TEMPLATE_PATH = "flex2/compiler/css/";
    private static final String ATEMBEDS_KEY = "atEmbeds";
    private static final String CLASSNAME_KEY = "className";
    private static final String STYLEDEFLIST_KEY = "styleDefList";
    private static final String _FONTFACERULES = "_FontFaceRules";
    protected MxmlDocument mxmlDocument;
    private QName mxmlDocumentQName;
    protected MxmlConfiguration mxmlConfiguration;
    protected CompilationUnit compilationUnit;
    protected Set<String> localStyleTypeNames = new HashSet<String>();
    protected List<VirtualFile> implicitIncludes = new ArrayList<VirtualFile>();
    protected StyleDefList lastStyleDefList;

    public StylesContainer(MxmlConfiguration mxmlConfiguration, CompilationUnit compilationUnit, ContextStatics perCompileData) {
        super(compilationUnit.getSource(), perCompileData);
        this.mxmlConfiguration = mxmlConfiguration;
        this.compilationUnit = compilationUnit;
        if (mxmlConfiguration != null) {
            if (mxmlConfiguration.getCompatibilityVersion() <= 0x3000000) {
                this.setAdvanced(false);
                this.setQualifiedTypeSelectors(false);
            } else {
                this.setQualifiedTypeSelectors(mxmlConfiguration.getQualifiedTypeSelectors());
            }
        }
    }

    MxmlDocument getMxmlDocument() {
        return this.mxmlDocument;
    }

    public void setMxmlDocument(MxmlDocument doc) {
        this.mxmlDocument = doc;
        if (this.mxmlDocument != null) {
            this.mxmlDocumentQName = this.mxmlDocument.getQName();
        }
    }

    public List<Source> processDependencies(Set<String> defNames, ResourceContainer resources, String packageName, String className) {
        if (className == null) {
            return Collections.emptyList();
        }
        ArrayList<Source> extraSources = new ArrayList<Source>();
        if (!this.fontFaceRules.isEmpty()) {
            this.compilationUnit.extraClasses.add(_FONTFACERULES);
            this.compilationUnit.mixins.add(_FONTFACERULES);
            extraSources.add(this.generateFontFaceRules(resources));
        }
        HashSet<String> processedDefNames = new HashSet<String>();
        for (String defName : defNames) {
            if (this.qualifiedTypeSelectors) {
                processedDefNames.add(NameFormatter.toDot(defName));
                continue;
            }
            processedDefNames.add(defName.replaceFirst(".*:", ""));
        }
        StyleDefList filteredStyleDefs = new StyleDefList();
        for (Map.Entry entry : this.styleDefs.entrySet()) {
            String styleName = (String)entry.getKey();
            StyleDef styleDef = (StyleDef)entry.getValue();
            String typeName = StyleDef.dehyphenize(styleName);
            if (styleDef.isTypeSelector() && !processedDefNames.contains(typeName) && !this.mxmlConfiguration.keepAllTypeSelectors() && !styleName.equals("global")) continue;
            filteredStyleDefs.add(styleDef);
        }
        if (filteredStyleDefs.size() > 0) {
            className = "_" + className + "_Styles";
            this.compilationUnit.extraClasses.add(className);
            this.compilationUnit.mixins.add(className);
            extraSources.add(this.generateStyleSource(filteredStyleDefs, resources, packageName, className));
        }
        return extraSources;
    }

    private boolean hasNonRootTypeSelectors(String subject, String selector, int lineNumber) {
        if (!this.compilationUnit.isRoot() && !"*".equals(subject)) {
            ComponentTypeSelectorsNotSupported componentTypeSelectorsNotSupported = new ComponentTypeSelectorsNotSupported(this.getSource().getName(), lineNumber, selector);
            ThreadLocalToolkit.log(componentTypeSelectorsNotSupported);
            return true;
        }
        return false;
    }

    public void validate(SymbolTable symbolTable, NameMappings nameMappings, StandardDefs standardDefs, Set<String> themeNames, Set<String> addedCSSFiles) {
        Set<String> classNames;
        TypeTable typeTable = (TypeTable)symbolTable.getContext().getAttribute(MxmlCompiler.TYPE_TABLE);
        if (typeTable == null) {
            typeTable = new TypeTable(symbolTable, nameMappings, standardDefs, themeNames);
        }
        if (this.qualifiedTypeSelectors) {
            classNames = symbolTable.getClassNames();
        } else {
            classNames = new HashSet<String>();
            for (String className : symbolTable.getClassNames()) {
                if (this.qualifiedTypeSelectors) {
                    classNames.add(NameFormatter.toDot(className));
                    continue;
                }
                classNames.add(className.replaceFirst(".*:", ""));
            }
        }
        String themeNamesString = themeNames.toString();
        themeNamesString = themeNamesString.substring(1, themeNamesString.length() - 1);
        for (Map.Entry entry : this.styleDefs.entrySet()) {
            String styleName = (String)entry.getKey();
            StyleDef styleDef = (StyleDef)entry.getValue();
            String typeName = StyleDef.dehyphenize(styleName);
            Map<String, StyleDeclaration> declarations = styleDef.getDeclarations();
            if (declarations == null) continue;
            for (StyleDeclaration styleDeclaration : declarations.values()) {
                Type type;
                Map<String, StyleProperty> styleProperties = styleDeclaration.getProperties();
                if (addedCSSFiles != null && !addedCSSFiles.contains(styleDeclaration.getPath())) continue;
                if (styleDef.isTypeSelector() && this.qualifiedTypeSelectors && this.mxmlConfiguration.showInvalidCssPropertyWarnings() && (type = typeTable.getType(NameFormatter.toColon(typeName))) != null) {
                    this.validateTypeSelectorProperties(styleProperties, type, styleDef, typeName, themeNamesString);
                }
                if (this.mxmlDocumentQName == null) continue;
                Type mxmlDocumentType = typeTable.getType(this.mxmlDocumentQName.toString());
                assert (mxmlDocumentType != null);
                this.validatePropertyReferences(styleProperties, mxmlDocumentType);
            }
            if (!this.localStyleTypeNames.contains(styleName) || classNames.contains(NameFormatter.toColon(typeName)) || styleName.equals("global") || !this.mxmlConfiguration.showUnusedTypeSelectorWarnings()) continue;
            ThreadLocalToolkit.log(new UnusedTypeSelector(this.getPathForReporting(styleDef), styleDef.getLineNumber(), styleName));
        }
    }

    private void validateTypeSelectorProperties(Map<String, StyleProperty> styleProperties, Type type, StyleDef styleDef, String typeName, String themeNamesString) {
        if (styleProperties != null) {
            for (StyleProperty styleProperty : styleProperties.values()) {
                String stylePropertyName = styleProperty.getName();
                if (type.getStyle(stylePropertyName) != null) continue;
                String styleThemes = type.getStyleThemes(stylePropertyName);
                if (type.isExcludedStyle(stylePropertyName)) {
                    ThreadLocalToolkit.log(new ExcludedStyleProperty(styleProperty.getPath(), styleProperty.getLineNumber(), stylePropertyName, typeName));
                    continue;
                }
                if (styleThemes != null) {
                    ThreadLocalToolkit.log(new InvalidStyleTheme(styleProperty.getPath(), styleProperty.getLineNumber(), stylePropertyName, typeName, styleThemes));
                    continue;
                }
                if (this.mxmlDocument == null) continue;
                ThreadLocalToolkit.log(new InvalidStyleProperty(styleProperty.getPath(), styleProperty.getLineNumber(), stylePropertyName, typeName));
            }
        }
    }

    private void validatePropertyReferences(Map<String, StyleProperty> styleProperties, Type mxmlDocumentType) {
        if (styleProperties != null) {
            for (StyleProperty styleProperty : styleProperties.values()) {
                Reference reference;
                Object value = styleProperty.getValue();
                if (!(value instanceof Reference) || (reference = (Reference)value).isClassReference() || mxmlDocumentType.getProperty(reference.getValue()) != null) continue;
                InvalidPropertyReference invalidPropertyReference = new InvalidPropertyReference(reference.getValue());
                invalidPropertyReference.path = styleProperty.getPath();
                invalidPropertyReference.line = styleProperty.getLineNumber();
                ThreadLocalToolkit.log(invalidPropertyReference);
            }
        }
    }

    @Override
    protected void addSelectorToStyleDef(String subject, StyleDeclaration declaration, boolean isTypeSelector, boolean isLocal, int lineNumber) {
        StyleDef styleDef;
        if (isTypeSelector && this.hasNonRootTypeSelectors(subject, subject, lineNumber)) {
            return;
        }
        if (isTypeSelector && isLocal) {
            this.localStyleTypeNames.add(subject);
        }
        if (this.styleDefs.containsKey(subject)) {
            styleDef = (StyleDef)this.styleDefs.get(subject);
        } else {
            styleDef = new StyleDef(subject, isTypeSelector, this.mxmlDocument, this.mxmlConfiguration, this.compilationUnit.getSource(), lineNumber, this.perCompileData);
            this.styleDefs.put(subject, styleDef);
        }
        styleDef.addDeclaration(declaration);
        if (this.mxmlDocument != null) {
            for (Import importObject : styleDef.getImports()) {
                this.mxmlDocument.addImport(importObject.getValue(), importObject.getLineNumber());
            }
        }
    }

    @Override
    protected void addAdvancedSelectorToStyleDef(String subject, StyleDeclaration declaration, StyleSelector selector, boolean isLocal, int lineNumber) {
        StyleDef styleDef;
        if (this.hasNonRootTypeSelectors(subject, selector.toString(), lineNumber)) {
            return;
        }
        String styleDefKey = subject;
        if ("*".equals(subject)) {
            styleDefKey = "global";
            if (selector.getConditions() != null && selector.getConditions().size() > 0) {
                selector.setValue("");
            }
        }
        if (this.styleDefs.containsKey(styleDefKey)) {
            styleDef = (StyleDef)this.styleDefs.get(styleDefKey);
        } else {
            if (isLocal && !"global".equals(styleDefKey)) {
                this.localStyleTypeNames.add(subject);
            }
            styleDef = new StyleDef(subject, this.mxmlDocument, this.mxmlConfiguration, this.getSource(), lineNumber, this.perCompileData);
            this.styleDefs.put(styleDefKey, styleDef);
        }
        styleDef.addDeclaration(subject, selector, declaration);
        if (this.mxmlDocument != null) {
            for (Import importObject : styleDef.getImports()) {
                this.mxmlDocument.addImport(importObject.getValue(), importObject.getLineNumber());
            }
        }
    }

    @Override
    protected void addAtEmbed(AtEmbed atEmbed) {
        if (this.mxmlDocument != null) {
            this.mxmlDocument.addAtEmbed(atEmbed);
        } else if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
    }

    private String generateFontFaceRuleSourceName() {
        String genDir = this.mxmlConfiguration.getGeneratedDirectory();
        String genFileName = genDir != null ? genDir + File.separatorChar + "_FontFaceRules.as" : "_FontFaceRules.as";
        return genFileName;
    }

    private Source generateFontFaceRules(ResourceContainer resources) {
        Template template;
        String genFileName = this.generateFontFaceRuleSourceName();
        Source styleSource = resources.findSource(genFileName);
        if (styleSource != null) {
            if (styleSource.getCompilationUnit() == null) {
                styleSource = null;
            } else {
                return styleSource;
            }
        }
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        String fontFaceRulesTemplate = TEMPLATE_PATH + standardDefs.getFontFaceRulesTemplate();
        try {
            template = VelocityManager.getTemplate(fontFaceRulesTemplate);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(fontFaceRulesTemplate));
            return null;
        }
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, this.mxmlConfiguration.debug(), out, null);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(ATEMBEDS_KEY, (Object)this.atEmbeds);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(this.compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return resources.addResource(this.createSource(genFileName, out, Long.MAX_VALUE));
    }

    private Source createSource(String fileName, SourceCodeBuffer sourceCodeBuffer, long lastModifiedTime) {
        Source result = null;
        if (sourceCodeBuffer.getBuffer() != null) {
            String sourceCode = sourceCodeBuffer.toString();
            if (this.mxmlConfiguration.keepGeneratedActionScript()) {
                try {
                    FileUtil.writeFile(fileName, sourceCode);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(fileName, e.getMessage()));
                }
            }
            TextFile genFile = new TextFile(sourceCode, fileName, null, "text/as", lastModifiedTime);
            String shortName = fileName.substring(0, fileName.lastIndexOf(46));
            result = new Source((VirtualFile)genFile, "", shortName, null, false, false, false);
            result.setPathResolver(this.compilationUnit.getSource().getPathResolver());
            for (VirtualFile virtualFile : this.implicitIncludes) {
                result.addFileInclude(virtualFile);
            }
        }
        return result;
    }

    private Source generateStyleSource(StyleDefList styleDefList, ResourceContainer resources, String packageName, String className) {
        Template template;
        String genFileName = this.generateStyleSourceName(packageName, className);
        Source styleSource = resources.findSource(genFileName);
        if (styleSource != null) {
            if (styleSource.getCompilationUnit() == null) {
                styleSource = null;
            } else if (this.lastStyleDefList != null && ((Object)this.lastStyleDefList.getStyleDefs()).equals(styleDefList.getStyleDefs())) {
                return styleSource;
            }
        }
        this.lastStyleDefList = styleDefList;
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        String styleDefTemplate = TEMPLATE_PATH + standardDefs.getStyleDefTemplate();
        try {
            template = VelocityManager.getTemplate(styleDefTemplate);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(styleDefTemplate));
            return null;
        }
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, this.mxmlConfiguration.debug(), out, null);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(STYLEDEFLIST_KEY, (Object)styleDefList);
            vc.put(CLASSNAME_KEY, (Object)className);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(this.compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return resources.addResource(this.createSource(genFileName, out, System.currentTimeMillis()));
    }

    private String generateStyleSourceName(String packageName, String className) {
        String genDir = this.mxmlConfiguration.getGeneratedDirectory();
        String genFileName = genDir != null ? genDir + File.separatorChar + className + ".as" : className + ".as";
        return genFileName;
    }

    public void loadDefaultStyles() {
        VirtualFile defaultsCSSFile = this.resolveDefaultsCssFile();
        for (VirtualFile swcDefaultsCssFile : this.mxmlConfiguration.getDefaultsCssFiles()) {
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver(0, swcDefaultsCssFile);
            this.processStyleSheet(swcDefaultsCssFile);
            ThreadLocalToolkit.getPathResolver().removeSinglePathResolver(swcDefaultsCssFile);
        }
        if (defaultsCSSFile != null) {
            if (!(defaultsCSSFile instanceof VirtualZipFile)) {
                this.processStyleSheet(defaultsCSSFile);
            }
        } else {
            ThreadLocalToolkit.log(new DefaultCSSFileNotFound());
        }
        for (VirtualFile themeCssFile : this.mxmlConfiguration.getThemeCssFiles()) {
            ThreadLocalToolkit.getPathResolver().addSinglePathResolver(0, themeCssFile);
            this.processStyleSheet(themeCssFile);
            ThreadLocalToolkit.getPathResolver().removeSinglePathResolver(themeCssFile);
        }
    }

    private VirtualFile resolveDefaultsCssFile() {
        VirtualFile defaultsCSSFile = this.mxmlConfiguration.getDefaultsCssUrl();
        if (defaultsCSSFile == null) {
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            String version = this.mxmlConfiguration.getCompatibilityVersionString();
            if (version != null) {
                defaultsCSSFile = resolver.resolve("defaults-" + version + ".css");
            }
            if (defaultsCSSFile == null) {
                defaultsCSSFile = resolver.resolve("defaults.css");
            }
        }
        return defaultsCSSFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStyleSheet(VirtualFile cssFile) {
        this.implicitIncludes.add(cssFile);
        InputStream cssFileStream = null;
        try {
            FontManager fontManager = this.mxmlConfiguration.getFontsConfiguration().getTopLevelManager();
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.checkDeprecation(this.mxmlConfiguration.showDeprecationWarnings());
            cssFileStream = cssFile.getInputStream();
            styleSheet.parse(cssFile.getName(), cssFileStream, ThreadLocalToolkit.getLogger(), fontManager);
            this.extractStyles(styleSheet, false);
        }
        catch (Exception exception) {
            ParseError m = new ParseError(exception.getLocalizedMessage());
            m.setPath(cssFile.getName());
            ThreadLocalToolkit.log(m);
        }
        finally {
            block13: {
                if (cssFileStream != null) {
                    try {
                        cssFileStream.close();
                    }
                    catch (IOException e) {
                        if (!Trace.error) break block13;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String getPathForReporting(StyleDef styleDef) {
        if (styleDef.isAdvanced()) {
            Map<String, StyleDeclaration> declarations = styleDef.getDeclarations();
            for (StyleDeclaration decl : declarations.values()) {
                if (decl == null || decl.getPath() == null) continue;
                return decl.getPath();
            }
        }
        return this.compilationUnit.getSource().getName();
    }

    public static class InvalidPropertyReference
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3730898410175891395L;
        public String value;

        public InvalidPropertyReference(String value) {
            this.value = value;
        }
    }

    public static class ComponentTypeSelectorsNotSupported
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -1211821282841071569L;
        public String selector;

        public ComponentTypeSelectorsNotSupported(String path, int line, String selector) {
            this.path = path;
            this.line = line;
            this.selector = selector;
        }
    }

    public static class UnusedTypeSelector
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -655374071288180326L;
        public String styleName;

        public UnusedTypeSelector(String path, int line, String styleName) {
            this.path = path;
            this.line = line;
            this.styleName = styleName;
        }
    }

    public static class InvalidStyleTheme
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -655374071288180328L;
        public String stylePropertyName;
        public String typeName;
        public String styleThemes;

        public InvalidStyleTheme(String path, int line, String stylePropertyName, String typeName, String styleThemes) {
            this.path = path;
            this.line = line;
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
            this.styleThemes = styleThemes;
        }
    }

    public static class InvalidStyleProperty
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -655374071288180326L;
        public String stylePropertyName;
        public String typeName;

        public InvalidStyleProperty(String path, int line, String stylePropertyName, String typeName) {
            this.path = path;
            this.line = line;
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
        }
    }

    public static class ExcludedStyleProperty
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -655374071288180325L;
        public String stylePropertyName;
        public String typeName;

        public ExcludedStyleProperty(String path, int line, String stylePropertyName, String typeName) {
            this.path = path;
            this.line = line;
            this.stylePropertyName = stylePropertyName;
            this.typeName = typeName;
        }
    }

    public static class DefaultCSSFileNotFound
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -7274067342526310418L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StyleDefList {
        List<StyleDef> styleDefs = new ArrayList<StyleDef>();

        public List<StyleDef> getStyleDefs() {
            return this.styleDefs;
        }

        public void add(StyleDef styleDef) {
            this.styleDefs.add(styleDef);
        }

        public int size() {
            return this.styleDefs.size();
        }

        public boolean isAdvanced() {
            for (StyleDef styleDef : this.styleDefs) {
                if (!styleDef.isAdvanced()) continue;
                return true;
            }
            return false;
        }

        public boolean getAllowDuplicateDefaultStyleDeclarations() {
            for (StyleDef styleDef : this.styleDefs) {
                if (!styleDef.getAllowDuplicateDefaultStyleDeclarations()) continue;
                return true;
            }
            return false;
        }

        public Set<Import> getImports() {
            HashSet<Import> result = new HashSet<Import>();
            for (StyleDef styleDef : this.styleDefs) {
                result.addAll(styleDef.getImports());
            }
            return result;
        }

        public Set<AtEmbed> getAtEmbeds() {
            HashSet<AtEmbed> result = new HashSet<AtEmbed>();
            for (StyleDef styleDef : this.styleDefs) {
                result.addAll(styleDef.getAtEmbeds());
            }
            return result;
        }
    }
}

