/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeSharedLibrarySettingsConfiguration {
    private Configuration configuration;
    protected ConfigurationPathResolver configResolver;
    private Set<VirtualFile> forceRsls;

    public RuntimeSharedLibrarySettingsConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public VirtualFile[] getForceRsls() {
        if (this.forceRsls == null) {
            return new VirtualFile[0];
        }
        return this.forceRsls.toArray(new VirtualFile[0]);
    }

    public Set<String> getForceRslsPaths() {
        if (this.forceRsls == null) {
            return Collections.emptySet();
        }
        HashSet<String> rslPaths = new HashSet<String>();
        for (VirtualFile file : this.forceRsls) {
            rslPaths.add(file.getName());
        }
        return rslPaths;
    }

    public void cfgForceRsls(ConfigurationValue cfgval, String[] args) throws ConfigurationException {
        if (this.forceRsls == null) {
            this.forceRsls = new HashSet<VirtualFile>();
        }
        for (String arg : args) {
            VirtualFile swcFile = ConfigurationPathResolver.getVirtualFile(arg, this.configResolver, cfgval);
            String swcPath = swcFile.getName();
            if (!this.doesSwcHaveRSLInfo(swcPath)) {
                throw new ConfigurationException.SwcDoesNotHaveRslData(swcPath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.forceRsls.add(swcFile);
        }
    }

    public static ConfigurationInfo getForceRslsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getPrerequisites() {
                return new String[]{"runtime-shared-library-path"};
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    private boolean doesSwcHaveRSLInfo(String swcPath) {
        if (swcPath == null) {
            return false;
        }
        List<Configuration.RslPathInfo> rslInfoList = this.configuration.getRslPathInfo();
        for (Configuration.RslPathInfo rslInfo : rslInfoList) {
            if (!swcPath.equals(rslInfo.getSwcVirtualFile().getName())) continue;
            return true;
        }
        return false;
    }
}

