/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flex2.compiler.asdoc.AsClass;
import flex2.compiler.asdoc.AsDocUtil;
import flex2.compiler.asdoc.QualifiedNameInfo;
import flex2.compiler.asdoc.SortComparator;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.ASDoc;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TopLevelClassesGenerator {
    private final String GLOBAL = "$$Global$$";
    private Document asDocConfig;
    private Document domObject;
    private Document outputObject;
    private Element root;
    private String errorFile = "validation_errors.log";
    private String namespaces = ":";
    private String hiddenPackages = ":";
    private boolean verbose = false;
    private boolean includePrivate;
    private AsDocUtil asDocUtil;
    private HashMap<String, String> oldNewNamesMap;
    private HashMap<String, AsClass> classTable = null;
    private HashMap<String, HashMap<String, AsClass>> packageContentsTable = null;
    private HashMap<String, Element> packageTable = null;
    private HashMap<String, String> bindableTable = null;
    private DocumentBuilderFactory factory;
    private DocumentBuilder parser;

    public TopLevelClassesGenerator(Document asDocConfig, Document domObject) {
        this.asDocConfig = asDocConfig;
        this.domObject = domObject;
        this.classTable = new HashMap();
        this.packageContentsTable = new HashMap();
        this.packageTable = new HashMap();
        this.bindableTable = new HashMap();
    }

    public void initialize() throws Exception {
        NodeList asPackageNodeList;
        this.factory = DocumentBuilderFactory.newInstance();
        this.parser = this.factory.newDocumentBuilder();
        this.outputObject = this.parser.newDocument();
        this.oldNewNamesMap = new HashMap();
        this.oldNewNamesMap.put("em", "i");
        this.oldNewNamesMap.put("strong", "b");
        this.oldNewNamesMap.put("bold", "b");
        this.root = this.outputObject.createElement("asdoc");
        NodeList options = this.asDocConfig.getElementsByTagName("options");
        String buildnum = ((Element)options.item(0)).getAttribute("buildNum");
        if (buildnum != null) {
            this.root.setAttribute("build", buildnum);
        } else {
            this.root.setAttribute("build", "0");
        }
        if (((Element)options.item(0)).getAttribute("verbose").equals("true")) {
            this.verbose = true;
        }
        this.asDocUtil = new AsDocUtil(this.verbose);
        String includePrivateStr = ((Element)options.item(0)).getAttribute("includePrivate");
        if ("true".equals(includePrivateStr)) {
            this.includePrivate = true;
        }
        Element link = this.outputObject.createElement("link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("href", "style.css");
        link.setAttribute("type", "text/css");
        this.root.appendChild(link);
        this.outputObject.appendChild(this.root);
        NodeList namespaceNodeList = this.asDocConfig.getElementsByTagName("namespace");
        if (namespaceNodeList != null) {
            for (int ix = 0; ix < namespaceNodeList.getLength(); ++ix) {
                Element nameSpaceElement = (Element)namespaceNodeList.item(ix);
                String hide = nameSpaceElement.getAttribute("hide");
                if (hide == null) continue;
                this.namespaces = this.namespaces + nameSpaceElement.getTextContent() + ":" + hide + ":";
            }
        }
        if ((asPackageNodeList = this.asDocConfig.getElementsByTagName("asPackage")) != null) {
            for (int ix = 0; ix < asPackageNodeList.getLength(); ++ix) {
                Element asPackageElement = (Element)asPackageNodeList.item(ix);
                String hide = asPackageElement.getAttribute("hide");
                if (hide == null) continue;
                this.hiddenPackages = this.hiddenPackages + asPackageElement.getTextContent() + ":" + hide + ":";
            }
        }
        AsClass tempAsClass = new AsClass();
        tempAsClass.setName("$$Global$$");
        tempAsClass.setFullName("$$Global$$");
        tempAsClass.setBaseName("Object");
        tempAsClass.setDecompName(this.asDocUtil.decomposeFullClassName("Object"));
        Element aClass = this.outputObject.createElement("aClass");
        tempAsClass.setNode(aClass);
        this.classTable.put("$$Global$$", tempAsClass);
        HashMap<String, AsClass> packageContents = new HashMap<String, AsClass>();
        packageContents.put("$$Global$$", tempAsClass);
        this.packageContentsTable.put("$$Global$$", packageContents);
    }

    public void generate() {
        this.preprocessClasses();
        this.processClasses();
        this.processExcludes();
        this.processFields();
        this.processMethods();
        this.processMetadata();
        this.processClassInheritance();
        this.assembleClassXML();
        this.assembleClassPackageHierarchy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOutputFiles(String ditaOutputDir, String outputDir, boolean lenient) {
        block23: {
            String fileName;
            DOMSource source;
            StreamResult result;
            Transformer trans;
            TreeSet<String> packageNames;
            block24: {
                if (this.asDocUtil.isErrors()) {
                    this.errorFile = outputDir.endsWith(File.separator) ? outputDir + this.errorFile : outputDir + File.separator + this.errorFile;
                    try {
                        FileUtil.writeFile(this.errorFile, this.asDocUtil.getValidationErrors());
                    }
                    catch (IOException ex) {
                        System.out.println("Error in writing error file " + ex.getMessage());
                    }
                    ThreadLocalToolkit.log(new ASDoc.ValidationMessage(this.errorFile));
                    if (!lenient) {
                        return;
                    }
                }
                String ditaDTDLoc = "";
                NodeList ditaDTDDirList = this.asDocConfig.getElementsByTagName("ditaDTDDir");
                if (ditaDTDDirList != null && ditaDTDDirList.getLength() != 0) {
                    ditaDTDLoc = ditaDTDDirList.item(0).getTextContent();
                }
                packageNames = new TreeSet<String>(new SortComparator());
                TransformerFactory transfac = TransformerFactory.newInstance();
                trans = null;
                try {
                    trans = transfac.newTransformer();
                    trans.setOutputProperty("encoding", "UTF-8");
                    trans.setOutputProperty("indent", "no");
                    if (!ditaDTDLoc.equals("")) {
                        trans.setOutputProperty("doctype-system", ditaDTDLoc + "/" + "adobeAPIPackage.dtd");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                StringWriter sw = null;
                result = null;
                source = null;
                fileName = null;
                Element packages = this.asDocUtil.getElementByTagName(this.root, "packages");
                if (packages == null) break block23;
                NodeList apiPackageList = packages.getElementsByTagName("apiPackage");
                OutputStreamWriter osw = null;
                if (apiPackageList == null || apiPackageList.getLength() == 0) break block24;
                for (int packageCount = 0; packageCount < apiPackageList.getLength(); ++packageCount) {
                    String id;
                    block22: {
                        Element apiPackage = (Element)apiPackageList.item(packageCount);
                        id = apiPackage.getAttribute("id");
                        fileName = ditaOutputDir + File.separator + id + ".xml";
                        source = new DOMSource(apiPackage);
                        sw = new StringWriter();
                        result = new StreamResult(sw);
                        trans.transform(source, result);
                        String xmlString = sw.toString();
                        Pattern pattern = Pattern.compile("\r");
                        Matcher match = pattern.matcher(xmlString);
                        xmlString = match.replaceAll("");
                        pattern = Pattern.compile("\n\n");
                        match = pattern.matcher(xmlString);
                        xmlString = match.replaceAll("\n");
                        xmlString = xmlString.replaceAll("<!\\[CDATA\\[", "");
                        xmlString = xmlString.replaceAll("\\]\\]>", "");
                        xmlString = xmlString.replaceAll("<mxml>", "<mxml><!\\[CDATA\\[");
                        xmlString = xmlString.replaceAll("</mxml>", "\\]\\]></mxml>");
                        osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fileName)), "UTF-8");
                        osw.write(xmlString, 0, xmlString.length());
                        Object var23_27 = null;
                        try {
                            if (osw != null) {
                                osw.close();
                            }
                            break block22;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                        break block22;
                        {
                            catch (Exception ex) {
                                ex.printStackTrace(System.err);
                                var23_27 = null;
                                try {
                                    if (osw != null) {
                                        osw.close();
                                    }
                                    break block22;
                                }
                                catch (IOException ex2) {
                                    ex2.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var23_27 = null;
                            try {
                                if (osw != null) {
                                    osw.close();
                                }
                            }
                            catch (IOException ex2) {
                                ex2.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                    packageNames.add(id);
                }
            }
            Element apiMap = this.asDocUtil.createApiMap(packageNames, this.outputObject);
            String ditaTOC = "packages.dita";
            try {
                fileName = ditaOutputDir + File.separator + ditaTOC;
                result = new StreamResult(new BufferedOutputStream(new FileOutputStream(fileName)));
                source = new DOMSource(apiMap);
                trans.transform(source, result);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private void preprocessClasses() {
        int iChild;
        boolean flag;
        NodeList children;
        int ix;
        NodeList recordList = this.domObject.getElementsByTagName("classRec");
        for (ix = 0; ix < recordList.getLength(); ++ix) {
            Element classRec = (Element)recordList.item(ix);
            if (classRec.getAttribute("access").equals("private") && !this.includePrivate) continue;
            children = classRec.getElementsByTagName("private");
            if (children != null && children.getLength() != 0 && !this.includePrivate) {
                flag = false;
                for (iChild = 0; iChild < children.getLength(); ++iChild) {
                    if (!children.item(iChild).getParentNode().equals(classRec)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ((children = classRec.getElementsByTagName("ExcludeClass")) != null && children.getLength() != 0 || classRec.getAttribute("access").equals("internal")) continue;
            this.preprocessClass(classRec, false);
        }
        recordList = this.domObject.getElementsByTagName("interfaceRec");
        for (ix = 0; ix < recordList.getLength(); ++ix) {
            Element interfaceRec = (Element)recordList.item(ix);
            if (interfaceRec.getAttribute("access").equals("private") && !this.includePrivate) continue;
            children = interfaceRec.getElementsByTagName("private");
            if (children != null && children.getLength() != 0 && !this.includePrivate) {
                flag = false;
                for (iChild = 0; iChild < children.getLength(); ++iChild) {
                    if (!children.item(iChild).getParentNode().equals(interfaceRec)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ((children = interfaceRec.getElementsByTagName("ExcludeClass")) != null && children.getLength() != 0 || interfaceRec.getAttribute("access").equals("internal")) continue;
            this.preprocessClass(interfaceRec, true);
        }
        recordList = this.domObject.getElementsByTagName("packageRec");
        for (ix = 0; ix < recordList.getLength(); ++ix) {
            Element packageRec = (Element)recordList.item(ix);
            String packageName = packageRec.getAttribute("fullname");
            Element apiPackageElement = this.packageTable.get(packageName);
            if (apiPackageElement == null) {
                apiPackageElement = this.outputObject.createElement("apiPackage");
                Element apiNameElement = this.outputObject.createElement("apiName");
                apiNameElement.setTextContent(packageName);
                apiPackageElement.appendChild(apiNameElement);
                apiPackageElement.setAttribute("id", packageName);
                this.packageTable.put(packageName, apiPackageElement);
            }
            String description = ((Element)packageRec.getElementsByTagName("description").item(0)).getTextContent();
            Element shortDescElement = this.outputObject.createElement("shortdesc");
            String textContent = this.asDocUtil.descToShortDesc(description);
            shortDescElement.setTextContent(textContent);
            apiPackageElement.appendChild(shortDescElement);
            Element apiDetailElement = this.outputObject.createElement("apiDetail");
            Element apiDescElement = this.outputObject.createElement("apiDesc");
            CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(description, "description", packageName));
            apiDescElement.appendChild(cdata);
            apiDetailElement.appendChild(apiDescElement);
            apiPackageElement.appendChild(apiDetailElement);
            this.asDocUtil.convertDescToDITA(apiDescElement, this.oldNewNamesMap);
            NodeList privateChilds = packageRec.getElementsByTagName("private");
            if (privateChilds != null && privateChilds.getLength() != 0) {
                boolean flag2 = false;
                for (int iChild2 = 0; iChild2 < privateChilds.getLength(); ++iChild2) {
                    if (!privateChilds.item(iChild2).getParentNode().equals(packageRec)) continue;
                    flag2 = true;
                    break;
                }
                if (flag2) {
                    Element apiAccessElement = this.outputObject.createElement("apiAccess");
                    apiAccessElement.setAttribute("value", "private");
                    apiPackageElement.appendChild(apiAccessElement);
                }
            }
            this.processCustoms(packageRec, apiPackageElement, false, "", "", "");
        }
    }

    private void preprocessClass(Element record, boolean isInterface) {
        Element descriptionElement;
        String isDynamic;
        String isFinal;
        HashMap<String, AsClass> packageContents;
        String fullName = record.getAttribute("fullname");
        if (this.verbose) {
            System.out.println("preprocessing " + fullName);
        }
        AsClass thisClass = new AsClass();
        thisClass.setDecompName(this.asDocUtil.decomposeFullClassName(fullName));
        String packageName = thisClass.getDecompName().getPackageName();
        if (this.asDocUtil.hidePackage(packageName, this.hiddenPackages)) {
            return;
        }
        String name = record.getAttribute("name");
        thisClass.setName(name);
        thisClass.setFullName(fullName);
        thisClass.setBaseName(record.getAttribute("baseclass"));
        thisClass.setInterfaceFlag(isInterface);
        thisClass.setSourceFile(record.getAttribute("sourcefile"));
        this.classTable.put(fullName, thisClass);
        if (packageName == null || packageName.equals("")) {
            packageName = "$$Global$$";
        }
        if (this.verbose) {
            System.out.println("  adding class " + name + " to package: " + packageName);
        }
        if ((packageContents = this.packageContentsTable.get(packageName)) == null) {
            packageContents = new HashMap();
            this.packageContentsTable.put(packageName, packageContents);
        }
        packageContents.put(name, thisClass);
        String accessLevel = record.getAttribute("access");
        String href = "";
        Element hrefElement = this.asDocUtil.getElementByTagName(record, "href");
        if (hrefElement != null) {
            href = hrefElement.getTextContent();
        }
        thisClass.setHref(href);
        String author = "";
        Element authorElement = this.asDocUtil.getElementByTagName(record, "author");
        if (authorElement != null) {
            author = authorElement.getTextContent();
        }
        if ((isFinal = record.getAttribute("isFinal")).equals("")) {
            isFinal = "false";
        }
        if ((isDynamic = record.getAttribute("isDynamic")).equals("")) {
            isDynamic = "false";
        }
        Element nuClass = this.outputObject.createElement("apiClassifier");
        nuClass.setAttribute("id", this.asDocUtil.formatId(fullName));
        Element apiName = this.outputObject.createElement("apiName");
        apiName.setTextContent(name);
        nuClass.appendChild(apiName);
        Element shortdesc = this.outputObject.createElement("shortdesc");
        nuClass.appendChild(shortdesc);
        Element prolog = this.outputObject.createElement("prolog");
        nuClass.appendChild(prolog);
        Element apiClassifierDetail = this.outputObject.createElement("apiClassifierDetail");
        Element apiClassifierDef = this.outputObject.createElement("apiClassifierDef");
        apiClassifierDetail.appendChild(apiClassifierDef);
        nuClass.appendChild(apiClassifierDetail);
        String interfaceStr = "";
        if (isInterface) {
            Element apiInterface = this.outputObject.createElement("apiInterface");
            apiClassifierDef.appendChild(apiInterface);
            interfaceStr = record.getAttribute("baseClasses");
        } else {
            interfaceStr = record.getAttribute("interfaces");
        }
        if (!interfaceStr.equals("")) {
            thisClass.setInterfaceStr(interfaceStr);
        }
        if ((descriptionElement = this.asDocUtil.getElementByTagName(record, "description")) != null && descriptionElement.getParentNode().equals(record)) {
            String fullDesc = descriptionElement.getTextContent();
            shortdesc.setTextContent(this.asDocUtil.descToShortDesc(fullDesc));
            Element apiDesc = this.outputObject.createElement("apiDesc");
            CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(fullDesc, "description", fullName));
            apiDesc.appendChild(cdata);
            apiClassifierDetail.appendChild(apiDesc);
            this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
        }
        Element apiAccess = this.outputObject.createElement("apiAccess");
        apiAccess.setAttribute("value", accessLevel);
        apiClassifierDef.appendChild(apiAccess);
        if (isDynamic.equals("true")) {
            Element apiDynamic = this.outputObject.createElement("apiDynamic");
            apiClassifierDef.appendChild(apiDynamic);
        } else {
            Element apiStatic = this.outputObject.createElement("apiStatic");
            apiClassifierDef.appendChild(apiStatic);
        }
        if (isFinal.equals("true")) {
            Element apiFinal = this.outputObject.createElement("apiFinal");
            apiClassifierDef.appendChild(apiFinal);
        }
        if (!author.equals("")) {
            Element tempAuthorElement = this.outputObject.createElement("author");
            tempAuthorElement.setTextContent(author);
            prolog.appendChild(tempAuthorElement);
        }
        Element asMetadata = this.outputObject.createElement("asMetadata");
        prolog.appendChild(asMetadata);
        this.processVersions(record, nuClass);
        NodeList nodeList = record.getElementsByTagName("example");
        if (nodeList != null) {
            for (int ix = 0; ix < nodeList.getLength(); ++ix) {
                Element inputExampleElement = (Element)nodeList.item(ix);
                Element exampleElement = this.outputObject.createElement("example");
                CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(inputExampleElement.getTextContent(), "example", fullName));
                exampleElement.appendChild(cdata);
                apiClassifierDetail.appendChild(exampleElement);
                this.asDocUtil.convertDescToDITA(exampleElement, this.oldNewNamesMap);
            }
        }
        thisClass.setNode(nuClass);
        if (this.verbose) {
            System.out.println("done preprocessing " + fullName);
        }
    }

    private void processClasses() {
        int iChild;
        boolean flag;
        NodeList children;
        int ix;
        NodeList recordList = this.domObject.getElementsByTagName("classRec");
        for (ix = 0; ix < recordList.getLength(); ++ix) {
            Element classRec = (Element)recordList.item(ix);
            if (classRec.getAttribute("access").equals("private") && !this.includePrivate) continue;
            children = classRec.getElementsByTagName("private");
            if (children != null && children.getLength() != 0 && !this.includePrivate) {
                flag = false;
                for (iChild = 0; iChild < children.getLength(); ++iChild) {
                    if (!children.item(iChild).getParentNode().equals(classRec)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ((children = classRec.getElementsByTagName("ExcludeClass")) != null && children.getLength() != 0) continue;
            this.processClass(classRec, false);
        }
        recordList = this.domObject.getElementsByTagName("interfaceRec");
        for (ix = 0; ix < recordList.getLength(); ++ix) {
            Element interfaceRec = (Element)recordList.item(ix);
            if (interfaceRec.getAttribute("access").equals("private") && !this.includePrivate) continue;
            children = interfaceRec.getElementsByTagName("private");
            if (children != null && children.getLength() != 0 && !this.includePrivate) {
                flag = false;
                for (iChild = 0; iChild < children.getLength(); ++iChild) {
                    if (!children.item(iChild).getParentNode().equals(interfaceRec)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
            }
            if ((children = interfaceRec.getElementsByTagName("ExcludeClass")) != null && children.getLength() != 0) continue;
            this.processClass(interfaceRec, true);
        }
    }

    private void processClass(Element record, boolean isInterface) {
        String fullName;
        QualifiedNameInfo qualifiedFullName;
        String name = record.getAttribute("name");
        if (this.verbose) {
            System.out.println("  processing class: " + name);
        }
        if (this.asDocUtil.hidePackage((qualifiedFullName = this.asDocUtil.decomposeFullClassName(fullName = record.getAttribute("fullname"))).getPackageName(), this.hiddenPackages)) {
            return;
        }
        if (this.asDocUtil.hideNamespace(record.getAttribute("access"), this.namespaces)) {
            return;
        }
        AsClass thisClass = this.classTable.get(fullName);
        this.processCustoms(record, thisClass.getNode(), false, "", "", "");
        if (thisClass.getDecompName().getClassNames().size() > 1) {
            thisClass.setInnerClass(true);
            String tempFullName = thisClass.getDecompName().getFullClassName();
            String classScopName = tempFullName.substring(0, tempFullName.indexOf("/"));
            AsClass outerClass = this.classTable.get(classScopName);
            if (outerClass != null) {
                if (outerClass.getInnerClassCount() == 0) {
                    ArrayList<AsClass> innerClasses = outerClass.getInnerClasses();
                    if (innerClasses == null) {
                        innerClasses = new ArrayList();
                    }
                    innerClasses.add(thisClass);
                }
            } else if (this.verbose) {
                System.out.println("Didn't find outer class for " + thisClass.getDecompName().getFullClassName());
            }
        }
        if (this.verbose) {
            System.out.println("  done processing class: ");
        }
    }

    private void processVersions(Element record, Element target) {
        StringBuilder versionDescription;
        int ix;
        String langVersion = "";
        boolean versionFound = false;
        Element langVersionElement = this.asDocUtil.getElementByTagName(record, "langversion");
        if (langVersionElement != null) {
            versionFound = true;
            langVersion = langVersionElement.getTextContent().replaceAll("\n", "").replaceAll("\r", "");
        }
        ArrayList<String[]> playerVersion = new ArrayList<String[]>();
        NodeList playerVersionList = record.getElementsByTagName("playerversion");
        if (playerVersionList != null && playerVersionList.getLength() != 0) {
            versionFound = true;
            for (int ix2 = 0; ix2 < playerVersionList.getLength(); ++ix2) {
                if (!playerVersionList.item(ix2).getParentNode().equals(record)) continue;
                String playerVersionStr = playerVersionList.item(ix2).getTextContent();
                playerVersionStr = playerVersionStr.replaceAll("\\A\\s+", "");
                playerVersionStr = playerVersionStr.replaceAll("\\Z\\s+", "");
                playerVersionStr = playerVersionStr.replaceAll("\\s+", " ");
                String[] playerVersionArr = playerVersionStr.split(" ");
                playerVersion.add(playerVersionArr);
            }
        }
        ArrayList<String[]> productVersion = new ArrayList<String[]>();
        NodeList productVersionList = record.getElementsByTagName("productversion");
        if (productVersionList != null && productVersionList.getLength() != 0) {
            versionFound = true;
            for (int ix3 = 0; ix3 < productVersionList.getLength(); ++ix3) {
                if (!productVersionList.item(ix3).getParentNode().equals(record)) continue;
                String productVersionStr = productVersionList.item(ix3).getTextContent();
                productVersionStr = productVersionStr.replaceAll("\\A\\s+", "");
                productVersionStr = productVersionStr.replaceAll("\\Z\\s+", "");
                productVersionStr = productVersionStr.replaceAll("\\s+", " ");
                String[] productVersionArr = productVersionStr.split(" ");
                productVersion.add(productVersionArr);
            }
        }
        ArrayList<String[]> toolVersion = new ArrayList<String[]>();
        NodeList toolVersionList = record.getElementsByTagName("toolversion");
        if (toolVersionList != null && toolVersionList.getLength() != 0) {
            versionFound = true;
            for (int ix4 = 0; ix4 < toolVersionList.getLength(); ++ix4) {
                if (!toolVersionList.item(ix4).getParentNode().equals(record)) continue;
                String toolVersionStr = toolVersionList.item(ix4).getTextContent();
                toolVersionStr = toolVersionStr.replaceAll("\\A\\s+", "");
                toolVersionStr = toolVersionStr.replaceAll("\\Z\\s+", "");
                toolVersionStr = toolVersionStr.replaceAll("\\s+", " ");
                String[] toolVersionArr = toolVersionStr.split(" ");
                toolVersion.add(toolVersionArr);
            }
        }
        String sinceVersion = null;
        NodeList sinceList = record.getElementsByTagName("since");
        if (sinceList != null && sinceList.getLength() != 0) {
            versionFound = true;
            for (int ix5 = 0; ix5 < sinceList.getLength(); ++ix5) {
                if (!sinceList.item(ix5).getParentNode().equals(record)) continue;
                sinceVersion = sinceList.item(ix5).getTextContent();
                sinceVersion = sinceVersion.trim();
            }
        }
        if (!versionFound) {
            return;
        }
        Element asMetadata = null;
        Element apiVersion = null;
        Element prolog = this.asDocUtil.getElementByTagName(target, "prolog");
        if (prolog != null) {
            asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata");
            if (asMetadata != null) {
                apiVersion = this.asDocUtil.getElementByTagName(asMetadata, "apiVersion");
                if (apiVersion == null) {
                    apiVersion = this.outputObject.createElement("apiVersion");
                    asMetadata.appendChild(apiVersion);
                }
            } else {
                asMetadata = this.outputObject.createElement("asMetadata");
                apiVersion = this.outputObject.createElement("apiVersion");
                asMetadata.appendChild(apiVersion);
                prolog.appendChild(asMetadata);
            }
        } else {
            asMetadata = this.outputObject.createElement("asMetadata");
            apiVersion = this.outputObject.createElement("apiVersion");
            asMetadata.appendChild(apiVersion);
            prolog = this.outputObject.createElement("prolog");
            prolog.appendChild(asMetadata);
            target.appendChild(prolog);
        }
        if (langVersion.length() > 0) {
            Element apiLanguage = this.outputObject.createElement("apiLanguage");
            langVersion = langVersion.replaceAll("^\\s+", "");
            langVersion = langVersion.replaceAll("^\\s+$", "");
            String[] langVersionArr = (langVersion = langVersion.replaceAll("\\s+", " ")).split(" ");
            if (langVersionArr.length > 1) {
                apiLanguage.setAttribute("name", langVersionArr[0]);
                apiLanguage.setAttribute("version", langVersionArr[1]);
            } else {
                apiLanguage.setAttribute("version", langVersionArr[0]);
            }
            apiVersion.appendChild(apiLanguage);
        }
        for (ix = 0; ix < playerVersion.size(); ++ix) {
            String[] playerVersionArr = (String[])playerVersion.get(ix);
            versionDescription = new StringBuilder();
            if (playerVersionArr.length > 2) {
                for (int iy = 2; iy < playerVersionArr.length; ++iy) {
                    if ("".equals(playerVersionArr[iy]) || "\n".equals(playerVersionArr[iy])) continue;
                    if (iy != playerVersionArr.length - 1 && !playerVersionArr[iy].matches("\\s")) {
                        versionDescription.append(playerVersionArr[iy].replaceAll("\\s", ""));
                        versionDescription.append(" ");
                        continue;
                    }
                    versionDescription.append(playerVersionArr[iy].replaceAll("\\s", ""));
                }
            }
            if (playerVersionArr.length <= 1) continue;
            Element apiPlatform = this.outputObject.createElement("apiPlatform");
            apiPlatform.setAttribute("name", playerVersionArr[0]);
            apiPlatform.setAttribute("version", playerVersionArr[1].replaceAll("\\s", ""));
            apiPlatform.setAttribute("description", versionDescription.toString());
            apiVersion.appendChild(apiPlatform);
        }
        for (ix = 0; ix < productVersion.size(); ++ix) {
            String[] productVersionArr = (String[])productVersion.get(ix);
            versionDescription = new StringBuilder();
            if (productVersionArr.length > 2) {
                for (int iy = 2; iy < productVersionArr.length; ++iy) {
                    if ("".equals(productVersionArr[iy]) || "\n".equals(productVersionArr[iy])) continue;
                    if (iy != productVersionArr.length - 1 && !productVersionArr[iy].matches("\\s")) {
                        versionDescription.append(productVersionArr[iy].replaceAll("\\s", ""));
                        versionDescription.append(" ");
                        continue;
                    }
                    versionDescription.append(productVersionArr[iy].replaceAll("\\s", ""));
                }
            }
            if (productVersionArr.length <= 1) continue;
            Element apiTool = this.outputObject.createElement("apiTool");
            apiTool.setAttribute("name", productVersionArr[0]);
            apiTool.setAttribute("version", productVersionArr[1].replaceAll("\\s", ""));
            apiTool.setAttribute("description", versionDescription.toString());
            apiVersion.appendChild(apiTool);
        }
        for (ix = 0; ix < toolVersion.size(); ++ix) {
            String[] toolVersionArr = (String[])toolVersion.get(ix);
            if (toolVersionArr.length <= 1) continue;
            Element apiTool = this.outputObject.createElement("apiTool");
            apiTool.setAttribute("name", toolVersionArr[0]);
            apiTool.setAttribute("version", toolVersionArr[1].replaceAll("\\s", ""));
            apiVersion.appendChild(apiTool);
        }
        if (sinceVersion != null) {
            Element apiSince = this.outputObject.createElement("apiSince");
            apiSince.setAttribute("version", sinceVersion);
            apiVersion.appendChild(apiSince);
        }
    }

    private void processCustoms(Element record, Element target, boolean useParams, String paramNames, String paramTypes, String paramDefaults) {
        this.processCustoms(record, target, useParams, paramNames, paramTypes, paramDefaults, null);
    }

    private void processCustoms(Element record, Element target, boolean useParams, String paramNames, String paramTypes, String paramDefaults, AsClass fromClass) {
        NodeList childNodes = record.getChildNodes();
        if (childNodes != null && childNodes.getLength() != 0) {
            ArrayList<String> handledTags = new ArrayList<String>();
            handledTags.add("path");
            handledTags.add("relativePath");
            handledTags.add("href");
            handledTags.add("author");
            handledTags.add("langversion");
            handledTags.add("playerversion");
            handledTags.add("productversion");
            handledTags.add("toolversion");
            handledTags.add("taghref");
            handledTags.add("description");
            handledTags.add("result");
            handledTags.add("return");
            handledTags.add("example");
            handledTags.add("throws");
            handledTags.add("canThrow");
            handledTags.add("event");
            handledTags.add("eventType");
            handledTags.add("metadata");
            handledTags.add("since");
            boolean customsFound = false;
            boolean seeFound = false;
            boolean paramFound = false;
            boolean includeExamplesFound = false;
            boolean tipTextFound = false;
            Element customData = null;
            Element relatedLinks = this.outputObject.createElement("related-links");
            ArrayList<Element> includeExamples = new ArrayList<Element>();
            Element params = this.outputObject.createElement("params");
            Element apiTipTexts = this.outputObject.createElement("apiTipTexts");
            int lastParamName = 0;
            int lastParamType = 0;
            int lastParamDefault = 0;
            for (int ix = 0; ix < childNodes.getLength(); ++ix) {
                CDATASection cdata;
                Element child;
                String tagName;
                Node elementNode = childNodes.item(ix);
                if (elementNode.getNodeType() != 1 || handledTags.contains(tagName = (child = (Element)elementNode).getNodeName())) continue;
                if (tagName.equals("see")) {
                    seeFound = true;
                    relatedLinks.appendChild(this.processSeeTag(record.getAttribute("fullname"), child.getTextContent()));
                    continue;
                }
                if (useParams && tagName.equals("param")) {
                    if (child.getTextContent().equals("none")) continue;
                    int nextParam = paramNames.indexOf(";", lastParamName);
                    if (nextParam == -1) {
                        nextParam = paramNames.length();
                    }
                    if (lastParamName > nextParam) {
                        lastParamName = nextParam;
                    }
                    String nextName = paramNames.substring(lastParamName, nextParam);
                    lastParamName = nextParam + 1;
                    nextParam = paramTypes.indexOf(";", lastParamType);
                    if (nextParam == -1) {
                        nextParam = paramTypes.length();
                    }
                    if (lastParamType > nextParam) {
                        lastParamType = nextParam;
                    }
                    String nextType = paramTypes.substring(lastParamType, nextParam);
                    lastParamType = nextParam + 1;
                    nextParam = paramDefaults.indexOf(";", lastParamDefault);
                    if (nextParam == -1) {
                        nextParam = paramDefaults.length();
                    }
                    if (lastParamDefault > nextParam) {
                        lastParamDefault = nextParam;
                    }
                    String nextDefault = paramDefaults.substring(lastParamDefault, nextParam);
                    lastParamDefault = nextParam + 1;
                    if (nextName.equals("")) continue;
                    Element apiParam = this.outputObject.createElement("apiParam");
                    Element apiItemName = this.outputObject.createElement("apiItemName");
                    apiItemName.setTextContent(nextName);
                    apiParam.appendChild(apiItemName);
                    AsClass paramClass = this.classTable.get(nextType);
                    if (paramClass != null) {
                        Element apiOperationClassifier = this.outputObject.createElement("apiOperationClassifier");
                        apiOperationClassifier.setTextContent(paramClass.getFullName());
                        apiParam.appendChild(apiOperationClassifier);
                    } else {
                        Element apiType = this.outputObject.createElement("apiType");
                        if (nextType.equals("*")) {
                            apiType.setAttribute("value", "any");
                        } else {
                            apiType.setAttribute("value", nextType);
                        }
                        apiParam.appendChild(apiType);
                    }
                    if (nextDefault != null && !nextDefault.equals("undefined")) {
                        Element apiData = this.outputObject.createElement("apiData");
                        apiData.setTextContent(nextDefault);
                        apiParam.appendChild(apiData);
                    }
                    String desc = child.getTextContent();
                    int tabIndex = desc.indexOf(9);
                    int spaceIndex = desc.indexOf(" ");
                    if (tabIndex != -1 && tabIndex < spaceIndex) {
                        spaceIndex = tabIndex;
                    }
                    if (spaceIndex != -1) {
                        desc = desc.substring(spaceIndex + 1);
                    }
                    Element apiDesc = this.outputObject.createElement("apiDesc");
                    CDATASection cdata2 = this.outputObject.createCDATASection(this.asDocUtil.validateText(desc, "param", record.getAttribute("fullname")));
                    apiDesc.appendChild(cdata2);
                    apiParam.appendChild(apiDesc);
                    this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                    params.appendChild(apiParam);
                    paramFound = true;
                    continue;
                }
                if (tagName.equals("param")) continue;
                if (tagName.equals("includeExample")) {
                    includeExamplesFound = true;
                    includeExamples.add(this.processIncludeExampleTag(record.getAttribute("fullname"), child.getTextContent()));
                    continue;
                }
                if (tagName.equals("tiptext")) {
                    tipTextFound = true;
                    Element apiTipText = this.outputObject.createElement("apiTipText");
                    cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(child.getTextContent(), "tiptext", record.getAttribute("fullname")));
                    apiTipText.appendChild(cdata);
                    this.asDocUtil.convertDescToDITA(apiTipText, this.oldNewNamesMap);
                    apiTipTexts.appendChild(apiTipText);
                    continue;
                }
                if (tagName.equals("copy")) {
                    Element apiDesc;
                    String copyRef = child.getTextContent();
                    if ((copyRef = copyRef.replaceAll("[\\n\\s]", "")).equals("")) continue;
                    Element shortDescElement = this.asDocUtil.getElementByTagName(target, "shortdesc");
                    if (shortDescElement == null) {
                        shortDescElement = this.outputObject.createElement("shortdesc");
                        target.appendChild(shortDescElement);
                    }
                    shortDescElement.setAttribute("conref", copyRef);
                    Element detailNode = this.asDocUtil.getDetailNode(target);
                    if (detailNode == null || (apiDesc = this.asDocUtil.getElementImmediateChildByTagName(detailNode, "apiDesc")) == null) continue;
                    apiDesc.setAttribute("conref", copyRef);
                    continue;
                }
                if (tagName.equals("default")) {
                    Element apiDefaultValue = this.outputObject.createElement("apiDefaultValue");
                    apiDefaultValue.setTextContent(child.getTextContent());
                    Element defNode = this.asDocUtil.getDefNode(target);
                    defNode.appendChild(apiDefaultValue);
                    continue;
                }
                if (tagName.equals("inheritDoc")) {
                    Element apiInheritDoc = this.outputObject.createElement("apiInheritDoc");
                    target.appendChild(apiInheritDoc);
                    continue;
                }
                customsFound = true;
                customData = this.outputObject.createElement(child.getNodeName());
                NodeList customsChildren = child.getChildNodes();
                if (customsChildren == null || customsChildren.getLength() == 0) continue;
                if (customsChildren.item(0).getNodeType() == 4) {
                    cdata = this.outputObject.createCDATASection(child.getTextContent());
                    cdata.setData(((CDATASection)customsChildren.item(0)).getData());
                    customData.appendChild(cdata);
                    continue;
                }
                cdata = this.outputObject.createCDATASection(child.getTextContent());
                customData.appendChild(cdata);
            }
            if (useParams && lastParamName < paramNames.length()) {
                if (this.verbose) {
                    System.out.println("     more params declared than found @param tags for, inventing param elements");
                    System.out.println("        params to synth docs for: " + paramNames.substring(lastParamName));
                }
                while (lastParamName < paramNames.length()) {
                    int nextParam = paramNames.indexOf(";", lastParamName);
                    if (nextParam == -1) {
                        nextParam = paramNames.length();
                    }
                    if (lastParamName > nextParam) {
                        lastParamName = nextParam;
                    }
                    String nextName = paramNames.substring(lastParamName, nextParam);
                    lastParamName = nextParam + 1;
                    nextParam = paramTypes.indexOf(";", lastParamType);
                    if (nextParam == -1) {
                        nextParam = paramTypes.length();
                    }
                    if (lastParamType > nextParam) {
                        lastParamType = nextParam;
                    }
                    String nextType = paramTypes.substring(lastParamType, nextParam);
                    lastParamType = nextParam + 1;
                    nextParam = paramDefaults.indexOf(";", lastParamDefault);
                    if (nextParam == -1) {
                        nextParam = paramDefaults.length();
                    }
                    if (lastParamDefault > nextParam) {
                        lastParamDefault = nextParam;
                    }
                    String nextDefault = paramDefaults.substring(lastParamDefault, nextParam);
                    lastParamDefault = nextParam + 1;
                    Element apiParam = this.outputObject.createElement("apiParam");
                    Element apiItemName = this.outputObject.createElement("apiItemName");
                    apiItemName.setTextContent(nextName);
                    apiParam.appendChild(apiItemName);
                    AsClass paramClass = this.classTable.get(nextType);
                    if (paramClass != null) {
                        Element apiOperationClassifier = this.outputObject.createElement("apiOperationClassifier");
                        apiOperationClassifier.setTextContent(paramClass.getFullName());
                        apiParam.appendChild(apiOperationClassifier);
                    } else {
                        Element apiType = this.outputObject.createElement("apiType");
                        if (nextType.equals("*")) {
                            apiType.setAttribute("value", "any");
                        } else {
                            apiType.setAttribute("value", nextType);
                        }
                        apiParam.appendChild(apiType);
                    }
                    if (nextDefault != null && !nextDefault.equals("undefined")) {
                        Element apiData = this.outputObject.createElement("apiData");
                        apiData.setTextContent(nextDefault);
                        apiParam.appendChild(apiData);
                    }
                    params.appendChild(apiParam);
                    paramFound = true;
                }
            }
            if (seeFound) {
                target.appendChild(relatedLinks);
            }
            if (paramFound) {
                Element apiOperationDetail = this.asDocUtil.getElementByTagName(target, "apiOperationDetail");
                if (apiOperationDetail != null) {
                    Element apiOperationDef = this.asDocUtil.getElementByTagName(apiOperationDetail, "apiOperationDef");
                    if (apiOperationDef == null) {
                        apiOperationDef = this.outputObject.createElement("apiOperationDef");
                    }
                    NodeList listofChilds = params.getElementsByTagName("apiParam");
                    for (int iChild = 0; iChild < listofChilds.getLength(); ++iChild) {
                        Node node = listofChilds.item(iChild);
                        apiOperationDef.appendChild(node.cloneNode(true));
                    }
                } else {
                    Element apiConstructorDetail = this.asDocUtil.getElementByTagName(target, "apiConstructorDetail");
                    if (apiConstructorDetail != null) {
                        Element apiConstructorDef = this.asDocUtil.getElementByTagName(apiConstructorDetail, "apiConstructorDef");
                        if (apiConstructorDef == null) {
                            apiConstructorDef = this.outputObject.createElement("apiConstructorDef");
                        }
                        NodeList listofChilds = params.getElementsByTagName("apiParam");
                        for (int iChild = 0; iChild < listofChilds.getLength(); ++iChild) {
                            Node node = listofChilds.item(iChild);
                            apiConstructorDef.appendChild(node.cloneNode(true));
                        }
                    } else if (this.verbose) {
                        System.out.println("Error neither operationdetail nor constructordetail exists for " + target.getNodeName());
                    }
                }
            }
            if (includeExamplesFound) {
                Element detailNode = this.asDocUtil.getDetailNode(target);
                for (int ix = 0; ix < includeExamples.size(); ++ix) {
                    detailNode.appendChild((Node)includeExamples.get(ix));
                }
            }
            if (customsFound) {
                Element asCustoms = null;
                Element prolog = this.asDocUtil.getElementByTagName(target, "prolog");
                if (prolog != null) {
                    asCustoms = this.asDocUtil.getElementByTagName(prolog, "asCustoms");
                    if (asCustoms == null) {
                        asCustoms = this.outputObject.createElement("asCustoms");
                        prolog.appendChild(asCustoms);
                    }
                } else {
                    asCustoms = this.outputObject.createElement("asCustoms");
                    prolog = this.outputObject.createElement("prolog");
                    prolog.appendChild(asCustoms);
                    target.appendChild(prolog);
                }
                asCustoms.appendChild(customData);
            }
            if (tipTextFound) {
                Element defNode = this.asDocUtil.getDefNode(target);
                defNode.appendChild(apiTipTexts);
            }
        }
    }

    private QualifiedNameInfo decomposeFullMethodOrFieldName(String fullName) {
        AsClass fakeClass;
        int classNameSpacesSize;
        QualifiedNameInfo result = this.asDocUtil.decomposeFullClassName(fullName);
        int classNameSize = result.getClassNames().size();
        if (classNameSize != 0) {
            result.setMethodName(result.getClassNames().get(classNameSize - 1));
            result.getClassNames().remove(classNameSize - 1);
        }
        if ((classNameSpacesSize = result.getClassNameSpaces().size()) != 0) {
            result.setMethodNameSpace(result.getClassNameSpaces().get(classNameSpacesSize - 1));
            result.getClassNameSpaces().remove(classNameSpacesSize - 1);
        }
        classNameSize = result.getClassNames().size();
        classNameSpacesSize = result.getClassNameSpaces().size();
        if (result.getMethodName().equals("get") && classNameSize > 1) {
            result.setGetterSetter("Get");
            result.setMethodName(result.getClassNames().get(classNameSize - 1));
            result.getClassNames().remove(classNameSize - 1);
            if (classNameSpacesSize != 0) {
                result.setMethodNameSpace(result.getClassNameSpaces().get(classNameSpacesSize - 1));
                result.getClassNameSpaces().remove(classNameSpacesSize - 1);
            }
        } else if (result.getMethodName().equals("set") && classNameSize > 1) {
            result.setGetterSetter("Set");
            result.setMethodName(result.getClassNames().get(classNameSize - 1));
            result.getClassNames().remove(classNameSize - 1);
            if (classNameSpacesSize != 0) {
                result.setMethodNameSpace(result.getClassNameSpaces().get(classNameSpacesSize - 1));
                result.getClassNameSpaces().remove(classNameSpacesSize - 1);
            }
        }
        classNameSize = result.getClassNames().size();
        if (result.getMethodNameSpace().equals(result.getPackageName())) {
            result.setMethodNameSpace("public");
        }
        classNameSpacesSize = result.getClassNameSpaces().size();
        if (classNameSize == 0 && !result.getPackageName().equals("")) {
            result.getClassNames().add("$$" + result.getPackageName() + "$$");
        }
        result.setFullClassName("");
        if (!result.getPackageName().equals("")) {
            result.setFullClassName(result.getPackageName());
            if (classNameSpacesSize != 0 && !result.getClassNameSpaces().get(0).equals("public") && !result.getClassNameSpaces().get(0).equals("")) {
                result.setFullClassName(result.getFullClassName() + "$" + result.getClassNameSpaces().get(0) + ":");
            } else {
                result.setFullClassName(result.getFullClassName() + ":");
            }
        }
        if ((classNameSize = result.getClassNames().size()) != 0 && !result.getClassNames().get(0).equals("")) {
            result.setFullClassName(result.getFullClassName() + result.getClassNames().get(0));
        }
        if (result.getFullClassName().equals("")) {
            result.setFullClassName("$$Global$$");
        } else if (classNameSize != 0 && result.getClassNames().get(0).equals("$$" + result.getPackageName() + "$$") && (fakeClass = this.classTable.get(result.getFullClassName())) == null) {
            fakeClass = new AsClass();
            fakeClass.setName(result.getClassNames().get(0));
            fakeClass.setDecompName(result);
            fakeClass.setBaseName("");
            fakeClass.setInterfaceFlag(false);
            Element apiClassifier = this.outputObject.createElement("apiClassifier");
            fakeClass.setNode(apiClassifier);
            this.classTable.put(result.getFullClassName(), fakeClass);
            HashMap<String, AsClass> packageContents = this.packageContentsTable.get(result.getPackageName());
            if (packageContents == null) {
                packageContents = new HashMap();
                this.packageContentsTable.put(result.getPackageName(), packageContents);
            }
            packageContents.put(result.getClassNames().get(0), fakeClass);
        }
        return result;
    }

    private Element processSeeTag(String fullName, String seeStr) {
        String labelStr = "";
        String hrefStr = "";
        String invalidHrefStr = null;
        if ((seeStr = this.asDocUtil.normalizeString(seeStr)).length() == 0) {
            if (this.verbose) {
                System.out.println("ERROR: Empty @see string in " + fullName);
            }
            Element link = this.outputObject.createElement("link");
            link.setAttribute("href", "");
            Element linkText = this.outputObject.createElement("linktext");
            link.appendChild(linkText);
            return link;
        }
        int spaceIndex = seeStr.indexOf(" ");
        if (seeStr.indexOf("\"") == 0) {
            labelStr = seeStr.replaceAll("^[\"]|[\"]$", "");
        } else {
            if (spaceIndex != -1) {
                hrefStr = seeStr.substring(0, spaceIndex);
                labelStr = seeStr.substring(spaceIndex + 1);
            } else {
                hrefStr = seeStr;
                labelStr = seeStr;
            }
            if (hrefStr.indexOf("http://") == -1 && hrefStr.indexOf(".html") == -1) {
                int poundLoc = hrefStr.indexOf("#");
                hrefStr = hrefStr.replaceAll("event:", "event!");
                hrefStr = hrefStr.replaceAll("style:", "style!");
                hrefStr = hrefStr.replaceAll("effect:", "effect!");
                hrefStr = hrefStr.replaceAll("skinstate:", "skinstate!");
                int lastDot = (hrefStr = hrefStr.replaceAll("skinpart:", "skinpart!")).lastIndexOf(".");
                if (lastDot != -1) {
                    hrefStr = hrefStr.substring(0, lastDot) + ":" + hrefStr.substring(lastDot + 1);
                }
                int colonLoc = hrefStr.indexOf(":");
                String packageNameStr = "";
                String className = "";
                boolean isValidLink = true;
                if (poundLoc != -1) {
                    QualifiedNameInfo qualifiedName = fullName.indexOf("/") == -1 ? this.asDocUtil.decomposeFullClassName(fullName) : this.decomposeFullMethodOrFieldName(fullName);
                    String memberName = hrefStr.substring(poundLoc + 1);
                    if (colonLoc != -1) {
                        packageNameStr = hrefStr.substring(0, colonLoc);
                        className = hrefStr.substring(colonLoc + 1, poundLoc);
                        if (this.classTable.get(hrefStr.substring(0, poundLoc)) == null) {
                            String fullNameStr = packageNameStr + "." + className;
                            if ((fullNameStr = fullNameStr.replaceAll(":", ".")).endsWith(".")) {
                                fullNameStr = fullNameStr.substring(0, fullNameStr.length() - 1);
                            }
                            if (this.packageContentsTable.get(fullNameStr) != null) {
                                packageNameStr = fullNameStr;
                                className = "";
                            } else {
                                isValidLink = false;
                            }
                        }
                    } else {
                        className = hrefStr.substring(0, poundLoc);
                        if (className.equals("") && qualifiedName.getClassNames().size() != 0) {
                            className = qualifiedName.getClassNames().get(qualifiedName.getClassNames().size() - 1);
                        }
                        if (packageNameStr.equals("") && this.classTable.get(className) == null) {
                            packageNameStr = qualifiedName.getPackageName();
                        }
                        String fullNameStr = "";
                        if (!packageNameStr.equals("")) {
                            fullNameStr = packageNameStr + ":";
                        }
                        if (!className.equals("")) {
                            fullNameStr = fullNameStr + className;
                        }
                        if (this.classTable.get(fullNameStr) == null && !className.equals("global")) {
                            isValidLink = false;
                        }
                    }
                    if (isValidLink) {
                        hrefStr = !packageNameStr.equals("") ? packageNameStr + ".xml#" + className + "/" + memberName : "#" + className + "/" + memberName;
                    } else {
                        hrefStr = "";
                        invalidHrefStr = !packageNameStr.equals("") ? packageNameStr + ".xml#" + className + "/" + memberName : "#" + className + "/" + memberName;
                    }
                } else {
                    QualifiedNameInfo qualifiedName = this.asDocUtil.decomposeFullClassName(fullName);
                    if (colonLoc != -1) {
                        packageNameStr = hrefStr.substring(0, colonLoc);
                        className = hrefStr.substring(colonLoc + 1);
                    } else {
                        className = hrefStr;
                    }
                    if (className.equals("") && qualifiedName.getClassNames().size() != 0) {
                        className = qualifiedName.getClassNames().get(qualifiedName.getClassNames().size() - 1);
                    }
                    if (packageNameStr.equals("") && this.classTable.get(className) == null) {
                        packageNameStr = qualifiedName.getPackageName();
                    }
                    String fullNameStr = "";
                    if (!packageNameStr.equals("")) {
                        fullNameStr = packageNameStr + ":";
                    }
                    if (this.classTable.get(fullNameStr = fullNameStr + className) == null) {
                        String temp = fullNameStr.replaceAll(":", ".");
                        if (this.packageContentsTable.get(temp) != null) {
                            hrefStr = temp + ".xml";
                        } else {
                            hrefStr = "";
                            invalidHrefStr = temp + ".xml";
                        }
                    } else {
                        hrefStr = !packageNameStr.equals("") ? packageNameStr + ".xml#" + className : "#" + className;
                    }
                }
                hrefStr = hrefStr.replaceAll("event!", "event:");
                hrefStr = hrefStr.replaceAll("style!", "style:");
                hrefStr = hrefStr.replaceAll("effect!", "effect:");
                hrefStr = hrefStr.replaceAll("skinstate!", "skinstate:");
                hrefStr = hrefStr.replaceAll("skinpart!", "skinpart:");
                if (invalidHrefStr != null) {
                    invalidHrefStr = invalidHrefStr.replaceAll("event!", "event:");
                    invalidHrefStr = invalidHrefStr.replaceAll("style!", "style:");
                    invalidHrefStr = invalidHrefStr.replaceAll("effect!", "effect:");
                    invalidHrefStr = invalidHrefStr.replaceAll("skinstate!", "skinstate:");
                    invalidHrefStr = invalidHrefStr.replaceAll("skinpart!", "skinpart:");
                }
                labelStr = labelStr.indexOf("#") == 0 ? labelStr.replaceAll("#", "") : labelStr.replaceAll("#", ".");
                labelStr = labelStr.replaceAll("event:", "");
                labelStr = labelStr.replaceAll("style:", "");
                labelStr = labelStr.replaceAll("effect:", "");
                labelStr = labelStr.replaceAll("skinstate:", "");
                labelStr = labelStr.replaceAll("skinpart:", "");
                labelStr = labelStr.replaceAll("global\\.", "");
            }
        }
        Element link = this.outputObject.createElement("link");
        link.setAttribute("href", hrefStr);
        if (invalidHrefStr != null) {
            link.setAttribute("invalidHref", invalidHrefStr);
        }
        Element linkText = this.outputObject.createElement("linktext");
        linkText.setTextContent(labelStr);
        link.appendChild(linkText);
        return link;
    }

    private Element processIncludeExampleTag(String fullName, String exampleStr) {
        String codeFileName;
        String codePart;
        String swfPartFile;
        String exampleFileName;
        String versionStr;
        Element result;
        boolean noSwf;
        block61: {
            if (this.verbose) {
                System.out.println("processIncludeExampleTag:: fullname : " + fullName + "   exampleStr :" + exampleStr);
            }
            noSwf = false;
            result = null;
            int versionIdx = exampleStr.indexOf("-version");
            versionStr = "";
            int noSwfIdx = exampleStr.indexOf("-noswf");
            if (noSwfIdx != -1) {
                noSwf = true;
                if (versionIdx != -1 && versionIdx > noSwfIdx) {
                    versionStr = exampleStr.substring(versionIdx + 8);
                }
                exampleStr = exampleStr.substring(0, noSwfIdx);
            } else if (versionIdx != -1) {
                versionStr = exampleStr.substring(versionIdx + 8);
                exampleStr = exampleStr.substring(0, versionIdx);
            }
            exampleFileName = exampleStr = exampleStr.replaceAll("\\s*", "");
            int index = exampleFileName.lastIndexOf(47);
            if (index != -1) {
                exampleFileName = exampleFileName.substring(index + 1);
            }
            if ((index = (swfPartFile = exampleStr).lastIndexOf(46)) != -1) {
                swfPartFile = swfPartFile.substring(0, index);
                swfPartFile = swfPartFile + ".swf";
            }
            codePart = null;
            codeFileName = "";
            try {
                NodeList includeExamplesList = this.asDocConfig.getElementsByTagName("includeExamplesDirectory");
                if (includeExamplesList != null && includeExamplesList.getLength() != 0) {
                    codeFileName = includeExamplesList.item(0).getTextContent();
                }
                codeFileName = codeFileName + "/";
                QualifiedNameInfo qualifiedFullName = this.asDocUtil.decomposeFullClassName(fullName);
                codeFileName = codeFileName + qualifiedFullName.getPackageName().replaceAll("\\.+", "/");
                codeFileName = codeFileName + "/";
                codeFileName = codeFileName + exampleStr;
                codePart = FileUtil.readFile(new File(codeFileName));
            }
            catch (Exception ex) {
                if (!this.verbose) break block61;
                System.out.print("The file specified in @includeExample, " + exampleStr + ", cannot be found at " + codeFileName);
            }
        }
        if (codePart != null) {
            codeFileName = codeFileName.toLowerCase();
            Pattern pattern = Pattern.compile("\n");
            Matcher matcher = pattern.matcher(codePart);
            codePart = matcher.replaceAll("\n\n");
            codePart = codePart.replaceAll("\\t", "    ");
            StringBuilder output = new StringBuilder();
            int descBegin = 0;
            int descEnd = 0;
            int descEnd1 = 0;
            String descText = null;
            String descText2 = null;
            descBegin = codePart.indexOf("@exampleText");
            if (descBegin != -1) {
                descEnd1 = codePart.indexOf("@", descBegin + 1);
                descEnd = codeFileName.endsWith(".mxml") ? codePart.indexOf("-->", descBegin) : codePart.indexOf("*/", descBegin);
                if (descEnd1 != -1 && descEnd1 < descEnd) {
                    descEnd = descEnd1;
                }
                if (descEnd != -1) {
                    String temp = codePart.substring(descBegin + 12, descEnd - 1);
                    pattern = Pattern.compile("^\\s*\\*", 8);
                    matcher = pattern.matcher(temp);
                    descText = matcher.replaceAll("");
                    if (codeFileName.endsWith(".mxml")) {
                        pattern = Pattern.compile("^\\s*-", 8);
                        matcher = pattern.matcher(descText);
                        descText = matcher.replaceAll("");
                    }
                } else {
                    String validationErrors = this.asDocUtil.getValidationErrors();
                    validationErrors = validationErrors + "comment not closed correctly in " + codeFileName + " for " + fullName + " \n";
                    this.asDocUtil.setValidationErrors(validationErrors);
                    this.asDocUtil.setErrors(true);
                }
            }
            int codeBegin = -1;
            if (codeFileName.endsWith(".mxml")) {
                if (codePart.indexOf("<!---") != -1) {
                    codeBegin = codePart.indexOf("-->");
                }
            } else {
                codeBegin = codePart.indexOf("*/");
            }
            if (codeBegin == -1) {
                codeBegin = 0;
            } else {
                codeBegin += 2;
                if (codeFileName.endsWith(".mxml")) {
                    ++codeBegin;
                }
            }
            int codeEnd = -1;
            codeEnd = codeFileName.endsWith(".mxml") ? codePart.indexOf("<!---", codeBegin) : codePart.indexOf("/*", codeBegin);
            if (codeEnd != -1 && codeEnd < codeBegin) {
                codeBegin = 0;
            }
            String codeBlock = "";
            codeBlock = codeEnd == -1 ? codePart.substring(codeBegin) : codePart.substring(codeBegin, codeEnd - 1);
            if (codeBlock.replaceAll("\\s*", "").length() == 0 && this.verbose) {
                System.out.println("warning :: codeblock is empty for " + codeFileName);
            }
            if (codeBegin < descBegin) {
                output.append("<codeblock>");
                output.append(this.asDocUtil.convertToEntity(codeBlock));
                output.append("</codeblock>");
                if (descText != null) {
                    output.append(descText);
                }
            } else {
                if (descText != null) {
                    output.append(descText);
                }
                output.append("<codeblock>");
                output.append(this.asDocUtil.convertToEntity(codeBlock));
                output.append("</codeblock>");
                codeEnd = codeBegin + codeBlock.length();
                descBegin = codePart.indexOf("@exampleText", codeEnd);
                if (descBegin != -1) {
                    descEnd1 = codePart.indexOf("@", descBegin + 1);
                    descEnd = codeFileName.endsWith(".mxml") ? codePart.indexOf("-->", descBegin) : codePart.indexOf("*/", descBegin);
                    if (descEnd1 != -1 && descEnd1 < descEnd) {
                        descEnd = descEnd1;
                    }
                    if (descEnd != -1) {
                        String temp = codePart.substring(descBegin + 12, descEnd - 1);
                        pattern = Pattern.compile("^\\s*\\*", 8);
                        matcher = pattern.matcher(temp);
                        descText2 = matcher.replaceAll("");
                        if (codeFileName.endsWith(".mxml")) {
                            pattern = Pattern.compile("^\\s*-", 8);
                            matcher = pattern.matcher(descText2);
                            descText2 = matcher.replaceAll("");
                        }
                        output.append(descText2);
                    } else {
                        String validationErrors = this.asDocUtil.getValidationErrors();
                        validationErrors = validationErrors + "comment not closed correctly in " + codeFileName + " for " + fullName + " \n";
                        this.asDocUtil.setValidationErrors(validationErrors);
                        this.asDocUtil.setErrors(true);
                    }
                }
            }
            result = this.outputObject.createElement("example");
            result.setAttribute("conref", exampleFileName);
            CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(output.toString(), "includeExample " + exampleStr, fullName));
            result.appendChild(cdata);
        }
        if (result == null) {
            result = this.outputObject.createElement("example");
            result.setAttribute("conref", exampleFileName);
        }
        this.asDocUtil.convertDescToDITA(result, this.oldNewNamesMap);
        if (!noSwf) {
            Element swfBlock = this.outputObject.createElement("swfblock");
            swfBlock.setAttribute("conref", swfPartFile);
            result.appendChild(swfBlock);
        }
        if (!versionStr.equals("")) {
            int langVersionIdx = versionStr.indexOf("-langversion");
            int productVersionIdx = versionStr.indexOf("-productversion");
            int playerVersionIdx = versionStr.indexOf("-playerversion");
            boolean skipVersions = false;
            if (langVersionIdx != -1 && versionStr.indexOf("-langversion", langVersionIdx + 1) != -1) {
                String validationErrors = this.asDocUtil.getValidationErrors();
                validationErrors = validationErrors + "@includeExample for " + fullName + " contains multiple -langversion \n";
                this.asDocUtil.setValidationErrors(validationErrors);
                this.asDocUtil.setErrors(true);
                skipVersions = true;
            }
            if (productVersionIdx != -1 && versionStr.indexOf("-productversion", productVersionIdx + 1) != -1) {
                String validationErrors = this.asDocUtil.getValidationErrors();
                validationErrors = validationErrors + "@includeExample for " + fullName + " contains multiple -productversion \n";
                this.asDocUtil.setValidationErrors(validationErrors);
                this.asDocUtil.setErrors(true);
                skipVersions = true;
            }
            if (playerVersionIdx != -1 && versionStr.indexOf("-playerversion", playerVersionIdx + 1) != -1) {
                String validationErrors = this.asDocUtil.getValidationErrors();
                validationErrors = validationErrors + "@includeExample for " + fullName + " contains multiple -playerversion \n";
                this.asDocUtil.setValidationErrors(validationErrors);
                this.asDocUtil.setErrors(true);
                skipVersions = true;
            }
            if (!skipVersions) {
                StringBuilder versionDescription;
                int ix;
                int idx;
                ArrayList<Integer> tagIndexs = new ArrayList<Integer>();
                if (langVersionIdx != -1) {
                    tagIndexs.add(langVersionIdx);
                }
                if (productVersionIdx != -1) {
                    tagIndexs.add(productVersionIdx);
                }
                if (playerVersionIdx != -1) {
                    tagIndexs.add(playerVersionIdx);
                }
                int tagLength = tagIndexs.size();
                Collections.sort(tagIndexs);
                Element asMetadata = this.outputObject.createElement("asMetadata");
                Element apiVersion = this.outputObject.createElement("apiVersion");
                asMetadata.appendChild(apiVersion);
                Element prolog = this.outputObject.createElement("prolog");
                prolog.appendChild(asMetadata);
                if (langVersionIdx != -1) {
                    idx = tagIndexs.indexOf(langVersionIdx);
                    String langVersion = "";
                    langVersion = idx != tagLength - 1 ? versionStr.substring(langVersionIdx + 12, (Integer)tagIndexs.get(idx + 1)) : versionStr.substring(langVersionIdx + 12);
                    if ((langVersion = langVersion.replaceAll("\n", "").replaceAll("\r", "")).length() > 0) {
                        Element apiLanguage = this.outputObject.createElement("apiLanguage");
                        langVersion = langVersion.replaceAll("^\\s+", "");
                        langVersion = langVersion.replaceAll("^\\s+$", "");
                        String[] langVersionArr = (langVersion = langVersion.replaceAll("\\s+", " ")).split(" ");
                        if (langVersionArr.length > 1) {
                            apiLanguage.setAttribute("name", langVersionArr[0]);
                            apiLanguage.setAttribute("version", langVersionArr[1]);
                        } else {
                            apiLanguage.setAttribute("version", langVersionArr[0]);
                        }
                        apiVersion.appendChild(apiLanguage);
                    }
                }
                if (playerVersionIdx != -1) {
                    idx = tagIndexs.indexOf(playerVersionIdx);
                    String playerVersionStr = "";
                    playerVersionStr = idx != tagLength - 1 ? versionStr.substring(playerVersionIdx + 14, (Integer)tagIndexs.get(idx + 1)) : versionStr.substring(playerVersionIdx + 14);
                    if ((playerVersionStr = playerVersionStr.replaceAll("\n", "").replaceAll("\r", "")).length() > 0) {
                        ArrayList<String[]> playerVersion = new ArrayList<String[]>();
                        playerVersionStr = playerVersionStr.replaceAll("\\A\\s+", "");
                        playerVersionStr = playerVersionStr.replaceAll("\\Z\\s+", "");
                        playerVersionStr = playerVersionStr.replaceAll("\\s+", " ");
                        String[] playerVersionArr = playerVersionStr.split(",");
                        for (ix = 0; ix < playerVersionArr.length; ++ix) {
                            String tmpPlayerVersion = playerVersionArr[ix].trim();
                            playerVersion.add(tmpPlayerVersion.split(" "));
                        }
                        for (ix = 0; ix < playerVersion.size(); ++ix) {
                            String[] tempPlayerVersionArr = (String[])playerVersion.get(ix);
                            versionDescription = new StringBuilder();
                            if (tempPlayerVersionArr.length > 2) {
                                for (int iy = 2; iy < tempPlayerVersionArr.length; ++iy) {
                                    if ("".equals(tempPlayerVersionArr[iy]) || "\n".equals(tempPlayerVersionArr[iy])) continue;
                                    if (iy != tempPlayerVersionArr.length - 1 && !tempPlayerVersionArr[iy].matches("\\s")) {
                                        versionDescription.append(tempPlayerVersionArr[iy].replaceAll("\\s", ""));
                                        versionDescription.append(" ");
                                        continue;
                                    }
                                    versionDescription.append(tempPlayerVersionArr[iy].replaceAll("\\s", ""));
                                }
                            }
                            if (tempPlayerVersionArr.length <= 1) continue;
                            Element apiPlatform = this.outputObject.createElement("apiPlatform");
                            apiPlatform.setAttribute("name", tempPlayerVersionArr[0]);
                            apiPlatform.setAttribute("version", tempPlayerVersionArr[1].replaceAll("\\s", ""));
                            apiPlatform.setAttribute("description", versionDescription.toString());
                            apiVersion.appendChild(apiPlatform);
                        }
                    }
                }
                if (productVersionIdx != -1) {
                    idx = tagIndexs.indexOf(productVersionIdx);
                    String productVersionStr = "";
                    productVersionStr = idx != tagLength - 1 ? versionStr.substring(productVersionIdx + 15, (Integer)tagIndexs.get(idx + 1)) : versionStr.substring(productVersionIdx + 15);
                    if ((productVersionStr = productVersionStr.replaceAll("\n", "").replaceAll("\r", "")).length() > 0) {
                        ArrayList<String[]> productVersion = new ArrayList<String[]>();
                        productVersionStr = productVersionStr.replaceAll("\\A\\s+", "");
                        productVersionStr = productVersionStr.replaceAll("\\Z\\s+", "");
                        productVersionStr = productVersionStr.replaceAll("\\s+", " ");
                        String[] productVersionArr = productVersionStr.split(",");
                        for (ix = 0; ix < productVersionArr.length; ++ix) {
                            String tmpProductVersion = productVersionArr[ix].trim();
                            productVersion.add(tmpProductVersion.split(" "));
                        }
                        for (ix = 0; ix < productVersion.size(); ++ix) {
                            String[] tmpProductVersionArr = (String[])productVersion.get(ix);
                            versionDescription = new StringBuilder();
                            if (tmpProductVersionArr.length > 2) {
                                for (int iy = 2; iy < tmpProductVersionArr.length; ++iy) {
                                    if ("".equals(tmpProductVersionArr[iy]) || "\n".equals(tmpProductVersionArr[iy])) continue;
                                    if (iy != tmpProductVersionArr.length - 1 && !tmpProductVersionArr[iy].matches("\\s")) {
                                        versionDescription.append(tmpProductVersionArr[iy].replaceAll("\\s", ""));
                                        versionDescription.append(" ");
                                        continue;
                                    }
                                    versionDescription.append(tmpProductVersionArr[iy].replaceAll("\\s", ""));
                                }
                            }
                            if (tmpProductVersionArr.length <= 1) continue;
                            Element apiTool = this.outputObject.createElement("apiTool");
                            apiTool.setAttribute("name", tmpProductVersionArr[0]);
                            apiTool.setAttribute("version", tmpProductVersionArr[1].replaceAll("\\s", ""));
                            apiTool.setAttribute("description", versionDescription.toString());
                            apiVersion.appendChild(apiTool);
                        }
                    }
                }
                result.appendChild(prolog);
            }
        }
        return result;
    }

    private void processExcludes() {
        Iterator<String> iterator;
        this.processExcludesForChildren(this.domObject);
        Set<String> keyset = this.classTable.keySet();
        if (keyset != null && (iterator = keyset.iterator()) != null) {
            block0: while (iterator.hasNext()) {
                AsClass tempClass = this.classTable.get(iterator.next());
                AsClass baseClass = this.classTable.get(tempClass.getBaseName());
                while (baseClass != null) {
                    Element exclude;
                    Element asMetadata;
                    Element prolog = this.asDocUtil.getElementByTagName(baseClass.getNode(), "prolog");
                    if (prolog != null && (asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata")) != null && (exclude = this.asDocUtil.getElementByTagName(asMetadata, "Exclude")) != null) {
                        tempClass.getExcludedProperties().addAll(baseClass.getExcludedProperties());
                    }
                    if (baseClass.getName().equals("Object")) continue block0;
                    baseClass = this.classTable.get(baseClass.getBaseName());
                }
            }
        }
    }

    private void processExcludesForChildren(Node parent) {
        NodeList listOfChilds;
        String fullName;
        AsClass ownerClass;
        if (parent.getNodeName().equals("Exclude") && (ownerClass = this.classTable.get(fullName = ((Element)parent).getAttribute("owner"))) != null) {
            Element node = ownerClass.getNode();
            Element asMetadata = null;
            Element prolog = this.asDocUtil.getElementByTagName(node, "prolog");
            if (prolog != null) {
                asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata");
                if (asMetadata == null) {
                    asMetadata = this.outputObject.createElement("asMetadata");
                    prolog.appendChild(asMetadata);
                }
            } else {
                asMetadata = this.outputObject.createElement("asMetadata");
                prolog = this.outputObject.createElement("prolog");
                prolog.appendChild(asMetadata);
                node.appendChild(prolog);
            }
            Element excludeElement = this.outputObject.createElement("Exclude");
            excludeElement.setAttribute("name", ((Element)parent).getAttribute("name"));
            excludeElement.setAttribute("kind", ((Element)parent).getAttribute("kind"));
            asMetadata.appendChild(excludeElement);
            if (((Element)parent).getAttribute("id").equals("property")) {
                ownerClass.getExcludedProperties().add(((Element)parent).getAttribute("name"));
            }
        }
        if ((listOfChilds = parent.getChildNodes()) != null && listOfChilds.getLength() != 0) {
            for (int ix = 0; ix < listOfChilds.getLength(); ++ix) {
                Node childNode = listOfChilds.item(ix);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                this.processExcludesForChildren(child);
            }
        }
    }

    private void processFields() {
        this.processFieldsForChildren(this.domObject);
    }

    private void processFieldsForChildren(Node parent) {
        NodeList listOfChilds = parent.getChildNodes();
        if (listOfChilds != null && listOfChilds.getLength() != 0) {
            for (int ix = 0; ix < listOfChilds.getLength(); ++ix) {
                Node childNode = listOfChilds.item(ix);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                this.processFieldsForChildren(child);
            }
        }
        if (parent.getNodeName().equals("field")) {
            String type;
            AsClass fieldClass;
            String author;
            String isConst;
            NodeList excludeList;
            Element asMetadata;
            NodeList children;
            String name = ((Element)parent).getAttribute("name");
            String fullName = ((Element)parent).getAttribute("fullname");
            if (this.verbose) {
                System.out.println("   processing field: " + fullName);
            }
            if (((children = ((Element)parent).getElementsByTagName("private")) != null && children.getLength() != 0 || ((Element)parent).getAttribute("access").equals("private")) && !this.includePrivate) {
                return;
            }
            QualifiedNameInfo qualifiedFullName = this.decomposeFullMethodOrFieldName(fullName);
            if (this.asDocUtil.hideNamespace(qualifiedFullName.getMethodNameSpace(), this.namespaces) || this.asDocUtil.hidePackage(qualifiedFullName.getPackageName(), this.hiddenPackages)) {
                return;
            }
            AsClass myClass = this.classTable.get(qualifiedFullName.getFullClassName());
            if (myClass == null) {
                return;
            }
            Element prolog = this.asDocUtil.getElementByTagName(myClass.getNode(), "prolog");
            if (prolog != null && (asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata")) != null && (excludeList = asMetadata.getElementsByTagName("Exclude")) != null && excludeList.getLength() != 0) {
                for (int ix = 0; ix < excludeList.getLength(); ++ix) {
                    Element exclude = (Element)excludeList.item(ix);
                    if (!exclude.getAttribute("kind").equals("property") || !exclude.getAttribute("name").equals(name)) continue;
                    if (this.verbose) {
                        System.out.println("Excluding property " + name + " from " + myClass.getName());
                    }
                    return;
                }
            }
            if ((isConst = ((Element)parent).getAttribute("isConst")).equals("")) {
                isConst = "false";
            }
            Element apiValue = this.outputObject.createElement("apiValue");
            apiValue.setAttribute("id", this.asDocUtil.formatId(fullName));
            Element apiName = this.outputObject.createElement("apiName");
            apiName.setTextContent(name);
            apiValue.appendChild(apiName);
            Element shortdesc = this.outputObject.createElement("shortdesc");
            apiValue.appendChild(shortdesc);
            prolog = this.outputObject.createElement("prolog");
            apiValue.appendChild(prolog);
            Element apiValueDetail = this.outputObject.createElement("apiValueDetail");
            Element apiValueDef = this.outputObject.createElement("apiValueDef");
            apiValueDetail.appendChild(apiValueDef);
            apiValue.appendChild(apiValueDetail);
            if (isConst.equals("false")) {
                Element apiProperty = this.outputObject.createElement("apiProperty");
                apiValueDef.appendChild(apiProperty);
            }
            if ((children = ((Element)parent).getElementsByTagName("author")) != null && children.getLength() != 0 && !(author = children.item(0).getTextContent()).equals("")) {
                Element authorElement = this.outputObject.createElement("author");
                authorElement.setTextContent(author);
                prolog.appendChild(authorElement);
            }
            Element apiAccess = this.outputObject.createElement("apiAccess");
            apiAccess.setAttribute("value", qualifiedFullName.getMethodNameSpace());
            apiValueDef.appendChild(apiAccess);
            if (((Element)parent).getAttribute("isStatic").equals("true")) {
                Element apiStatic = this.outputObject.createElement("apiStatic");
                apiValueDef.appendChild(apiStatic);
            } else {
                Element apiDynamic = this.outputObject.createElement("apiDynamic");
                apiValueDef.appendChild(apiDynamic);
            }
            String defaultValue = ((Element)parent).getAttribute("defaultValue");
            if (defaultValue.length() > 0) {
                Element apiData = this.outputObject.createElement("apiData");
                apiData.setTextContent(defaultValue);
                apiValueDef.appendChild(apiData);
            }
            if ((fieldClass = this.classTable.get(type = ((Element)parent).getAttribute("type"))) != null) {
                Element apiValueClassifier = this.outputObject.createElement("apiValueClassifier");
                apiValueClassifier.setTextContent(fieldClass.getFullName());
                apiValueDef.appendChild(apiValueClassifier);
            } else {
                Element apiType = this.outputObject.createElement("apiType");
                if (type.equals("*")) {
                    apiType.setAttribute("value", "any");
                } else {
                    apiType.setAttribute("value", type);
                }
                apiValueDef.appendChild(apiType);
            }
            String fullDesc = null;
            NodeList descriptionList = ((Element)parent).getElementsByTagName("description");
            if (descriptionList != null && descriptionList.getLength() != 0) {
                fullDesc = descriptionList.item(0).getTextContent();
                Element apiDesc = this.outputObject.createElement("apiDesc");
                CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(fullDesc, "description", fullName));
                apiDesc.appendChild(cdata);
                apiValueDetail.appendChild(apiDesc);
                this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                shortdesc.setTextContent(this.asDocUtil.descToShortDesc(fullDesc));
            }
            if ((children = ((Element)parent).getElementsByTagName("example")) != null) {
                for (int ix = 0; ix < children.getLength(); ++ix) {
                    Element inputExampleElement = (Element)children.item(ix);
                    Element example = this.outputObject.createElement("example");
                    CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(inputExampleElement.getTextContent(), "example", fullName));
                    example.appendChild(cdata);
                    apiValueDetail.appendChild(example);
                    this.asDocUtil.convertDescToDITA(example, this.oldNewNamesMap);
                }
            }
            if ((children = ((Element)parent).getElementsByTagName("throws")) != null && children.getLength() != 0) {
                for (int ix = 0; ix < children.getLength(); ++ix) {
                    Element throwsElement = (Element)children.item(ix);
                    apiValueDef.appendChild(this.createCanThrow(throwsElement, qualifiedFullName));
                }
            }
            this.processVersions((Element)parent, apiValue);
            this.processCustoms((Element)parent, apiValue, false, "", "", "");
            children = ((Element)parent).getElementsByTagName("eventType");
            if (children != null && children.getLength() != 0) {
                String eventNameStr = children.item(0).getTextContent();
                eventNameStr = eventNameStr.replaceAll("\\n", "");
                eventNameStr = eventNameStr.replaceAll("\\r", "");
                int firstSpace = (eventNameStr = this.asDocUtil.normalizeString(eventNameStr)).indexOf(" ");
                if (firstSpace != -1) {
                    eventNameStr = eventNameStr.substring(0, firstSpace);
                }
                String eventId = this.asDocUtil.formatId(fullName) + "_" + eventNameStr;
                Element adobeApiEvent = this.outputObject.createElement("adobeApiEvent");
                adobeApiEvent.setAttribute("id", eventId);
                Element apiName2 = this.outputObject.createElement("apiName");
                apiName2.setTextContent(eventNameStr);
                adobeApiEvent.appendChild(apiName2);
                adobeApiEvent.appendChild(this.outputObject.createElement("prolog"));
                Element adobeApiEventDetail = this.outputObject.createElement("adobeApiEventDetail");
                adobeApiEvent.appendChild(adobeApiEventDetail);
                Element adobeApiEventDef = this.outputObject.createElement("adobeApiEventDef");
                adobeApiEventDetail.appendChild(adobeApiEventDef);
                Element apiEventType = this.outputObject.createElement("apiEventType");
                apiEventType.setTextContent(this.asDocUtil.formatId(fullName));
                adobeApiEventDef.appendChild(apiEventType);
                Element adobeApiEventClassifier = this.outputObject.createElement("adobeApiEventClassifier");
                adobeApiEventClassifier.setTextContent(myClass.getFullName());
                adobeApiEventDef.appendChild(adobeApiEventClassifier);
                Element apiDefinedEvent = this.outputObject.createElement("apiDefinedEvent");
                adobeApiEventDef.appendChild(apiDefinedEvent);
                this.processCustoms((Element)parent, adobeApiEvent, false, "", "", "");
                myClass.getNode().appendChild(adobeApiEvent);
                if (this.verbose) {
                    System.out.println("event handling for fields added event " + eventNameStr + " to class " + myClass.getNode().getNodeName());
                }
                if (descriptionList != null && descriptionList.getLength() != 0) {
                    myClass.getEventCommentTable().put(eventNameStr, descriptionList.item(0).getTextContent());
                }
            }
            if (myClass != null) {
                if (myClass.getFieldCount() == 0) {
                    Element fields = this.outputObject.createElement("fields");
                    fields.appendChild(apiValue);
                    myClass.setFields(fields);
                } else {
                    myClass.getFields().appendChild(apiValue);
                }
                myClass.setFieldCount(myClass.getFieldCount() + 1);
            } else if (this.verbose) {
                System.out.print("*** Internal error: can't find class for field: " + qualifiedFullName.getFullClassName());
            }
            if (this.verbose) {
                System.out.println(" done  processing field: " + fullName);
            }
        }
    }

    private Element createCanThrow(Element source, QualifiedNameInfo qualifiedFullName) {
        String throwComment = "";
        String fullThrows = source.getTextContent();
        int nextSpaceIndex = fullThrows.indexOf(" ");
        String errorClassStr = null;
        if (nextSpaceIndex == -1) {
            errorClassStr = "Error";
            throwComment = fullThrows;
        } else {
            errorClassStr = fullThrows.substring(0, nextSpaceIndex);
            throwComment = fullThrows.substring(nextSpaceIndex + 1);
        }
        Element apiException = this.outputObject.createElement("apiException");
        Element apiDesc = this.outputObject.createElement("apiDesc");
        CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(throwComment, "throws", qualifiedFullName.getFullClassName()));
        apiDesc.appendChild(cdata);
        apiException.appendChild(apiDesc);
        this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
        AsClass errorClass = this.classTable.get(errorClassStr);
        if (errorClass == null) {
            if (this.verbose) {
                System.out.println("   Can not resolve error class name: " + errorClassStr + " looking in flash.errors");
            }
            errorClass = this.classTable.get("flash.errors:" + errorClassStr);
        }
        if (errorClass == null && errorClassStr.indexOf(".") != -1 && errorClassStr.indexOf(":") == -1) {
            String[] parts = errorClassStr.split("\\.");
            errorClassStr = "";
            for (int ix = 0; ix < parts.length; ++ix) {
                if (ix == parts.length - 1) {
                    errorClassStr = errorClassStr + ":";
                } else if (ix != 0) {
                    errorClassStr = errorClassStr + ".";
                }
                errorClassStr = errorClassStr + parts[ix];
            }
            errorClass = this.classTable.get(errorClassStr);
        }
        if (errorClass == null) {
            errorClass = this.classTable.get("Error");
        }
        Element apiItemName = this.outputObject.createElement("apiItemName");
        Element apiOperationClassifier = this.outputObject.createElement("apiOperationClassifier");
        if (errorClass != null) {
            apiItemName.setTextContent(errorClass.getName());
            apiOperationClassifier.setTextContent(errorClass.getFullName());
        } else {
            apiItemName.setTextContent(errorClassStr);
            apiOperationClassifier.setTextContent(errorClassStr);
        }
        apiException.appendChild(apiItemName);
        apiException.appendChild(apiOperationClassifier);
        return apiException;
    }

    private void processMethods() {
        this.processMethodsForChildren(this.domObject);
    }

    private void processMethodsForChildren(Node parent) {
        NodeList listOfChilds = parent.getChildNodes();
        if (listOfChilds != null && listOfChilds.getLength() != 0) {
            for (int ix = 0; ix < listOfChilds.getLength(); ++ix) {
                Node childNode = listOfChilds.item(ix);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                this.processMethodsForChildren(child);
            }
        }
        if (parent.getNodeName().equals("method")) {
            NodeList excludeList;
            Element asMetadata;
            Element prolog;
            AsClass myClass;
            QualifiedNameInfo qualifiedFullName;
            String name = ((Element)parent).getAttribute("name");
            String fullName = ((Element)parent).getAttribute("fullname");
            if (this.verbose) {
                System.out.println("   #processing method: " + fullName);
            }
            if (this.asDocUtil.hidePackage((qualifiedFullName = this.decomposeFullMethodOrFieldName(fullName)).getPackageName(), this.hiddenPackages)) {
                return;
            }
            boolean isBindable = false;
            if (this.bindableTable.get(fullName) != null) {
                isBindable = true;
            }
            if (!isBindable && this.bindableTable.get(qualifiedFullName.getFullClassName()) != null) {
                isBindable = true;
            }
            if (this.verbose) {
                System.out.println(" @@ qualifiedFullName.getFullClassName() " + qualifiedFullName.getFullClassName());
            }
            if (!((myClass = this.classTable.get(qualifiedFullName.getFullClassName())) != null && myClass.isInterfaceFlag() || qualifiedFullName.getClassNames() == null && qualifiedFullName.getClassNames().size() == 0 && name.equals(qualifiedFullName.getClassNames().get(qualifiedFullName.getClassNames().size() - 1)) || !this.asDocUtil.hideNamespace(qualifiedFullName.getMethodNameSpace(), this.namespaces))) {
                return;
            }
            if (myClass != null && (prolog = this.asDocUtil.getElementByTagName(myClass.getNode(), "prolog")) != null && (asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata")) != null && (excludeList = asMetadata.getElementsByTagName("Exclude")) != null && excludeList.getLength() != 0) {
                String kind = qualifiedFullName.getGetterSetter().length() != 0 ? "property" : "method";
                for (int ix = 0; ix < excludeList.getLength(); ++ix) {
                    Element exclude = (Element)excludeList.item(ix);
                    if (!exclude.getAttribute("kind").equals(kind) || !exclude.getAttribute("name").equals(name)) continue;
                    if (this.verbose) {
                        System.out.println("Excluding " + kind + " " + name + " from " + myClass.getName());
                    }
                    return;
                }
            }
            if (myClass == null) {
                return;
            }
            if (myClass != null && qualifiedFullName.getGetterSetter().length() != 0) {
                NodeList throwsList;
                NodeList privateChilds;
                if (this.verbose) {
                    System.out.println("   changing method: " + fullName + " into a field (its a getter or setter)");
                }
                Element apiValue = this.outputObject.createElement("apiValue");
                apiValue.setAttribute("id", this.asDocUtil.formatId(fullName));
                Element apiName = this.outputObject.createElement("apiName");
                apiName.setTextContent(name);
                apiValue.appendChild(apiName);
                Element shortdesc = this.outputObject.createElement("shortdesc");
                apiValue.appendChild(shortdesc);
                Element prolog2 = this.outputObject.createElement("prolog");
                apiValue.appendChild(prolog2);
                Element apiValueDetail = this.outputObject.createElement("apiValueDetail");
                Element apiValueDef = this.outputObject.createElement("apiValueDef");
                apiValueDetail.appendChild(apiValueDef);
                boolean isOverride = Boolean.parseBoolean(((Element)parent).getAttribute("isOverride"));
                if (isOverride) {
                    Element apiIsOverride = this.outputObject.createElement("apiIsOverride");
                    apiValueDef.appendChild(apiIsOverride);
                }
                apiValue.appendChild(apiValueDetail);
                Element apiProperty = this.outputObject.createElement("apiProperty");
                apiValueDef.appendChild(apiProperty);
                Element apiAccess = this.outputObject.createElement("apiAccess");
                apiAccess.setAttribute("value", qualifiedFullName.getMethodNameSpace());
                apiValueDef.appendChild(apiAccess);
                if (((Element)parent).getAttribute("isStatic").equals("true")) {
                    Element apiStatic = this.outputObject.createElement("apiStatic");
                    apiValueDef.appendChild(apiStatic);
                } else {
                    Element apiDynamic = this.outputObject.createElement("apiDynamic");
                    apiValueDef.appendChild(apiDynamic);
                }
                String getterSetterFullDesc = "";
                NodeList descriptionList = ((Element)parent).getElementsByTagName("description");
                if (descriptionList != null && descriptionList.getLength() != 0) {
                    getterSetterFullDesc = descriptionList.item(0).getTextContent();
                    Element apiDesc = this.outputObject.createElement("apiDesc");
                    CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(getterSetterFullDesc, "description", fullName));
                    apiDesc.appendChild(cdata);
                    apiValueDetail.appendChild(apiDesc);
                    this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                    shortdesc.setTextContent(this.asDocUtil.descToShortDesc(getterSetterFullDesc));
                }
                if (isBindable) {
                    apiProperty.setAttribute("isBindable", "true");
                }
                this.processVersions((Element)parent, apiValue);
                if (myClass.getFieldGetSet().get(name) == null) {
                    myClass.getFieldGetSet().put(name, 0);
                }
                if ((privateChilds = ((Element)parent).getElementsByTagName("private")) != null && privateChilds.getLength() != 0 && !this.includePrivate) {
                    if (myClass.getPrivateGetSet().get(name) == null) {
                        myClass.getPrivateGetSet().put(name, 0);
                    }
                    if (qualifiedFullName.getGetterSetter().equals("Get")) {
                        if (myClass.getPrivateGetSet().get(name) <= 1) {
                            myClass.getPrivateGetSet().put(name, 1);
                            myClass.getFieldGetSet().put(name, 1);
                        } else {
                            myClass.getPrivateGetSet().put(name, myClass.getPrivateGetSet().get(name) + 1);
                            myClass.getFieldGetSet().put(name, myClass.getFieldGetSet().get(name) + 1);
                        }
                    } else {
                        myClass.getPrivateGetSet().put(name, myClass.getPrivateGetSet().get(name) + 2);
                        myClass.getFieldGetSet().put(name, myClass.getFieldGetSet().get(name) + 2);
                    }
                    return;
                }
                AsClass fieldTypeClass = null;
                String type = null;
                if (qualifiedFullName.getGetterSetter().equals("Get")) {
                    type = ((Element)parent).getAttribute("result_type");
                    fieldTypeClass = this.classTable.get(type);
                    if (myClass.getFieldGetSet().get(name) <= 1) {
                        myClass.getFieldGetSet().put(name, 1);
                    } else {
                        myClass.getFieldGetSet().put(name, myClass.getFieldGetSet().get(name) + 1);
                    }
                } else {
                    type = ((Element)parent).getAttribute("param_types");
                    fieldTypeClass = this.classTable.get(type);
                    myClass.getFieldGetSet().put(name, myClass.getFieldGetSet().get(name) + 2);
                }
                Element apiValueAccess = this.outputObject.createElement("apiValueAccess");
                apiValueDef.appendChild(apiValueAccess);
                if (fieldTypeClass != null) {
                    Element apiValueClassifier = this.outputObject.createElement("apiValueClassifier");
                    apiValueClassifier.setTextContent(fieldTypeClass.getFullName());
                    apiValueDef.appendChild(apiValueClassifier);
                } else {
                    Element apiType = this.outputObject.createElement("apiType");
                    if (type.equals("*")) {
                        apiType.setAttribute("value", "any");
                    } else {
                        apiType.setAttribute("value", type);
                    }
                    apiValueDef.appendChild(apiType);
                }
                NodeList exampleList = ((Element)parent).getElementsByTagName("example");
                if (exampleList != null) {
                    for (int ix = 0; ix < exampleList.getLength(); ++ix) {
                        Element inputExampleElement = (Element)exampleList.item(ix);
                        Element example = this.outputObject.createElement("example");
                        CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(inputExampleElement.getTextContent(), "example", fullName));
                        example.appendChild(cdata);
                        apiValueDetail.appendChild(example);
                        this.asDocUtil.convertDescToDITA(example, this.oldNewNamesMap);
                    }
                }
                if ((throwsList = ((Element)parent).getElementsByTagName("throws")) != null && throwsList.getLength() != 0) {
                    for (int ix = 0; ix < throwsList.getLength(); ++ix) {
                        Element throwsElement = (Element)throwsList.item(ix);
                        apiValueDef.appendChild(this.createCanThrow(throwsElement, qualifiedFullName));
                    }
                }
                this.processCustoms((Element)parent, apiValue, false, "", "", "");
                if (myClass != null) {
                    if (myClass.getFieldCount() == 0) {
                        Element fields = this.outputObject.createElement("fields");
                        fields.appendChild(apiValue);
                        myClass.setFields(fields);
                        myClass.setFieldCount(myClass.getFieldCount() + 1);
                    } else {
                        Element temp = myClass.getFields();
                        NodeList apiValueList = temp.getElementsByTagName("apiValue");
                        int numChildren = apiValueList.getLength();
                        Element foundField = null;
                        for (int ix = 0; ix < numChildren; ++ix) {
                            if (!((Element)apiValueList.item(ix)).getElementsByTagName("apiName").item(0).getTextContent().equals(apiName.getTextContent())) continue;
                            foundField = (Element)apiValueList.item(ix);
                            break;
                        }
                        if (foundField == null) {
                            myClass.getFields().appendChild(apiValue);
                            myClass.setFieldCount(myClass.getFieldCount() + 1);
                        } else {
                            Element foundApiValueDetail;
                            boolean replaceFlag = false;
                            if (getterSetterFullDesc != null && getterSetterFullDesc.trim().length() != 0) {
                                Element foundApiDesc = null;
                                foundApiValueDetail = this.asDocUtil.getElementByTagName(foundField, "apiValueDetail");
                                if (foundApiValueDetail != null) {
                                    foundApiDesc = this.asDocUtil.getElementByTagName(foundApiValueDetail, "apiDesc");
                                    if (foundApiDesc != null) {
                                        if (foundApiDesc.getTextContent().trim().length() == 0) {
                                            replaceFlag = true;
                                        }
                                    } else {
                                        replaceFlag = true;
                                    }
                                    if (replaceFlag) {
                                        temp.replaceChild(apiValue, foundField);
                                    }
                                }
                            }
                            if (!replaceFlag) {
                                Element foundApiValueDef = null;
                                foundApiValueDetail = null;
                                Element apiType = this.asDocUtil.getElementByTagName(apiValueDef, "apiType");
                                if (apiType != null) {
                                    foundApiValueDetail = this.asDocUtil.getElementByTagName(foundField, "apiValueDetail");
                                    if (foundApiValueDetail != null) {
                                        foundApiValueDef = this.asDocUtil.getElementByTagName(foundApiValueDetail, "apiValueDef");
                                        if (foundApiValueDef == null) {
                                            foundApiValueDef = this.outputObject.createElement("apiValueDef");
                                            foundApiValueDetail.appendChild(foundApiValueDef);
                                        }
                                    } else {
                                        foundApiValueDef = this.outputObject.createElement("apiValueDef");
                                        foundApiValueDetail = this.outputObject.createElement("apiValueDetail");
                                        foundApiValueDetail.appendChild(foundApiValueDef);
                                        foundField.appendChild(foundApiValueDetail);
                                    }
                                    if (this.asDocUtil.getElementByTagName(foundApiValueDef, "apiType") == null) {
                                        foundApiValueDef.appendChild(apiType);
                                    }
                                } else {
                                    Element apiValueClassifier = this.asDocUtil.getElementByTagName(apiValueDef, "apiValueClassifier");
                                    if (apiValueClassifier != null) {
                                        foundApiValueDetail = this.asDocUtil.getElementByTagName(foundField, "apiValueDetail");
                                        if (foundApiValueDetail != null) {
                                            foundApiValueDef = this.asDocUtil.getElementByTagName(foundApiValueDetail, "apiValueDef");
                                            if (foundApiValueDef == null) {
                                                foundApiValueDef = this.outputObject.createElement("apiValueDef");
                                                foundApiValueDetail.appendChild(foundApiValueDef);
                                            }
                                        } else {
                                            foundApiValueDef = this.outputObject.createElement("apiValueDef");
                                            foundApiValueDetail = this.outputObject.createElement("apiValueDetail");
                                            foundApiValueDetail.appendChild(foundApiValueDef);
                                            foundField.appendChild(foundApiValueDetail);
                                        }
                                        if (this.asDocUtil.getElementByTagName(foundApiValueDef, "apiValueClassifier") == null) {
                                            foundApiValueDef.appendChild(apiValueClassifier);
                                        }
                                    } else if (this.verbose) {
                                        System.out.println("Error : No type definition for " + name);
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (myClass != null) {
                String author;
                NodeList authorList;
                NodeList throwsList;
                NodeList exampleList;
                NodeList privateChilds = ((Element)parent).getElementsByTagName("private");
                if (privateChilds != null && privateChilds.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                Element apiOperation = null;
                Element detailNode = null;
                Element defNode = null;
                Element shortdesc = null;
                Element prolog3 = null;
                boolean isConstructor = false;
                if (qualifiedFullName.getClassNames() != null && qualifiedFullName.getClassNames().size() != 0 && name.equals(qualifiedFullName.getClassNames().get(qualifiedFullName.getClassNames().size() - 1))) {
                    apiOperation = this.outputObject.createElement("apiConstructor");
                    apiOperation.setAttribute("id", this.asDocUtil.formatId(fullName));
                    Element apiName = this.outputObject.createElement("apiName");
                    apiName.setTextContent(name);
                    apiOperation.appendChild(apiName);
                    shortdesc = this.outputObject.createElement("shortdesc");
                    apiOperation.appendChild(shortdesc);
                    prolog3 = this.outputObject.createElement("prolog");
                    apiOperation.appendChild(prolog3);
                    detailNode = this.outputObject.createElement("apiConstructorDetail");
                    defNode = this.outputObject.createElement("apiConstructorDef");
                    detailNode.appendChild(defNode);
                    Element apiAccess = this.outputObject.createElement("apiAccess");
                    apiAccess.setAttribute("value", qualifiedFullName.getMethodNameSpace());
                    defNode.appendChild(apiAccess);
                    apiOperation.appendChild(detailNode);
                    isConstructor = true;
                } else {
                    boolean isFinal = Boolean.parseBoolean(((Element)parent).getAttribute("isFinal"));
                    boolean isOverride = Boolean.parseBoolean(((Element)parent).getAttribute("isOverride"));
                    boolean isStatic = Boolean.parseBoolean(((Element)parent).getAttribute("isStatic"));
                    if (isOverride) {
                        myClass.getMethodOverrideTable().put(name, "true");
                    }
                    apiOperation = this.outputObject.createElement("apiOperation");
                    apiOperation.setAttribute("id", this.asDocUtil.formatId(fullName));
                    Element apiName = this.outputObject.createElement("apiName");
                    apiName.setTextContent(name);
                    apiOperation.appendChild(apiName);
                    shortdesc = this.outputObject.createElement("shortdesc");
                    apiOperation.appendChild(shortdesc);
                    prolog3 = this.outputObject.createElement("prolog");
                    apiOperation.appendChild(prolog3);
                    detailNode = this.outputObject.createElement("apiOperationDetail");
                    defNode = this.outputObject.createElement("apiOperationDef");
                    detailNode.appendChild(defNode);
                    Element apiAccess = this.outputObject.createElement("apiAccess");
                    apiAccess.setAttribute("value", qualifiedFullName.getMethodNameSpace());
                    defNode.appendChild(apiAccess);
                    if (isFinal) {
                        Element apiFinal = this.outputObject.createElement("apiFinal");
                        defNode.appendChild(apiFinal);
                    }
                    if (isStatic) {
                        Element apiStatic = this.outputObject.createElement("apiStatic");
                        defNode.appendChild(apiStatic);
                    }
                    if (isOverride) {
                        Element apiIsOverride = this.outputObject.createElement("apiIsOverride");
                        defNode.appendChild(apiIsOverride);
                    }
                    apiOperation.appendChild(detailNode);
                }
                NodeList descriptionList = ((Element)parent).getElementsByTagName("description");
                if (descriptionList != null && descriptionList.getLength() != 0) {
                    String fullDesc = descriptionList.item(0).getTextContent();
                    if (isConstructor && fullDesc.length() == 0 && myClass.getSourceFile().toLowerCase().endsWith(".mxml")) {
                        fullDesc = "Constructor.";
                    }
                    Element apiDesc = this.outputObject.createElement("apiDesc");
                    CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(fullDesc, "description", fullName));
                    apiDesc.appendChild(cdata);
                    detailNode.appendChild(apiDesc);
                    this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                    shortdesc.setTextContent(this.asDocUtil.descToShortDesc(fullDesc));
                }
                if ((exampleList = ((Element)parent).getElementsByTagName("example")) != null) {
                    for (int ix = 0; ix < exampleList.getLength(); ++ix) {
                        Element inputExampleElement = (Element)exampleList.item(ix);
                        Element example = this.outputObject.createElement("example");
                        CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(inputExampleElement.getTextContent(), "example", fullName));
                        example.appendChild(cdata);
                        detailNode.appendChild(example);
                        this.asDocUtil.convertDescToDITA(example, this.oldNewNamesMap);
                    }
                }
                if ((throwsList = ((Element)parent).getElementsByTagName("throws")) != null && throwsList.getLength() != 0) {
                    for (int ix = 0; ix < throwsList.getLength(); ++ix) {
                        Element throwsElement = (Element)throwsList.item(ix);
                        defNode.appendChild(this.createCanThrow(throwsElement, myClass.getDecompName()));
                    }
                }
                if ((authorList = ((Element)parent).getElementsByTagName("author")) != null && authorList.getLength() != 0 && !(author = authorList.item(0).getTextContent()).equals("")) {
                    Element authorElement = this.outputObject.createElement("author");
                    authorElement.setTextContent(author);
                    prolog3.appendChild(authorElement);
                }
                this.processVersions((Element)parent, apiOperation);
                if (!isConstructor) {
                    Element apiType;
                    NodeList returnList = ((Element)parent).getElementsByTagName("return");
                    Element apiReturn = this.outputObject.createElement("apiReturn");
                    if (returnList != null && returnList.getLength() != 0) {
                        Element apiDesc = this.outputObject.createElement("apiDesc");
                        CDATASection cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(returnList.item(0).getTextContent(), "return", fullName));
                        apiDesc.appendChild(cdata);
                        apiReturn.appendChild(apiDesc);
                        defNode.appendChild(apiReturn);
                        this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                    } else {
                        defNode.appendChild(apiReturn);
                    }
                    String returnType = ((Element)parent).getAttribute("result_type");
                    AsClass returnClass = this.classTable.get(returnType);
                    if (returnClass != null) {
                        Element apiOperationClassifier = this.outputObject.createElement("apiOperationClassifier");
                        apiOperationClassifier.setTextContent(returnClass.getFullName());
                        apiReturn.appendChild(apiOperationClassifier);
                    } else if (returnType.equals("*")) {
                        apiType = this.outputObject.createElement("apiType");
                        apiType.setAttribute("value", "any");
                        apiReturn.appendChild(apiType);
                    } else {
                        apiType = this.outputObject.createElement("apiType");
                        apiType.setAttribute("value", returnType);
                        apiReturn.appendChild(apiType);
                    }
                }
                String paramNames = ((Element)parent).getAttribute("param_names");
                String paramTypes = ((Element)parent).getAttribute("param_types");
                String paramDefaults = ((Element)parent).getAttribute("param_defaults");
                this.processCustoms((Element)parent, apiOperation, true, paramNames, paramTypes, paramDefaults, myClass);
                NodeList eventList = ((Element)parent).getElementsByTagName("event");
                if (eventList != null && eventList.getLength() != 0) {
                    for (int ix = 0; ix < eventList.getLength(); ++ix) {
                        AsClass eventClass;
                        String fullEventStr = eventList.item(ix).getTextContent();
                        String eventCommentStr = "";
                        int nextSpaceIndex = fullEventStr.indexOf(" ");
                        String eventClassStr = null;
                        if (nextSpaceIndex == -1) {
                            eventClassStr = "Event";
                            eventCommentStr = fullEventStr;
                            nextSpaceIndex = fullEventStr.length() - 1;
                        }
                        String eventName = fullEventStr.substring(0, nextSpaceIndex);
                        if (eventClassStr == null) {
                            int lastSpaceIndex = nextSpaceIndex + 1;
                            if ((nextSpaceIndex = fullEventStr.indexOf(" ", lastSpaceIndex)) == -1) {
                                eventClassStr = "Event";
                                eventCommentStr = fullEventStr.substring(lastSpaceIndex);
                            } else {
                                eventClassStr = fullEventStr.substring(lastSpaceIndex, nextSpaceIndex);
                                eventCommentStr = fullEventStr.substring(nextSpaceIndex + 1);
                            }
                        }
                        if (eventClassStr != null && eventClassStr.indexOf(58) == -1 && eventClassStr.indexOf(46) != -1) {
                            int periodIndex = eventClassStr.lastIndexOf(46);
                            eventClassStr = eventClassStr.substring(0, periodIndex) + ':' + eventClassStr.substring(periodIndex + 1);
                        }
                        if ((eventClass = this.classTable.get(eventClassStr)) == null) {
                            if (this.verbose) {
                                System.out.println("   Can not resolve event name: " + eventClassStr + " looking in flash.events");
                            }
                            if ((eventClass = this.classTable.get("flash.events:" + eventClassStr)) == null) {
                                if (this.verbose) {
                                    System.out.println("   Can not resolve event name: " + eventClassStr + " looking in air.update.events");
                                }
                                eventClass = this.classTable.get("air.update.events:" + eventClassStr);
                            }
                        }
                        String eventId = this.asDocUtil.formatId(fullName) + "_" + eventName;
                        String eventComment = this.asDocUtil.validateText(eventCommentStr, "event", fullName);
                        Element adobeApiEvent = this.outputObject.createElement("adobeApiEvent");
                        adobeApiEvent.setAttribute("id", eventId);
                        Element apiName2 = this.outputObject.createElement("apiName");
                        apiName2.setTextContent(eventName);
                        adobeApiEvent.appendChild(apiName2);
                        adobeApiEvent.appendChild(this.outputObject.createElement("prolog"));
                        Element adobeApiEventDetail = this.outputObject.createElement("adobeApiEventDetail");
                        adobeApiEvent.appendChild(adobeApiEventDetail);
                        Element adobeApiEventDef = this.outputObject.createElement("adobeApiEventDef");
                        adobeApiEventDetail.appendChild(adobeApiEventDef);
                        Element apiDesc = this.outputObject.createElement("apiDesc");
                        CDATASection cdata = this.outputObject.createCDATASection(eventComment);
                        apiDesc.appendChild(cdata);
                        adobeApiEventDetail.appendChild(apiDesc);
                        if (eventClass != null) {
                            Element adobeApiEventClassifier = this.outputObject.createElement("adobeApiEventClassifier");
                            adobeApiEventClassifier.setTextContent(eventClass.getFullName());
                            adobeApiEventDef.appendChild(adobeApiEventClassifier);
                        }
                        Element apiGeneratedEvent = this.outputObject.createElement("apiGeneratedEvent");
                        adobeApiEventDef.appendChild(apiGeneratedEvent);
                        this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                        Element shortdesc2 = this.outputObject.createElement("shortdesc");
                        shortdesc2.setTextContent(this.asDocUtil.descToShortDesc(eventComment));
                        adobeApiEvent.appendChild(shortdesc2);
                        apiOperation.appendChild(adobeApiEvent);
                        if (!this.verbose) continue;
                        System.out.println("event handling for methods added event " + eventName + " to method " + fullName);
                    }
                }
                if (isConstructor) {
                    Element constructors = null;
                    if (myClass.getConstructorCount() == 0) {
                        constructors = this.outputObject.createElement("constructors");
                        myClass.setConstructors(constructors);
                    }
                    myClass.getConstructors().appendChild(apiOperation);
                    myClass.setConstructorCount(myClass.getConstructorCount() + 1);
                } else {
                    Element methods = null;
                    if (myClass.getMethodCount() == 0) {
                        methods = this.outputObject.createElement("methods");
                        myClass.setMethods(methods);
                    }
                    myClass.getMethods().appendChild(apiOperation);
                    myClass.setMethodCount(myClass.getMethodCount() + 1);
                }
            } else if (this.verbose) {
                System.out.println("can't find method for class: " + qualifiedFullName.getFullClassName());
            }
            if (this.verbose) {
                System.out.println("  done processing method: " + fullName);
            }
        }
    }

    private void processMetadata() {
        this.processMetadataForChildren(this.domObject);
    }

    private void processMetadataForChildren(Node parent) {
        NodeList listOfChilds = parent.getChildNodes();
        if (listOfChilds != null && listOfChilds.getLength() != 0) {
            for (int ix = 0; ix < listOfChilds.getLength(); ++ix) {
                Node childNode = listOfChilds.item(ix);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                this.processMetadataForChildren(child);
            }
        }
        if (parent.getNodeName().equals("metadata")) {
            String fullName;
            Element alternativeElement;
            Element skinPartElement;
            String text;
            Element relatedLinks;
            AsClass myClass;
            Element skinStateElement;
            Element deprecatedElement;
            Element defaultPropertyElement;
            AsClass myClass2;
            Element bindableElement;
            CDATASection cdata;
            Element eventElement;
            Element excludeElement;
            HashMap<String, String> attributes;
            Element asMetadata;
            Element prolog;
            Element node;
            AsClass myClass3;
            String fullName2;
            String name;
            Element effectElement;
            CDATASection cdata2;
            Element asMetadata2;
            Element styleElement = this.asDocUtil.getElementByTagName((Element)parent, "Style");
            if (styleElement != null) {
                NodeList descriptionList;
                NodeList childrenOfStyle = styleElement.getElementsByTagName("private");
                if (childrenOfStyle != null && childrenOfStyle.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                Element newStyleElement = this.asDocUtil.renameElementAndImportChild(styleElement, this.outputObject, "style");
                String name2 = newStyleElement.getAttribute("name");
                String fullName3 = newStyleElement.getAttribute("owner");
                AsClass myClass4 = this.classTable.get(fullName3);
                if (myClass4 == null) {
                    if (this.verbose) {
                        System.out.println("   Can not resolve style class name: " + fullName3);
                    }
                    return;
                }
                Element node2 = myClass4.getNode();
                Element prolog2 = this.asDocUtil.getElementByTagName(node2, "prolog");
                if (prolog2 != null && (asMetadata2 = this.asDocUtil.getElementByTagName(prolog2, "asMetadata")) != null) {
                    HashMap<String, String> attributes2 = new HashMap<String, String>();
                    attributes2.put("kind", "style");
                    attributes2.put("name", name2);
                    Element excludeElement2 = this.asDocUtil.getElementByTagNameAndMatchingAttributes(asMetadata2, "Exclude", attributes2.entrySet());
                    if (excludeElement2 != null) {
                        if (this.verbose) {
                            System.out.println("Excluding style " + name2 + " from " + myClass4.getName());
                        }
                        return;
                    }
                }
                this.asDocUtil.processCustoms(newStyleElement, this.outputObject);
                childrenOfStyle = newStyleElement.getElementsByTagName("default");
                if (childrenOfStyle != null && childrenOfStyle.getLength() != 0) {
                    Element defaultElement = (Element)childrenOfStyle.item(0);
                    String defaultText = defaultElement.getTextContent();
                    Element newDefaultElement = this.outputObject.createElement("default");
                    newDefaultElement.setTextContent(defaultText);
                    newStyleElement.replaceChild(newDefaultElement, defaultElement);
                }
                if ((descriptionList = newStyleElement.getElementsByTagName("description")) != null && descriptionList.getLength() != 0) {
                    Element descriptionElement = (Element)descriptionList.item(0);
                    String descriptionText = descriptionElement.getTextContent();
                    Element newDescriptionElement = this.outputObject.createElement("description");
                    cdata2 = this.outputObject.createCDATASection(this.asDocUtil.validateText(descriptionText, "description", fullName3));
                    newDescriptionElement.appendChild(cdata2);
                    newStyleElement.replaceChild(newDescriptionElement, descriptionElement);
                    this.asDocUtil.convertDescToDITA(newDescriptionElement, this.oldNewNamesMap);
                }
                if ((childrenOfStyle = newStyleElement.getElementsByTagName("see")) != null && childrenOfStyle.getLength() != 0) {
                    int ix;
                    Element relatedLinks2 = this.outputObject.createElement("related-links");
                    for (ix = 0; ix < childrenOfStyle.getLength(); ++ix) {
                        Element seeElement = (Element)childrenOfStyle.item(ix);
                        relatedLinks2.appendChild(this.processSeeTag(fullName3, seeElement.getTextContent()));
                    }
                    newStyleElement.appendChild(relatedLinks2);
                    for (ix = 0; ix < childrenOfStyle.getLength(); ++ix) {
                        newStyleElement.removeChild(childrenOfStyle.item(ix));
                    }
                }
                if ((childrenOfStyle = newStyleElement.getElementsByTagName("copy")) != null && childrenOfStyle.getLength() != 0) {
                    String text2 = childrenOfStyle.item(0).getTextContent();
                    text2 = text2.replaceAll("\\s+", "");
                    descriptionList = newStyleElement.getElementsByTagName("description");
                    Element descriptionElement = null;
                    if (descriptionList != null && descriptionList.getLength() != 0) {
                        descriptionElement = (Element)descriptionList.item(0);
                    } else {
                        descriptionElement = this.outputObject.createElement("description");
                        newStyleElement.appendChild(descriptionElement);
                    }
                    descriptionElement.setAttribute("conref", text2);
                    newStyleElement.removeChild(childrenOfStyle.item(0));
                }
                if ((childrenOfStyle = newStyleElement.getElementsByTagName("playerversion")) != null && childrenOfStyle.getLength() != 0) {
                    String playerversion = childrenOfStyle.item(0).getTextContent();
                    playerversion = playerversion.replaceAll("\\s+", "");
                    newStyleElement.setAttribute("playerVersion", playerversion);
                    newStyleElement.removeChild(childrenOfStyle.item(0));
                }
                Element stylesElement = null;
                Element asMetadata3 = null;
                if (prolog2 != null) {
                    asMetadata3 = this.asDocUtil.getElementByTagName(prolog2, "asMetadata");
                    if (asMetadata3 != null) {
                        stylesElement = this.asDocUtil.getElementByTagName(asMetadata3, "styles");
                        if (stylesElement == null) {
                            stylesElement = this.outputObject.createElement("styles");
                            asMetadata3.appendChild(stylesElement);
                        }
                    } else {
                        stylesElement = this.outputObject.createElement("styles");
                        asMetadata3 = this.outputObject.createElement("asMetadata");
                        asMetadata3.appendChild(stylesElement);
                        prolog2.appendChild(asMetadata3);
                    }
                } else {
                    stylesElement = this.outputObject.createElement("styles");
                    asMetadata3 = this.outputObject.createElement("asMetadata");
                    asMetadata3.appendChild(stylesElement);
                    prolog2 = this.outputObject.createElement("prolog");
                    prolog2.appendChild(asMetadata3);
                    myClass4.getNode().appendChild(prolog2);
                }
                newStyleElement = (Element)this.outputObject.importNode(newStyleElement, true);
                stylesElement.appendChild(newStyleElement);
            }
            if ((effectElement = this.asDocUtil.getElementByTagName((Element)parent, "Effect")) != null) {
                NodeList descriptionList;
                NodeList childrenOfEffect = effectElement.getElementsByTagName("private");
                if (childrenOfEffect != null && childrenOfEffect.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                Element newEffectElement = this.asDocUtil.renameElementAndImportChild(effectElement, this.outputObject, "effect");
                name = newEffectElement.getAttribute("name");
                fullName2 = newEffectElement.getAttribute("owner");
                myClass3 = this.classTable.get(fullName2);
                if (myClass3 == null) {
                    if (this.verbose) {
                        System.out.println("   Can not resolve effect class name: " + fullName2);
                    }
                    return;
                }
                node = myClass3.getNode();
                prolog = this.asDocUtil.getElementByTagName(node, "prolog");
                if (prolog != null && (asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata")) != null) {
                    attributes = new HashMap<String, String>();
                    attributes.put("kind", "effect");
                    attributes.put("name", name);
                    excludeElement = this.asDocUtil.getElementByTagNameAndMatchingAttributes(asMetadata, "Exclude", attributes.entrySet());
                    if (excludeElement != null) {
                        if (this.verbose) {
                            System.out.println("Excluding effect " + name + " from " + myClass3.getName());
                        }
                        return;
                    }
                }
                this.asDocUtil.processCustoms(newEffectElement, this.outputObject);
                childrenOfEffect = newEffectElement.getElementsByTagName("default");
                if (childrenOfEffect != null && childrenOfEffect.getLength() != 0) {
                    Element defaultElement = (Element)childrenOfEffect.item(0);
                    String defaultText = defaultElement.getTextContent();
                    Element newDefaultElement = this.outputObject.createElement("default");
                    newDefaultElement.setTextContent(defaultText);
                    newEffectElement.replaceChild(newDefaultElement, defaultElement);
                }
                if ((descriptionList = newEffectElement.getElementsByTagName("description")) != null && descriptionList.getLength() != 0) {
                    Element descriptionElement = (Element)descriptionList.item(0);
                    String descriptionText = descriptionElement.getTextContent();
                    Element newDescriptionElement = this.outputObject.createElement("description");
                    CDATASection cdata3 = this.outputObject.createCDATASection(this.asDocUtil.validateText(descriptionText, "description", fullName2));
                    newDescriptionElement.appendChild(cdata3);
                    newEffectElement.replaceChild(newDescriptionElement, descriptionElement);
                    this.asDocUtil.convertDescToDITA(newDescriptionElement, this.oldNewNamesMap);
                }
                if ((childrenOfEffect = newEffectElement.getElementsByTagName("copy")) != null && childrenOfEffect.getLength() != 0) {
                    String text3 = childrenOfEffect.item(0).getTextContent();
                    text3 = text3.replaceAll("[\\n\\s]", "");
                    descriptionList = newEffectElement.getElementsByTagName("description");
                    Element descriptionElement = null;
                    if (descriptionList != null && descriptionList.getLength() != 0) {
                        descriptionElement = (Element)descriptionList.item(0);
                    } else {
                        descriptionElement = this.outputObject.createElement("description");
                        newEffectElement.appendChild(descriptionElement);
                    }
                    descriptionElement.setAttribute("conref", text3);
                    newEffectElement.removeChild(childrenOfEffect.item(0));
                }
                Element effectsElement = null;
                Element asMetadata4 = null;
                if (prolog != null) {
                    asMetadata4 = this.asDocUtil.getElementByTagName(prolog, "asMetadata");
                    if (asMetadata4 != null) {
                        effectsElement = this.asDocUtil.getElementByTagName(asMetadata4, "effects");
                        if (effectsElement == null) {
                            effectsElement = this.outputObject.createElement("effects");
                            asMetadata4.appendChild(effectsElement);
                        }
                    } else {
                        effectsElement = this.outputObject.createElement("effects");
                        asMetadata4 = this.outputObject.createElement("asMetadata");
                        asMetadata4.appendChild(effectsElement);
                        prolog.appendChild(asMetadata4);
                    }
                } else {
                    effectsElement = this.outputObject.createElement("effects");
                    asMetadata4 = this.outputObject.createElement("asMetadata");
                    asMetadata4.appendChild(effectsElement);
                    prolog = this.outputObject.createElement("prolog");
                    prolog.appendChild(asMetadata4);
                    myClass3.getNode().appendChild(prolog);
                }
                newEffectElement = (Element)this.outputObject.importNode(newEffectElement, true);
                effectsElement.appendChild(newEffectElement);
            }
            if ((eventElement = this.asDocUtil.getElementByTagName((Element)parent, "Event")) != null) {
                NodeList childrenOfEvent = eventElement.getElementsByTagName("private");
                if (childrenOfEvent != null && childrenOfEvent.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                name = eventElement.getAttribute("name");
                fullName2 = eventElement.getAttribute("owner");
                myClass3 = this.classTable.get(fullName2);
                if (myClass3 == null) {
                    if (this.verbose) {
                        System.out.println("   Can not resolve event  class name: " + fullName2);
                    }
                    return;
                }
                node = myClass3.getNode();
                prolog = this.asDocUtil.getElementByTagName(node, "prolog");
                if (prolog != null && (asMetadata = this.asDocUtil.getElementByTagName(prolog, "asMetadata")) != null) {
                    attributes = new HashMap();
                    attributes.put("kind", "event");
                    attributes.put("name", name);
                    excludeElement = this.asDocUtil.getElementByTagNameAndMatchingAttributes(asMetadata, "Exclude", attributes.entrySet());
                    if (excludeElement != null) {
                        if (this.verbose) {
                            System.out.println("Excluding event " + name + " from " + myClass3.getName());
                        }
                        return;
                    }
                }
                String eventType = null;
                childrenOfEvent = ((Element)parent).getElementsByTagName("eventType");
                if (childrenOfEvent != null && childrenOfEvent.getLength() != 0) {
                    eventType = childrenOfEvent.item(0).getTextContent().replaceAll("\\s+", "");
                }
                String eventObjectType = eventElement.getAttribute("type");
                String fullDesc = "";
                childrenOfEvent = eventElement.getElementsByTagName("description");
                if (childrenOfEvent != null && childrenOfEvent.getLength() != 0) {
                    Element descriptionElement = (Element)childrenOfEvent.item(0);
                    descriptionElement.normalize();
                    fullDesc = descriptionElement.getTextContent();
                }
                String eventId = null;
                eventId = eventType != null ? this.asDocUtil.formatId(myClass3.getFullName()) + "_" + this.asDocUtil.formatId(eventType) + "_" + name : this.asDocUtil.formatId(myClass3.getFullName()) + "_" + this.asDocUtil.formatId(eventObjectType) + "_" + name;
                Element adobeApiEvent = this.outputObject.createElement("adobeApiEvent");
                adobeApiEvent.setAttribute("id", eventId);
                Element apiName = this.outputObject.createElement("apiName");
                apiName.setTextContent(name);
                adobeApiEvent.appendChild(apiName);
                Element shortdesc = this.outputObject.createElement("shortdesc");
                adobeApiEvent.appendChild(shortdesc);
                adobeApiEvent.appendChild(this.outputObject.createElement("prolog"));
                Element adobeApiEventDetail = this.outputObject.createElement("adobeApiEventDetail");
                adobeApiEvent.appendChild(adobeApiEventDetail);
                Element adobeApiEventDef = this.outputObject.createElement("adobeApiEventDef");
                adobeApiEventDetail.appendChild(adobeApiEventDef);
                if (eventType != null) {
                    Element apiEventType = this.outputObject.createElement("apiEventType");
                    apiEventType.setTextContent(eventType);
                    adobeApiEventDef.appendChild(apiEventType);
                }
                if (eventObjectType != null) {
                    Element adobeApiEventClassifier = this.outputObject.createElement("adobeApiEventClassifier");
                    adobeApiEventClassifier.setTextContent(eventObjectType);
                    adobeApiEventDef.appendChild(adobeApiEventClassifier);
                }
                Element apiGeneratedEvent = this.outputObject.createElement("apiGeneratedEvent");
                adobeApiEventDef.appendChild(apiGeneratedEvent);
                Element apiDesc = this.outputObject.createElement("apiDesc");
                cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(fullDesc, "description", fullName2));
                apiDesc.appendChild(cdata);
                adobeApiEventDetail.appendChild(apiDesc);
                this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                shortdesc.setTextContent(this.asDocUtil.descToShortDesc(fullDesc));
                eventElement.setAttribute("fullname", fullName2);
                this.processVersions(eventElement, adobeApiEvent);
                this.processCustoms(eventElement, adobeApiEvent, false, "", "", "");
                Element deprecatedNode = null;
                if (!eventElement.getAttribute("deprecatedMessage").equals("")) {
                    deprecatedNode = this.outputObject.createElement("apiDeprecated");
                    Element apiDesc2 = this.outputObject.createElement("apiDesc");
                    CDATASection cdata22 = this.outputObject.createCDATASection(eventElement.getAttribute("deprecatedMessage"));
                    apiDesc2.appendChild(cdata22);
                    deprecatedNode.appendChild(apiDesc2);
                    this.asDocUtil.convertDescToDITA(apiDesc2, this.oldNewNamesMap);
                } else if (!eventElement.getAttribute("deprecatedReplacement").equals("")) {
                    deprecatedNode = this.outputObject.createElement("apiDeprecated");
                    deprecatedNode.setAttribute("replacement", eventElement.getAttribute("deprecatedReplacement"));
                }
                if (deprecatedNode != null) {
                    if (!eventElement.getAttribute("deprecatedSince").equals("")) {
                        deprecatedNode.setAttribute("sinceVersion", eventElement.getAttribute("deprecatedSince"));
                    }
                    adobeApiEventDef.appendChild(deprecatedNode);
                }
                if ((childrenOfEvent = eventElement.getElementsByTagName("example")) != null) {
                    for (int ix = 0; ix < childrenOfEvent.getLength(); ++ix) {
                        Element inputExampleElement = (Element)childrenOfEvent.item(ix);
                        Element example = this.outputObject.createElement("example");
                        CDATASection cdata23 = this.outputObject.createCDATASection(this.asDocUtil.validateText(inputExampleElement.getTextContent(), "example", fullName2));
                        example.appendChild(cdata23);
                        adobeApiEvent.appendChild(example);
                        this.asDocUtil.convertDescToDITA(example, this.oldNewNamesMap);
                    }
                }
                if (myClass3 != null && eventElement != null) {
                    myClass3.getNode().appendChild(adobeApiEvent);
                    if (this.verbose) {
                        System.out.println("event handling for metadata added event " + name + " to class " + fullName2);
                    }
                } else if (this.verbose) {
                    System.out.println("*** Internal error: can't find class for event: " + fullName2);
                }
            }
            if ((bindableElement = this.asDocUtil.getElementByTagName((Element)parent, "Bindable")) != null) {
                NodeList childrenOfBindable = bindableElement.getElementsByTagName("private");
                if (childrenOfBindable != null && childrenOfBindable.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                fullName2 = bindableElement.getAttribute("owner");
                if (this.verbose) {
                    System.out.println(" processing bindable " + fullName2);
                }
                String bindableEventName = bindableElement.getAttribute("name");
                myClass2 = this.classTable.get(fullName2);
                if (myClass2 == null) {
                    QualifiedNameInfo qualifiedFullName = this.decomposeFullMethodOrFieldName(fullName2);
                    myClass2 = this.classTable.get(qualifiedFullName.getFullClassName());
                    boolean found = false;
                    if (myClass2 != null && myClass2.getFields() != null) {
                        NodeList apiValueList = myClass2.getFields().getChildNodes();
                        for (int ix = 0; ix < apiValueList.getLength(); ++ix) {
                            Element apiValueElement = (Element)apiValueList.item(ix);
                            if (!apiValueElement.getAttribute("id").equals(this.asDocUtil.formatId(fullName2))) continue;
                            Element apiValueDetail = null;
                            Element apiValueDef = null;
                            Element apiProperty = null;
                            NodeList apiValueDetailList = apiValueElement.getElementsByTagName("apiValueDetail");
                            if (apiValueDetailList != null && apiValueDetailList.getLength() != 0) {
                                apiValueDetail = (Element)apiValueDetailList.item(0);
                                NodeList apiValueDefList = apiValueDetail.getElementsByTagName("apiValueDef");
                                if (apiValueDefList != null && apiValueDefList.getLength() != 0) {
                                    apiValueDef = (Element)apiValueDefList.item(0);
                                    NodeList apiPropertyList = apiValueDef.getElementsByTagName("apiProperty");
                                    if (apiPropertyList != null && apiPropertyList.getLength() != 0) {
                                        apiProperty = (Element)apiPropertyList.item(0);
                                        if (!apiProperty.getAttribute("isBindable").equals("") && apiProperty.getAttribute("isBindable").equals("true")) continue;
                                        apiProperty.setAttribute("isBindable", "true");
                                        if (!bindableEventName.equals("")) {
                                            apiProperty.setAttribute("name", bindableEventName);
                                        }
                                        found = true;
                                        break;
                                    }
                                    apiProperty = this.outputObject.createElement("apiProperty");
                                    apiProperty.setAttribute("isBindable", "true");
                                    if (!bindableEventName.equals("")) {
                                        apiProperty.setAttribute("name", bindableEventName);
                                    }
                                    apiValueDef.appendChild(apiProperty);
                                    found = true;
                                    break;
                                }
                                apiProperty = this.outputObject.createElement("apiProperty");
                                apiProperty.setAttribute("isBindable", "true");
                                if (!bindableEventName.equals("")) {
                                    apiProperty.setAttribute("name", bindableEventName);
                                }
                                apiValueDef = this.outputObject.createElement("apiValueDef");
                                apiValueDef.appendChild(apiProperty);
                                apiValueDetail.appendChild(apiValueDef);
                                found = true;
                                break;
                            }
                            apiProperty = this.outputObject.createElement("apiProperty");
                            apiProperty.setAttribute("isBindable", "true");
                            if (!bindableEventName.equals("")) {
                                apiProperty.setAttribute("name", bindableEventName);
                            }
                            apiValueDef = this.outputObject.createElement("apiValueDef");
                            apiValueDetail = this.outputObject.createElement("apiValueDetail");
                            apiValueDetail.appendChild(apiValueDef);
                            apiValueDef.appendChild(apiProperty);
                            apiValueElement.appendChild(apiValueDetail);
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        this.bindableTable.put(fullName2, "isBindable");
                    }
                } else {
                    this.bindableTable.put(fullName2, "isBindable");
                }
            }
            if ((defaultPropertyElement = this.asDocUtil.getElementByTagName((Element)parent, "DefaultProperty")) != null && (myClass3 = this.classTable.get(fullName2 = defaultPropertyElement.getAttribute("owner"))) != null) {
                node = myClass3.getNode();
                asMetadata2 = null;
                Element defaultProperty = this.outputObject.createElement("DefaultProperty");
                defaultProperty.setAttribute("name", defaultPropertyElement.getAttribute("name"));
                Element prolog3 = this.asDocUtil.getElementByTagName(node, "prolog");
                if (prolog3 != null) {
                    asMetadata2 = this.asDocUtil.getElementByTagName(prolog3, "asMetadata");
                    if (asMetadata2 != null) {
                        asMetadata2.appendChild(defaultProperty);
                    } else {
                        asMetadata2 = this.outputObject.createElement("asMetadata");
                        asMetadata2.appendChild(defaultProperty);
                        prolog3.appendChild(asMetadata2);
                    }
                } else {
                    asMetadata2 = this.outputObject.createElement("asMetadata");
                    asMetadata2.appendChild(defaultProperty);
                    prolog3 = this.outputObject.createElement("prolog");
                    prolog3.appendChild(asMetadata2);
                    myClass3.getNode().appendChild(prolog3);
                }
            }
            if ((deprecatedElement = this.asDocUtil.getElementByTagName((Element)parent, "Deprecated")) != null) {
                String fullName4 = deprecatedElement.getAttribute("owner");
                if (this.verbose) {
                    System.out.println(" processing deprecated " + fullName4);
                }
                myClass2 = this.classTable.get(fullName4);
                Element node3 = null;
                if (myClass2 != null) {
                    node3 = myClass2.getNode();
                } else {
                    QualifiedNameInfo qualifiedFullName = this.decomposeFullMethodOrFieldName(fullName4);
                    myClass2 = this.classTable.get(qualifiedFullName.getFullClassName());
                    if (myClass2 != null) {
                        Element childElement;
                        NodeList childNodeList;
                        if (myClass2.getFields() != null) {
                            childNodeList = myClass2.getFields().getElementsByTagName("apiValue");
                            for (int ix = 0; ix < childNodeList.getLength(); ++ix) {
                                childElement = (Element)childNodeList.item(ix);
                                if (!childElement.getAttribute("id").equals(this.asDocUtil.formatId(fullName4))) continue;
                                node3 = childElement;
                                break;
                            }
                        }
                        if (node3 == null && myClass2.getMethods() != null) {
                            childNodeList = myClass2.getMethods().getElementsByTagName("apiOperation");
                            for (int ix = 0; ix < childNodeList.getLength(); ++ix) {
                                childElement = (Element)childNodeList.item(ix);
                                if (!childElement.getAttribute("id").equals(this.asDocUtil.formatId(fullName4))) continue;
                                node3 = childElement;
                                break;
                            }
                        }
                    } else if (this.verbose) {
                        System.out.println("   did not find my class for : " + qualifiedFullName.getFullClassName());
                    }
                }
                if (node3 == null) {
                    return;
                }
                Element defNode = this.asDocUtil.getDefNode(node3);
                Element apiDeprecated = this.outputObject.createElement("apiDeprecated");
                if (!deprecatedElement.getAttribute("replacement").equals("")) {
                    apiDeprecated.setAttribute("replacement", deprecatedElement.getAttribute("replacement"));
                } else if (!deprecatedElement.getAttribute("message").equals("")) {
                    Element apiDesc = this.outputObject.createElement("apiDesc");
                    cdata2 = this.outputObject.createCDATASection(deprecatedElement.getAttribute("message"));
                    apiDesc.appendChild(cdata2);
                    apiDeprecated.appendChild(apiDesc);
                    this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                } else if (!deprecatedElement.getAttribute("name").equals("")) {
                    Element apiDesc = this.outputObject.createElement("apiDesc");
                    cdata2 = this.outputObject.createCDATASection(deprecatedElement.getAttribute("name"));
                    apiDesc.appendChild(cdata2);
                    apiDeprecated.appendChild(apiDesc);
                    this.asDocUtil.convertDescToDITA(apiDesc, this.oldNewNamesMap);
                }
                if (!deprecatedElement.getAttribute("since").equals("")) {
                    apiDeprecated.setAttribute("sinceVersion", deprecatedElement.getAttribute("since"));
                }
                defNode.appendChild(apiDeprecated);
            }
            if ((skinStateElement = this.asDocUtil.getElementByTagName((Element)parent, "SkinState")) != null) {
                NodeList childrenOfSkinState = skinStateElement.getElementsByTagName("private");
                if (childrenOfSkinState != null && childrenOfSkinState.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                String fullName5 = skinStateElement.getAttribute("owner");
                String name3 = skinStateElement.getAttribute("name");
                myClass = this.classTable.get(fullName5);
                if (myClass != null) {
                    NodeList descriptionList;
                    Element node4 = myClass.getNode();
                    Element skinStatesElement = null;
                    Element asMetadata5 = null;
                    Element prolog4 = this.asDocUtil.getElementByTagName(node4, "prolog");
                    if (prolog4 != null) {
                        asMetadata5 = this.asDocUtil.getElementByTagName(prolog4, "asMetadata");
                        if (asMetadata5 != null) {
                            HashMap<String, String> attributes3 = new HashMap<String, String>();
                            attributes3.put("kind", "SkinState");
                            attributes3.put("name", name3);
                            Element excludeElement3 = this.asDocUtil.getElementByTagNameAndMatchingAttributes(asMetadata5, "Exclude", attributes3.entrySet());
                            if (excludeElement3 != null) {
                                if (this.verbose) {
                                    System.out.println("Excluding SkinState " + name3 + " from " + myClass.getName());
                                }
                                return;
                            }
                            skinStatesElement = this.asDocUtil.getElementByTagName(asMetadata5, "skinStates");
                            if (skinStatesElement == null) {
                                skinStatesElement = this.outputObject.createElement("skinStates");
                                asMetadata5.appendChild(skinStatesElement);
                            }
                        } else {
                            skinStatesElement = this.outputObject.createElement("skinStates");
                            asMetadata5 = this.outputObject.createElement("asMetadata");
                            asMetadata5.appendChild(skinStatesElement);
                            prolog4.appendChild(asMetadata5);
                        }
                    } else {
                        skinStatesElement = this.outputObject.createElement("skinStates");
                        asMetadata5 = this.outputObject.createElement("asMetadata");
                        asMetadata5.appendChild(skinStatesElement);
                        prolog4 = this.outputObject.createElement("prolog");
                        prolog4.appendChild(asMetadata5);
                        myClass.getNode().appendChild(prolog4);
                    }
                    Element newSkinStateElement = (Element)this.outputObject.importNode(skinStateElement, true);
                    this.asDocUtil.processCustoms(newSkinStateElement, this.outputObject);
                    childrenOfSkinState = newSkinStateElement.getElementsByTagName("default");
                    if (childrenOfSkinState != null && childrenOfSkinState.getLength() != 0) {
                        Element defaultElement = (Element)childrenOfSkinState.item(0);
                        String defaultText = defaultElement.getTextContent();
                        Element newDefaultElement = this.outputObject.createElement("default");
                        newDefaultElement.setTextContent(defaultText);
                        newSkinStateElement.replaceChild(newDefaultElement, defaultElement);
                    }
                    if ((descriptionList = newSkinStateElement.getElementsByTagName("description")) != null && descriptionList.getLength() != 0) {
                        Element descriptionElement = (Element)descriptionList.item(0);
                        String descriptionText = descriptionElement.getTextContent();
                        Element newDescriptionElement = this.outputObject.createElement("description");
                        cdata = this.outputObject.createCDATASection(this.asDocUtil.validateText(descriptionText, "description", fullName5));
                        newDescriptionElement.appendChild(cdata);
                        newSkinStateElement.replaceChild(newDescriptionElement, descriptionElement);
                        this.asDocUtil.convertDescToDITA(newDescriptionElement, this.oldNewNamesMap);
                    }
                    if ((childrenOfSkinState = newSkinStateElement.getElementsByTagName("see")) != null && childrenOfSkinState.getLength() != 0) {
                        int ix;
                        relatedLinks = this.outputObject.createElement("related-links");
                        for (ix = 0; ix < childrenOfSkinState.getLength(); ++ix) {
                            Element seeElement = (Element)childrenOfSkinState.item(ix);
                            relatedLinks.appendChild(this.processSeeTag(fullName5, seeElement.getTextContent()));
                        }
                        newSkinStateElement.appendChild(relatedLinks);
                        for (ix = 0; ix < childrenOfSkinState.getLength(); ++ix) {
                            newSkinStateElement.removeChild(childrenOfSkinState.item(ix));
                        }
                    }
                    if ((childrenOfSkinState = newSkinStateElement.getElementsByTagName("copy")) != null && childrenOfSkinState.getLength() != 0) {
                        text = childrenOfSkinState.item(0).getTextContent();
                        text = text.replaceAll("\\s+", "");
                        descriptionList = newSkinStateElement.getElementsByTagName("description");
                        Element descriptionElement = null;
                        if (descriptionList != null && descriptionList.getLength() != 0) {
                            descriptionElement = (Element)descriptionList.item(0);
                        } else {
                            descriptionElement = this.outputObject.createElement("description");
                            newSkinStateElement.appendChild(descriptionElement);
                        }
                        descriptionElement.setAttribute("conref", text);
                        newSkinStateElement.removeChild(childrenOfSkinState.item(0));
                    }
                    if ((childrenOfSkinState = newSkinStateElement.getElementsByTagName("playerversion")) != null && childrenOfSkinState.getLength() != 0) {
                        String playerversion = childrenOfSkinState.item(0).getTextContent();
                        playerversion = playerversion.replaceAll("\\s+", "");
                        newSkinStateElement.setAttribute("playerVersion", playerversion);
                        newSkinStateElement.removeChild(childrenOfSkinState.item(0));
                    }
                    skinStatesElement.appendChild(newSkinStateElement);
                }
            }
            if ((skinPartElement = this.asDocUtil.getElementByTagName((Element)parent, "SkinPart")) != null) {
                NodeList childrenOfSkinPart = skinPartElement.getElementsByTagName("private");
                if (childrenOfSkinPart != null && childrenOfSkinPart.getLength() != 0 && !this.includePrivate) {
                    return;
                }
                String fullName6 = skinPartElement.getAttribute("owner");
                String name4 = skinPartElement.getAttribute("name");
                AsClass myClass5 = this.classTable.get(fullName6);
                if (myClass5 != null) {
                    NodeList descriptionList;
                    Element node5 = myClass5.getNode();
                    Element skinPartsElement = null;
                    Element asMetadata6 = null;
                    Element prolog5 = this.asDocUtil.getElementByTagName(node5, "prolog");
                    if (prolog5 != null) {
                        asMetadata6 = this.asDocUtil.getElementByTagName(prolog5, "asMetadata");
                        if (asMetadata6 != null) {
                            HashMap<String, String> attributes4 = new HashMap<String, String>();
                            attributes4.put("kind", "SkinPart");
                            attributes4.put("name", name4);
                            Element excludeElement4 = this.asDocUtil.getElementByTagNameAndMatchingAttributes(asMetadata6, "Exclude", attributes4.entrySet());
                            if (excludeElement4 != null) {
                                if (this.verbose) {
                                    System.out.println("Excluding SkinPart " + name4 + " from " + myClass5.getName());
                                }
                                return;
                            }
                            skinPartsElement = this.asDocUtil.getElementByTagName(asMetadata6, "skinParts");
                            if (skinPartsElement == null) {
                                skinPartsElement = this.outputObject.createElement("skinParts");
                                asMetadata6.appendChild(skinPartsElement);
                            }
                        } else {
                            skinPartsElement = this.outputObject.createElement("skinParts");
                            asMetadata6 = this.outputObject.createElement("asMetadata");
                            asMetadata6.appendChild(skinPartsElement);
                            prolog5.appendChild(asMetadata6);
                        }
                    } else {
                        skinPartsElement = this.outputObject.createElement("skinParts");
                        asMetadata6 = this.outputObject.createElement("asMetadata");
                        asMetadata6.appendChild(skinPartsElement);
                        prolog5 = this.outputObject.createElement("prolog");
                        prolog5.appendChild(asMetadata6);
                        myClass5.getNode().appendChild(prolog5);
                    }
                    Element newSkinPartElement = (Element)this.outputObject.importNode(skinPartElement, true);
                    this.asDocUtil.processCustoms(newSkinPartElement, this.outputObject);
                    childrenOfSkinPart = newSkinPartElement.getElementsByTagName("default");
                    if (childrenOfSkinPart != null && childrenOfSkinPart.getLength() != 0) {
                        Element defaultElement = (Element)childrenOfSkinPart.item(0);
                        String defaultText = defaultElement.getTextContent();
                        Element newDefaultElement = this.outputObject.createElement("default");
                        newDefaultElement.setTextContent(defaultText);
                        newSkinPartElement.replaceChild(newDefaultElement, defaultElement);
                    }
                    if ((descriptionList = newSkinPartElement.getElementsByTagName("description")) != null && descriptionList.getLength() != 0) {
                        Element descriptionElement = (Element)descriptionList.item(0);
                        String descriptionText = descriptionElement.getTextContent();
                        Element shortdesc = this.outputObject.createElement("shortdesc");
                        newSkinPartElement.appendChild(shortdesc);
                        shortdesc.setTextContent(this.asDocUtil.descToShortDesc(descriptionText));
                        Element newDescriptionElement = this.outputObject.createElement("description");
                        CDATASection cdata4 = this.outputObject.createCDATASection(this.asDocUtil.validateText(descriptionText, "description", fullName6));
                        newDescriptionElement.appendChild(cdata4);
                        newSkinPartElement.replaceChild(newDescriptionElement, descriptionElement);
                        this.asDocUtil.convertDescToDITA(newDescriptionElement, this.oldNewNamesMap);
                    }
                    if ((childrenOfSkinPart = newSkinPartElement.getElementsByTagName("see")) != null && childrenOfSkinPart.getLength() != 0) {
                        int ix;
                        Element relatedLinks3 = this.outputObject.createElement("related-links");
                        for (ix = 0; ix < childrenOfSkinPart.getLength(); ++ix) {
                            Element seeElement = (Element)childrenOfSkinPart.item(ix);
                            relatedLinks3.appendChild(this.processSeeTag(fullName6, seeElement.getTextContent()));
                        }
                        newSkinPartElement.appendChild(relatedLinks3);
                        for (ix = 0; ix < childrenOfSkinPart.getLength(); ++ix) {
                            newSkinPartElement.removeChild(childrenOfSkinPart.item(ix));
                        }
                    }
                    if ((childrenOfSkinPart = newSkinPartElement.getElementsByTagName("copy")) != null && childrenOfSkinPart.getLength() != 0) {
                        String text4 = childrenOfSkinPart.item(0).getTextContent();
                        text4 = text4.replaceAll("\\s+", "");
                        descriptionList = newSkinPartElement.getElementsByTagName("description");
                        Element descriptionElement = null;
                        if (descriptionList != null && descriptionList.getLength() != 0) {
                            descriptionElement = (Element)descriptionList.item(0);
                        } else {
                            descriptionElement = this.outputObject.createElement("description");
                            newSkinPartElement.appendChild(descriptionElement);
                        }
                        descriptionElement.setAttribute("conref", text4);
                        newSkinPartElement.removeChild(childrenOfSkinPart.item(0));
                    }
                    if ((childrenOfSkinPart = newSkinPartElement.getElementsByTagName("playerversion")) != null && childrenOfSkinPart.getLength() != 0) {
                        String playerversion = childrenOfSkinPart.item(0).getTextContent();
                        playerversion = playerversion.replaceAll("\\s+", "");
                        newSkinPartElement.setAttribute("playerVersion", playerversion);
                        newSkinPartElement.removeChild(childrenOfSkinPart.item(0));
                    }
                    skinPartsElement.appendChild(newSkinPartElement);
                }
            }
            if ((alternativeElement = this.asDocUtil.getElementByTagName((Element)parent, "Alternative")) != null && (myClass = this.classTable.get(fullName = alternativeElement.getAttribute("owner"))) != null) {
                NodeList childrenOfAlternative;
                Element node6 = myClass.getNode();
                Element asMetadata7 = null;
                Element prolog6 = this.asDocUtil.getElementByTagName(node6, "prolog");
                if (prolog6 != null) {
                    asMetadata7 = this.asDocUtil.getElementByTagName(prolog6, "asMetadata");
                    if (asMetadata7 == null) {
                        asMetadata7 = this.outputObject.createElement("asMetadata");
                        prolog6.appendChild(asMetadata7);
                    }
                } else {
                    asMetadata7 = this.outputObject.createElement("asMetadata");
                    prolog6 = this.outputObject.createElement("prolog");
                    prolog6.appendChild(asMetadata7);
                    myClass.getNode().appendChild(prolog6);
                }
                Element alternative = (Element)this.outputObject.importNode(alternativeElement, true);
                this.asDocUtil.processCustoms(alternative, this.outputObject);
                NodeList descriptionList = alternative.getElementsByTagName("description");
                if (descriptionList != null && descriptionList.getLength() != 0) {
                    Element descriptionElement = (Element)descriptionList.item(0);
                    String descriptionText = descriptionElement.getTextContent();
                    Element newDescriptionElement = this.outputObject.createElement("description");
                    CDATASection cdata5 = this.outputObject.createCDATASection(this.asDocUtil.validateText(descriptionText, "description", fullName));
                    newDescriptionElement.appendChild(cdata5);
                    alternative.replaceChild(newDescriptionElement, descriptionElement);
                    this.asDocUtil.convertDescToDITA(newDescriptionElement, this.oldNewNamesMap);
                }
                if ((childrenOfAlternative = alternative.getElementsByTagName("see")) != null && childrenOfAlternative.getLength() != 0) {
                    int ix;
                    relatedLinks = this.outputObject.createElement("related-links");
                    for (ix = 0; ix < childrenOfAlternative.getLength(); ++ix) {
                        Element seeElement = (Element)childrenOfAlternative.item(ix);
                        relatedLinks.appendChild(this.processSeeTag(fullName, seeElement.getTextContent()));
                    }
                    alternative.appendChild(relatedLinks);
                    for (ix = 0; ix < childrenOfAlternative.getLength(); ++ix) {
                        alternative.removeChild(childrenOfAlternative.item(ix));
                    }
                }
                if ((childrenOfAlternative = alternative.getElementsByTagName("copy")) != null && childrenOfAlternative.getLength() != 0) {
                    text = childrenOfAlternative.item(0).getTextContent();
                    text = text.replaceAll("\\s+", "");
                    descriptionList = alternative.getElementsByTagName("description");
                    Element descriptionElement = null;
                    if (descriptionList != null && descriptionList.getLength() != 0) {
                        descriptionElement = (Element)descriptionList.item(0);
                    } else {
                        descriptionElement = this.outputObject.createElement("description");
                        alternative.appendChild(descriptionElement);
                    }
                    descriptionElement.setAttribute("conref", text);
                    alternative.removeChild(childrenOfAlternative.item(0));
                }
                asMetadata7.appendChild(alternative);
            }
        }
    }

    private void processClassInheritance() {
        Collection<AsClass> classes = this.classTable.values();
        for (AsClass asClass : classes) {
            NodeList apiClassifierDefList;
            if (asClass.getNode() == null || asClass.getName().equals("$$Global$$") || asClass.getName().startsWith("$$") && asClass.getName().endsWith("$$") || asClass.getName().equals("Object") || asClass.isInterfaceFlag() && asClass.getInterfaceStr() == null) continue;
            Element defNode = null;
            Element apiClassifierDetailElement = this.asDocUtil.getElementByTagName(asClass.getNode(), "apiClassifierDetail");
            if (apiClassifierDetailElement != null && (apiClassifierDefList = apiClassifierDetailElement.getElementsByTagName("apiClassifierDef")) != null && apiClassifierDefList.getLength() != 0) {
                defNode = (Element)apiClassifierDefList.item(0);
            }
            if (asClass.getInterfaceStr() != null && !asClass.getInterfaceStr().equals("") && !asClass.getInterfaceStr().equals("Object")) {
                String[] interfaces = asClass.getInterfaceStr().split(";");
                for (int ix = 0; ix < interfaces.length; ++ix) {
                    if (interfaces[ix] == null) continue;
                    Element apiBaseInterface = this.outputObject.createElement("apiBaseInterface");
                    apiBaseInterface.setTextContent(interfaces[ix]);
                    defNode.appendChild(apiBaseInterface);
                    AsClass interfaceClass = this.classTable.get(interfaces[ix]);
                    if (interfaceClass == null) continue;
                    this.asDocUtil.processAncestorClass(interfaceClass, asClass);
                }
            }
            if (asClass.getBaseName() != null) {
                Element apiBaseClassifier = this.outputObject.createElement("apiBaseClassifier");
                apiBaseClassifier.setTextContent(asClass.getBaseName());
                defNode.appendChild(apiBaseClassifier);
            }
            if (!asClass.isInterfaceFlag()) {
                AsClass baseClass = this.classTable.get(asClass.getBaseName());
                while (baseClass != null) {
                    this.asDocUtil.processAncestorClass(baseClass, asClass);
                    if (baseClass.getName().equals("Object")) break;
                    baseClass = this.classTable.get(baseClass.getBaseName());
                }
            }
            this.asDocUtil.processCopyDoc(asClass, this.classTable);
        }
        classes = this.classTable.values();
        for (AsClass asClass : classes) {
            if (asClass.getNode() == null || !asClass.isPendingCopyDoc() || asClass.getName().equals("$$Global$$") || asClass.getName().startsWith("$$") && asClass.getName().endsWith("$$") || asClass.getName().equals("Object") || asClass.isInterfaceFlag() && asClass.getInterfaceStr() == null) continue;
            this.asDocUtil.processCopyDoc(asClass, this.classTable);
        }
    }

    private void assembleClassXML() {
        Collection<AsClass> classes = this.classTable.values();
        for (AsClass asClass : classes) {
            NodeList apiValueList;
            NodeList apiOperationList;
            Element apiConstructor;
            int ix;
            NodeList apiConstructorList;
            if (this.verbose) {
                System.out.println("assembling " + asClass.getFullName());
            }
            if (asClass.getNode() == null) continue;
            if (asClass.getConstructorCount() > 1 && (apiConstructorList = asClass.getConstructors().getElementsByTagName("apiConstructor")) != null && apiConstructorList.getLength() != 0) {
                for (ix = 0; ix < apiConstructorList.getLength(); ++ix) {
                    apiConstructor = (Element)apiConstructorList.item(ix);
                    apiConstructor.setAttribute("id", apiConstructor.getAttribute("id") + "_" + ix);
                }
            }
            if (asClass.getConstructorCount() > 0 && (apiConstructorList = asClass.getConstructors().getElementsByTagName("apiConstructor")) != null && apiConstructorList.getLength() != 0) {
                for (ix = 0; ix < apiConstructorList.getLength(); ++ix) {
                    apiConstructor = (Element)apiConstructorList.item(ix);
                    asClass.getNode().appendChild(apiConstructor.cloneNode(true));
                }
            }
            if (asClass.getMethodCount() > 0 && (apiOperationList = asClass.getMethods().getElementsByTagName("apiOperation")) != null && apiOperationList.getLength() != 0) {
                for (ix = 0; ix < apiOperationList.getLength(); ++ix) {
                    Element apiOperation = (Element)apiOperationList.item(ix);
                    asClass.getNode().appendChild(apiOperation.cloneNode(true));
                }
            }
            if (asClass.getFieldCount() <= 0 || (apiValueList = asClass.getFields().getElementsByTagName("apiValue")) == null || apiValueList.getLength() == 0) continue;
            for (ix = 0; ix < apiValueList.getLength(); ++ix) {
                Element apiValue = (Element)apiValueList.item(ix);
                Element apiName = this.asDocUtil.getElementByTagName(apiValue, "apiName");
                Integer val = asClass.getFieldGetSet().get(apiName.getTextContent());
                if (val == null) {
                    asClass.getNode().appendChild(apiValue.cloneNode(true));
                    continue;
                }
                Element apiValueDetail = null;
                Element apiValueDef = null;
                Element apiValueAccess = null;
                apiValueDetail = this.asDocUtil.getElementByTagName(apiValue, "apiValueDetail");
                if (apiValueDetail != null) {
                    apiValueDef = this.asDocUtil.getElementByTagName(apiValueDetail, "apiValueDef");
                    if (apiValueDef != null) {
                        apiValueAccess = this.asDocUtil.getElementByTagName(apiValueDef, "apiValueAccess");
                        if (apiValueAccess == null) {
                            apiValueAccess = this.outputObject.createElement("apiValueAccess");
                            apiValueDef.appendChild(apiValueAccess);
                        }
                    } else {
                        apiValueAccess = this.outputObject.createElement("apiValueAccess");
                        apiValueDef = this.outputObject.createElement("apiValueDef");
                        apiValueDef.appendChild(apiValueAccess);
                        apiValueDetail.appendChild(apiValueDef);
                    }
                } else {
                    apiValueAccess = this.outputObject.createElement("apiValueAccess");
                    apiValueDef = this.outputObject.createElement("apiValueDef");
                    apiValueDetail = this.outputObject.createElement("apiValueDetail");
                    apiValueDef.appendChild(apiValueAccess);
                    apiValueDetail.appendChild(apiValueDef);
                    apiValue.appendChild(apiValueDetail);
                }
                if (val == 1) {
                    apiValueAccess.setAttribute("value", "read");
                } else if (val == 2) {
                    apiValueAccess.setAttribute("value", "write");
                } else if (val == 3) {
                    apiValueAccess.setAttribute("value", "readwrite");
                }
                asClass.getNode().appendChild(apiValue.cloneNode(true));
            }
        }
    }

    private void assembleClassPackageHierarchy() {
        Collection<AsClass> classes = this.classTable.values();
        for (AsClass asClass : classes) {
            if (asClass == null) continue;
            int innerClassSize = asClass.getInnerClasses().size();
            for (int ix = 0; ix < innerClassSize; ++ix) {
                AsClass innerClass = asClass.getInnerClasses().get(ix);
                Element apiName = this.outputObject.createElement("apiName");
                apiName.setTextContent(asClass.getName() + "." + innerClass.getName());
                innerClass.getNode().appendChild(apiName);
                Element apiClassifier = this.asDocUtil.getElementByTagName(asClass.getNode(), "apiClassifier");
                if (apiClassifier == null) continue;
                apiClassifier.appendChild(innerClass.getNode());
            }
        }
        HashMap<String, AsClass> packageContents = this.packageContentsTable.get("$$Global$$");
        classes = packageContents.values();
        for (AsClass asClass : classes) {
            asClass.getNode().setAttribute("id", "globalClassifier:" + asClass.getNode().getAttribute("id"));
        }
        Element packages = this.outputObject.createElement("packages");
        Set<String> keySet = this.packageContentsTable.keySet();
        for (String key : keySet) {
            NodeList privateChilds;
            Element packageElement = this.packageTable.get(key);
            if (packageElement == null) {
                String packageName = key.replaceAll("\\$", "_");
                packageElement = this.outputObject.createElement("apiPackage");
                packageElement.setAttribute("id", packageName);
                Element apiName = this.outputObject.createElement("apiName");
                apiName.setTextContent(packageName);
                Element apiDetail = this.outputObject.createElement("apiDetail");
                packageElement.appendChild(apiName);
                packageElement.appendChild(apiDetail);
            }
            if ((privateChilds = packageElement.getElementsByTagName("private")) != null && privateChilds.getLength() != 0 || this.asDocUtil.hidePackage(key, this.hiddenPackages)) continue;
            if (!key.equals("")) {
                packageContents = this.packageContentsTable.get(key);
                classes = packageContents.values();
                for (AsClass asClass : classes) {
                    Element apiAccess;
                    if (this.verbose) {
                        System.out.println("post-processing class " + asClass.getName() + " in package " + key);
                    }
                    if (asClass.getName().charAt(0) == '$' && asClass.getName().charAt(1) == '$') {
                        int ix;
                        NodeList childrenOfNode = asClass.getNode().getElementsByTagName("apiOperation");
                        if (childrenOfNode != null && childrenOfNode.getLength() != 0) {
                            for (ix = 0; ix < childrenOfNode.getLength(); ++ix) {
                                Element apiOperation = (Element)childrenOfNode.item(ix);
                                apiOperation.setAttribute("id", "globalOperation:" + apiOperation.getAttribute("id"));
                                packageElement.appendChild(apiOperation.cloneNode(true));
                            }
                        }
                        if ((childrenOfNode = asClass.getNode().getElementsByTagName("apiValue")) == null || childrenOfNode.getLength() == 0) continue;
                        for (ix = 0; ix < childrenOfNode.getLength(); ++ix) {
                            Element apiValue = (Element)childrenOfNode.item(ix);
                            apiValue.setAttribute("id", "globalValue:" + apiValue.getAttribute("id"));
                            packageElement.appendChild(apiValue.cloneNode(true));
                        }
                        continue;
                    }
                    if (asClass.isInnerClass() || (apiAccess = this.asDocUtil.getElementByTagName(asClass.getNode(), "apiAccess")) == null || apiAccess.getAttribute("value").equals("private") && !this.includePrivate) continue;
                    packageElement.appendChild(asClass.getNode());
                }
            }
            NodeList apiClassifierList = packageElement.getElementsByTagName("apiClassifier");
            NodeList apiValueList = packageElement.getElementsByTagName("apiValue");
            NodeList apiOperationList = packageElement.getElementsByTagName("apiOperation");
            if (apiClassifierList != null && apiClassifierList.getLength() != 0) {
                packages.appendChild(packageElement);
                continue;
            }
            if (apiValueList != null && apiValueList.getLength() != 0) {
                packages.appendChild(packageElement);
                continue;
            }
            if (apiOperationList == null || apiOperationList.getLength() == 0) continue;
            packages.appendChild(packageElement);
        }
        this.root.appendChild(packages);
    }
}

