/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.localization.LocalizationManager;
import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.Transcoder;
import flex2.compiler.abc.AbcCompiler;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.HostComponentExtension;
import flex2.compiler.as3.binding.BindableExtension;
import flex2.compiler.as3.managed.ManagedExtension;
import flex2.compiler.asdoc.ASDocConfigHandler;
import flex2.compiler.asdoc.ASDocExtension;
import flex2.compiler.asdoc.AsDocHelper;
import flex2.compiler.asdoc.OverviewsHandler;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.css.CssCompiler;
import flex2.compiler.fxg.FXGCompiler;
import flex2.compiler.i18n.I18nCompiler;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.MxmlCompiler;
import flex2.compiler.swc.SwcAPI;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.ASDocConfiguration;
import flex2.tools.CompcPreLink;
import flex2.tools.Mxmlc;
import flex2.tools.WebTierAPI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.saxon.Transform;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class AsDocAPI {
    /*
     * Loose catch block
     */
    public static void createASDocConfig(ASDocConfiguration config) throws CompilerException {
        block16: {
            IOException ioe22;
            Reader reader;
            BufferedWriter writer;
            block15: {
                String templatesPath = config.getTemplatesPath();
                String ditaPath = config.getOutput() + "tempdita" + File.separator;
                File ditaDir = new File(ditaPath);
                if (!ditaDir.exists()) {
                    ditaDir.mkdirs();
                }
                writer = null;
                reader = null;
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ditaPath + "ASDoc_Config.xml"), "UTF-8"));
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(templatesPath + "ASDoc_Config_Base.xml"), "UTF-8"));
                ASDocConfigHandler h = new ASDocConfigHandler(writer, config);
                InputSource source = new InputSource(reader);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(source, (DefaultHandler)h);
                Object var11_12 = null;
                if (writer == null) break block15;
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe22) {}
            }
            break block16;
            {
                catch (Exception e) {
                    if (Trace.error) {
                        e.printStackTrace();
                    }
                    CouldNotCreate c = new CouldNotCreate("ASDoc_Config.xml", e.getMessage());
                    ThreadLocalToolkit.log(c);
                    throw c;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var11_13 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void createOverviews(ASDocConfiguration config) throws CompilerException {
        block15: {
            IOException ioe22;
            Reader reader;
            BufferedWriter writer;
            block14: {
                String templatesPath = config.getTemplatesPath();
                String ditaPath = config.getOutput() + "tempdita" + File.separator;
                writer = null;
                reader = null;
                writer = new BufferedWriter(new FileWriter(ditaPath + "overviews.xml"));
                reader = config.getPackageDescriptionFile() != null ? new BufferedReader(new FileReader(config.getPackageDescriptionFile())) : new BufferedReader(new FileReader(templatesPath + "Overviews_Base.xml"));
                OverviewsHandler h = new OverviewsHandler(writer, config);
                InputSource source = new InputSource(reader);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(source, (DefaultHandler)h);
                Object var10_11 = null;
                if (writer == null) break block14;
                try {
                    writer.close();
                }
                catch (IOException ioe22) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe22) {}
            }
            break block15;
            {
                catch (Exception e) {
                    if (Trace.error) {
                        e.printStackTrace();
                    }
                    CouldNotCreate c = new CouldNotCreate("overviews.xml", e.getMessage());
                    ThreadLocalToolkit.log(c);
                    throw c;
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var10_12 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static void createTopLevelXML(ASDocConfiguration configuration, LocalizationManager l10n) throws ConfigurationException, CompilerException {
        Iterator<Object> iterator;
        StringBuilder sb;
        CompilerAPI.setupHeadless(configuration);
        CompilerAPI.setSkipTimestampCheck(true);
        String[] sourceMimeTypes = WebTierAPI.getSourcePathMimeTypes();
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        if (!compilerConfig.doc()) {
            compilerConfig.cfgDoc(null, true);
        }
        SourcePath sourcePath = new SourcePath(sourceMimeTypes, compilerConfig.allowSourcePathOverlap());
        sourcePath.addPathElements(compilerConfig.getSourcePath());
        List<VirtualFile>[] array = CompilerAPI.getVirtualFileList(configuration.getDocSources(), Collections.<VirtualFile>emptySet(), new HashSet<String>(Arrays.asList(sourceMimeTypes)), sourcePath.getPaths(), configuration.getExcludeSources());
        NameMappings mappings = CompilerAPI.getNameMappings(configuration);
        Transcoder[] transcoders = WebTierAPI.getTranscoders(configuration);
        SubCompiler[] compilers = AsDocAPI.getCompilers(compilerConfig, mappings, transcoders);
        FileSpec fileSpec = new FileSpec(array[0], WebTierAPI.getFileSpecMimeTypes(), false);
        SourceList sourceList = new SourceList(array[1], compilerConfig.getSourcePath(), null, WebTierAPI.getSourceListMimeTypes(), false);
        ResourceContainer resources = new ResourceContainer();
        ResourceBundlePath bundlePath = new ResourceBundlePath(configuration.getCompilerConfiguration(), null);
        HashMap<String, Source> classes = new HashMap<String, Source>();
        List<SwcComponent> nsComponents = SwcAPI.setupNamespaceComponents(configuration.getNamespaces(), mappings, sourcePath, sourceList, classes, configuration.getIncludeLookupOnly(), configuration.isIncludeAllForAsdoc());
        SwcAPI.setupClasses(configuration.getClasses(), sourcePath, sourceList, classes);
        HashSet<String> includeOnly = null;
        if (configuration.excludeDependencies()) {
            includeOnly = new HashSet<String>();
            for (SwcComponent component : nsComponents) {
                includeOnly.add(component.getClassName());
            }
            includeOnly.addAll(configuration.getClasses());
        }
        List excludeClasses = configuration.getExcludeClasses();
        Set<String> packages = configuration.getPackagesConfiguration().getPackageNames();
        ASDocExtension asdoc = new ASDocExtension(excludeClasses, includeOnly, packages, configuration.restoreBuiltinClasses());
        As3Compiler asc = (As3Compiler)compilers[0];
        asc.addCompilerExtension(asdoc);
        asc.addCompilerExtension(new HostComponentExtension(configuration.getCompilerConfiguration().reportMissingRequiredSkinPartsAsWarnings()));
        String gendir = compilerConfig.keepGeneratedActionScript() ? compilerConfig.getGeneratedDirectory() : null;
        asc.addCompilerExtension(new BindableExtension(gendir, compilerConfig.getGenerateAbstractSyntaxTree(), true));
        asc.addCompilerExtension(new ManagedExtension(gendir, compilerConfig.getGenerateAbstractSyntaxTree(), true));
        ((MxmlCompiler)compilers[1]).addImplementationCompilerExtension(asdoc);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.InitialSetup()));
        }
        CompilerSwcContext swcContext = new CompilerSwcContext();
        SwcCache cache = new SwcCache();
        cache.setLazyRead(true);
        swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, null, mappings, I18nUtils.getTranslationFormat(compilerConfig), cache);
        configuration.addExterns(swcContext.getExterns());
        CompilerAPI.validateCompilationUnits(fileSpec, sourceList, sourcePath, bundlePath, resources, swcContext, null, false, configuration);
        Map<String, String> licenseMap = configuration.getLicensesConfiguration().getLicenseMap();
        CompilerAPI.compile(fileSpec, sourceList, classes.values(), sourcePath, resources, bundlePath, swcContext, mappings, configuration, compilers, new CompcPreLink(null, null), licenseMap, new ArrayList<Source>());
        asdoc.finish(configuration.restoreBuiltinClasses());
        asdoc.saveFile(new File(configuration.getOutput(), "toplevel.xml"));
        if (excludeClasses.size() != 0) {
            sb = new StringBuilder();
            iterator = excludeClasses.iterator();
            while (iterator.hasNext()) {
                sb.append(' ');
                sb.append(iterator.next());
            }
            ThreadLocalToolkit.log(new NotFound("exclude-classes", sb.toString()));
        }
        if (packages.size() != 0) {
            sb = new StringBuilder();
            iterator = packages.iterator();
            while (iterator.hasNext()) {
                sb.append(' ');
                sb.append(iterator.next());
            }
            ThreadLocalToolkit.log(new NotFound("packages", sb.toString()));
        }
    }

    public static SubCompiler[] getCompilers(CompilerConfiguration compilerConfig, NameMappings mappings, Transcoder[] transcoders) {
        As3Compiler asc = new As3Compiler(compilerConfig);
        MxmlCompiler mxmlc = new MxmlCompiler(compilerConfig, compilerConfig, mappings, transcoders, true);
        AbcCompiler abc = new AbcCompiler(compilerConfig);
        FXGCompiler fxg = new FXGCompiler(compilerConfig, mappings);
        I18nCompiler prop = new I18nCompiler(compilerConfig, transcoders);
        CssCompiler css = new CssCompiler(compilerConfig, transcoders, mappings);
        return new SubCompiler[]{asc, mxmlc, abc, fxg, prop, css};
    }

    public static void createTopLevelClassesXML(String outputDir, String templatesPath, boolean lenient) throws CompilerException {
        try {
            AsDocHelper asDocHelp = new AsDocHelper(outputDir + "toplevel.xml", outputDir + "tempdita", outputDir, outputDir + "tempdita" + File.separator + "ASDoc_Config.xml");
            asDocHelp.createTopLevelClasses(lenient);
        }
        catch (Throwable t) {
            if (Trace.error) {
                t.printStackTrace();
            }
            CouldNotCreate c = new CouldNotCreate("toplevel.xml", t.getMessage());
            ThreadLocalToolkit.log(c);
            throw c;
        }
    }

    /*
     * Loose catch block
     */
    public static void createHTML(String outputDir, String templatesDir, ASDocConfiguration config) throws Exception {
        block24: {
            templatesDir = templatesDir.replace('\\', '/');
            String outputDitaDir = outputDir + "tempdita/";
            File indexTmp = new File(outputDir + "index.tmp");
            String inputFile = indexTmp.toString();
            while (inputFile.indexOf(92) != -1) {
                inputFile = inputFile.replace('\\', '/');
            }
            try {
                AsDocAPI.copyFile(templatesDir + "all-classes.xslt", outputDitaDir + "all-classes.xslt");
                AsDocAPI.copyFile(templatesDir + "all-index.xslt", outputDitaDir + "all-index.xslt");
                AsDocAPI.copyFile(templatesDir + "asdoc-util.xslt", outputDitaDir + "asdoc-util.xslt");
                AsDocAPI.copyFile(templatesDir + "ASDoc_terms.xml", outputDitaDir + "ASDoc_terms.xml");
                AsDocAPI.copyFile(templatesDir + "class-files.xslt", outputDitaDir + "class-files.xslt");
                AsDocAPI.copyFile(templatesDir + "class-list.xslt", outputDitaDir + "class-list.xslt");
                AsDocAPI.copyFile(templatesDir + "class-parts.xslt", outputDitaDir + "class-parts.xslt");
                AsDocAPI.copyFile(templatesDir + "class-summary.xslt", outputDitaDir + "class-summary.xslt");
                AsDocAPI.copyFile(templatesDir + "Classes.xslt", outputDitaDir + "Classes.xslt");
                AsDocAPI.copyFile(templatesDir + "ClassHeader.xslt", outputDitaDir + "ClassHeader.xslt");
                AsDocAPI.copyFile(templatesDir + "eventsGeneratedSummary.xslt", outputDitaDir + "eventsGeneratedSummary.xslt");
                AsDocAPI.copyFile(templatesDir + "effectsSummary.xslt", outputDitaDir + "effectsSummary.xslt");
                AsDocAPI.copyFile(templatesDir + "fieldSummary.xslt", outputDitaDir + "fieldSummary.xslt");
                AsDocAPI.copyFile(templatesDir + "merge_dita_xml.xslt", outputDitaDir + "merge_dita_xml.xslt");
                AsDocAPI.copyFile(templatesDir + "methodSummary.xslt", outputDitaDir + "methodSummary.xslt");
                AsDocAPI.copyFile(templatesDir + "processHTML.xslt", outputDitaDir + "processHTML.xslt");
                AsDocAPI.copyFile(templatesDir + "PostProcessing.xslt", outputDitaDir + "PostProcessing.xslt");
                AsDocAPI.copyFile(templatesDir + "package-list.xslt", outputDitaDir + "package-list.xslt");
                AsDocAPI.copyFile(templatesDir + "package-detail.xslt", outputDitaDir + "package-detail.xslt");
                AsDocAPI.copyFile(templatesDir + "package-summary.xslt", outputDitaDir + "package-summary.xslt");
                AsDocAPI.copyFile(templatesDir + "package.xslt", outputDitaDir + "package.xslt");
                AsDocAPI.copyFile(templatesDir + "stylesSummary.xslt", outputDitaDir + "stylesSummary.xslt");
                AsDocAPI.copyFile(templatesDir + "index.html", outputDitaDir + "index.html");
                AsDocAPI.copyFile(templatesDir + "package-frame.html", outputDitaDir + "package-frame.html");
                AsDocAPI.copyFile(templatesDir + "title-bar.html", outputDitaDir + "title-bar.html");
                String warnings = "silent";
                String[] args = new String[]{"-s", outputDitaDir + "index.html", "-o", inputFile, "-xsl", outputDitaDir + "processHTML.xslt", "index-file=index.html", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "package-frame.html", "-o", outputDir + "package-frame.html", "-xsl", outputDitaDir + "processHTML.xslt", "package-frame=package-frame.html", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", templatesDir + "index-list.html", "-o", outputDir + "index-list.html", "-xsl", outputDitaDir + "processHTML.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "title-bar.html", "-o", outputDir + "title-bar.html", "-xsl", outputDitaDir + "processHTML.xslt", "titleBarFile=title-bar.html", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-o", outputDitaDir + "packagemap.xml", "-xsl", outputDitaDir + "merge_dita_xml.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-o", outputDitaDir + "Classes.xml", "-xsl", outputDitaDir + "Classes.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "Classes.xml", "-o", outputDitaDir + "ClassHeader.xml", "-xsl", outputDitaDir + "ClassHeader.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-o", outputDitaDir + "pp_fieldSummary.xml", "-warnings:" + warnings, "-xsl", outputDitaDir + "fieldSummary.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "pp_fieldSummary.xml", "-warnings:" + warnings, "-o", outputDitaDir + "fieldSummary.xml", "-xsl", outputDitaDir + "PostProcessing.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDitaDir + "pp_methodSummary.xml", "-xsl", outputDitaDir + "methodSummary.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "pp_methodSummary.xml", "-warnings:" + warnings, "-o", outputDitaDir + "methodSummary.xml", "-xsl", outputDitaDir + "PostProcessing.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDitaDir + "eventsGeneratedSummary.xml", "-xsl", outputDitaDir + "eventsGeneratedSummary.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDitaDir + "stylesSummary.xml", "-xsl", outputDitaDir + "stylesSummary.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDitaDir + "effectsSummary.xml", "-xsl", outputDitaDir + "effectsSummary.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "dummy.html", "-xsl", outputDitaDir + "class-files.xslt", "showIncludeExamples=true", "prog_language_name=ActionScript", "process_xref_href_attribute=1"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packagemap.xml", "-warnings:" + warnings, "-o", outputDir + "all-classes.html", "-xsl", outputDitaDir + "all-classes.xslt", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "package-list.html", "-xsl", outputDitaDir + "package-list.xslt"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packagemap.xml", "-warnings:" + warnings, "-o", outputDir + "class-summary.html", "-xsl", outputDitaDir + "class-summary.xslt", "localTitle=allClasses", "filter=*"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "dummy.html", "-xsl", outputDitaDir + "package-detail.xslt", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "package-summary.html", "-xsl", outputDitaDir + "package-summary.xslt", "localTitle=allPackages", "filter=*", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "dummy.html", "-xsl", outputDitaDir + "class-list.xslt", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packagemap.xml", "-warnings:" + warnings, "-o", outputDir + "dummy.html", "-xsl", outputDitaDir + "all-index.xslt", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                args = new String[]{"-s", outputDitaDir + "packages.dita", "-warnings:" + warnings, "-o", outputDir + "dummy.html", "-xsl", outputDitaDir + "package.xslt", "prog_language_name=ActionScript"};
                Transform.main((String[])args);
                new File(outputDir + "dummy.html").delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            File indexHtml = new File(outputDir + "index.html");
            if (config.getLeftFramesetWidth() == -1) {
                FileUtils.renameFile((File)indexTmp, (File)indexHtml);
            } else {
                IOException ioe22;
                File indexTmp2;
                BufferedWriter writer;
                BufferedReader reader;
                block22: {
                    String s;
                    reader = null;
                    writer = null;
                    indexTmp2 = new File(outputDir + "index2.tmp");
                    reader = new BufferedReader(new FileReader(indexTmp));
                    writer = new BufferedWriter(new FileWriter(indexTmp2));
                    boolean foundFrameset = false;
                    String search1 = "frameset cols=";
                    String search2 = ",";
                    while ((s = reader.readLine()) != null) {
                        int ind;
                        if (!foundFrameset && (ind = s.indexOf(search1)) != -1) {
                            foundFrameset = true;
                            int ind2 = s.indexOf(search2, ind);
                            if (ind2 != -1) {
                                s = s.substring(0, ind + search1.length() + 1) + config.getLeftFramesetWidth() + s.substring(ind2);
                            }
                        }
                        writer.write(s);
                        writer.newLine();
                    }
                    Object var17_19 = null;
                    if (writer == null) break block22;
                    try {
                        writer.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                FileUtils.renameFile((File)indexTmp2, (File)indexHtml);
                {
                    break block24;
                    catch (Exception ex) {
                        if (Trace.error) {
                            ex.printStackTrace();
                        }
                        CouldNotCreate c = new CouldNotCreate("index.html", ex.getMessage());
                        ThreadLocalToolkit.log(c);
                        throw c;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe22;
                    Object var17_20 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioe22) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe22) {
                            // empty catch block
                        }
                    }
                    FileUtils.renameFile((File)indexTmp2, (File)indexHtml);
                    throw throwable;
                }
            }
        }
    }

    public static void copyFiles(String outputDir, String templatesPath) throws IOException {
        File templateFile = new File(templatesPath);
        File[] temArr = templateFile.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".js") || name.endsWith(".css");
            }
        });
        for (int i = 0; i < temArr.length; ++i) {
            File f = temArr[i];
            AsDocAPI.copyFile(new File(templatesPath, f.getName()), new File(outputDir, f.getName()));
        }
        File outImages = new File(outputDir, "images");
        outImages.mkdir();
        File temImages = new File(templatesPath, "images");
        File[] imageArr = temImages.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return !f.getName().startsWith(".") && !f.isHidden() && f.canRead() && !f.isDirectory();
            }
        });
        for (int i = 0; i < imageArr.length; ++i) {
            File f = imageArr[i];
            AsDocAPI.copyFile(new File(temImages, f.getName()), new File(outImages, f.getName()));
        }
    }

    public static void copyFile(String fromFile, String toFile) throws IOException {
        AsDocAPI.copyFile(new File(fromFile), new File(toFile));
    }

    public static void copyFile(File fromFile, File toFile) throws IOException {
        int i;
        FileInputStream fileInputStream = new FileInputStream(fromFile);
        FileOutputStream fileOutputStream = new FileOutputStream(toFile);
        byte[] bytes = new byte[2048];
        while ((i = fileInputStream.read(bytes)) != -1) {
            fileOutputStream.write(bytes, 0, i);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void removeXML(String outputDir, String templatesPath) {
        new File(templatesPath + "ASDoc_Config.xml").delete();
        new File(templatesPath + "overviews.xml").delete();
        new File(outputDir + "index.tmp").delete();
        new File(outputDir + "index2.tmp").delete();
        new File(outputDir + "toplevel.xml").delete();
        File outputDitaDir = new File(outputDir + "tempdita/");
        if (outputDitaDir.exists()) {
            File[] files = outputDitaDir.listFiles();
            for (int ix = 0; ix < files.length; ++ix) {
                files[ix].delete();
            }
            outputDitaDir.delete();
        }
    }

    public static class NotFound
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -1859901085068385739L;
        public String property;
        public String names;

        public NotFound(String property, String names) {
            this.property = property;
            this.names = names;
        }
    }

    public static class CouldNotCreate
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6183856182026536203L;
        public String file;
        public String message;

        public CouldNotCreate(String file, String message) {
            this.file = file;
            this.message = message;
        }
    }
}

