/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.BytecodeEmitter;
import flex2.compiler.as3.CodeFragmentLogAdapter;
import flex2.compiler.as3.CodeFragmentsInputBuffer;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSyntaxTreeUtil {
    private static final String DOT = ".";
    private static final String DOUBLE_COLON = "::";
    private static final String LESS_THAN = "<";
    private static final String GREATER_THAN = ">";
    private static final String __AS3__ = "__AS3__".intern();
    private static final String CONFIG = "CONFIG".intern();
    private static final String MX_INTERNAL = "mx_internal".intern();
    private static final String OVERRIDE = "override".intern();
    private static final String PRIVATE = "private".intern();
    private static final String PROTECTED = "protected".intern();
    private static final String PRIVATE_DOC_COMMENT = "<description><![CDATA[\n ]]></description>\n<private><![CDATA[ ]]></private>";
    private static final String INHERIT_DOC_COMMENT = "<description><![CDATA[\n ]]></description>\n<inheritDoc><![CDATA[ ]]></inheritDoc>";
    private static final String PUBLIC = "public".intern();
    private static final String STATIC = "static".intern();
    private static final String VEC = "vec".intern();
    private static final String VECTOR = "Vector".intern();

    public static ApplyTypeExprNode generateApplyTypeExpr(NodeFactory nodeFactory, String type) {
        IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, VECTOR, false);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, true, true);
        ListNode typeArgs = nodeFactory.list(null, (Node)typeExpression);
        return (ApplyTypeExprNode)nodeFactory.applyTypeExpr((Node)identifier, typeArgs, -1);
    }

    public static ApplyTypeExprNode generateApplyTypeExpr(NodeFactory nodeFactory, String type, int lessThanIndex) {
        String vectorType = type.substring(0, lessThanIndex - 1);
        int dotIndex = vectorType.lastIndexOf(DOT);
        Object identifier = dotIndex > 0 ? AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, vectorType.substring(0, dotIndex), vectorType.substring(dotIndex + 1), true) : AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, vectorType, true);
        int greaterThanIndex = type.lastIndexOf(GREATER_THAN);
        String elementType = type.substring(lessThanIndex + 1, greaterThanIndex);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, elementType, true, true);
        ListNode typeArgs = nodeFactory.list(null, (Node)typeExpression);
        return (ApplyTypeExprNode)nodeFactory.applyTypeExpr((Node)identifier, typeArgs, -1);
    }

    public static ExpressionStatementNode generateAssignment(NodeFactory nodeFactory, String lvalue, String rvalue) {
        IdentifierNode lvalueIdentifier = nodeFactory.identifier(lvalue);
        IdentifierNode rvalueIdentifier = nodeFactory.identifier(rvalue);
        GetExpressionNode getExpression = nodeFactory.getExpression(rvalueIdentifier);
        MemberExpressionNode rvalueMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)rvalueMemberExpression);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)lvalueIdentifier, argumentList, false, 1);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)setExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    public static ExpressionStatementNode generateAssignment(NodeFactory nodeFactory, Node base, String lvalue, Node rvalue) {
        IdentifierNode lvalueIdentifier = nodeFactory.identifier(lvalue);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, rvalue);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)lvalueIdentifier, argumentList, false, 1);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(base, (SelectorNode)setExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    public static ClassDefinitionNode generateClassDefinition(Context context, String className, String baseClassName, Set<String> interfaceNames, StatementListNode statementList) {
        int index;
        NodeFactory nodeFactory = context.getNodeFactory();
        nodeFactory.StartClassDefs();
        ListNode interfaces = null;
        for (String interfaceName : interfaceNames) {
            index = interfaceName.lastIndexOf(DOT);
            if (index > 0) {
                interfaces = nodeFactory.list(interfaces, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, interfaceName.substring(0, index), interfaceName.substring(index + 1), true));
                continue;
            }
            interfaces = nodeFactory.list(interfaces, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, interfaceName, true));
        }
        index = baseClassName.lastIndexOf(DOT);
        InheritanceNode inheritance = index > 0 ? nodeFactory.inheritance((Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, baseClassName.substring(0, index), baseClassName.substring(index + 1), true), interfaces) : nodeFactory.inheritance((Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, baseClassName, true), interfaces);
        ClassDefinitionNode classDefinition = nodeFactory.classDefinition(context, AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory), (IdentifierNode)AbstractSyntaxTreeUtil.generatePublicQualifiedIdentifier(nodeFactory, className), inheritance, statementList);
        return classDefinition;
    }

    public static FunctionDefinitionNode generateConstructor(Context context, String className, ParameterListNode parameterList, boolean generateSuperCall, StatementListNode statementList, int position) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode identifier = nodeFactory.identifier(className);
        FunctionNameNode functionName = nodeFactory.functionName(-133, identifier);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.no_anno = true;
        if (generateSuperCall) {
            SuperExpressionNode superExpression = nodeFactory.superExpression(null, -1);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)superExpression, null);
            SuperStatementNode superStatement = nodeFactory.superStatement(callExpression);
            if (statementList != null) {
                statementList.items.add(0, (Object)superStatement);
            } else {
                statementList = nodeFactory.statementList(null, (Node)superStatement);
            }
        }
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, identifier, functionSignature, statementList, position);
        functionCommon.setUserDefinedBody(true);
        return nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
    }

    public static Context generateContext(ContextStatics contextStatics, Source source, BytecodeEmitter emitter, ObjectList<ConfigVar> defines) {
        Context result = new Context(contextStatics);
        result.setOrigin(source.getBackingFile().getName());
        result.setScriptName(source.getBackingFile().getName());
        result.setPath(source.getBackingFile().getParent());
        result.setEmitter((Emitter)emitter);
        result.setHandler((CompilerHandler)new As3Compiler.CompilerHandler(source));
        result.input = new CodeFragmentsInputBuffer(source.getBackingFile().getName());
        if (defines != null) {
            result.config_vars.addAll(defines);
        }
        return result;
    }

    public static DocCommentNode generateDocComment(NodeFactory nodeFactory, String comment) {
        LiteralStringNode literalString = nodeFactory.literalString(comment, false);
        ListNode list = nodeFactory.list(null, (Node)literalString);
        LiteralXMLNode literalXML = nodeFactory.literalXML(list, false, -1);
        GetExpressionNode getExpression = nodeFactory.getExpression((Node)literalXML);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        return nodeFactory.docComment(literalArray, -1);
    }

    public static MemberExpressionNode generateGetterSelector(NodeFactory nodeFactory, String name, boolean intern) {
        return AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, name, intern, -1);
    }

    public static MemberExpressionNode generateGetterSelector(NodeFactory nodeFactory, String name, boolean intern, int position) {
        IdentifierNode identifier = nodeFactory.identifier(name, intern, position);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
        return nodeFactory.memberExpression(null, (SelectorNode)getExpression);
    }

    public static MemberExpressionNode generateGetterSelector(NodeFactory nodeFactory, String qualifier, String name, boolean intern) {
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, qualifier, name, intern);
        GetExpressionNode getExpression = nodeFactory.getExpression((IdentifierNode)qualifiedIdentifier);
        return nodeFactory.memberExpression(null, (SelectorNode)getExpression);
    }

    public static MemberExpressionNode generateGetterSelector(NodeFactory nodeFactory, MemberExpressionNode qualifier, String name, boolean intern) {
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, qualifier, name, intern);
        GetExpressionNode getExpression = nodeFactory.getExpression((IdentifierNode)qualifiedIdentifier);
        return nodeFactory.memberExpression(null, (SelectorNode)getExpression);
    }

    public static IdentifierNode generateIdentifier(NodeFactory nodeFactory, String name, boolean intern) {
        IdentifierNode result;
        int index = name.lastIndexOf(DOT);
        if (index > -1) {
            result = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, name.substring(0, index), name.substring(index + 1), true);
        } else {
            index = name.indexOf(DOUBLE_COLON);
            if (index > -1) {
                MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, name.substring(0, index), true);
                result = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, memberExpression, name.substring(index + 2), true);
            } else {
                result = nodeFactory.identifier(name, intern);
            }
        }
        return result;
    }

    public static IdentifierNode generateIdentifier(NodeFactory nodeFactory, QName qName, boolean intern) {
        IdentifierNode result;
        if (qName.getNamespace().length() > 0) {
            MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, qName.getNamespace(), intern);
            result = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, memberExpression, qName.getLocalPart(), intern);
        } else {
            result = nodeFactory.identifier(qName.getLocalPart(), intern);
        }
        return result;
    }

    private static StatementListNode generateImplicitNamespaces(Context context, StatementListNode statementList) {
        StatementListNode result = statementList;
        NodeFactory nodeFactory = context.getNodeFactory();
        if (context.statics.es4_vectors) {
            IdentifierNode as3Identifier = nodeFactory.identifier(__AS3__, false);
            PackageIdentifiersNode packageIdentifiers = nodeFactory.packageIdentifiers(null, as3Identifier, true);
            IdentifierNode vecIdentifier = nodeFactory.identifier(VEC, false);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, vecIdentifier, true);
            IdentifierNode vectorIdentifier = nodeFactory.identifier(VECTOR, false);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, vectorIdentifier, true);
            PackageNameNode packageName = nodeFactory.packageName(packageIdentifiers);
            ImportDirectiveNode importDirective = nodeFactory.importDirective(null, packageName, null, context);
            result = nodeFactory.statementList(result, (Node)importDirective);
        }
        if (!context.statics.use_namespaces.isEmpty()) {
            for (String useName : context.statics.use_namespaces) {
                IdentifierNode identifier = nodeFactory.identifier(useName);
                GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
                MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
                result = nodeFactory.statementList(result, (Node)nodeFactory.useDirective(null, (Node)memberExpression));
            }
        }
        result = nodeFactory.statementList(result, (Node)Parser.generateAs3UseDirective((Context)context));
        return result;
    }

    public static ImportDirectiveNode generateImport(Context context, String name) {
        return AbstractSyntaxTreeUtil.generateImport(context, name, -1);
    }

    public static ImportDirectiveNode generateImport(Context context, String[] splitName) {
        return AbstractSyntaxTreeUtil.generateImport(context, splitName, -1);
    }

    public static ImportDirectiveNode generateImport(Context context, String name, int position) {
        NodeFactory nodeFactory = context.getNodeFactory();
        PackageNameNode packageName = AbstractSyntaxTreeUtil.generatePackageName(nodeFactory, name, true, position);
        return nodeFactory.importDirective(null, packageName, null, context);
    }

    public static ImportDirectiveNode generateImport(Context context, String[] splitName, int position) {
        NodeFactory nodeFactory = context.getNodeFactory();
        PackageNameNode packageName = AbstractSyntaxTreeUtil.generatePackageName(nodeFactory, splitName, true, position);
        return nodeFactory.importDirective(null, packageName, null, context);
    }

    public static MemberExpressionNode generateMemberExpression(NodeFactory nodeFactory, String expression, int position) {
        MemberExpressionNode result;
        int lessThanIndex = expression.indexOf(LESS_THAN);
        if (lessThanIndex != -1) {
            String vectorString = expression.substring(0, lessThanIndex - 1);
            MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, vectorString, true);
            String elementString = expression.substring(lessThanIndex + 1, expression.length() - 1);
            ApplyTypeExprNode selector = AbstractSyntaxTreeUtil.generateApplyTypeExpr(nodeFactory, elementString);
            selector.setRValue(false);
            result = nodeFactory.memberExpression((Node)base, (SelectorNode)selector, position);
        } else {
            int lastDotIndex = expression.lastIndexOf(DOT);
            if (lastDotIndex != -1) {
                String baseString = expression.substring(0, lastDotIndex);
                MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, baseString, true, position);
                String selectorString = expression.substring(lastDotIndex + 1);
                IdentifierNode identifier = nodeFactory.identifier(selectorString, position);
                GetExpressionNode selector = nodeFactory.getExpression(identifier, position);
                selector.setRValue(false);
                result = nodeFactory.memberExpression((Node)base, (SelectorNode)selector, position);
                result.setPositionTerminal(position);
            } else {
                result = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, expression, true, position);
            }
        }
        return result;
    }

    public static MemberExpressionNode generateMemberExpression(NodeFactory nodeFactory, String expression) {
        return AbstractSyntaxTreeUtil.generateMemberExpression(nodeFactory, expression, -1);
    }

    public static MetaDataNode generateMetaData(NodeFactory nodeFactory, String name) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        return nodeFactory.metaData(literalArray, -1);
    }

    public static MetaDataNode generateMetaData(NodeFactory nodeFactory, String name, String value) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        LiteralStringNode literalString = nodeFactory.literalString(value, false);
        ArgumentListNode callExpressionArgumentList = nodeFactory.argumentList(null, (Node)literalString);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, callExpressionArgumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        return nodeFactory.metaData(literalArray, -1);
    }

    public static MetaDataNode generateMetaData(NodeFactory nodeFactory, String name, String key, String value) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        IdentifierNode attributeIdentifier = nodeFactory.identifier(key, false);
        LiteralStringNode literalString = nodeFactory.literalString(value);
        ArgumentListNode attributeArgumentList = nodeFactory.argumentList(null, (Node)literalString);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)attributeIdentifier, attributeArgumentList, false);
        MemberExpressionNode keyValueMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)setExpression);
        ArgumentListNode callExpressionArgumentList = nodeFactory.argumentList(null, (Node)keyValueMemberExpression);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, callExpressionArgumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        return nodeFactory.metaData(literalArray, -1);
    }

    public static MetaDataNode generateMetaData(NodeFactory nodeFactory, String name, Map<String, Object> attributes) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        ArgumentListNode callExpressionArgumentList = null;
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            IdentifierNode attributeIdentifier = nodeFactory.identifier(entry.getKey());
            LiteralStringNode literalString = nodeFactory.literalString(entry.getValue().toString());
            ArgumentListNode attributeArgumentList = nodeFactory.argumentList(null, (Node)literalString);
            SetExpressionNode setExpression = nodeFactory.setExpression((Node)attributeIdentifier, attributeArgumentList, false);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)setExpression);
            callExpressionArgumentList = nodeFactory.argumentList(callExpressionArgumentList, (Node)memberExpression);
        }
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, callExpressionArgumentList);
        callExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        return nodeFactory.metaData(literalArray, -1);
    }

    public static QualifiedIdentifierNode generateMxInternalQualifiedIdentifier(NodeFactory nodeFactory, String name, boolean intern) {
        if (intern) {
            name = name.intern();
        }
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        MemberExpressionNode mxInternalGetterSelector = AbstractSyntaxTreeUtil.generateResolvedGetterSelector(nodeFactory, standardDefs.getCorePackage(), MX_INTERNAL);
        return nodeFactory.qualifiedIdentifier((Node)mxInternalGetterSelector, name);
    }

    public static AttributeListNode generateOverridePublicAttribute(NodeFactory nodeFactory) {
        IdentifierNode identifier = nodeFactory.identifier(PUBLIC, false);
        AttributeListNode attributeList = nodeFactory.attributeList((Node)identifier, null);
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, OVERRIDE, false);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        attributeList = nodeFactory.attributeList((Node)list, attributeList);
        return attributeList;
    }

    public static PackageNameNode generatePackageName(NodeFactory nodeFactory, String name, boolean isDefinition, int position) {
        Scanner scanner = new Scanner(name).useDelimiter("\\.");
        PackageIdentifiersNode packageIdentifiers = null;
        if (scanner.hasNext()) {
            while (scanner.hasNext()) {
                IdentifierNode identifier = nodeFactory.identifier(scanner.next());
                packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, identifier, isDefinition);
            }
        } else {
            IdentifierNode identifier = nodeFactory.identifier(name);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, identifier, isDefinition);
        }
        return nodeFactory.packageName(packageIdentifiers, position);
    }

    public static PackageNameNode generatePackageName(NodeFactory nodeFactory, String[] splitName, boolean isDefinition, int position) {
        PackageIdentifiersNode packageIdentifiers = null;
        for (int i = 0; i < splitName.length; ++i) {
            assert (splitName[i].intern() == splitName[i]);
            IdentifierNode identifier = nodeFactory.identifier(splitName[i], false);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, identifier, isDefinition);
        }
        return nodeFactory.packageName(packageIdentifiers, position);
    }

    public static ParameterNode generateParameter(NodeFactory nodeFactory, String name, String type, boolean internType) {
        return AbstractSyntaxTreeUtil.generateParameter(nodeFactory, name, type, internType, -1);
    }

    public static ParameterNode generateParameter(NodeFactory nodeFactory, String name, String type, boolean internType, int position) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, internType);
        return nodeFactory.parameter(-112, identifier, (Node)typeExpression);
    }

    public static ParameterNode generateParameter(NodeFactory nodeFactory, String name, String type, boolean internType, Node init) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, internType);
        return nodeFactory.parameter(-112, identifier, (Node)typeExpression, init);
    }

    public static ParameterNode generateParameter(NodeFactory nodeFactory, String name, String typeNamespace, String typeName, boolean internType) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, typeNamespace, typeName, internType);
        return nodeFactory.parameter(-112, identifier, (Node)typeExpression);
    }

    public static DocCommentNode generatePrivateDocComment(NodeFactory nodeFactory) {
        return AbstractSyntaxTreeUtil.generateDocComment(nodeFactory, PRIVATE_DOC_COMMENT);
    }

    public static DocCommentNode generateInheritDocComment(NodeFactory nodeFactory) {
        return AbstractSyntaxTreeUtil.generateDocComment(nodeFactory, INHERIT_DOC_COMMENT);
    }

    public static Node generatePrivateVariable(NodeFactory nodeFactory, TypeExpressionNode typeExpression, String name) {
        return AbstractSyntaxTreeUtil.generatePrivateVariable(nodeFactory, typeExpression, name, null);
    }

    public static Node generatePrivateVariable(NodeFactory nodeFactory, TypeExpressionNode typeExpression, String name, Node initializer) {
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateAttribute(nodeFactory);
        int kind = -112;
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generatePrivateQualifiedIdentifier(nodeFactory, name);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)qualifiedIdentifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(attributeList, kind, typedIdentifier, initializer);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return nodeFactory.variableDefinition(attributeList, kind, list);
    }

    public static AttributeListNode generatePrivateAttribute(NodeFactory nodeFactory) {
        ListNode list = nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PRIVATE, false));
        AttributeListNode attributeList = nodeFactory.attributeList((Node)list, null);
        return attributeList;
    }

    public static QualifiedIdentifierNode generatePrivateQualifiedIdentifier(NodeFactory nodeFactory, String name) {
        return nodeFactory.qualifiedIdentifier((Node)AbstractSyntaxTreeUtil.generatePrivateAttribute(nodeFactory), name.intern());
    }

    public static AttributeListNode generatePrivateStaticAttribute(NodeFactory nodeFactory) {
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, STATIC, false);
        AttributeListNode attributeList = nodeFactory.attributeList((Node)memberExpression, null);
        ListNode list = nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PRIVATE, false));
        attributeList = nodeFactory.attributeList((Node)list, attributeList);
        return attributeList;
    }

    public static ProgramNode generateProgram(Context context, StatementListNode configVars, String packageNameString) {
        return AbstractSyntaxTreeUtil.generateProgram(context, configVars, packageNameString, null, -1);
    }

    public static ProgramNode generateProgram(Context context, StatementListNode configVars, String packageNameString, DocCommentNode packageDocComment, int lineNumber) {
        NodeFactory nodeFactory = context.getNodeFactory();
        IdentifierNode configIdentifier = nodeFactory.identifier(CONFIG, false);
        NamespaceDefinitionNode configNamespaceDefinition = nodeFactory.configNamespaceDefinition(null, configIdentifier, -1);
        StatementListNode statementList = nodeFactory.statementList(null, (Node)configNamespaceDefinition);
        if (context.config_vars != null && context.config_vars.size() > 0) {
            statementList.items.addAll(0, (Collection)configVars.items);
        }
        statementList = AbstractSyntaxTreeUtil.generateImplicitNamespaces(context, statementList);
        if (packageDocComment != null) {
            statementList = nodeFactory.statementList(statementList, (Node)packageDocComment);
        }
        PackageNameNode packageName = AbstractSyntaxTreeUtil.generatePackageName(nodeFactory, packageNameString, false, -1);
        PackageDefinitionNode packageDefinition = nodeFactory.startPackage(context, null, packageName);
        statementList = nodeFactory.statementList(statementList, (Node)packageDefinition);
        statementList = AbstractSyntaxTreeUtil.generateImplicitNamespaces(context, statementList);
        int position = -1;
        if (lineNumber != -1) {
            position = AbstractSyntaxTreeUtil.lineNumberToPosition(nodeFactory, lineNumber);
        }
        return nodeFactory.program(context, statementList, position);
    }

    public static AttributeListNode generatePublicAttribute(NodeFactory nodeFactory) {
        ListNode list = nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PUBLIC, false));
        AttributeListNode attributeList = nodeFactory.attributeList((Node)list, null);
        return attributeList;
    }

    public static AttributeListNode generateProtectedAttribute(NodeFactory nodeFactory) {
        ListNode list = nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PROTECTED, false));
        AttributeListNode attributeList = nodeFactory.attributeList((Node)list, null);
        return attributeList;
    }

    public static QualifiedIdentifierNode generatePublicQualifiedIdentifier(NodeFactory nodeFactory, String name) {
        return nodeFactory.qualifiedIdentifier((Node)AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory), name.intern());
    }

    public static QualifiedIdentifierNode generateProtectedQualifiedIdentifier(NodeFactory nodeFactory, String name) {
        return nodeFactory.qualifiedIdentifier((Node)AbstractSyntaxTreeUtil.generateProtectedAttribute(nodeFactory), name.intern());
    }

    public static AttributeListNode generatePublicStaticAttribute(NodeFactory nodeFactory) {
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, STATIC, false);
        AttributeListNode attributeList = nodeFactory.attributeList((Node)memberExpression, null);
        ListNode list = nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PUBLIC, false));
        attributeList = nodeFactory.attributeList((Node)list, attributeList);
        return attributeList;
    }

    public static Node generatePublicVariable(Context context, TypeExpressionNode typeExpression, String name) {
        return AbstractSyntaxTreeUtil.generatePublicVariable(context, typeExpression, name, null);
    }

    public static Node generatePublicVariable(Context context, TypeExpressionNode typeExpression, String name, MemberExpressionNode initializer) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        int kind = -112;
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generatePublicQualifiedIdentifier(nodeFactory, name);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)qualifiedIdentifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(attributeList, kind, typedIdentifier, (Node)initializer);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return nodeFactory.variableDefinition(attributeList, kind, list);
    }

    public static Node generatePrivateStaticVariable(Context context, TypeExpressionNode typeExpression, String name, Node initializer) {
        NodeFactory nodeFactory = context.getNodeFactory();
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateStaticAttribute(nodeFactory);
        int kind = -112;
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generatePublicQualifiedIdentifier(nodeFactory, name);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)qualifiedIdentifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(attributeList, kind, typedIdentifier, initializer);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return nodeFactory.variableDefinition(attributeList, kind, list);
    }

    public static QualifiedIdentifierNode generateQualifiedIdentifier(NodeFactory nodeFactory, String qualifier, String name, boolean intern) {
        if (intern) {
            name = name.intern();
        }
        LiteralStringNode literalString = nodeFactory.literalString(qualifier, intern);
        return nodeFactory.qualifiedIdentifier((Node)literalString, name);
    }

    public static QualifiedIdentifierNode generateQualifiedIdentifier(NodeFactory nodeFactory, MemberExpressionNode qualifier, String name, boolean intern) {
        if (intern) {
            name = name.intern();
        }
        return nodeFactory.qualifiedIdentifier((Node)qualifier, name);
    }

    public static MemberExpressionNode generateResolvedGetterSelector(NodeFactory nodeFactory, String namespace, String name) {
        assert (name.intern() == name);
        IdentifierNode identifier = AbstractSyntaxTreeUtil.generateResolvedIdentifier(nodeFactory, namespace, name);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
        return nodeFactory.memberExpression(null, (SelectorNode)getExpression);
    }

    public static IdentifierNode generateResolvedIdentifier(NodeFactory nodeFactory, String namespace, String name) {
        assert (name.intern() == name);
        IdentifierNode result = nodeFactory.identifier(name, false);
        Namespaces namespaces = new Namespaces();
        NamespaceValue namespaceValue = new NamespaceValue();
        namespaceValue.name = namespace;
        namespaces.add((Object)namespaceValue);
        ReferenceValue referenceValue = new ReferenceValue(nodeFactory.getContext(), null, name, namespaces);
        referenceValue.setIsAttributeIdentifier(false);
        result.ref = referenceValue;
        return result;
    }

    public static TypeExpressionNode generateTypeExpression(NodeFactory nodeFactory, String typeNamespace, String typeName, boolean intern) {
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, typeNamespace, typeName, intern);
        return nodeFactory.typeExpression((Node)memberExpression, true, false, -1);
    }

    public static TypeExpressionNode generateTypeExpression(NodeFactory nodeFactory, String type, boolean intern) {
        return AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, intern, false, -1);
    }

    public static TypeExpressionNode generateTypeExpression(NodeFactory nodeFactory, String type, boolean intern, int position) {
        return AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, intern, false, position);
    }

    public static TypeExpressionNode generateTypeExpression(NodeFactory nodeFactory, String type, boolean intern, boolean includeAnyType) {
        return AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, intern, includeAnyType, -1);
    }

    public static TypeExpressionNode generateTypeExpression(NodeFactory nodeFactory, String type, boolean intern, boolean includeAnyType, int position) {
        TypeExpressionNode result = null;
        if (includeAnyType || !type.equals("*")) {
            MemberExpressionNode memberExpression;
            if (intern) {
                int lessThanIndex = type.indexOf(LESS_THAN);
                if (lessThanIndex > 0) {
                    ApplyTypeExprNode applyTypeExpr = AbstractSyntaxTreeUtil.generateApplyTypeExpr(nodeFactory, type, lessThanIndex);
                    memberExpression = nodeFactory.memberExpression(null, (SelectorNode)applyTypeExpr);
                } else {
                    int dotIndex = type.lastIndexOf(DOT);
                    memberExpression = dotIndex > 0 ? AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, type.substring(0, dotIndex), type.substring(dotIndex + 1), intern) : AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, type, intern);
                }
            } else {
                assert (type.lastIndexOf(DOT) < 0) : "It's likely that the type, " + type + ", needs to be interned.";
                memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, type, intern);
            }
            result = nodeFactory.typeExpression((Node)memberExpression, true, false, position);
        }
        return result;
    }

    private static UseDirectiveNode generateUseDirective(Context context, String name) {
        NodeFactory nodeFactory = context.getNodeFactory();
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
        UseDirectiveNode useDirective = nodeFactory.useDirective(null, (Node)memberExpression);
        return useDirective;
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, String name, boolean intern) {
        IdentifierNode identifier = nodeFactory.identifier(name, intern);
        int kind = -112;
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, null);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(null, kind, typedIdentifier, null);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(null, kind, list);
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, String name, String type, boolean internType, Node rvalue) {
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, name, type, internType, rvalue, -1);
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, String name, String type, boolean internType, Node rvalue, int position) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        int kind = -112;
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, internType, position);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(null, kind, typedIdentifier, rvalue);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(null, kind, list);
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, String name, String typeNamespace, String typeName, boolean internType, Node rvalue) {
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        int kind = -112;
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, typeNamespace, typeName, internType);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(null, kind, typedIdentifier, rvalue);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(null, kind, list);
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, AttributeListNode attributeList, IdentifierNode identifier, String type, boolean internType, Node rvalue) {
        int kind = -112;
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, internType);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(attributeList, kind, typedIdentifier, rvalue);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(attributeList, kind, list);
    }

    public static VariableDefinitionNode generateVariable(NodeFactory nodeFactory, AttributeListNode attributeList, IdentifierNode identifier, String typeNamespace, String typeName, boolean internType, Node rvalue) {
        int kind = -112;
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, typeNamespace, typeName, internType);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, (Node)typeExpression);
        VariableBindingNode variableBinding = nodeFactory.variableBinding(attributeList, kind, typedIdentifier, rvalue);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(attributeList, kind, list);
    }

    public static VariableDefinitionNode generateVariableNew(NodeFactory nodeFactory, String name, String type, int position) {
        return AbstractSyntaxTreeUtil.generateVariableNew(nodeFactory, name, type, null, position);
    }

    public static VariableDefinitionNode generateVariableNew(NodeFactory nodeFactory, String name, String type, ArgumentListNode argumentList, int position) {
        CallExpressionNode initializer;
        IdentifierNode identifier = nodeFactory.identifier(name, false);
        TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, type, true, position);
        TypedIdentifierNode typedIdentifier = nodeFactory.typedIdentifier((Node)identifier, (Node)typeExpression);
        int lessThanIndex = type.indexOf(LESS_THAN);
        if (lessThanIndex > 0) {
            ApplyTypeExprNode applyTypeExpr = AbstractSyntaxTreeUtil.generateApplyTypeExpr(nodeFactory, type, lessThanIndex);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)applyTypeExpr);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)memberExpression, argumentList);
            callExpression.is_new = true;
            initializer = callExpression;
        } else {
            IdentifierNode typeIdentifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, type, true);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)typeIdentifier, argumentList);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            initializer = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        }
        int kind = -112;
        VariableBindingNode variableBinding = nodeFactory.variableBinding(null, kind, typedIdentifier, (Node)initializer);
        ListNode list = nodeFactory.list(null, (Node)variableBinding);
        return (VariableDefinitionNode)nodeFactory.variableDefinition(null, kind, list);
    }

    public static List<Node> parse(Context context, HashSet<String> configNamespaces, String text, int lineNumberOffset, boolean emitDocInfo) {
        return AbstractSyntaxTreeUtil.parse(context, configNamespaces, text, lineNumberOffset, emitDocInfo, false);
    }

    private static List<Node> parse(Context context, HashSet<String> configNamespaces, String text, int lineNumberOffset, boolean emitDocInfo, boolean isExpression) {
        List<Node> result = Collections.emptyList();
        CodeFragmentsInputBuffer codeFragmentsInputBuffer = (CodeFragmentsInputBuffer)context.input;
        String origin = context.input.origin;
        InputBuffer offsetInputBuffer = new InputBuffer(text, origin, codeFragmentsInputBuffer.getLength(), 0);
        Parser parser = new Parser(context, offsetInputBuffer, origin, emitDocInfo);
        parser.block_kind_stack.add(-94);
        parser.block_kind_stack.add(-64);
        parser.config_namespaces.push_back(configNamespaces);
        Logger original = ThreadLocalToolkit.getLogger();
        CodeFragmentLogAdapter codeFragmentLogAdapter = new CodeFragmentLogAdapter(original, lineNumberOffset);
        ThreadLocalToolkit.setLogger(codeFragmentLogAdapter);
        StatementListNode statementList = parser.parseDirectives(null, null);
        parser.match(-1);
        if (statementList != null && statementList.items != null) {
            result = new ArrayList(1);
            for (Node node : statementList.items) {
                if (isExpression && node instanceof MetaDataNode) {
                    result.add((Node)new ExpressionStatementNode((Node)new ListNode(null, (Node)((MetaDataNode)node).data, -1)));
                    continue;
                }
                result.add(node);
            }
        }
        ThreadLocalToolkit.setLogger(original);
        codeFragmentsInputBuffer.addCodeFragment(text.length(), offsetInputBuffer, lineNumberOffset);
        context.input = codeFragmentsInputBuffer;
        return result;
    }

    public static List<Node> parseExpression(Context context, HashSet<String> configNamespaces, String text) {
        return AbstractSyntaxTreeUtil.parseExpression(context, configNamespaces, text, 0, false);
    }

    public static List<Node> parseExpression(Context context, HashSet<String> configNamespaces, String text, int lineNumberOffset, boolean emitDocInfo) {
        return AbstractSyntaxTreeUtil.parse(context, configNamespaces, text, lineNumberOffset, emitDocInfo, true);
    }

    public static StatementListNode parseConfigVars(Context context, HashSet<String> configNamespaces) {
        InputBuffer originalInputBuffer = context.input;
        Parser parser = new Parser(context, "", context.input.origin);
        parser.config_namespaces.push_back(configNamespaces);
        ((HashSet)parser.config_namespaces.last()).add(CONFIG);
        StatementListNode result = parser.parseConfigValues();
        context.input = originalInputBuffer;
        return result;
    }

    public static int lineNumberToPosition(NodeFactory nodeFactory, int lineNumber) {
        CodeFragmentsInputBuffer codeFragmentsInputBuffer = (CodeFragmentsInputBuffer)nodeFactory.getContext().input;
        int position = codeFragmentsInputBuffer.getLength();
        codeFragmentsInputBuffer.addLineNumber(lineNumber);
        return position;
    }
}

