/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipFile;
import flex2.compiler.swc.zip.ZipOutputStream;
import flex2.compiler.util.MimeMappings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcDynamicArchive
implements SwcArchive {
    protected OutputStream out;
    protected String path;
    protected Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();

    public SwcDynamicArchive(String path) {
        this.path = path;
    }

    public SwcDynamicArchive(OutputStream out, String path) {
        this.out = out;
        this.path = path;
    }

    @Override
    public String getLocation() {
        return this.path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load() {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.path);
                Enumeration<ZipEntry> e = zipFile.getEntries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    InputStream inputStream = zipFile.getInputStream(ze);
                    InMemoryFile f = new InMemoryFile(inputStream, ze.getSize(), this.path + "$" + ze.getName(), MimeMappings.getMimeType(ze.getName()), ze.getTime());
                    this.files.put(ze.getName(), f);
                }
                Object var7_9 = null;
            }
            catch (SwcException.UnknownZipFormat e2) {
                throw new SwcException.NotASwcFile(this.path);
            }
            catch (SwcException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new SwcException.FilesNotRead(e4.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (zipFile == null) return;
        zipFile.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        String tmpPath = null;
        ZipOutputStream zos = null;
        try {
            File file;
            File tmpFile;
            assert (this.out != null || this.path != null) : "Must supply either an output stream or a location";
            if (this.out != null) {
                zos = new ZipOutputStream(this.out);
            } else if (this.path != null) {
                tmpPath = this.path + ".tmp";
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(FileUtil.openFile(tmpPath, true))));
            }
            for (Map.Entry<String, VirtualFile> mapEntry : this.files.entrySet()) {
                VirtualFile f = mapEntry.getValue();
                ZipEntry entry = new ZipEntry(mapEntry.getKey());
                entry.setTime(f.getLastModified());
                zos.putNextEntry(entry);
                BufferedInputStream in = new BufferedInputStream(f.getInputStream());
                FileUtil.streamOutput(in, zos);
                zos.closeEntry();
            }
            zos.close();
            zos = null;
            if (this.out == null && this.path != null && !FileUtils.renameFile((File)(tmpFile = new File(tmpPath)), (File)(file = new File(this.path)))) {
                throw new SwcException.SwcNotRenamed(tmpFile.getAbsolutePath(), file.getAbsolutePath());
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (zos != null) {
                zos.close();
            }
        }
        catch (IOException ioe) {}
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, VirtualFile> getFiles() {
        return this.files;
    }

    @Override
    public VirtualFile getFile(String path) {
        return this.files.get(path);
    }

    @Override
    public void putFile(VirtualFile file) {
        this.files.put(file.getName(), file);
    }

    @Override
    public void putFile(String path, byte[] data, long lastModified) {
        InMemoryFile file = new InMemoryFile(data, path, MimeMappings.getMimeType(path), lastModified);
        this.files.put(file.getName(), file);
    }

    @Override
    public long getLastModified() {
        return 0L;
    }
}

