/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.graphics.images.LosslessImage;
import flash.swf.builder.tags.DefineBitsLosslessBuilder;
import flash.swf.tags.DefineBitsJPEG3;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineSprite;
import flex2.compiler.TranscoderException;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.media.ImageTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LosslessImageTranscoder
extends ImageTranscoder {
    public static final String COMPRESSION = "compression";
    public static final String QUALITY = "quality";

    public LosslessImageTranscoder() {
        super(new String[]{"image/gif", "image/png"}, DefineSprite.class, true);
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return COMPRESSION.equals(attr) || QUALITY.equals(attr) || super.isSupportedAttribute(attr);
    }

    @Override
    public ImageTranscoder.ImageInfo getImage(VirtualFile sourceFile, Map<String, Object> args) throws TranscoderException {
        ImageTranscoder.ImageInfo info = new ImageTranscoder.ImageInfo();
        try {
            LosslessImage image = new LosslessImage(sourceFile.getName(), sourceFile.getInputStream(), sourceFile.getLastModified());
            if (args.containsKey(COMPRESSION) && Boolean.parseBoolean((String)args.get(COMPRESSION))) {
                DefineBitsJPEG3 defineBits = new DefineBitsJPEG3();
                int imageSize = image.getWidth() * image.getHeight();
                byte[] alphaData = new byte[imageSize];
                int[] pixels = image.getPixels();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                bufferedImage.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
                for (int i = 0; i < imageSize; ++i) {
                    alphaData[i] = (byte)(pixels[i] >> 24 & 0xFF);
                }
                float quality = 1.0f;
                if (args.containsKey(QUALITY)) {
                    try {
                        String qualityString = (String)args.get(QUALITY);
                        double qualityPercentage = Double.parseDouble(qualityString);
                        if (qualityPercentage < 0.0 || qualityPercentage > 100.0) {
                            throw new InvalidQuality();
                        }
                        quality = (float)(qualityPercentage / 100.0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidQuality();
                    }
                }
                defineBits.data = LosslessImageTranscoder.bufferedImageToJPEG(bufferedImage, quality);
                defineBits.alphaDataOffset = alphaData.length;
                defineBits.alphaData = alphaData;
                info.defineBits = defineBits;
            } else {
                if (args.containsKey(QUALITY)) {
                    throw new QualityRequiresCompression();
                }
                DefineBitsLossless defineBits = DefineBitsLosslessBuilder.build((int[])image.getPixels(), (int)image.getWidth(), (int)image.getHeight());
                info.defineBits = defineBits;
            }
            info.width = image.getWidth();
            info.height = image.getHeight();
        }
        catch (TranscoderException transcoderException) {
            throw transcoderException;
        }
        catch (Exception exception) {
            throw new AbstractTranscoder.ExceptionWhileTranscoding(exception);
        }
        return info;
    }

    private static byte[] bufferedImageToJPEG(BufferedImage bufferedImage, float quality) throws Exception {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        DirectColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, ((ColorModel)colorModel).createCompatibleSampleModel(1, 1));
        writeParam.setDestinationType(imageTypeSpecifier);
        writeParam.setSourceBands(new int[]{0, 1, 2});
        writeParam.setCompressionMode(2);
        writeParam.setCompressionQuality(quality);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        writer.setOutput(new MemoryCacheImageOutputStream(buffer));
        IIOImage ioImage = new IIOImage(bufferedImage, null, null);
        writer.write(null, ioImage, writeParam);
        writer.dispose();
        return buffer.toByteArray();
    }

    public class QualityRequiresCompression
    extends TranscoderException {
        private static final long serialVersionUID = 6347969168361169994L;
    }

    public class InvalidQuality
    extends TranscoderException {
        private static final long serialVersionUID = 6347969168361169993L;
    }
}

