/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;

public class DefaultsConfigurator {
    private static void set(ConfigurationBuffer cfgbuf, String var, String val) throws ConfigurationException {
        LinkedList<String> args = new LinkedList<String>();
        args.add(val);
        cfgbuf.setVar(var, args, "defaults", -1);
    }

    private static void set(ConfigurationBuffer cfgbuf, String[] vars, String val) throws ConfigurationException {
        for (int i = 0; i < vars.length; ++i) {
            DefaultsConfigurator.set(cfgbuf, vars[i], val);
        }
    }

    public static void loadDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.loadCommonDefaults(cfgbuf);
        DefaultsConfigurator.set(cfgbuf, "compiler.debug", "false");
        DefaultsConfigurator.set(cfgbuf, "compiler.use-resource-bundle-metadata", "true");
    }

    public static void loadCompcDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.loadCommonDefaults(cfgbuf);
        DefaultsConfigurator.set(cfgbuf, "compiler.debug", "true");
        DefaultsConfigurator.set(cfgbuf, "compiler.use-resource-bundle-metadata", "false");
        DefaultsConfigurator.set(cfgbuf, "compiler.archive-classes-and-assets", "true");
        DefaultsConfigurator.set(cfgbuf, "directory", "false");
    }

    public static void loadASDocDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.loadCommonDefaults(cfgbuf);
        DefaultsConfigurator.set(cfgbuf, "compiler.debug", "false");
        DefaultsConfigurator.set(cfgbuf, "compiler.use-resource-bundle-metadata", "false");
        DefaultsConfigurator.set(cfgbuf, "compiler.doc", "true");
        DefaultsConfigurator.set(cfgbuf, "output", "asdoc-output");
        DefaultsConfigurator.set(cfgbuf, "left-frameset-width", "-1");
    }

    public static void loadOEMCompcDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.loadCommonDefaults(cfgbuf);
        DefaultsConfigurator.set(cfgbuf, "compiler.debug", "true");
        DefaultsConfigurator.set(cfgbuf, "compiler.use-resource-bundle-metadata", "false");
        DefaultsConfigurator.set(cfgbuf, "compiler.archive-classes-and-assets", "true");
    }

    public static void loadMinimumDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("${flexlib}/${configname}-config.xml");
        if (cfgbuf.isValidVar("load-config")) {
            cfgbuf.setVar("load-config", args, "defaults", -1, null, false);
        }
    }

    private static void loadCommonDefaults(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        DefaultsConfigurator.set(cfgbuf, "target-player", "10.0.0");
        DefaultsConfigurator.set(cfgbuf, new String[]{"compiler.accessible", "compiler.es", "compiler.verbose-stacktraces", "compiler.show-dependency-warnings", "compiler.keep-generated-actionscript", "compiler.keep-generated-signatures", "compiler.disable-incremental-optimizations", "compiler.allow-source-path-overlap"}, "false");
        DefaultsConfigurator.set(cfgbuf, new String[]{"lazy-init", "compiler.omit-trace-statements", "compiler.optimize", "compiler.strict", "compiler.show-actionscript-warnings", "compiler.as3", "compiler.show-deprecation-warnings", "compiler.show-shadowed-device-font-warnings", "compiler.show-binding-warnings", "compiler.fonts.advanced-anti-aliasing", "generate-frame-loader", "use-network"}, "true");
        DefaultsConfigurator.set(cfgbuf, "debug-password", "");
        DefaultsConfigurator.set(cfgbuf, "framework", "halo");
        DefaultsConfigurator.set(cfgbuf, "compiler.theme", "${flexlib}/themes/Spark/spark.css");
        DefaultsConfigurator.set(cfgbuf, "compiler.locale", Locale.getDefault().toString());
        DefaultsConfigurator.set(cfgbuf, "compiler.translation-format", "flex2.compiler.i18n.PropertyTranslationFormat");
        DefaultsConfigurator.set(cfgbuf, "default-frame-rate", "24");
        DefaultsConfigurator.set(cfgbuf, "default-background-color", "0xFFFFFF");
        LinkedList<String> args = new LinkedList<String>();
        args.add("500");
        args.add("375");
        cfgbuf.setVar("default-size", args, "defaults", -1);
        args.clear();
        args.add("${flexlib}/${configname}-config.xml");
        if (cfgbuf.isValidVar("load-config")) {
            cfgbuf.setVar("load-config", args, "defaults", -1, null, false);
        }
        args.clear();
        args.add("1000");
        args.add("60");
        cfgbuf.setVar("default-script-limits", args, "defaults", -1);
        DefaultsConfigurator.set(cfgbuf, "compiler.fonts.max-cached-fonts", "20");
        DefaultsConfigurator.set(cfgbuf, "compiler.fonts.max-glyphs-per-face", "1000");
        ArrayList<String> fontManagers = new ArrayList<String>();
        fontManagers.add("flash.fonts.JREFontManager");
        fontManagers.add("flash.fonts.BatikFontManager");
        cfgbuf.setVar("compiler.fonts.managers", fontManagers, "defaults", -1);
        String os = System.getProperty("os.name");
        if (os != null) {
            if ((os = os.toLowerCase()).startsWith("windows xp")) {
                DefaultsConfigurator.set(cfgbuf, "compiler.fonts.local-fonts-snapshot", "${flexlib}/winFonts.ser");
            } else if (os.startsWith("mac os x")) {
                DefaultsConfigurator.set(cfgbuf, "compiler.fonts.local-fonts-snapshot", "${flexlib}/macFonts.ser");
            } else {
                DefaultsConfigurator.set(cfgbuf, "compiler.fonts.local-fonts-snapshot", "${flexlib}/localFonts.ser");
            }
        } else {
            DefaultsConfigurator.set(cfgbuf, "compiler.fonts.local-fonts-snapshot", "${flexlib}/localFonts.ser");
        }
    }
}

