/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.tools.ToolsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompcConfiguration
extends ToolsConfiguration {
    protected static boolean outputRequired = true;
    private boolean isDirectory;
    private List<String> classes = new LinkedList<String>();
    private Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();
    private Map<String, VirtualFile> stylesheets = new HashMap<String, VirtualFile>();
    private boolean includeLookupOnly = false;
    private List<String> namespaces = new LinkedList<String>();
    private List<String> resourceBundles = new LinkedList<String>();
    private List<String> sources = new LinkedList<String>();
    private boolean computeDigest = true;

    public static Map<String, String> getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("o", "output");
        map.put("ic", "include-classes");
        map.put("in", "include-namespaces");
        map.put("is", "include-sources");
        map.put("if", "include-file");
        map.put("ir", "include-resource-bundles");
        map.putAll(Configuration.getAliases());
        return map;
    }

    @Override
    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        super.validate(cfgbuf);
        this.validateSwcInputs();
    }

    protected void validateSwcInputs() throws ConfigurationException {
        if (this.getIncludeSources().isEmpty() && this.getClasses().isEmpty() && this.getNamespaces().isEmpty() && (this.getCompilerConfiguration().getIncludeLibraries() == null || this.getCompilerConfiguration().getIncludeLibraries().length == 0) && this.getFiles().isEmpty() && this.getIncludeResourceBundles().isEmpty()) {
            throw new ConfigurationException.NoSwcInputs(null, null, -1);
        }
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void cfgDirectory(ConfigurationValue val, boolean directory) {
        this.isDirectory = directory;
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void cfgIncludeClasses(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.classes.addAll(this.toQNameString(args));
    }

    public static ConfigurationInfo getIncludeClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public Map<String, VirtualFile> getFiles() {
        return this.files;
    }

    public void addFiles(Map<String, VirtualFile> f) {
        this.files.putAll(f);
    }

    public void cfgIncludeFile(ConfigurationValue cfgval, String name, String path) throws ConfigurationException {
        if (this.files.containsKey(name)) {
            throw new ConfigurationException.RedundantFile(name, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        VirtualFile f = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cfgval);
        this.files.put(name, f);
    }

    public static ConfigurationInfo getIncludeFileInfo() {
        return new ConfigurationInfo(new String[]{"name", "path"}){

            public boolean isPath() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public Map<String, VirtualFile> getStylesheets() {
        return this.stylesheets;
    }

    public void addStylesheets(Map<String, VirtualFile> f) {
        this.stylesheets.putAll(f);
    }

    public void cfgIncludeStylesheet(ConfigurationValue cfgval, String name, String path) throws ConfigurationException {
        if (this.stylesheets.containsKey(name)) {
            throw new ConfigurationException.RedundantFile(name, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        VirtualFile f = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cfgval);
        this.stylesheets.put(name, f);
    }

    public static ConfigurationInfo getIncludeStylesheetInfo() {
        return new ConfigurationInfo(new String[]{"name", "path"}){

            public boolean isPath() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public boolean getIncludeLookupOnly() {
        return this.includeLookupOnly;
    }

    public void cfgIncludeLookupOnly(ConfigurationValue val, boolean includeLookupOnly) {
        this.includeLookupOnly = includeLookupOnly;
    }

    public static ConfigurationInfo getIncludeLookupOnlyInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void cfgIncludeNamespaces(ConfigurationValue val, List<String> includeNamespaces) {
        this.namespaces.addAll(includeNamespaces);
    }

    public static ConfigurationInfo getIncludeNamespacesInfo() {
        return new ConfigurationInfo(-1, new String[]{"uri"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List<String> getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List<String> includeResourceBundles) {
        this.resourceBundles.addAll(this.toQNameString(includeResourceBundles));
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void setIncludeSources(List<String> sources) {
        this.sources = sources;
    }

    public List<String> getIncludeSources() {
        return this.sources;
    }

    public void cfgIncludeSources(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.sources.addAll(args);
    }

    public static ConfigurationInfo getIncludeSourcesInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
        File d;
        this.output = output != null && (output.startsWith(File.separator) || output.startsWith("/") || FileUtils.isAbsolute((File)new File(output))) ? output : (val.getContext() != null ? FileUtils.addPathComponents((String)val.getContext(), (String)output, (char)File.separatorChar) : output);
        if (this.isDirectory && (d = new File(this.output)).exists()) {
            if (!d.isDirectory()) {
                throw new ConfigurationException.NotADirectory(this.output, val.getVar(), val.getSource(), val.getLine());
            }
            File[] fl = d.listFiles();
            if (fl != null && fl.length > 0) {
                throw new ConfigurationException.DirectoryNotEmpty(this.output, val.getVar(), val.getSource(), val.getLine());
            }
        }
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String[] getPrerequisites() {
                return new String[]{"directory"};
            }

            public boolean isRequired() {
                return outputRequired;
            }
        };
    }

    @Override
    public String getTargetFile() {
        return null;
    }

    public void cfgRoot(ConfigurationValue val, String rootStr) throws ConfigurationException {
        throw new ConfigurationException.ObsoleteVariable("source-path", val.getVar(), val.getSource(), val.getLine());
    }

    public static ConfigurationInfo getRootInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }

    @Override
    public boolean getComputeDigest() {
        return this.computeDigest;
    }

    public void cfgComputeDigest(ConfigurationValue cv, boolean b) {
        this.computeDigest = b;
    }
}

