/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flash.localization.LocalizationManager;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.SwcDependencyInfo;
import flex2.compiler.util.SwcDependencyInfoImpl;
import flex2.compiler.util.SwcExternalScriptInfo;
import flex2.compiler.util.SwcExternalScriptInfoImpl;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.graph.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcDependencyUtil {
    public static SwcDependencyInfo getSwcDependencyInfo(VirtualFile[] swcs, String[] dependencyTypesArray, boolean minimizeDependencySet) {
        String swcLocation;
        HashSet<String> scriptDependencyTypes = dependencyTypesArray != null ? new HashSet<String>(Arrays.asList(dependencyTypesArray)) : null;
        SwcCache cache = new SwcCache();
        SwcGroup swcGroup = cache.getSwcGroup(swcs);
        cache.setLazyRead(true);
        SwcDependencyInfoImpl depInfo = new SwcDependencyInfoImpl();
        HashMap swcDefMap = new HashMap(swcGroup.getNumberLoaded());
        HashMap<String, SwcExternalScriptInfoImpl> swcExternMap = new HashMap<String, SwcExternalScriptInfoImpl>(swcGroup.getNumberLoaded());
        for (Map.Entry<String, Swc> swcEntry : swcGroup.getSwcs().entrySet()) {
            if (swcDefMap.get(swcEntry.getValue().getLocation()) != null) continue;
            HashMap<String, SwcScript> defMap = new HashMap<String, SwcScript>();
            swcLocation = swcEntry.getValue().getLocation();
            SwcExternalScriptInfoImpl externalScripts = new SwcExternalScriptInfoImpl(swcLocation);
            swcDefMap.put(swcLocation, defMap);
            swcExternMap.put(swcLocation, externalScripts);
            depInfo.addSwcExternals(swcLocation, externalScripts);
            Iterator<SwcLibrary> swcLibraryIter = swcEntry.getValue().getLibraryIterator();
            while (swcLibraryIter.hasNext()) {
                SwcScript swcScript;
                SwcLibrary swcLibrary = swcLibraryIter.next();
                Iterator<SwcScript> scriptIter = swcLibrary.getScriptIterator();
                while (scriptIter.hasNext()) {
                    swcScript = scriptIter.next();
                    Iterator<String> defIter = swcScript.getDefinitionIterator();
                    while (defIter.hasNext()) {
                        String definition = defIter.next();
                        defMap.put(definition, swcScript);
                    }
                }
                scriptIter = swcLibrary.getScriptIterator();
                while (scriptIter.hasNext()) {
                    swcScript = scriptIter.next();
                    Iterator<String> typeIter = swcScript.getDependencySet().getTypeIterator();
                    while (typeIter.hasNext()) {
                        String type = typeIter.next();
                        if (scriptDependencyTypes != null && !scriptDependencyTypes.contains(type)) continue;
                        Iterator scriptDepIter = swcScript.getDependencySet().getDependencyIterator(type);
                        while (scriptDepIter.hasNext()) {
                            String scriptDep = (String)scriptDepIter.next();
                            SwcScript dependentScript = (SwcScript)defMap.get(scriptDep);
                            if (dependentScript != null) continue;
                            externalScripts.addScriptDependencyType(scriptDep, type);
                        }
                    }
                }
            }
        }
        HashMap<String, Set<String>> dependencyMap = null;
        if (minimizeDependencySet) {
            dependencyMap = new HashMap<String, Set<String>>(swcGroup.getNumberLoaded());
        }
        for (Map.Entry swcExternEntry : swcExternMap.entrySet()) {
            swcLocation = (String)swcExternEntry.getKey();
            SwcExternalScriptInfoImpl externalInfo = (SwcExternalScriptInfoImpl)swcExternEntry.getValue();
            HashSet<String> dependencyList = null;
            if (minimizeDependencySet && (dependencyList = (HashSet<String>)dependencyMap.get(swcLocation)) == null) {
                dependencyList = new HashSet<String>();
                dependencyMap.put(swcLocation, dependencyList);
            }
            for (String externName : externalInfo.getExternalScripts()) {
                ArrayList<SwcScript> resolvingSwcs = new ArrayList<SwcScript>();
                for (Map.Entry swcDefEntry : swcDefMap.entrySet()) {
                    Map externMap2;
                    SwcScript script;
                    String swcLocation2 = (String)swcDefEntry.getKey();
                    if (swcLocation2.equals(swcLocation) || (script = (SwcScript)(externMap2 = (Map)swcDefEntry.getValue()).get(externName)) == null) continue;
                    if (minimizeDependencySet) {
                        resolvingSwcs.add(script);
                        continue;
                    }
                    depInfo.addDependency(swcLocation, swcLocation2);
                    externalInfo.addResolvingSwc(externName, swcLocation2);
                }
                if (!minimizeDependencySet) continue;
                SwcScript externalScript = null;
                if (resolvingSwcs.size() > 1) {
                    externalScript = SwcDependencyUtil.getOriginalSwc(resolvingSwcs);
                } else if (resolvingSwcs.size() > 0) {
                    externalScript = (SwcScript)resolvingSwcs.get(0);
                }
                if (externalScript == null) continue;
                String swcLocation2 = externalScript.getSwcLocation();
                dependencyList.add(swcLocation2);
                externalInfo.addResolvingSwc(externName, swcLocation2);
            }
        }
        if (minimizeDependencySet) {
            for (Map.Entry swcExternEntry : swcExternMap.entrySet()) {
                swcLocation = (String)swcExternEntry.getKey();
                SwcDependencyUtil.removeDependencySubsets(swcLocation, dependencyMap, depInfo);
                for (String swcDependLocation : (Set)dependencyMap.get(swcLocation)) {
                    depInfo.addDependency(swcLocation, swcDependLocation);
                }
            }
        }
        return depInfo;
    }

    private static SwcScript getOriginalSwc(List<SwcScript> resolvingSwcs) {
        SwcScript originalScript = null;
        SwcScript newestScript = null;
        long oldestSwcCreationTime = Long.MAX_VALUE;
        long newestScriptTime = Long.MAX_VALUE;
        boolean allScriptTimesEqual = true;
        for (SwcScript script : resolvingSwcs) {
            if (newestScript == null) {
                newestScript = script;
                newestScriptTime = script.getLastModified();
            } else if (script.getLastModified() != newestScriptTime) {
                allScriptTimesEqual = false;
                if (script.getLastModified() > newestScriptTime) {
                    newestScript = script;
                    newestScriptTime = script.getLastModified();
                }
            }
            if (!allScriptTimesEqual) continue;
            SwcLibrary library = script.getLibrary();
            if (allScriptTimesEqual && library.getDigest("SHA-256", true) != null) {
                originalScript = script;
                continue;
            }
            if (originalScript != null || library.getSwcCreationTime() >= oldestSwcCreationTime) continue;
            oldestSwcCreationTime = library.getSwcCreationTime();
            originalScript = script;
        }
        return allScriptTimesEqual ? originalScript : newestScript;
    }

    private static void removeDependencySubsets(String swcLocation, Map<String, Set<String>> dependencyMap, SwcDependencyInfoImpl depInfo) {
        HashSet<String> removeSet = new HashSet<String>();
        SwcExternalScriptInfo externalInfo = depInfo.getSwcExternalScriptInfo(swcLocation);
        HashMap<String, Set<String>> externalsBySwc = new HashMap<String, Set<String>>();
        block0: for (String swcDependLocation : dependencyMap.get(swcLocation)) {
            for (String swcDependLocation2 : dependencyMap.get(swcLocation)) {
                if (swcDependLocation.equals(swcDependLocation2)) continue;
                Set<String> externalScripts = (Set<String>)externalsBySwc.get(swcDependLocation);
                Set<String> externalScripts2 = (Set<String>)externalsBySwc.get(swcDependLocation2);
                if (externalScripts == null) {
                    externalScripts = externalInfo.getExternalScripts(swcDependLocation);
                    externalsBySwc.put(swcDependLocation, externalScripts);
                }
                if (externalScripts2 == null) {
                    externalScripts2 = externalInfo.getExternalScripts(swcDependLocation2);
                    externalsBySwc.put(swcDependLocation2, externalScripts2);
                }
                if (externalScripts2.size() <= externalScripts.size() || !externalScripts2.containsAll(externalScripts)) continue;
                removeSet.add(swcDependLocation);
                continue block0;
            }
        }
        Set<String> dependencySet = dependencyMap.get(swcLocation);
        dependencySet.removeAll(removeSet);
    }

    public static String SetOfVertexToString(Set<Vertex<String, SwcExternalScriptInfo>> vertexSet) {
        StringBuilder dependencyMessage = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        LocalizationManager i10n = ThreadLocalToolkit.getLocalizationManager();
        for (Vertex<String, SwcExternalScriptInfo> vertexEntry : vertexSet) {
            String message = i10n.getLocalizedTextString((Object)new DependsOn(vertexEntry.getWeight()));
            dependencyMessage.append(message + lineSeparator);
            Set<Vertex<String, SwcExternalScriptInfo>> predSet = vertexEntry.getPredecessors();
            for (Vertex<String, SwcExternalScriptInfo> predEntry : predSet) {
                dependencyMessage.append("\t" + predEntry.getWeight() + lineSeparator);
            }
        }
        return dependencyMessage.toString();
    }

    public static class DependsOn
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 948175715607113717L;
        public String location;

        public DependsOn(String location) {
            this.location = location;
        }
    }
}

