/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep.init;

import flash.util.StringUtils;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.mxml.ImplementationGenerator;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.DescriptorGenerator;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.mxml.rep.Vector;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.mxml.rep.XMLList;
import flex2.compiler.mxml.rep.init.ArrayElementInitializer;
import flex2.compiler.mxml.rep.init.EffectInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.NamedInitializer;
import flex2.compiler.mxml.rep.init.VisualChildInitializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralVectorNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.util.Context;
import org.apache.commons.collections.iterators.SingletonIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueInitializer
implements Initializer {
    private static final String INT = "int";
    private static final String ARRAY = "Array";
    private static final String NULL = "null";
    private static final String THIS = "this";
    private static final String DOT = ".";
    private static final String NEW_VALUE = "newValue".intern();
    private static final String OLD_VALUE = "oldValue".intern();
    private static final String PROPERTY = "property".intern();
    private static final String OBJECT = "Object".intern();
    private static final String SOURCE = "source".intern();
    private static final String BINDING_MANAGER = "BindingManager".intern();
    private static final String CD = "cd".intern();
    private static final String CHILD_DESCRIPTORS = "childDescriptors".intern();
    private static final String CLASS = "Class".intern();
    private static final String CREATE_XML_DOCUMENT = "createXMLDocument".intern();
    private static final String DEFERRED_INSTANCE_FROM_CLASS = "DeferredInstanceFromClass".intern();
    private static final String DEFERRED_INSTANCE_FROM_FUNCTION = "DeferredInstanceFromFunction".intern();
    private static final String DISPATCH_EVENT = "dispatchEvent".intern();
    private static final String DOCUMENT = "document".intern();
    private static final String EXECUTE_BINDINGS = "executeBindings".intern();
    private static final String EVENT = "Event".intern();
    private static final String FIRST_CHILD = "firstChild".intern();
    private static final String GET_DEFINITION_BY_NAME = "getDefinitionByName".intern();
    private static final String I = "i".intern();
    private static final String ID = "id".intern();
    private static final String INITIALIZE = "initialize".intern();
    private static final String INITIALIZED = "initialized".intern();
    private static final String LENGTH = "length".intern();
    private static final String MX_INTERNAL = "mx_internal".intern();
    private static final String REGISTER_EFFECTS = "registerEffects".intern();
    private static final String TEMP = "temp".intern();
    private static final String UNDEFINED = "undefined".intern();
    private static final String XML_UTIL = "XMLUtil".intern();
    private static final String _DOCUMENT_DESCRIPTOR = "_documentDescriptor".intern();
    private static final String __CLASS = "__class".intern();
    private static final String __E = "__e".intern();
    protected final StandardDefs standardDefs;
    protected final Object value;
    protected final int line;
    protected boolean stateSpecific;

    ValueInitializer(Object value, int line, StandardDefs defs) {
        this.value = value;
        this.line = line;
        this.stateSpecific = false;
        this.standardDefs = defs;
        if (value instanceof Model) {
            this.stateSpecific = ((Model)value).isStateSpecific();
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int getLineRef() {
        return this.line;
    }

    @Override
    public boolean isBinding() {
        return this.value instanceof BindingExpression || this.value instanceof Primitive && ((Primitive)this.value).hasBindings();
    }

    @Override
    public boolean isStateSpecific() {
        return this.stateSpecific;
    }

    public void setStateSpecific(boolean value) {
        this.stateSpecific = value;
    }

    @Override
    public boolean hasDefinition() {
        if (this.value instanceof Model) {
            Model model = (Model)this.value;
            return model.isDeclared() || !this.modelHasInlineRValue() || this.isInstanceGeneratorOverDefinition();
        }
        assert (this.isBinding() || !this.standardDefs.isInstanceGenerator(this.getLValueType())) : "instance generator lvalue has non-Model, non-BindingExpression rvalue (" + this.value.getClass() + ")";
        return false;
    }

    protected boolean isInstanceGeneratorOverDefinition() {
        Type ltype = this.getLValueType();
        return this.standardDefs.isIFactory(ltype) || this.standardDefs.isIDeferredInstance(ltype) && !this.rvalueIsClassRef();
    }

    protected boolean rvalueIsClassRef() {
        return this.value instanceof Primitive && ((Primitive)this.value).getType().equals(this.getTypeTable().classType);
    }

    @Override
    public String getValueExpr() {
        Type lvalueType = this.getLValueType();
        if (this.standardDefs.isIDeferredInstance(lvalueType)) {
            if (this.rvalueIsClassRef()) {
                return "new " + NameFormatter.toDot(this.standardDefs.CLASS_DEFERREDINSTANCEFROMCLASS) + "(" + this.getInlineRValue() + ")";
            }
            return "new " + NameFormatter.toDot(this.standardDefs.CLASS_DEFERREDINSTANCEFROMFUNCTION) + "(" + this.getDefinitionName() + (this.standardDefs.isITransientDeferredInstance(lvalueType) ? "," + ((Model)this.value).getDefinitionName() + "_r" : "") + ")";
        }
        return this.hasDefinition() ? this.getDefinitionName() + "()" : this.getInlineRValue();
    }

    @Override
    public Node generateValueExpr(NodeFactory nodeFactory) {
        MemberExpressionNode result;
        Type lvalueType = this.getLValueType();
        if (this.standardDefs.isIDeferredInstance(lvalueType)) {
            ArgumentListNode args;
            QualifiedIdentifierNode typeIdentifier;
            if (this.rvalueIsClassRef()) {
                typeIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, this.standardDefs.getCorePackage(), DEFERRED_INSTANCE_FROM_CLASS, false);
                args = nodeFactory.argumentList(null, this.generateInlineRValue(nodeFactory));
            } else {
                typeIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, this.standardDefs.getCorePackage(), DEFERRED_INSTANCE_FROM_FUNCTION, false);
                IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, this.getDefinitionName(), true);
                args = nodeFactory.argumentList(null, (Node)identifier);
                if (this.standardDefs.isITransientDeferredInstance(lvalueType)) {
                    identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, ((Model)this.value).getDefinitionName() + "_r", true);
                    args = nodeFactory.argumentList(args, (Node)identifier);
                }
            }
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)typeIdentifier, args);
            callExpression.is_new = true;
            callExpression.setRValue(false);
            result = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        } else if (this.hasDefinition()) {
            IdentifierNode identifier = AbstractSyntaxTreeUtil.generateIdentifier(nodeFactory, this.getDefinitionName(), true);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, null);
            callExpression.setRValue(false);
            result = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        } else {
            return this.generateInlineRValue(nodeFactory);
        }
        return result;
    }

    protected boolean modelHasInlineRValue() {
        boolean result = false;
        assert (this.value instanceof Model);
        Model model = (Model)this.value;
        if (model instanceof Vector) {
            Vector vector = (Vector)model;
            if (!vector.isFixed()) {
                result = true;
            }
        } else if (model instanceof XML || model instanceof XMLList || model instanceof Primitive || model instanceof Array || model.getType().equals(this.getTypeTable().objectType)) {
            result = true;
        }
        return result;
    }

    private String getInlineRValue() {
        if (this.value instanceof Model) {
            if (this.value instanceof Primitive) {
                Primitive primitive = (Primitive)this.value;
                return this.formatExpr(primitive.getType(), primitive.getValue());
            }
            if (this.value instanceof Vector) {
                return ValueInitializer.asVectorLiteral((Vector)this.value);
            }
            if (this.value instanceof Array) {
                return ValueInitializer.asArrayLiteral((Array)this.value);
            }
            if (this.value instanceof XML) {
                XML xml = (XML)this.value;
                return this.asXmlLiteral(xml);
            }
            if (this.value instanceof XMLList) {
                return ValueInitializer.asXMLList((XMLList)this.value);
            }
            if (((Model)this.value).getType().equals(this.getTypeTable().objectType)) {
                return ValueInitializer.asObjectLiteral((Model)this.value);
            }
            assert (false) : "can't generate inline expr for values of type " + this.value.getClass();
            return null;
        }
        return this.formatExpr(this.getLValueType(), this.value);
    }

    private Node generateInlineRValue(NodeFactory nodeFactory) {
        if (this.value instanceof Model) {
            if (this.value instanceof Primitive) {
                Primitive primitive = (Primitive)this.value;
                return this.formatExpr(nodeFactory, primitive.getType(), primitive.getValue());
            }
            if (this.value instanceof Vector) {
                return ValueInitializer.asVectorLiteral(nodeFactory, (Vector)this.value);
            }
            if (this.value instanceof Array) {
                return ValueInitializer.asArrayLiteral(nodeFactory, (Array)this.value);
            }
            if (this.value instanceof XML) {
                XML xml = (XML)this.value;
                return this.asXmlLiteral(nodeFactory, xml);
            }
            if (this.value instanceof XMLList) {
                return ValueInitializer.asXMLList(nodeFactory, (XMLList)this.value);
            }
            if (((Model)this.value).getType().equals(this.getTypeTable().objectType)) {
                return ValueInitializer.asObjectLiteral(nodeFactory, (Model)this.value);
            }
            assert (false) : "can't generate inline expr for values of type " + this.value.getClass();
            return null;
        }
        return this.formatExpr(nodeFactory, this.getLValueType(), this.value);
    }

    protected String getDefinitionName() {
        assert (this.hasDefinition()) : "no definition in getDefinitionName()";
        assert (this.value instanceof Model) : "non-Model value has definition in getDefinitionName()";
        return ((Model)this.value).getDefinitionName() + (((Model)this.value).isDeclared() ? "_i" : "_c");
    }

    protected CodeFragmentList getDefinitionBody() {
        Vector vector;
        String selfTypeName;
        assert (this.hasDefinition()) : "no definition in getDefinitionBody()";
        assert (this.value instanceof Model) : "non-Model value has definition in getDefinitionBody()";
        String varName = "temp";
        Model self = (Model)this.value;
        Type selfType = self.getType();
        if (this.value instanceof Vector) {
            Vector vector2 = (Vector)this.value;
            String elementTypeName = vector2.getElementTypeName();
            selfTypeName = StandardDefs.CLASS_VECTOR + ".<" + elementTypeName + ">";
        } else {
            selfTypeName = NameFormatter.toDot(selfType.getName());
        }
        boolean isDeclared = self.isDeclared();
        String id = isDeclared ? self.getId() : "temp";
        int line = this.getLineRef();
        CodeFragmentList list = new CodeFragmentList();
        list.add("private function ", this.getDefinitionName(), "() : ", selfTypeName, line);
        list.add("{", line);
        StringBuilder stringBuilder = new StringBuilder("\tvar temp : " + selfTypeName + " = ");
        if (this.modelHasInlineRValue()) {
            stringBuilder.append(this.getInlineRValue());
        } else if (this.value instanceof Vector) {
            vector = (Vector)this.value;
            stringBuilder.append("new " + selfTypeName + "(" + vector.size());
            if (vector.isFixed()) {
                stringBuilder.append(", true)");
            } else {
                stringBuilder.append(")");
            }
        } else {
            stringBuilder.append("new " + selfTypeName + "()");
        }
        stringBuilder.append(";");
        list.add(stringBuilder.toString(), line);
        if (!this.modelHasInlineRValue()) {
            if (this.value instanceof Vector) {
                vector = (Vector)this.value;
                ValueInitializer.addAssignExprs(list, vector.getElementInitializerIterator(), "temp");
            } else {
                ValueInitializer.addAssignExprs(list, self.getPropertyInitializerIterator(self.getType().hasDynamic()), "temp");
            }
        }
        ValueInitializer.addAssignExprs(list, self.getStyleInitializerIterator(), "temp");
        ValueInitializer.addAssignExprs(list, self.getEffectInitializerIterator(), "temp");
        ValueInitializer.addAssignExprs(list, self.getEventInitializerIterator(), "temp");
        String effectEventNames = self.getEffectNames();
        if (effectEventNames.length() > 0) {
            list.add("\t", "temp", ".registerEffects([ ", effectEventNames, " ]);", line);
        }
        if (isDeclared && this.standardDefs.isIUIComponentWithIdProperty(selfType)) {
            list.add("\t", "temp", ".id = \"", id, "\";", line);
        }
        if (this.standardDefs.isIUIComponent(selfType)) {
            Iterator<VisualChildInitializer> childIter;
            assert (self instanceof MovieClip) : "isIUIComponent(selfType) but !(self instanceof MovieClip)";
            list.add("\tif (!", "temp", ".document) ", "temp", ".document = this;", line);
            if (!this.standardDefs.isRepeater(selfType)) {
                if (this.standardDefs.isContainer(selfType)) {
                    list.add("\t", "temp", ".mx_internal::_documentDescriptor = ", line);
                    DescriptorGenerator.addDescriptorInitializerFragments(list, (MovieClip)self, "\t\t");
                    list.add("\t;", line);
                    list.add("\t", "temp", ".mx_internal::_documentDescriptor.document = this;", line);
                } else {
                    childIter = ((MovieClip)self).getChildInitializerIterator();
                    while (childIter.hasNext()) {
                        VisualChildInitializer init = childIter.next();
                        if (((Model)init.getValue()).isStateSpecific()) continue;
                        list.add("\t", init.getAssignExpr("temp"), ";", init.getLineRef());
                    }
                }
            } else {
                list.add("\tvar cd:Array = ", "temp", ".childDescriptors = [", line);
                childIter = ((MovieClip)self).children().iterator();
                while (childIter.hasNext()) {
                    VisualChildInitializer init = childIter.next();
                    DescriptorGenerator.addDescriptorInitializerFragments(list, (MovieClip)init.getValue(), "\t\t");
                    if (!childIter.hasNext()) continue;
                    list.add(",", 0);
                }
                list.add("\t];", line);
                list.add("\tfor (var i:int = 0; i < cd.length; i++) cd[i].document = this;", line);
            }
        }
        if (self.getType().isAssignableTo(this.standardDefs.INTERFACE_IMXMLOBJECT)) {
            String idParam = isDeclared ? TextGen.quoteWord(id) : NULL;
            list.add("\t", "temp", ".initialized(this, ", idParam, ")", line);
        }
        if (isDeclared) {
            if (self.getRepeaterLevel() == 0) {
                list.add("\t", id, " = ", "temp", ";", line);
            } else {
                ThreadLocalToolkit.log((CompilerMessage)new DeclaredAndProceduralWithinRepeater(), self.getDocument().getSourcePath(), line);
            }
        }
        list.add("\t", NameFormatter.toDot(this.standardDefs.CLASS_BINDINGMANAGER), ".executeBindings(this, ", TextGen.quoteWord(id), ", " + id + ");", line);
        if (this.standardDefs.isContainer(selfType) && self.isEarlyInit()) {
            list.add("\t", "temp", ".initialize();", line);
        }
        list.add("\treturn ", "temp", ";", line);
        list.add("}", line);
        Type lvalueType = this.getLValueType();
        if (this.standardDefs.isITransientDeferredInstance(lvalueType) || self.getIsTransient()) {
            list = this.getDestructorBody(list, line);
        }
        return list;
    }

    private void collectDeclarations(Iterator<Initializer> initializers, Set<String> ids) {
        Iterator<Initializer> iter = initializers;
        while (iter.hasNext()) {
            ValueInitializer valueInitializer;
            Object value;
            Initializer initializer = iter.next();
            if (!(initializer instanceof ValueInitializer) || !((value = (valueInitializer = (ValueInitializer)initializer).getValue()) instanceof Model)) continue;
            if (((Model)value).isDeclared()) {
                ids.add(((Model)value).getId());
            }
            this.collectDeclarations(((Model)value).getSubInitializerIterator(), ids);
        }
    }

    protected CodeFragmentList getDestructorBody(CodeFragmentList list, int line) {
        Model model = (Model)this.value;
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        if (model.isDeclared()) {
            ids.add(model.getId());
        }
        this.collectDeclarations(model.getSubInitializerIterator(), ids);
        list.add("\nprivate function ", model.getDefinitionName() + "_r", "() : void", line);
        list.add("{", line);
        for (String id : ids) {
            list.add("\t", id, " = null;", 0);
        }
        list.add("}", line);
        return list;
    }

    @Override
    public Iterator getDefinitionsIterator() {
        IteratorList iterList = null;
        if (!(!this.hasDefinition() || this.value instanceof Model && ((Model)this.value).isDescribed())) {
            iterList = new IteratorList();
            iterList.add((Iterator)new SingletonIterator((Object)this.getDefinitionBody()));
        }
        if (this.value instanceof Model) {
            (iterList != null ? iterList : (iterList = new IteratorList())).add(((Model)this.value).getSubDefinitionsIterator());
        }
        return iterList != null ? iterList.toIterator() : Collections.EMPTY_LIST.iterator();
    }

    public StatementListNode generateDefinitionBody(Context context, StatementListNode statementList) {
        LiteralStringNode literalString;
        ThisExpressionNode thisExpression;
        MemberExpressionNode varNameMemberExpression;
        ExpressionStatementNode expressionStatement;
        ListNode list;
        MemberExpressionNode memberExpression;
        SetExpressionNode selector;
        ExpressionStatementNode expressionStatement2;
        ListNode list2;
        MemberExpressionNode memberExpression2;
        ArgumentListNode argumentList;
        IdentifierNode identifier;
        MemberExpressionNode base;
        VariableDefinitionNode variableDefinition;
        String selfTypeName;
        assert (this.hasDefinition()) : "no definition in getDefinitionBody()";
        assert (this.value instanceof Model) : "non-Model value has definition in getDefinitionBody()";
        NodeFactory nodeFactory = context.getNodeFactory();
        StatementListNode result = statementList;
        String varName = TEMP;
        Model self = (Model)this.value;
        Type selfType = self.getType();
        if (this.value instanceof Vector) {
            Vector vector = (Vector)this.value;
            String elementTypeName = vector.getElementTypeName();
            selfTypeName = StandardDefs.CLASS_VECTOR + ".<" + elementTypeName + ">";
        } else {
            selfTypeName = NameFormatter.toDot(selfType.getName());
        }
        boolean isDeclared = self.isDeclared();
        String id = isDeclared ? self.getId() : varName;
        TypeExpressionNode returnType = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, selfTypeName, true);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, (Node)returnType);
        if (this.modelHasInlineRValue()) {
            variableDefinition = AbstractSyntaxTreeUtil.generateVariable(nodeFactory, varName, selfTypeName, true, this.generateInlineRValue(nodeFactory));
        } else if (this.value instanceof Vector) {
            Vector vector = (Vector)this.value;
            LiteralNumberNode literalNumber = nodeFactory.literalNumber(vector.size());
            ArgumentListNode argumentList2 = nodeFactory.argumentList(null, (Node)literalNumber);
            if (vector.isFixed()) {
                LiteralBooleanNode literalBoolean = nodeFactory.literalBoolean(vector.isFixed());
                argumentList2 = nodeFactory.argumentList(argumentList2, (Node)literalBoolean);
            }
            variableDefinition = AbstractSyntaxTreeUtil.generateVariableNew(nodeFactory, varName, selfTypeName, argumentList2);
        } else {
            variableDefinition = AbstractSyntaxTreeUtil.generateVariableNew(nodeFactory, varName, selfTypeName);
        }
        StatementListNode functionStatementList = nodeFactory.statementList(null, (Node)variableDefinition);
        if (!this.modelHasInlineRValue()) {
            if (this.value instanceof Vector) {
                Vector vector = (Vector)this.value;
                ValueInitializer.addAssignExprs(nodeFactory, functionStatementList, vector.getElementInitializerIterator(), varName);
            } else {
                ValueInitializer.addAssignExprs(nodeFactory, functionStatementList, self.getPropertyInitializerIterator(self.getType().hasDynamic()), varName);
            }
        }
        ValueInitializer.addAssignExprs(nodeFactory, functionStatementList, self.getStyleInitializerIterator(), varName);
        ValueInitializer.addAssignExprs(nodeFactory, functionStatementList, self.getEffectInitializerIterator(), varName);
        ValueInitializer.addAssignExprs(nodeFactory, functionStatementList, self.getEventInitializerIterator(), varName);
        Iterator<Initializer> iterator = self.getEffectInitializerIterator();
        if (iterator.hasNext()) {
            base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            identifier = nodeFactory.identifier(REGISTER_EFFECTS, false);
            ArgumentListNode effectEventNamesArgumentList = null;
            while (iterator.hasNext()) {
                EffectInitializer effectInitializer = (EffectInitializer)iterator.next();
                String effectName = effectInitializer.getName();
                LiteralStringNode literalString2 = nodeFactory.literalString(effectName);
                effectEventNamesArgumentList = nodeFactory.argumentList(effectEventNamesArgumentList, (Node)literalString2);
            }
            LiteralArrayNode literalArray = nodeFactory.literalArray(effectEventNamesArgumentList);
            ArgumentListNode argumentList3 = nodeFactory.argumentList(null, (Node)literalArray);
            CallExpressionNode selector2 = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList3);
            selector2.setRValue(false);
            MemberExpressionNode memberExpression3 = nodeFactory.memberExpression((Node)base, (SelectorNode)selector2);
            ListNode list3 = nodeFactory.list(null, (Node)memberExpression3);
            ExpressionStatementNode expressionStatement3 = nodeFactory.expressionStatement((Node)list3);
            functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement3);
        }
        if (isDeclared && this.standardDefs.isIUIComponentWithIdProperty(selfType)) {
            base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            identifier = nodeFactory.identifier(ID, false);
            LiteralStringNode literalString3 = nodeFactory.literalString(id);
            argumentList = nodeFactory.argumentList(null, (Node)literalString3);
            SetExpressionNode selector3 = nodeFactory.setExpression((Node)identifier, argumentList, false);
            memberExpression2 = nodeFactory.memberExpression((Node)base, (SelectorNode)selector3);
            list2 = nodeFactory.list(null, (Node)memberExpression2);
            expressionStatement2 = nodeFactory.expressionStatement((Node)list2);
            functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement2);
        }
        if (this.standardDefs.isIUIComponent(selfType)) {
            assert (self instanceof MovieClip) : "isIUIComponent(selfType) but !(self instanceof MovieClip)";
            MemberExpressionNode base2 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            IdentifierNode identifier2 = nodeFactory.identifier(DOCUMENT, false);
            GetExpressionNode selector4 = nodeFactory.getExpression(identifier2);
            MemberExpressionNode memberExpression4 = nodeFactory.memberExpression((Node)base2, (SelectorNode)selector4);
            Node unaryExpression = nodeFactory.unaryExpression(-4, (Node)memberExpression4);
            ListNode test = nodeFactory.list(null, unaryExpression);
            MemberExpressionNode base3 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            IdentifierNode identifier3 = nodeFactory.identifier(DOCUMENT, false);
            ThisExpressionNode thisExpression2 = nodeFactory.thisExpression(-1);
            ArgumentListNode argumentList4 = nodeFactory.argumentList(null, (Node)thisExpression2);
            selector = nodeFactory.setExpression((Node)identifier3, argumentList4, false);
            memberExpression = nodeFactory.memberExpression((Node)base3, (SelectorNode)selector);
            list = nodeFactory.list(null, (Node)memberExpression);
            expressionStatement = nodeFactory.expressionStatement((Node)list);
            StatementListNode then = nodeFactory.statementList(null, (Node)expressionStatement);
            Node ifStatement = nodeFactory.ifStatement(test, (Node)then, null);
            functionStatementList = nodeFactory.statementList(functionStatementList, ifStatement);
            if (!this.standardDefs.isRepeater(selfType)) {
                if (this.standardDefs.isContainer(selfType)) {
                    QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateMxInternalQualifiedIdentifier(nodeFactory, _DOCUMENT_DESCRIPTOR, false);
                    MemberExpressionNode descriptorsMemberExpression = ImplementationGenerator.addDescriptorInitializerFragments(nodeFactory, (MovieClip)self);
                    argumentList4 = nodeFactory.argumentList(null, (Node)descriptorsMemberExpression);
                    SetExpressionNode setExpression = nodeFactory.setExpression((Node)qualifiedIdentifier, argumentList4, false);
                    MemberExpressionNode base4 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
                    MemberExpressionNode memberExpression5 = nodeFactory.memberExpression((Node)base4, (SelectorNode)setExpression);
                    ListNode list4 = nodeFactory.list(null, (Node)memberExpression5);
                    ExpressionStatementNode expressionStatement4 = nodeFactory.expressionStatement((Node)list4);
                    functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement4);
                    MemberExpressionNode varNameMemberExpression2 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
                    QualifiedIdentifierNode qualifiedIdentifier2 = AbstractSyntaxTreeUtil.generateMxInternalQualifiedIdentifier(nodeFactory, _DOCUMENT_DESCRIPTOR, false);
                    GetExpressionNode documentDescriptorGetExpression = nodeFactory.getExpression((IdentifierNode)qualifiedIdentifier2);
                    MemberExpressionNode varNameDocumentDescriptorMemberExpression = nodeFactory.memberExpression((Node)varNameMemberExpression2, (SelectorNode)documentDescriptorGetExpression);
                    IdentifierNode identifier4 = nodeFactory.identifier(DOCUMENT, false);
                    ThisExpressionNode thisExpression3 = nodeFactory.thisExpression(-1);
                    ArgumentListNode argumentList5 = nodeFactory.argumentList(null, (Node)thisExpression3);
                    SetExpressionNode setExpression2 = nodeFactory.setExpression((Node)identifier4, argumentList5, false);
                    MemberExpressionNode memberExpression6 = nodeFactory.memberExpression((Node)varNameDocumentDescriptorMemberExpression, (SelectorNode)setExpression2);
                    ListNode list5 = nodeFactory.list(null, (Node)memberExpression6);
                    ExpressionStatementNode expressionStatement5 = nodeFactory.expressionStatement((Node)list5);
                    functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement5);
                } else {
                    Iterator<VisualChildInitializer> childIter = ((MovieClip)self).getChildInitializerIterator();
                    while (childIter.hasNext()) {
                        VisualChildInitializer init = childIter.next();
                        if (((Model)init.getValue()).isStateSpecific()) continue;
                        memberExpression2 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, true);
                        functionStatementList = init.generateAssignExpr(nodeFactory, functionStatementList, (Node)memberExpression2);
                    }
                }
            } else {
                VariableDefinitionNode childDescriptorVariableDefinition = this.generateChildDescriptorVariable(nodeFactory, varName, (MovieClip)self);
                functionStatementList = nodeFactory.statementList(functionStatementList, (Node)childDescriptorVariableDefinition);
                Node forStatement = this.generateRepeaterChildDescriptorLoop(nodeFactory);
                functionStatementList = nodeFactory.statementList(functionStatementList, forStatement);
            }
        }
        if (self.getType().isAssignableTo(this.standardDefs.INTERFACE_IMXMLOBJECT)) {
            varNameMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            identifier = nodeFactory.identifier(INITIALIZED, false);
            thisExpression = nodeFactory.thisExpression(-1);
            argumentList = nodeFactory.argumentList(null, (Node)thisExpression);
            if (isDeclared) {
                literalString = nodeFactory.literalString(id);
                argumentList = nodeFactory.argumentList(argumentList, (Node)literalString);
            } else {
                LiteralNullNode literalNull = nodeFactory.literalNull(-1);
                argumentList = nodeFactory.argumentList(argumentList, (Node)literalNull);
            }
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
            callExpression.setRValue(false);
            memberExpression2 = nodeFactory.memberExpression((Node)varNameMemberExpression, (SelectorNode)callExpression);
            list2 = nodeFactory.list(null, (Node)memberExpression2);
            expressionStatement2 = nodeFactory.expressionStatement((Node)list2);
            functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement2);
        }
        if (isDeclared) {
            if (self.getRepeaterLevel() == 0) {
                functionStatementList = this.generateValueCreation(nodeFactory, functionStatementList, id, varName);
            } else {
                ThreadLocalToolkit.log((CompilerMessage)new DeclaredAndProceduralWithinRepeater(), self.getDocument().getSourcePath(), this.getLineRef());
            }
        }
        base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, this.standardDefs.getBindingPackage(), BINDING_MANAGER, false);
        identifier = nodeFactory.identifier(EXECUTE_BINDINGS, false);
        thisExpression = nodeFactory.thisExpression(-1);
        argumentList = nodeFactory.argumentList(null, (Node)thisExpression);
        literalString = nodeFactory.literalString(id);
        argumentList = nodeFactory.argumentList(argumentList, (Node)literalString);
        MemberExpressionNode idMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, id, true);
        argumentList = nodeFactory.argumentList(argumentList, (Node)idMemberExpression);
        selector = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        selector.setRValue(false);
        memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        list = nodeFactory.list(null, (Node)memberExpression);
        expressionStatement = nodeFactory.expressionStatement((Node)list);
        functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement);
        if (this.standardDefs.isContainer(selfType) && self.isEarlyInit()) {
            varNameMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
            identifier = nodeFactory.identifier(INITIALIZE, false);
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, null);
            callExpression.setRValue(false);
            MemberExpressionNode memberExpression7 = nodeFactory.memberExpression((Node)varNameMemberExpression, (SelectorNode)callExpression);
            ListNode list6 = nodeFactory.list(null, (Node)memberExpression7);
            ExpressionStatementNode expressionStatement6 = nodeFactory.expressionStatement((Node)list6);
            functionStatementList = nodeFactory.statementList(functionStatementList, (Node)expressionStatement6);
        }
        MemberExpressionNode memberExpression8 = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, false);
        ListNode list7 = nodeFactory.list(null, (Node)memberExpression8);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)list7);
        functionStatementList = nodeFactory.statementList(functionStatementList, (Node)returnStatement);
        IdentifierNode functionIdentifier = nodeFactory.identifier(this.getDefinitionName());
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, functionIdentifier, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateAttribute(nodeFactory);
        FunctionNameNode functionName = nodeFactory.functionName(-133, functionIdentifier);
        FunctionDefinitionNode functionDefinition = nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
        result = nodeFactory.statementList(result, (Node)functionDefinition);
        Type lvalueType = this.getLValueType();
        if (this.standardDefs.isITransientDeferredInstance(lvalueType) || self.getIsTransient()) {
            result = this.generateDestructorBody(context, result);
        }
        return result;
    }

    protected StatementListNode generateDestructorBody(Context context, StatementListNode statementList) {
        Model model = (Model)this.value;
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        if (model.isDeclared()) {
            ids.add(model.getId());
        }
        this.collectDeclarations(model.getSubInitializerIterator(), ids);
        NodeFactory nodeFactory = context.getNodeFactory();
        StatementListNode result = statementList;
        StatementListNode functionStatementList = null;
        for (String id : ids) {
            LiteralNullNode literalNull = nodeFactory.literalNull();
            IdentifierNode identifier = nodeFactory.identifier(id);
            Node expressionStatement = nodeFactory.assignmentExpression((Node)identifier, -49, (Node)literalNull);
            functionStatementList = nodeFactory.statementList(functionStatementList, expressionStatement);
        }
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, null);
        functionSignature.void_anno = true;
        IdentifierNode functionIdentifier = nodeFactory.identifier(model.getDefinitionName() + "_r");
        FunctionCommonNode functionCommon = nodeFactory.functionCommon(context, functionIdentifier, functionSignature, functionStatementList);
        functionCommon.setUserDefinedBody(true);
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePrivateAttribute(nodeFactory);
        FunctionNameNode functionName = nodeFactory.functionName(-133, functionIdentifier);
        FunctionDefinitionNode functionDefinition = nodeFactory.functionDefinition(context, attributeList, functionName, functionCommon);
        result = nodeFactory.statementList(result, (Node)functionDefinition);
        return result;
    }

    public VariableDefinitionNode generateChildDescriptorVariable(NodeFactory nodeFactory, String varName, MovieClip movieClip) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, varName, true);
        IdentifierNode childDescriptorsIdentifier = nodeFactory.identifier(CHILD_DESCRIPTORS, false);
        ArgumentListNode visualChildArgumentList = null;
        for (VisualChildInitializer init : movieClip.children()) {
            MovieClip model = (MovieClip)init.getValue();
            MemberExpressionNode memberExpression = ImplementationGenerator.addDescriptorInitializerFragments(nodeFactory, model);
            visualChildArgumentList = nodeFactory.argumentList(visualChildArgumentList, (Node)memberExpression);
        }
        LiteralArrayNode literalArray = nodeFactory.literalArray(visualChildArgumentList);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalArray);
        SetExpressionNode selector = nodeFactory.setExpression((Node)childDescriptorsIdentifier, argumentList, false);
        selector.setRValue(false);
        MemberExpressionNode initializer = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, CD, ARRAY, false, (Node)initializer);
    }

    private VariableDefinitionNode generateClassVariable(NodeFactory nodeFactory) {
        IdentifierNode getDefinitionByNameIdentifier = nodeFactory.identifier(GET_DEFINITION_BY_NAME);
        LiteralStringNode literalString = nodeFactory.literalString(this.standardDefs.CLASS_PROPERTYCHANGEEVENT_DOT);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)getDefinitionByNameIdentifier, argumentList);
        callExpression.setRValue(false);
        MemberExpressionNode getDefinitionMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        IdentifierNode classIdentifier = nodeFactory.identifier(CLASS);
        GetExpressionNode getExpression = nodeFactory.getExpression(classIdentifier);
        MemberExpressionNode classMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)getExpression);
        BinaryExpressionNode binaryExpression = nodeFactory.binaryExpression(-60, (Node)getDefinitionMemberExpression, (Node)classMemberExpression);
        return AbstractSyntaxTreeUtil.generateVariable(nodeFactory, __CLASS, CLASS, false, (Node)binaryExpression);
    }

    @Override
    public StatementListNode generateDefinitions(Context context, HashSet<String> configNamespaces, StatementListNode statementList, boolean generateDocComments) {
        StatementListNode result = statementList;
        if (!(!this.hasDefinition() || this.value instanceof Model && ((Model)this.value).isDescribed())) {
            result = this.generateDefinitionBody(context, result);
        }
        if (this.value instanceof Model) {
            Iterator<Initializer> iterator = ((Model)this.value).getSubInitializerIterator();
            while (iterator.hasNext()) {
                result = iterator.next().generateDefinitions(context, configNamespaces, result, generateDocComments);
            }
        }
        return result;
    }

    private ExpressionStatementNode generateDispatchEvent(NodeFactory nodeFactory) {
        IdentifierNode dispatchEventIdentifier = nodeFactory.identifier(DISPATCH_EVENT, false);
        IdentifierNode eventIdentifier = nodeFactory.identifier(EVENT, false);
        MemberExpressionNode eMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, __E, false);
        ArgumentListNode eventArgumentList = nodeFactory.argumentList(null, (Node)eMemberExpression);
        CallExpressionNode eventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)eventIdentifier, eventArgumentList);
        eventCallExpression.setRValue(false);
        MemberExpressionNode eventMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)eventCallExpression);
        ArgumentListNode dispatchEventArgumentList = nodeFactory.argumentList(null, (Node)eventMemberExpression);
        CallExpressionNode dispatchEventCallExpression = (CallExpressionNode)nodeFactory.callExpression((Node)dispatchEventIdentifier, dispatchEventArgumentList);
        dispatchEventCallExpression.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression(null, (SelectorNode)dispatchEventCallExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private Node generateRepeaterChildDescriptorLoop(NodeFactory nodeFactory) {
        LiteralNumberNode initializer = nodeFactory.literalNumber(0);
        VariableDefinitionNode init = AbstractSyntaxTreeUtil.generateVariable(nodeFactory, I, INT, false, (Node)initializer);
        MemberExpressionNode iMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, I, false);
        MemberExpressionNode cdMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, CD, false);
        IdentifierNode lengthIdentifier = nodeFactory.identifier(LENGTH, false);
        GetExpressionNode lengthGetExpression = nodeFactory.getExpression(lengthIdentifier);
        MemberExpressionNode cdLengthMemberExpression = nodeFactory.memberExpression((Node)cdMemberExpression, (SelectorNode)lengthGetExpression);
        BinaryExpressionNode binaryExpression = nodeFactory.binaryExpression(-45, (Node)iMemberExpression, (Node)cdLengthMemberExpression);
        ListNode test = nodeFactory.list(null, (Node)binaryExpression);
        IdentifierNode iIdentifier = nodeFactory.identifier(I, false);
        IncrementNode increment = nodeFactory.increment(-43, (Node)iIdentifier, true);
        MemberExpressionNode incrMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)increment);
        ListNode incr = nodeFactory.list(null, (Node)incrMemberExpression);
        cdMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, CD, false);
        iMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, I, false);
        ArgumentListNode getArgumentList = nodeFactory.argumentList(null, (Node)iMemberExpression);
        GetExpressionNode iGetExpression = nodeFactory.getExpression((Node)getArgumentList);
        iGetExpression.setMode(-29);
        MemberExpressionNode base = nodeFactory.memberExpression((Node)cdMemberExpression, (SelectorNode)iGetExpression);
        IdentifierNode documentIdentifier = nodeFactory.identifier(DOCUMENT, false);
        ThisExpressionNode thisExpression = nodeFactory.thisExpression(-1);
        ArgumentListNode setArgumentList = nodeFactory.argumentList(null, (Node)thisExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)documentIdentifier, setArgumentList, false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode body = nodeFactory.statementList(null, (Node)expressionStatement);
        return nodeFactory.forStatement((Node)init, (Node)test, (Node)incr, (Node)body);
    }

    private StatementListNode generateValueCreation(NodeFactory nodeFactory, StatementListNode statementList, String id, String varName) {
        ExpressionStatementNode expressionStatement = AbstractSyntaxTreeUtil.generateAssignment(nodeFactory, id, varName);
        return nodeFactory.statementList(statementList, (Node)expressionStatement);
    }

    private TypeTable getTypeTable() {
        return this.getLValueType().getTypeTable();
    }

    private static void addAssignExprs(CodeFragmentList list, Iterator initIter, String name) {
        while (initIter.hasNext()) {
            Initializer init = (Initializer)initIter.next();
            if (init.isStateSpecific()) continue;
            list.add("\t", init.getAssignExpr(name), ";", init.getLineRef());
        }
    }

    private static void addAssignExprs(NodeFactory nodeFactory, StatementListNode statementList, Iterator<? extends Initializer> initIter, String name) {
        while (initIter.hasNext()) {
            Initializer init = initIter.next();
            if (init.isStateSpecific()) continue;
            MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, name, true);
            statementList = init.generateAssignExpr(nodeFactory, statementList, (Node)memberExpression);
        }
    }

    protected String formatExpr(Type targetType, Object value) {
        assert (targetType != null);
        assert (value != null);
        TypeTable typeTable = this.getTypeTable();
        if (value instanceof BindingExpression) {
            if (targetType.equals(typeTable.booleanType) || targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
                return "undefined";
            }
            return NULL;
        }
        if (value instanceof AtEmbed) {
            return ((AtEmbed)value).getPropName();
        }
        if (value instanceof AtResource) {
            return ((AtResource)value).getValueExpression();
        }
        if (targetType.equals(typeTable.stringType)) {
            return StringUtils.formatString((String)((String)value));
        }
        if (targetType.equals(typeTable.booleanType) || targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
            return value.toString();
        }
        if (targetType.equals(typeTable.objectType) || targetType.equals(typeTable.noType)) {
            if (value instanceof String) {
                return StringUtils.formatString((String)((String)value));
            }
            if (value instanceof Number || value instanceof Boolean) {
                return value.toString();
            }
            assert (false) : "formatExpr: unsupported rvalue type '" + value.getClass() + "' for lvalue type 'Object'";
        } else {
            if (targetType.equals(typeTable.classType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.functionType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.regExpType)) {
                return value.toString();
            }
            if (targetType.equals(typeTable.xmlType)) {
                return this.asXmlLiteral((XML)value);
            }
            if (targetType.equals(typeTable.xmlListType)) {
                return ValueInitializer.asXMLList((XMLList)value);
            }
            if (this.standardDefs.isInstanceGenerator(targetType)) {
                assert (false) : "formatExpr: instance generator lvalue with non-Model lvalue";
            } else assert (false) : "formatExpr: unsupported lvalue type: " + targetType.getName();
        }
        assert (false);
        return null;
    }

    protected Node formatExpr(NodeFactory nodeFactory, Type targetType, Object value) {
        assert (targetType != null);
        assert (value != null);
        TypeTable typeTable = this.getTypeTable();
        if (value instanceof BindingExpression) {
            if (targetType.equals(typeTable.booleanType) || targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
                return nodeFactory.identifier(UNDEFINED, false);
            }
            return nodeFactory.literalNull(-1);
        }
        if (value instanceof AtEmbed) {
            return AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, ((AtEmbed)value).getPropName(), true);
        }
        if (value instanceof AtResource) {
            return ((AtResource)value).getValueExpression(nodeFactory);
        }
        if (targetType.equals(typeTable.stringType)) {
            return nodeFactory.literalString(value.toString());
        }
        if (targetType.equals(typeTable.booleanType)) {
            return nodeFactory.literalBoolean(Boolean.parseBoolean(value.toString()));
        }
        if (targetType.equals(typeTable.numberType) || targetType.equals(typeTable.intType) || targetType.equals(typeTable.uintType)) {
            return nodeFactory.literalNumber(value.toString());
        }
        if (targetType.equals(typeTable.objectType) || targetType.equals(typeTable.noType)) {
            if (value instanceof String) {
                return nodeFactory.literalString((String)value);
            }
            if (value instanceof Number) {
                return nodeFactory.literalNumber(value.toString());
            }
            if (value instanceof Boolean) {
                return nodeFactory.literalBoolean(Boolean.parseBoolean(value.toString()));
            }
            assert (false) : "formatExpr: unsupported rvalue type '" + value.getClass() + "' for lvalue type 'Object'";
        } else {
            if (targetType.equals(typeTable.classType)) {
                if (value.equals(THIS)) {
                    return nodeFactory.thisExpression(-1);
                }
                if (value.equals(NULL)) {
                    return nodeFactory.literalNull(-1);
                }
                return AbstractSyntaxTreeUtil.generateMemberExpression(nodeFactory, value.toString());
            }
            if (targetType.equals(typeTable.functionType)) {
                String valueString = value.toString();
                int lastDotIndex = valueString.lastIndexOf(DOT);
                if (valueString.indexOf(DOT) != lastDotIndex) {
                    String fullyQualifiedClassName = valueString.substring(0, lastDotIndex);
                    String functionName = valueString.substring(lastDotIndex + 1);
                    MemberExpressionNode base = AbstractSyntaxTreeUtil.generateMemberExpression(nodeFactory, fullyQualifiedClassName);
                    IdentifierNode identifier = nodeFactory.identifier(functionName);
                    GetExpressionNode selector = nodeFactory.getExpression(identifier);
                    selector.setRValue(false);
                    return nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
                }
                return AbstractSyntaxTreeUtil.generateMemberExpression(nodeFactory, value.toString());
            }
            if (targetType.equals(typeTable.regExpType)) {
                return nodeFactory.literalRegExp(value.toString(), -1);
            }
            if (targetType.equals(typeTable.xmlType)) {
                return this.asXmlLiteral(nodeFactory, (XML)value);
            }
            if (targetType.equals(typeTable.xmlListType)) {
                return ValueInitializer.asXMLList(nodeFactory, (XMLList)value);
            }
            if (this.standardDefs.isInstanceGenerator(targetType)) {
                assert (false) : "formatExpr: instance generator lvalue with non-Model lvalue";
            } else assert (false) : "formatExpr: unsupported lvalue type: " + targetType.getName();
        }
        assert (false);
        return null;
    }

    private static String asArrayLiteral(Array array) {
        ArrayList<String> elements = new ArrayList<String>();
        Iterator<ArrayElementInitializer> iter = array.getElementInitializerIterator();
        while (iter.hasNext()) {
            ArrayElementInitializer initializer = iter.next();
            if (initializer.isStateSpecific()) continue;
            elements.add(initializer.getValueExpr());
        }
        return "[" + TextGen.toCommaList(elements.iterator()) + "]";
    }

    private static LiteralArrayNode asArrayLiteral(NodeFactory nodeFactory, Array array) {
        ArgumentListNode argumentList = null;
        Iterator<ArrayElementInitializer> iter = array.getElementInitializerIterator();
        while (iter.hasNext()) {
            ArrayElementInitializer initializer = iter.next();
            if (initializer.isStateSpecific()) continue;
            Node valueExprNode = initializer.generateValueExpr(nodeFactory);
            argumentList = nodeFactory.argumentList(argumentList, valueExprNode);
        }
        return nodeFactory.literalArray(argumentList);
    }

    private static String asObjectLiteral(Model model) {
        ArrayList<String> pairs = new ArrayList<String>();
        Iterator<Initializer> iter = model.getPropertyInitializerIterator();
        while (iter.hasNext()) {
            NamedInitializer init = (NamedInitializer)iter.next();
            pairs.add(init.getName() + ": " + init.getValueExpr());
        }
        return "{" + TextGen.toCommaList(pairs.iterator()) + "}";
    }

    private static LiteralObjectNode asObjectLiteral(NodeFactory nodeFactory, Model model) {
        ArgumentListNode argumentList = null;
        Iterator<Initializer> iter = model.getPropertyInitializerIterator();
        while (iter.hasNext()) {
            NamedInitializer init = (NamedInitializer)iter.next();
            IdentifierNode identifier = nodeFactory.identifier(init.getName());
            LiteralFieldNode literalField = nodeFactory.literalField((Node)identifier, init.generateValueExpr(nodeFactory));
            argumentList = nodeFactory.argumentList(argumentList, (Node)literalField);
        }
        return nodeFactory.literalObject(argumentList);
    }

    private static String asVectorLiteral(Vector vector) {
        ArrayList<String> elements = new ArrayList<String>();
        Iterator<ArrayElementInitializer> iter = vector.getElementInitializerIterator();
        while (iter.hasNext()) {
            ArrayElementInitializer initializer = iter.next();
            if (initializer.isStateSpecific()) continue;
            elements.add(initializer.getValueExpr());
        }
        return "new <" + vector.getElementTypeName() + ">[" + TextGen.toCommaList(elements.iterator()) + "]";
    }

    private static LiteralVectorNode asVectorLiteral(NodeFactory nodeFactory, Vector vector) {
        ArgumentListNode argumentList = null;
        Iterator<ArrayElementInitializer> iter = vector.getElementInitializerIterator();
        while (iter.hasNext()) {
            ArrayElementInitializer initializer = iter.next();
            if (initializer.isStateSpecific()) continue;
            Node valueExprNode = initializer.generateValueExpr(nodeFactory);
            argumentList = nodeFactory.argumentList(argumentList, valueExprNode);
        }
        ApplyTypeExprNode applyTypeExpr = AbstractSyntaxTreeUtil.generateApplyTypeExpr(nodeFactory, vector.getElementTypeName());
        return nodeFactory.literalVector((Node)applyTypeExpr, argumentList, 0);
    }

    private static String fixupXMLString(String orig) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < orig.length(); ++i) {
            if (orig.charAt(i) == '\r') continue;
            if (orig.charAt(i) == '\n') {
                result.append("\\n");
                continue;
            }
            if (orig.charAt(i) == '\"') {
                result.append('\\');
            }
            result.append(orig.charAt(i));
        }
        return result.toString();
    }

    private String asXmlLiteral(XML component) {
        String xml = component.getLiteralXML();
        if (component.getIsE4X()) {
            return xml;
        }
        StringBuilder buf = new StringBuilder(NameFormatter.toDot(this.standardDefs.CLASS_XMLUTIL) + ".createXMLDocument(\"");
        buf.append(ValueInitializer.fixupXMLString(xml));
        buf.append("\").firstChild");
        return buf.toString();
    }

    private Node asXmlLiteral(NodeFactory nodeFactory, XML component) {
        String xml = component.getLiteralXML();
        if (component.getIsE4X()) {
            LiteralStringNode literalString = nodeFactory.literalString(component.getLiteralXML());
            ListNode list = nodeFactory.list(null, (Node)literalString);
            return nodeFactory.literalXML(list, false, -1);
        }
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, this.standardDefs.getUtilsPackage(), XML_UTIL, false);
        IdentifierNode createXMLDocumentIdentifier = nodeFactory.identifier(CREATE_XML_DOCUMENT, false);
        LiteralStringNode literalString = nodeFactory.literalString(xml);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression((Node)createXMLDocumentIdentifier, argumentList);
        selector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        IdentifierNode firstChildIdentifier = nodeFactory.identifier(FIRST_CHILD, false);
        GetExpressionNode getExpression = nodeFactory.getExpression(firstChildIdentifier);
        return nodeFactory.memberExpression((Node)memberExpression, (SelectorNode)getExpression);
    }

    private static String asXMLList(XMLList component) {
        StringBuilder buf = new StringBuilder("<>");
        buf.append(component.getLiteralXML());
        buf.append("</>");
        return buf.toString();
    }

    private static LiteralXMLNode asXMLList(NodeFactory nodeFactory, XMLList component) {
        LiteralStringNode literalString = nodeFactory.literalString(component.getLiteralXML());
        ListNode list = nodeFactory.list(null, (Node)literalString);
        LiteralXMLNode literalXML = nodeFactory.literalXML(list, false, -1);
        literalXML.is_xmllist = true;
        return literalXML;
    }

    public String getComment() {
        if (this.value instanceof Model) {
            return ((Model)this.value).comment;
        }
        return null;
    }

    public static class DeclaredAndProceduralWithinRepeater
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5966918771156671871L;
    }
}

