/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ClassNode;
import flex2.compiler.mxml.dom.FunctionNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Assignable;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.MxmlDocument;

public class NodeTypeResolver
extends ValueNodeHandler {
    final TypeTable typeTable;
    Type type;

    public NodeTypeResolver(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    public Type resolveType(Node node, MxmlDocument document) {
        this.invoke(null, node, document);
        return this.type;
    }

    protected void componentNode(Assignable property, Node node, MxmlDocument document) {
        Type localType;
        String className;
        if (document != null && (className = document.getLocalClass(node.getNamespace(), node.getLocalPart())) != null && (localType = this.typeTable.getType(className)) != null) {
            this.type = localType;
            return;
        }
        this.type = this.typeTable.getType(node.getNamespace(), node.getLocalPart());
    }

    protected void arrayNode(Assignable property, ArrayNode node) {
        this.type = this.typeTable.arrayType;
    }

    protected void primitiveNode(Assignable property, PrimitiveNode node) {
        Class<?> nodeClass = node.getClass();
        Type type = nodeClass == BooleanNode.class ? this.typeTable.booleanType : (nodeClass == NumberNode.class ? this.typeTable.numberType : (nodeClass == IntNode.class ? this.typeTable.intType : (nodeClass == UIntNode.class ? this.typeTable.uintType : (nodeClass == StringNode.class ? this.typeTable.stringType : (nodeClass == ClassNode.class ? this.typeTable.classType : (this.type = nodeClass == FunctionNode.class ? this.typeTable.functionType : null))))));
        assert (this.type != null) : "unknown subclass of PrimitiveNode";
    }

    protected void vectorNode(Assignable property, VectorNode node) {
        this.type = this.typeTable.vectorType;
    }

    protected void xmlNode(Assignable property, XMLNode node) {
        if (node.isE4X()) {
            this.type = this.typeTable.xmlType;
        } else {
            this.type = this.typeTable.getType(StandardDefs.CLASS_XMLNODE);
            assert (this.type != null) : "MXML core type " + StandardDefs.CLASS_XMLNODE + " not loaded";
        }
    }

    protected void xmlListNode(Assignable property, XMLListNode node) {
        this.type = this.typeTable.xmlListType;
    }

    protected void modelNode(Assignable property, ModelNode node) {
        this.type = this.typeTable.objectType;
    }

    protected void inlineComponentNode(Assignable property, InlineComponentNode node) {
        this.type = this.typeTable.getType(this.typeTable.getStandardDefs().INTERFACE_IFACTORY);
        assert (this.type != null) : "MXML core type " + this.typeTable.getStandardDefs().INTERFACE_IFACTORY + " not loaded";
    }

    protected void reparentNode(Assignable property, ReparentNode node) {
        this.type = this.typeTable.objectType;
    }

    protected void stateNode(Assignable property, StateNode node) {
        this.type = this.typeTable.getType(node.getNamespace(), node.getLocalPart());
    }

    protected void cdataNode(Assignable property, CDATANode node) {
        this.type = this.typeTable.objectType;
    }

    protected void unknown(Assignable property, Node node) {
        this.type = null;
    }
}

