/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.PrefixMapping;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.XMLStringSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import macromedia.asc.util.IntegerPool;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLBuilder
extends AbstractBuilder {
    private String id;
    private Model parent;
    private boolean allowTopLevelBinding;
    private boolean allowTwoWayBind;
    XML xml;

    XMLBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        this(unit, typeTable, mxmlConfiguration, document, null);
        this.allowTopLevelBinding = true;
        this.allowTwoWayBind = true;
    }

    XMLBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.allowTopLevelBinding = false;
        this.allowTwoWayBind = false;
    }

    @Override
    public void analyze(XMLNode node) {
        this.id = (String)this.getLanguageAttributeValue(node, "id");
        boolean e4x = node.isE4X();
        Type t = this.typeTable.getType(this.standardDefs.getXmlBackingClassName(e4x));
        this.xml = new XML(this.document, t, this.parent, e4x, node.beginLine);
        if (this.id != null) {
            this.xml.setId(this.id, false);
        }
        StringWriter writer = new StringWriter();
        if (node.getChildCount() > 1) {
            this.log(node, (CompilerMessage)new OnlyOneRootTag());
        } else if (node.getChildCount() == 0) {
            writer.write("null");
        } else if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                if (be != null) {
                    if (this.allowTopLevelBinding) {
                        if (!be.isConstructTwoWay() || this.allowTwoWayBind) {
                            be.setDestination(this.xml);
                            writer.write("null");
                        } else {
                            this.log(cdata, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowed());
                        }
                    } else {
                        this.log(cdata, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
                    }
                } else {
                    this.log(node, (CompilerMessage)new RequireXMLContent());
                }
            }
        } else if (e4x) {
            this.processChildren(e4x, node, writer, null, new Stack<String>(), new Stack<PrefixMapping>());
        } else {
            this.processChildren(e4x, node, new XMLStringSerializer(writer), null, new Stack<String>(), null);
        }
        this.xml.setLiteralXML(writer.toString());
    }

    private void processNode(boolean e4x, Node node, Object serializer, String getElementsByLocalName, Stack<String> destinationPropertyStack, Stack<PrefixMapping> namespaces) {
        QNameMap<BindingExpression> attributeBindings = this.processAttributes(node);
        if (attributeBindings != null) {
            String destinationProperty = this.createExpression(destinationPropertyStack);
            for (QName attrName : attributeBindings.keySet()) {
                String attrExpr;
                String nsUri = null;
                int nsId = 0;
                if (e4x) {
                    nsUri = attrName.getNamespace();
                    if (nsUri.length() > 0) {
                        nsId = PrefixMapping.getNamespaceId(nsUri, namespaces);
                    } else {
                        PrefixMapping pm = namespaces.peek();
                        nsUri = pm.getUri();
                        nsId = pm.getNs();
                    }
                    attrExpr = nsId > 0 ? getElementsByLocalName + ".@ns" + nsId + "::" + attrName.getLocalPart() : getElementsByLocalName + ".@" + attrName.getLocalPart();
                } else {
                    attrExpr = getElementsByLocalName + ".attributes[\"" + attrName.getLocalPart() + "\"]";
                }
                BindingExpression be = (BindingExpression)attributeBindings.get(attrName);
                be.setDestinationE4X(e4x);
                be.setDestinationXMLAttribute(true);
                be.setDestinationLValue(attrExpr);
                be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                be.setDestination(this.xml);
                this.xml.setHasBindings(true);
                if (!e4x) continue;
                PrefixMapping.pushNamespaces(be, namespaces);
                if (nsUri.length() <= 0) continue;
                be.addNamespace(nsUri, nsId);
            }
        }
        try {
            if (e4x) {
                node.toStartElement((StringWriter)serializer);
            } else {
                QName qname = new QName(node.getNamespace(), node.getLocalPart(), node.getPrefix());
                ((XMLStringSerializer)serializer).startElement(qname, new AttributesHelper(node));
            }
            if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
                CDATANode cdata = (CDATANode)node.getChildAt(0);
                if (cdata.image.length() > 0) {
                    if (cdata.inCDATA) {
                        if (e4x) {
                            ((StringWriter)serializer).write("<![CDATA[" + cdata.image + "]]>");
                        } else {
                            ((XMLStringSerializer)serializer).writeString(cdata.image);
                        }
                    } else {
                        BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                        if (be != null) {
                            if (be.isConstructTwoWay() && !this.allowTwoWayBind) {
                                this.log(cdata, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowed());
                            } else {
                                String destinationProperty = this.createExpression(destinationPropertyStack);
                                be.setDestinationLValue(getElementsByLocalName);
                                be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                                be.setDestination(this.xml);
                                be.setDestinationXMLNode(true);
                                this.xml.setHasBindings(true);
                                if (e4x) {
                                    be.setDestinationE4X(true);
                                    PrefixMapping.pushNamespaces(be, namespaces);
                                }
                            }
                        } else if (e4x) {
                            ((StringWriter)serializer).write(TextParser.replaceBindingEscapesForE4X(cdata.image));
                        } else {
                            String text = TextParser.cleanupBindingEscapes(cdata.image);
                            text = TextParser.cleanupAtFunctionEscapes(text);
                            ((XMLStringSerializer)serializer).writeString(text);
                        }
                    }
                }
            } else {
                this.processChildren(e4x, node, serializer, getElementsByLocalName, destinationPropertyStack, namespaces);
            }
            if (e4x) {
                node.toEndElement((StringWriter)serializer);
            } else {
                ((XMLStringSerializer)serializer).endElement();
            }
        }
        catch (IOException e) {
            this.logError(node, e.getLocalizedMessage());
        }
    }

    private void processChildren(boolean e4x, Node node, Object serializer, String getElementsByLocalName, Stack<String> destinationProperty, Stack<PrefixMapping> namespaces) {
        this.assignIndices(node);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) {
                CDATANode cdata = (CDATANode)child;
                if (cdata.image.trim().length() > 0) {
                    this.log(child, (CompilerMessage)new MixedContent(child.image));
                    continue;
                }
                if (e4x) {
                    ((StringWriter)serializer).write(cdata.image);
                    continue;
                }
                try {
                    ((XMLStringSerializer)serializer).writeString(cdata.image);
                }
                catch (IOException e) {
                    this.logError(cdata, e.getLocalizedMessage());
                }
                continue;
            }
            if (e4x) {
                PrefixMapping.pushNodeNamespace(child, namespaces);
                if (getElementsByLocalName != null) {
                    StringBuilder e4xbuffer = new StringBuilder(getElementsByLocalName);
                    String destProp = child.getLocalPart();
                    if (child.getNamespace().length() > 0) {
                        PrefixMapping pm = namespaces.peek();
                        destProp = "ns" + pm.getNs() + "::" + destProp;
                    }
                    e4xbuffer.append(".").append(destProp).append("[").append(child.getIndex()).append("]");
                    destinationProperty.push(destProp);
                    this.processNode(e4x, child, serializer, e4xbuffer.toString(), destinationProperty, namespaces);
                    destinationProperty.pop();
                } else {
                    this.processNode(e4x, child, serializer, this.xml.getId(), destinationProperty, namespaces);
                }
                PrefixMapping.popNodeNamespace(namespaces);
                continue;
            }
            String classNamespaceUtil = NameFormatter.toDot(this.standardDefs.CLASS_NAMESPACEUTIL);
            this.document.addImport(classNamespaceUtil, node.beginLine);
            StringBuilder buffer = new StringBuilder(classNamespaceUtil + ".getElementsByLocalName(");
            buffer.append(getElementsByLocalName == null ? this.xml.getId() : getElementsByLocalName);
            buffer.append(", \"").append(child.getLocalPart()).append("\")[").append(child.getIndex()).append("]");
            destinationProperty.push(child.getLocalPart());
            this.processNode(e4x, child, serializer, buffer.toString(), destinationProperty, null);
            destinationProperty.pop();
        }
    }

    private QNameMap<BindingExpression> processAttributes(Node node) {
        QNameMap<BindingExpression> attributeBindings = null;
        Iterator<QName> i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = i.next();
            String value = (String)node.getAttributeValue(qname);
            BindingExpression be = this.textParser.parseBindingExpression(value, node.beginLine);
            if (be == null) continue;
            if (be.isConstructTwoWay() && !this.allowTwoWayBind) {
                this.log(node, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowed());
                continue;
            }
            if (attributeBindings == null) {
                attributeBindings = new QNameMap<BindingExpression>();
            }
            attributeBindings.put(qname, be);
            i.remove();
        }
        return attributeBindings;
    }

    private void assignIndices(Node parent) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Integer zero = IntegerPool.getNumber((int)0);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (child instanceof CDATANode) continue;
            if (!counts.containsKey(child.image)) {
                counts.put(child.image, zero);
                child.setIndex(0);
                continue;
            }
            int num = (Integer)counts.get(child.image) + 1;
            counts.put(child.image, IntegerPool.getNumber((int)num));
            child.setIndex(num);
        }
    }

    private String createExpression(Stack<String> stack) {
        StringBuilder buffer = new StringBuilder();
        int count = stack.size();
        for (int i = 0; i < count; ++i) {
            buffer.append((String)stack.get(i));
            if (i >= count - 1) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public static class RequireXMLContent
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2844205717905239917L;
    }

    public static class OnlyOneRootTag
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5956735990753539012L;
    }

    public static class MixedContent
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 8086425515879147830L;
        public String image;

        public MixedContent(String image) {
            this.image = image;
        }
    }

    class AttributesHelper
    implements Attributes {
        private String[] namespaces;
        private String[] localParts;
        private Object[] values;

        AttributesHelper(Node node) {
            this.namespaces = new String[node.getAttributeCount()];
            this.localParts = new String[node.getAttributeCount()];
            this.values = new Object[node.getAttributeCount()];
            Iterator<QName> names = node.getAttributeNames();
            int i = 0;
            while (names != null && names.hasNext()) {
                QName qname = names.next();
                this.namespaces[i] = qname.getNamespace();
                this.localParts[i] = qname.getLocalPart();
                this.values[i] = node.getAttributeValue(qname);
                ++i;
            }
        }

        public int getLength() {
            return this.values.length;
        }

        public String getURI(int index) {
            return this.namespaces[index];
        }

        public String getLocalName(int index) {
            return this.localParts[index];
        }

        public String getQName(int index) {
            if (this.namespaces[index] == null || this.namespaces[index].equals("")) {
                return this.localParts[index];
            }
            return this.namespaces[index] + ":" + this.localParts[index];
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getValue(int index) {
            return (String)this.values[index];
        }

        public int getIndex(String uri, String localName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.namespaces[i].equals(uri) || !this.localParts[i].equals(localName)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String qName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getValue(String uri, String localName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.namespaces[i].equals(uri) || !this.localParts[i].equals(localName)) continue;
                return (String)this.values[i];
            }
            return null;
        }

        public String getValue(String qName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return (String)this.values[i];
            }
            return null;
        }
    }
}

