/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.fxg;

import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import flex2.compiler.fxg.FlexGraphicNode;
import java.util.HashMap;
import java.util.Map;

public class FlexTextGraphicNode
extends TextGraphicNode {
    private static final String FXG_TRACKING_RIGHT_PROPERTY = "trackingRight";
    private static final String FXG_PARAGRAPH_START_INDENT_PROPERTY = "paragraphStartIndent";
    private static final String FXG_PARAGRAPH_SPACE_BEFORE_PROPERTY = "paragraphSpaceBefore";
    private static final String FXG_PARAGRAPH_END_INDENT_PROPERTY = "paragraphEndIndent";
    private static final String FXG_PARAGRAPH_SPACE_AFT_PROPERTY = "paragraphSpaceAft";
    private static final String DEFAULT_FXG_FONT_FAMILY = "Times New Roman";
    public Map<String, String> cachedAttributes;

    public FlexTextGraphicNode() {
        this.setAttribute("fontFamily", DEFAULT_FXG_FONT_FAMILY);
    }

    public void setAttribute(String name, String value) {
        super.setAttribute(name, value);
        name = FlexTextGraphicNode.translateAttribute(name);
        if (this.cachedAttributes == null) {
            this.cachedAttributes = new HashMap<String, String>(4);
        }
        this.cachedAttributes.put(name, value);
    }

    public void setDocumentNode(FXGNode root) {
        super.setDocumentNode(root);
        if (root instanceof FlexGraphicNode) {
            ((FlexGraphicNode)root).hasTextGraphic = true;
        }
    }

    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        }
        if (this.filters != null) {
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        }
        return graphicContext;
    }

    static String translateAttribute(String name) {
        if ("tracking".equals(name)) {
            name = FXG_TRACKING_RIGHT_PROPERTY;
        } else if ("marginLeft".equals(name)) {
            name = FXG_PARAGRAPH_START_INDENT_PROPERTY;
        } else if ("marginTop".equals(name)) {
            name = FXG_PARAGRAPH_SPACE_BEFORE_PROPERTY;
        } else if ("marginRight".equals(name)) {
            name = FXG_PARAGRAPH_END_INDENT_PROPERTY;
        } else if ("marginBottom".equals(name)) {
            name = FXG_PARAGRAPH_SPACE_AFT_PROPERTY;
        }
        return name;
    }
}

