/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.Descriptor;
import flash.css.StyleDeclaration;
import flash.css.StyleProperty;
import flash.css.StyleSelector;
import flex2.compiler.Source;
import flex2.compiler.css.Import;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleDef {
    private String subject;
    private Map<String, AtEmbed> atEmbeds = new HashMap<String, AtEmbed>();
    private Set<Import> imports = new HashSet<Import>();
    private List<String> effectStyles = new ArrayList<String>();
    private Map<String, StyleDeclaration> declarations;
    private boolean advanced;
    private boolean isTypeSelector;
    private List<StyleProperty> styles = new ArrayList<StyleProperty>();
    private MxmlDocument mxmlDocument;
    private Source source;
    private int lineNumber;
    private ContextStatics perCompileData;
    private static final String CLASS_REFERENCE = "ClassReference(";
    private static final String EMBED = "Embed(";
    public static final String GLOBAL = "global";
    public static final String UNIVERSAL = "*";
    private static final String PROPERTY_REFERENCE = "PropertyReference(";

    StyleDef(String subject, MxmlDocument mxmlDocument, Source source, int lineNumber, ContextStatics perCompileData) {
        this.subject = subject;
        this.mxmlDocument = mxmlDocument;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
        this.advanced = true;
        this.isTypeSelector = !GLOBAL.equals(subject) && !UNIVERSAL.equals(subject);
    }

    StyleDef(String name, boolean isTypeSelector, MxmlDocument mxmlDocument, Source source, int lineNumber, ContextStatics perCompileData) {
        this.subject = name;
        this.isTypeSelector = isTypeSelector;
        this.mxmlDocument = mxmlDocument;
        this.source = source;
        this.lineNumber = lineNumber;
        this.perCompileData = perCompileData;
    }

    void addDeclaration(String subject, StyleSelector selector, StyleDeclaration declaration) {
        String selectorString;
        StyleDeclaration decl;
        if (this.declarations == null) {
            this.declarations = new LinkedHashMap<String, StyleDeclaration>();
        }
        if ((decl = this.declarations.get(selectorString = selector.toString())) == null) {
            decl = declaration;
            ArrayList<StyleProperty> properties = new ArrayList<StyleProperty>();
            this.extractProperties(declaration, properties, declaration.getEffectStyles());
            decl.setSubject(subject);
            decl.setSelector(selector);
            decl.setProperties(properties);
            this.declarations.put(selectorString, decl);
        } else {
            this.extractProperties(declaration, decl.getProperties(), declaration.getEffectStyles());
        }
    }

    void addDeclaration(StyleDeclaration declaration) {
        this.extractProperties(declaration, this.styles, this.effectStyles);
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean value) {
        this.advanced = value;
    }

    public Collection<AtEmbed> getAtEmbeds() {
        return this.atEmbeds.values();
    }

    public Map<String, StyleDeclaration> getDeclarations() {
        return this.declarations;
    }

    public List<String> getEffectStyles() {
        return this.effectStyles;
    }

    public Set<Import> getImports() {
        return this.imports;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<StyleProperty> getStyles() {
        return this.styles;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTypeName() {
        if (UNIVERSAL.equals(this.subject)) {
            return GLOBAL;
        }
        return StyleDef.createTypeName(this.subject);
    }

    public boolean isTypeSelector() {
        return this.isTypeSelector;
    }

    public static String createTypeName(String subject) {
        subject = subject.replace('.', '_');
        return subject;
    }

    public static String dehyphenize(String string) {
        StringBuilder stringBuffer = new StringBuilder();
        int start = 0;
        int end = string.indexOf(45);
        while (end >= 0) {
            stringBuffer.append(string.substring(start, end));
            stringBuffer.append(Character.toUpperCase(string.charAt(end + 1)));
            start = end + 2;
            end = string.indexOf(45, start);
        }
        stringBuffer.append(string.substring(start));
        return stringBuffer.toString();
    }

    private void extractProperties(StyleDeclaration declaration, List<StyleProperty> properties, List<String> effectsStyles) {
        Iterator<Map.Entry<String, Descriptor>> propertyIterator = declaration.iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, Descriptor> entry = propertyIterator.next();
            Descriptor descriptor = entry.getValue();
            String propertyName = StyleDef.dehyphenize(descriptor.getName());
            try {
                if (propertyName.equals("fontFamily")) {
                    this.processFontFamily(properties, descriptor);
                    continue;
                }
                this.processPropertyDescriptor(propertyName, descriptor, properties, effectsStyles);
            }
            catch (CompilerMessage.CompilerError compilerError) {
                compilerError.setPath(descriptor.getPath());
                compilerError.setLine(descriptor.getLineNumber());
                ThreadLocalToolkit.log(compilerError);
            }
        }
    }

    private boolean addAtEmbed(AtEmbed atEmbed) {
        if (this.mxmlDocument != null) {
            this.mxmlDocument.addAtEmbed(atEmbed);
        } else if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return true;
    }

    private String processEmbed(String value, String styleSheetPath, int line) {
        String result = null;
        AtEmbed atEmbed = AtEmbed.create(this.perCompileData, this.source, value, styleSheetPath, line, "_embed_css_");
        if (atEmbed != null) {
            this.addAtEmbed(atEmbed);
            result = atEmbed.getPropName();
        }
        return result;
    }

    private String processReference(String value, String styleSheetPath, int line, boolean isClassReference) {
        String result = null;
        int prefixLength = isClassReference ? CLASS_REFERENCE.length() : PROPERTY_REFERENCE.length();
        String parameter = value.substring(prefixLength, value.length() - 1).trim();
        if (parameter.charAt(0) == '\"' && parameter.indexOf(34, 1) == parameter.length() - 1) {
            result = parameter.substring(1, parameter.length() - 1);
            if (isClassReference) {
                this.imports.add(new Import(result, line));
            }
        } else if (parameter.equals("null")) {
            result = parameter;
        } else {
            InvalidReference invalidReference = new InvalidReference(isClassReference);
            invalidReference.path = styleSheetPath;
            invalidReference.line = line;
            ThreadLocalToolkit.log(invalidReference);
        }
        return result;
    }

    private void processFontFamily(Collection<StyleProperty> properties, Descriptor descriptor) {
        String fontFamily = descriptor.getIdentAsString();
        StyleProperty stylesProperty = new StyleProperty("fontFamily", "\"" + fontFamily + "\"", descriptor.getLineNumber());
        properties.add(stylesProperty);
    }

    private void processPropertyDescriptor(String propertyName, Descriptor descriptor, Collection<StyleProperty> properties, List<String> effectStyles) throws CompilerMessage.CompilerError {
        String value;
        if (propertyName.endsWith("Effect")) {
            effectStyles.add(propertyName);
        }
        if ((value = this.processPropertyValue(descriptor)) != null) {
            StyleProperty styleProperty = new StyleProperty(propertyName, value, descriptor.getLineNumber());
            properties.add(styleProperty);
        }
    }

    private String processPropertyValue(Descriptor descriptor) throws CompilerMessage.CompilerError {
        String value = descriptor.getValueAsString();
        if (value.startsWith(EMBED)) {
            value = this.processEmbed(value, descriptor.getPath(), descriptor.getLineNumber());
        } else if (value.startsWith(CLASS_REFERENCE)) {
            value = this.processReference(value, descriptor.getPath(), descriptor.getLineNumber(), true);
        } else if (value.startsWith(PROPERTY_REFERENCE)) {
            value = this.processReference(value, descriptor.getPath(), descriptor.getLineNumber(), false);
        }
        if (!(this.advanced || this.mxmlDocument == null || descriptor.getValue().getLexicalUnitType() != 35 || value == null || value.length() <= 2 || value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"')) {
            String potentialProperty = value.substring(1, value.length() - 1);
            Type type = this.mxmlDocument.getRoot().getType();
            if (type != null && type.getProperty(potentialProperty) != null) {
                value = potentialProperty;
            }
            if (FrameworkDefs.isBuiltinEffectName(potentialProperty)) {
                this.mxmlDocument.addTypeRef(this.mxmlDocument.getStandardDefs().getEffectsPackage() + '.' + potentialProperty, descriptor.getLineNumber());
            }
        }
        return value;
    }

    public static class InvalidReference
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3730898410175891394L;
        public String type;

        public InvalidReference(boolean isClassReference) {
            this.type = isClassReference ? "Class" : "Property";
        }
    }
}

