/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.as3.reflect.As3Class;
import flex2.compiler.as3.reflect.Attributes;
import flex2.compiler.as3.reflect.TypeTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.semantics.ParameterizedName;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Variable
implements flex2.compiler.abc.Variable {
    private Attributes attributes;
    private flex2.compiler.util.QName qName;
    private String typeName;
    private String elementTypeName;
    private List<MetaData> metadata;
    private As3Class declaringClass;

    Variable(AttributeListNode attrs, VariableBindingNode binding, List<MetaData> metadata, As3Class declaringClass) {
        this.extractVariableTypeInfo(binding);
        if (attrs != null) {
            this.attributes = new Attributes(attrs);
            if (binding.kind == -65) {
                this.attributes.setHasConst();
            }
        }
        this.qName = new flex2.compiler.util.QName(TypeTable.getNamespace(this.attributes), binding.variable.identifier.name);
        this.metadata = metadata;
        this.declaringClass = declaringClass;
    }

    @Override
    public flex2.compiler.abc.Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public flex2.compiler.util.QName getQName() {
        return this.qName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getElementTypeName() {
        return this.elementTypeName;
    }

    @Override
    public List<MetaData> getMetaData() {
        return this.metadata != null ? this.metadata : Collections.emptyList();
    }

    @Override
    public List<MetaData> getMetaData(String id) {
        if (this.metadata == null) {
            return null;
        }
        ArrayList<MetaData> list = null;
        int length = this.metadata.size();
        for (int i = 0; i < length; ++i) {
            if (!id.equals(this.metadata.get(i).getID())) continue;
            if (list == null) {
                list = new ArrayList<MetaData>();
            }
            list.add(this.metadata.get(i));
        }
        return list;
    }

    @Override
    public AbcClass getDeclaringClass() {
        return this.declaringClass;
    }

    private void extractVariableTypeInfo(VariableBindingNode binding) {
        if (binding.variable.identifier.ref != null) {
            QName name = binding.variable.identifier.ref.slot.getType().getName();
            this.typeName = TypeTable.convertName(name.toString());
            if (name instanceof ParameterizedName) {
                ParameterizedName parameterizedName = (ParameterizedName)name;
                this.elementTypeName = TypeTable.convertName(((QName)parameterizedName.type_params.first()).toString());
            }
        } else if (binding.typeref != null) {
            this.typeName = TypeTable.convertName(binding.typeref);
            if (binding.typeref.type_params != null) {
                this.elementTypeName = TypeTable.convertName((ReferenceValue)binding.typeref.type_params.first());
            }
        } else {
            this.typeName = "*";
        }
    }
}

