/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.CompilationUnit;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.Attributes;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.binding.ArrayElementWatcher;
import flex2.compiler.as3.binding.DataBindingInfo;
import flex2.compiler.as3.binding.FunctionReturnWatcher;
import flex2.compiler.as3.binding.PropertyWatcher;
import flex2.compiler.as3.binding.RepeaterComponentWatcher;
import flex2.compiler.as3.binding.RepeaterItemWatcher;
import flex2.compiler.as3.binding.Watcher;
import flex2.compiler.as3.binding.XMLWatcher;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBindingFirstPassEvaluator
extends EvaluatorAdapter {
    private static final String BINDABLE = "Bindable";
    private static final String CHANGE_EVENT = "ChangeEvent";
    private static final String NON_COMMITTING_CHANGE_EVENT = "NonCommittingChangeEvent";
    private static final String EVENT = "event";
    private boolean showBindingWarnings;
    private TypeTable typeTable;
    private Stack<String> srcTypeStack;
    private Stack<Node> argumentListStack;
    private Set<ArgumentListNode> skipInitSet;
    private Set<Node> resetSet;
    private MemberExpressionNode xmlMember = null;
    private boolean insideRepeaterExpression = false;
    private boolean insideXMLExpression = false;
    private boolean insideBindingsSetupFunction = false;
    private boolean insideCallExpression = false;
    private boolean insideGetExpression = false;
    private boolean insideArrayExpression = false;
    private LinkedList<Watcher> watcherList;
    private ClassDefinitionNode currentClassDefinition;
    private BindingExpression currentBindingExpression;
    private int bindingId = 0;
    private int currentWatcherId = 0;
    private String bindingFunctionName;
    private List<BindingExpression> bindingExpressions;
    private Set<ClassDefinitionNode> evaluatedClasses;
    private DataBindingInfo dataBindingInfo;
    private List<DataBindingInfo> dataBindingInfoList;
    private boolean makeSecondPass = false;
    private StandardDefs standardDefs;

    public DataBindingFirstPassEvaluator(CompilationUnit unit, TypeTable typeTable, boolean showBindingWarnings) {
        List tmpBindingExpressions;
        this.typeTable = typeTable;
        this.argumentListStack = new Stack();
        this.skipInitSet = new HashSet<ArgumentListNode>();
        this.resetSet = new HashSet<Node>();
        this.srcTypeStack = new Stack();
        this.standardDefs = unit.getStandardDefs();
        this.bindingExpressions = tmpBindingExpressions = (List)unit.getContext().getAttribute("BindingExpressions");
        this.evaluatedClasses = new HashSet<ClassDefinitionNode>();
        this.dataBindingInfoList = new ArrayList<DataBindingInfo>();
        this.showBindingWarnings = showBindingWarnings;
        this.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
    }

    private boolean addBindables(Watcher watcher, List bindables) {
        boolean addedBindable = false;
        if (bindables != null) {
            for (MetaData metaData : bindables) {
                String event = this.getEventName(metaData);
                if (event != null) {
                    watcher.addChangeEvent(event);
                } else {
                    watcher.addChangeEvent("propertyChange");
                }
                addedBindable = true;
            }
        }
        return addedBindable;
    }

    private void checkForStaticProperty(Attributes attributes, Watcher watcher, String srcTypeName) {
        if (attributes != null && attributes.hasStatic() && watcher instanceof PropertyWatcher) {
            ((PropertyWatcher)watcher).setStaticProperty(true);
            watcher.setClassName(srcTypeName);
        }
    }

    private String getEventName(MetaData metaData) {
        String param;
        String eventName = metaData.getValue(EVENT);
        if (eventName != null) {
            return eventName;
        }
        if (metaData.count() == 1 && !(param = metaData.getValue(0)).equals(metaData.getID())) {
            return param;
        }
        return null;
    }

    private boolean addChangeEvents(Watcher watcher, List changeEvents) {
        boolean addedChangeEvent = false;
        if (changeEvents != null) {
            for (MetaData metaData : changeEvents) {
                String event = metaData.getValue(0);
                if (event == null) continue;
                watcher.addChangeEvent(event);
                addedChangeEvent = true;
            }
        }
        return addedChangeEvent;
    }

    private boolean addNonCommittingChangeEvents(Watcher watcher, List changeEvents) {
        boolean addedChangeEvent = false;
        if (changeEvents != null) {
            for (MetaData metaData : changeEvents) {
                String event = metaData.getValue(0);
                if (event == null) continue;
                watcher.addChangeEvent(event, false);
                addedChangeEvent = true;
            }
        }
        return addedChangeEvent;
    }

    @Override
    public Value evaluate(Context context, ArgumentListNode node) {
        if (this.insideBindingsSetupFunction) {
            int size = node.items.size();
            for (int i = 0; i < size; ++i) {
                Node argument = (Node)node.items.get(i);
                LinkedList<Watcher> tempWatcherList = this.watcherList;
                this.argumentListStack.push((Node)node);
                this.srcTypeStack.push((String)this.srcTypeStack.firstElement());
                if (!this.skipInitSet.remove(node)) {
                    this.watcherList = new LinkedList();
                }
                argument.evaluate(context, (Evaluator)this);
                if (this.resetSet.remove(node)) {
                    this.watcherList = tempWatcherList;
                }
                this.srcTypeStack.pop();
                this.argumentListStack.pop();
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, BinaryExpressionNode node) {
        if (node.lhs != null) {
            node.lhs.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction) {
            this.watcherList = new LinkedList();
        }
        if (node.rhs != null) {
            node.rhs.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction) {
            this.watcherList = new LinkedList();
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, CallExpressionNode node) {
        if (this.insideBindingsSetupFunction && node.expr != null) {
            if (this.insideRepeaterExpression && node.expr instanceof IdentifierNode && ((IdentifierNode)node.expr).name.equals("getItemAt")) {
                this.skipInitSet.add(node.args);
                node.args.evaluate(context, (Evaluator)this);
            } else {
                this.argumentListStack.push((Node)node.args);
                if (node.expr instanceof IdentifierNode) {
                    IdentifierNode identifier = (IdentifierNode)node.expr;
                    if (identifier.ref != null && identifier.ref.getType(context) != null && !identifier.name.equals(identifier.ref.getType((Context)context).getName().name)) {
                        this.insideCallExpression = true;
                        node.expr.evaluate(context, (Evaluator)this);
                        this.insideCallExpression = false;
                        this.resetSet.add((Node)node.args);
                    } else {
                        this.skipInitSet.add(node.args);
                    }
                } else assert (false) : "Unexpected CallExpressionNode.expr type: " + node.expr.getClass().getName();
                if (node.args != null) {
                    this.srcTypeStack.push((String)this.srcTypeStack.firstElement());
                    node.args.evaluate(context, (Evaluator)this);
                    this.srcTypeStack.pop();
                }
                this.argumentListStack.pop();
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.currentClassDefinition = node;
            String className = node.name.name;
            String convertedClassName = "_" + className.replace('.', '_').replace(':', '_');
            this.bindingFunctionName = convertedClassName + "_bindingsSetup";
            String fullyQualifiedClassName = node.cframe.name.toString();
            this.srcTypeStack.push(TypeTable.convertName(fullyQualifiedClassName));
            if (node.fexprs != null) {
                int size = node.fexprs.size();
                for (int i = 0; i < size; ++i) {
                    FunctionCommonNode functionCommon = (FunctionCommonNode)node.fexprs.get(i);
                    functionCommon.evaluate(context, (Evaluator)this);
                }
            }
            this.srcTypeStack.pop();
            if (this.dataBindingInfo != null) {
                this.dataBindingInfo.setBindingExpressions(this.bindingExpressions);
                this.dataBindingInfo.setClassName(fullyQualifiedClassName);
                this.dataBindingInfoList.add(this.dataBindingInfo);
                this.dataBindingInfo = null;
            }
            this.evaluatedClasses.add(node);
            this.currentClassDefinition = null;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, ConditionalExpressionNode node) {
        if (node.condition != null) {
            node.condition.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction) {
            this.watcherList = new LinkedList();
        }
        if (node.thenexpr != null) {
            node.thenexpr.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction) {
            this.watcherList = new LinkedList();
        }
        if (node.elseexpr != null) {
            node.elseexpr.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction) {
            this.watcherList = new LinkedList();
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, FunctionCommonNode functionCommon) {
        if (functionCommon.identifier != null && functionCommon.identifier.name.equals(this.bindingFunctionName)) {
            this.insideBindingsSetupFunction = true;
            this.dataBindingInfo = new DataBindingInfo(NodeMagic.getImports(this.currentClassDefinition.imported_names));
            for (int i = 0; i < functionCommon.body.items.size(); ++i) {
                Node item1 = (Node)functionCommon.body.items.get(i);
                if (!(item1 instanceof ExpressionStatementNode)) continue;
                ExpressionStatementNode expressionStatement1 = (ExpressionStatementNode)item1;
                ListNode list1 = (ListNode)expressionStatement1.expr;
                MemberExpressionNode memberExpression1 = (MemberExpressionNode)list1.items.get(0);
                SetExpressionNode setExpression = (SetExpressionNode)memberExpression1.selector;
                Node item2 = (Node)setExpression.args.items.get(0);
                if (!(item2 instanceof MemberExpressionNode)) continue;
                MemberExpressionNode memberExpression2 = (MemberExpressionNode)item2;
                if (!(memberExpression2.selector instanceof CallExpressionNode)) continue;
                CallExpressionNode callExpression = (CallExpressionNode)memberExpression2.selector;
                Node arg1 = (Node)callExpression.args.items.get(1);
                this.currentBindingExpression = this.bindingExpressions.get(this.bindingId++);
                this.watcherList = new LinkedList();
                if (arg1 instanceof FunctionCommonNode) {
                    FunctionCommonNode srcFunctionCommon = (FunctionCommonNode)arg1;
                    TypeExpressionNode typeExpression = (TypeExpressionNode)srcFunctionCommon.signature.result;
                    ObjectList items = srcFunctionCommon.body.items;
                    int size = items.size();
                    if (typeExpression != null && this.isArrayOrString(typeExpression)) {
                        ExpressionStatementNode expressionStatement3 = (ExpressionStatementNode)items.get(size - 3);
                        ListNode list2 = (ListNode)expressionStatement3.expr;
                        MemberExpressionNode memberExpression4 = (MemberExpressionNode)list2.items.get(0);
                        SetExpressionNode setExpression3 = (SetExpressionNode)memberExpression4.selector;
                        ((Node)setExpression3.args.items.get(0)).evaluate(context, (Evaluator)this);
                    } else {
                        ReturnStatementNode returnStatement = (ReturnStatementNode)items.get(size - 2);
                        returnStatement.expr.evaluate(context, (Evaluator)this);
                    }
                } else if (arg1 instanceof LiteralNullNode) {
                    LiteralStringNode literalString = (LiteralStringNode)callExpression.args.items.get(4);
                    String name = literalString.value;
                    PropertyWatcher watcher = this.watchExpressionStringAsProperty(name);
                    MultiName multiName = new MultiName("", name);
                    this.findEvents(context, name, multiName, arg1.pos(), watcher);
                } else assert (false) : arg1.getClass().getName();
                this.insideXMLExpression = false;
                this.xmlMember = null;
            }
            this.insideBindingsSetupFunction = false;
            this.makeSecondPass = true;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, GetExpressionNode node) {
        if (node.expr != null) {
            this.insideGetExpression = true;
            if (node.expr instanceof ArgumentListNode) {
                if (!this.insideRepeaterExpression) {
                    if (!this.insideXMLExpression && this.showBindingWarnings) {
                        context.localizedWarning2(node.pos(), (Object)new UnableToDetectSquareBracketChanges());
                    }
                    if (!this.insideXMLExpression) {
                        this.argumentListStack.push(node.expr);
                        this.watchExpressionArray();
                        this.argumentListStack.pop();
                    }
                    this.resetSet.add(node.expr);
                    node.expr.evaluate(context, (Evaluator)this);
                }
            } else {
                node.expr.evaluate(context, (Evaluator)this);
            }
            this.insideGetExpression = false;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, IdentifierNode node) {
        if (this.insideBindingsSetupFunction && !node.name.equals("instanceIndices")) {
            this.watchExpression(context, node, new MultiName(SymbolTable.VISIBILITY_NAMESPACES, node.name));
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, InvokeNode node) {
        if (this.insideBindingsSetupFunction && this.insideXMLExpression) {
            this.skipInitSet.add(node.args);
        }
        super.evaluate(context, node);
        return null;
    }

    @Override
    public Value evaluate(Context context, LiteralNumberNode node) {
        if (this.insideBindingsSetupFunction && this.insideGetExpression) {
            this.watchExpressionArray();
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, WithStatementNode node) {
        if (node.expr != null) {
            node.expr.evaluate(context, (Evaluator)this);
        }
        LinkedList<Watcher> savedWatcherList = this.watcherList;
        boolean normalWarningMode = this.showBindingWarnings;
        if (this.insideBindingsSetupFunction && !this.insideArrayExpression) {
            if (this.xmlMember != null) {
                XMLWatcher watcher = this.watchExpressionStringAsXML(this.xmlMember.ref.name);
                if (watcher != null) {
                    String name = this.xmlMember.ref.name;
                    MultiName multiName = new MultiName(SymbolTable.VISIBILITY_NAMESPACES, name);
                    this.findEvents(context, name, multiName, this.xmlMember.pos(), watcher);
                }
                this.xmlMember = null;
            }
            if (this.insideXMLExpression) {
                this.watcherList = new LinkedList();
                this.showBindingWarnings = false;
            }
        }
        if (node.statement != null) {
            node.statement.evaluate(context, (Evaluator)this);
        }
        if (this.insideBindingsSetupFunction && !this.insideArrayExpression && this.insideXMLExpression) {
            this.watcherList = savedWatcherList;
            this.showBindingWarnings = normalWarningMode;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, MemberExpressionNode node) {
        if (this.insideBindingsSetupFunction && !this.insideRepeaterExpression && this.isRepeaterBase(node.base)) {
            this.insideRepeaterExpression = true;
            node.base.evaluate(context, (Evaluator)this);
            this.srcTypeStack.push(null);
            node.selector.evaluate(context, (Evaluator)this);
            this.srcTypeStack.pop();
            this.insideRepeaterExpression = false;
        } else if (this.insideBindingsSetupFunction && this.isRepeaterIndicesBase(node.base)) {
            this.setupRepeaterWatchers(node);
        } else {
            ReferenceValue ref;
            int pushed = 0;
            boolean oldArrayExpression = this.insideArrayExpression;
            this.insideArrayExpression = node.isIndexedMemberExpression();
            if (node.base != null) {
                node.base.evaluate(context, (Evaluator)this);
                if (this.insideBindingsSetupFunction && (!this.insideArrayExpression || this.insideXMLExpression)) {
                    ReferenceValue ref2 = this.getRef(node);
                    this.pushSrcType(context, ref2, node.base);
                    ++pushed;
                }
            }
            boolean staticReference = false;
            if (this.insideBindingsSetupFunction && (ref = node.ref) != null) {
                String type;
                if (this.isStaticReference(node.selector, ref)) {
                    staticReference = true;
                    this.srcTypeStack.push(TypeTable.convertName(ref.slot.getObjectValue().toString()));
                    ++pushed;
                }
                if ((type = ref.getType(context).getName().toString()).equals("XML") || type.equals("XMLList")) {
                    this.xmlMember = node;
                    this.insideXMLExpression = true;
                }
            }
            if (node.selector != null && !staticReference) {
                node.selector.evaluate(context, (Evaluator)this);
            }
            this.insideArrayExpression = oldArrayExpression;
            for (int i = 0; i < pushed; ++i) {
                this.srcTypeStack.pop();
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, MetaDataNode node) {
        return null;
    }

    @Override
    public Value evaluate(Context context, QualifiedIdentifierNode node) {
        if (this.insideBindingsSetupFunction) {
            QName qName = NodeMagic.getQName(node);
            Map<Integer, String> namespaces = this.currentBindingExpression.getNamespaces();
            if (namespaces != null && namespaces.values().contains(qName.getNamespace())) {
                MultiName multiName = new MultiName(SymbolTable.VISIBILITY_NAMESPACES, qName.getLocalPart());
                this.watchExpression(context, (IdentifierNode)node, multiName);
            } else {
                this.watchExpression(context, node, qName);
            }
        }
        return null;
    }

    private void findEvents(Context context, String name, MultiName multiName, int pos, Watcher watcher) {
        AbcClass watchedClass;
        String srcTypeName = null;
        if (watcher.isPartOfAnonObjectGraph()) {
            srcTypeName = this.standardDefs.CLASS_OBJECTPROXY;
        } else if (!this.srcTypeStack.empty()) {
            srcTypeName = this.srcTypeStack.peek();
        }
        Watcher parentWatcher = watcher.getParent();
        if (parentWatcher != null && parentWatcher.isOperation()) {
            watcher.addChangeEvent("resultForBinding");
        } else if (srcTypeName != null && (watchedClass = this.typeTable.getClass(srcTypeName)) != null) {
            Method function;
            if (watchedClass.isSubclassOf(this.standardDefs.CLASS_OBJECTPROXY)) {
                watcher.setPartOfAnonObjectGraph(true);
            }
            List<MetaData> metaData = watchedClass.getMetaData(BINDABLE, true);
            boolean foundEvents = this.addBindables(watcher, metaData);
            boolean foundSource = false;
            Variable variable = watchedClass.getVariable(multiName.getNamespace(), multiName.getLocalPart(), true);
            if (variable != null) {
                metaData = variable.getMetaData(BINDABLE);
                foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                metaData = variable.getMetaData(CHANGE_EVENT);
                foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                metaData = variable.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                Attributes attributes = variable.getAttributes();
                if (!(attributes == null || !attributes.hasConst() || multiName.getLocalPart().equals("length") && variable.getDeclaringClass().getName().equals("Object"))) {
                    foundEvents = true;
                    if (watcher instanceof PropertyWatcher) {
                        ((PropertyWatcher)watcher).suppress();
                    }
                }
                if (!(attributes == null || multiName.getLocalPart().equals("length") && variable.getDeclaringClass().getName().equals("Object"))) {
                    this.checkForStaticProperty(attributes, watcher, srcTypeName);
                }
                foundSource = true;
            }
            if (!foundEvents) {
                Method setter;
                Method getter = watchedClass.getGetter(multiName.getNamespace(), multiName.getLocalPart(), true);
                if (getter != null) {
                    metaData = getter.getMetaData(BINDABLE);
                    foundEvents = this.addBindables(watcher, metaData);
                    metaData = getter.getMetaData(CHANGE_EVENT);
                    foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                    metaData = getter.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                    foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                    Attributes attributes = getter.getAttributes();
                    this.checkForStaticProperty(attributes, watcher, srcTypeName);
                    foundSource = true;
                }
                if ((setter = watchedClass.getSetter(multiName.getNamespace(), multiName.getLocalPart(), true)) != null) {
                    metaData = setter.getMetaData(BINDABLE);
                    foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                    metaData = setter.getMetaData(CHANGE_EVENT);
                    foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                    metaData = setter.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                    foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                    Attributes attributes = setter.getAttributes();
                    this.checkForStaticProperty(attributes, watcher, srcTypeName);
                    foundSource = true;
                } else if (getter != null) {
                    foundEvents = true;
                }
            }
            if (!foundSource && (function = watchedClass.getMethod(multiName.getNamespace(), multiName.getLocalPart(), true)) != null) {
                metaData = function.getMetaData(BINDABLE);
                foundEvents = this.addBindables(watcher, metaData) || foundEvents;
                metaData = function.getMetaData(CHANGE_EVENT);
                foundEvents = this.addChangeEvents(watcher, metaData) || foundEvents;
                metaData = function.getMetaData(NON_COMMITTING_CHANGE_EVENT);
                foundEvents = this.addNonCommittingChangeEvents(watcher, metaData) || foundEvents;
                foundSource = true;
                if (!foundEvents && !this.insideCallExpression) {
                    foundEvents = true;
                    if (watcher instanceof PropertyWatcher) {
                        ((PropertyWatcher)watcher).suppress();
                    }
                }
            }
            if (!foundSource && watchedClass.isSubclassOf(this.standardDefs.CLASS_ABSTRACTSERVICE)) {
                watcher.setOperation(true);
            } else if (!(foundEvents || watcher instanceof FunctionReturnWatcher || watcher instanceof XMLWatcher || watcher.isOperation() || watchedClass.getName().equals("Object") || watchedClass.getName().equals("*"))) {
                if (this.showBindingWarnings) {
                    context.localizedWarning2(pos, (Object)new UnableToDetectChanges(name));
                }
                if (watcher instanceof PropertyWatcher) {
                    ((PropertyWatcher)watcher).suppress();
                }
            }
        }
    }

    public List<DataBindingInfo> getDataBindingInfoList() {
        return this.dataBindingInfoList;
    }

    private ReferenceValue getRef(MemberExpressionNode node) {
        ReferenceValue ref = null;
        if (node.base instanceof CallExpressionNode) {
            CallExpressionNode base = (CallExpressionNode)node.base;
            ref = base.ref;
        } else if (node.base instanceof MemberExpressionNode) {
            MemberExpressionNode base = (MemberExpressionNode)node.base;
            ref = base.ref;
            if (ref == null || ref.slot == null) {
                ref = this.getRef(base);
            }
        } else if (node.base instanceof GetExpressionNode) {
            GetExpressionNode base = (GetExpressionNode)node.base;
            ref = base.ref;
        }
        return ref;
    }

    private boolean isRepeaterBase(Node node) {
        boolean result = false;
        if (node != null && node instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)node;
            if (memberExpression.base != null) {
                result = this.isRepeaterBase(memberExpression.base);
            } else if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    IdentifierNode identifier = (IdentifierNode)getExpression.expr;
                    if (this.currentBindingExpression.getRepeaterLevel(identifier.name) >= 0) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    private boolean isRepeaterIndicesBase(Node node) {
        boolean result = false;
        if (node != null && node instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)node;
            if (memberExpression.base != null) {
                result = this.isRepeaterIndicesBase(memberExpression.base);
            } else if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    IdentifierNode identifier = (IdentifierNode)getExpression.expr;
                    if (identifier.name.equals("repeaterIndices")) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    private boolean isStaticReference(SelectorNode selector, ReferenceValue referenceValue) {
        return (selector == null || selector instanceof GetExpressionNode) && referenceValue != null && referenceValue.slot != null && referenceValue.slot instanceof VariableSlot && referenceValue.slot.getType() != null && referenceValue.slot.getType().getName().ns.toString().equals("") && referenceValue.slot.getType().getName().name.equals("Class") && referenceValue.slot.getObjectValue() != null;
    }

    public boolean isArrayOrString(TypeExpressionNode typeExpression) {
        boolean result = false;
        if (typeExpression.expr instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)typeExpression.expr;
            if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    IdentifierNode identifier = (IdentifierNode)getExpression.expr;
                    if (identifier.name.equals("Array") || identifier.name.equals("String")) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public boolean makeSecondPass() {
        return this.makeSecondPass;
    }

    private void pushSrcType(Context context, ReferenceValue ref, Node base) {
        if (ref != null && ref.slot != null) {
            if (ref.slot.getObjectValue() != null && !ref.slot.getObjectValue().toString().equals("")) {
                this.srcTypeStack.push(TypeTable.convertName(ref.slot.getObjectValue().toString()));
            } else if (ref.getType(context) != null && !ref.getType(context).getName().toString().equals("")) {
                this.srcTypeStack.push(TypeTable.convertName(ref.getType(context).getName().toString()));
            } else if (ref.slot.getType() != null && !ref.slot.getType().getName().toString().equals("")) {
                this.srcTypeStack.push(TypeTable.convertName(ref.slot.getType().getName().toString()));
            } else {
                this.srcTypeStack.push(null);
            }
        } else if (base instanceof ThisExpressionNode) {
            this.srcTypeStack.push((String)this.srcTypeStack.firstElement());
        } else {
            this.srcTypeStack.push(null);
        }
    }

    private void setupRepeaterWatchers(MemberExpressionNode node) {
        Watcher repeaterWatcher;
        if (this.watcherList.isEmpty()) {
            GetExpressionNode getExpression = (GetExpressionNode)node.selector;
            ArgumentListNode argumentList = (ArgumentListNode)getExpression.expr;
            LiteralNumberNode literalNumber = (LiteralNumberNode)argumentList.items.get(0);
            int level = literalNumber.numericValue.intValue();
            repeaterWatcher = new PropertyWatcher(this.currentWatcherId++, this.currentBindingExpression.getRepeaterId(level));
            this.watcherList.addLast(repeaterWatcher);
        } else {
            repeaterWatcher = this.watcherList.getLast();
        }
        PropertyWatcher dataProviderWatcher = repeaterWatcher.getChild("dataProvider");
        if (dataProviderWatcher == null) {
            dataProviderWatcher = new PropertyWatcher(this.currentWatcherId++, "dataProvider");
            repeaterWatcher.addChild(dataProviderWatcher);
        }
        this.watcherList.addLast(dataProviderWatcher);
        dataProviderWatcher.addBindingExpression(this.currentBindingExpression);
        RepeaterItemWatcher repeaterItemWatcher = new RepeaterItemWatcher(this.currentWatcherId++);
        repeaterItemWatcher.addBindingExpression(this.currentBindingExpression);
        dataProviderWatcher.addChild(repeaterItemWatcher);
        this.watcherList.addLast(repeaterItemWatcher);
        if (node.selector instanceof GetExpressionNode) {
            GetExpressionNode getExpression = (GetExpressionNode)node.selector;
            if (getExpression.expr instanceof ArgumentListNode) {
                this.skipInitSet.add((ArgumentListNode)getExpression.expr);
            } else assert (false) : "Unexpected selector for repeaterIndices MemberExpressionNode";
        } else assert (false) : "Unexpected selector for repeaterIndices MemberExpressionNode";
    }

    private Watcher watchIdentifier(String name) {
        Watcher watcher = null;
        int size = this.srcTypeStack.size();
        if (!(!this.insideGetExpression || size == 1 && (name.equals("Infinity") || name.equals("-Infinity") || name.equals("NaN") || name.equals("undefined")))) {
            String src = this.srcTypeStack.peek();
            if (!this.watcherList.isEmpty() && this.watcherList.getLast() instanceof XMLWatcher || src != null && (src.equals("XML") || src.equals("XMLList"))) {
                watcher = this.watchExpressionStringAsXML(name);
                this.xmlMember = null;
            } else {
                watcher = this.watchExpressionStringAsProperty(name);
            }
        } else if (!(!this.insideCallExpression || size == 1 && (name.equals("Array") || name.equals("Boolean") || name.equals("decodeURI") || name.equals("decodeURIComponent") || name.equals("encodeURI") || name.equals("encodeURIComponent") || name.equals("escape") || name.equals("int") || name.equals("isFinite") || name.equals("isNaN") || name.equals("isXMLName") || name.equals("Number") || name.equals("Object") || name.equals("parseFloat") || name.equals("parseInt") || name.equals("trace") || name.equals("uint") || name.equals("unescape") || name.equals("XML") || name.equals("XMLList")))) {
            watcher = this.watchExpressionStringAsFunction(name);
        }
        return watcher;
    }

    private void watchExpression(Context context, IdentifierNode identifier, MultiName multiName) {
        String name = multiName.getLocalPart();
        Watcher watcher = this.watchIdentifier(name);
        if (watcher != null) {
            this.findEvents(context, name, multiName, identifier.pos(), watcher);
        }
    }

    private void watchExpression(Context context, QualifiedIdentifierNode qualifiedIdentifier, QName qName) {
        String name = qName.getNamespace() + "::" + qName.getLocalPart();
        Watcher watcher = this.watchIdentifier(name);
        if (watcher != null) {
            MultiName multiName = new MultiName(new String[]{qName.getNamespace()}, qName.getLocalPart());
            this.findEvents(context, name, multiName, qualifiedIdentifier.pos(), watcher);
        }
    }

    private void watchExpressionArray() {
        ArrayElementWatcher watcher = new ArrayElementWatcher(this.currentWatcherId++, this.currentBindingExpression, (ArgumentListNode)this.argumentListStack.peek());
        if (!this.watcherList.isEmpty()) {
            Watcher parentWatcher = this.watcherList.getLast();
            watcher.setParentWatcher(parentWatcher);
            parentWatcher.addChild(watcher);
            if (parentWatcher.isPartOfAnonObjectGraph()) {
                watcher.setPartOfAnonObjectGraph(true);
            }
        }
        this.watcherList.addLast(watcher);
    }

    private FunctionReturnWatcher watchExpressionStringAsFunction(String value) {
        FunctionReturnWatcher watcher = new FunctionReturnWatcher(this.currentWatcherId++, this.currentBindingExpression, value, (ArgumentListNode)this.argumentListStack.peek());
        if (!this.watcherList.isEmpty()) {
            Watcher parentWatcher = this.watcherList.getLast();
            parentWatcher.addChild(watcher);
            watcher.setParentWatcher(parentWatcher);
        } else {
            this.dataBindingInfo.getRootWatchers().put(value + watcher.getId(), watcher);
        }
        String src = this.srcTypeStack.peek();
        if (this.srcTypeStack.size() > 1 && src != null && this.srcTypeStack.firstElement() != src && this.watcherList.isEmpty()) {
            watcher.setClassName(src);
        }
        this.watcherList.addLast(watcher);
        return watcher;
    }

    private XMLWatcher watchExpressionStringAsXML(String value) {
        XMLWatcher watcher;
        if (this.watcherList.isEmpty()) {
            Map<String, Watcher> rootWatchers = this.dataBindingInfo.getRootWatchers();
            if (rootWatchers.containsKey(value)) {
                return null;
            }
            watcher = new XMLWatcher(this.currentWatcherId++, value);
            rootWatchers.put(value, watcher);
        } else {
            Watcher parentWatcher = this.watcherList.getLast();
            PropertyWatcher child = parentWatcher.getChild(value);
            if (child instanceof XMLWatcher) {
                watcher = (XMLWatcher)child;
            } else {
                watcher = new XMLWatcher(this.currentWatcherId++, value);
                parentWatcher.addChild(watcher);
            }
        }
        String src = this.srcTypeStack.peek();
        if (this.srcTypeStack.size() > 1 && src != null && this.srcTypeStack.firstElement() != src && this.watcherList.isEmpty()) {
            watcher.setClassName(src);
        }
        this.watcherList.addLast(watcher);
        watcher.addBindingExpression(this.currentBindingExpression);
        return watcher;
    }

    private PropertyWatcher watchExpressionStringAsProperty(String value) {
        PropertyWatcher watcher = null;
        if (this.watcherList.isEmpty()) {
            watcher = this.watchRootProperty(value);
        } else {
            Watcher parentWatcher = this.watcherList.getLast();
            watcher = parentWatcher.getChild(value);
            if (watcher == null) {
                watcher = new PropertyWatcher(this.currentWatcherId++, value);
                if (parentWatcher.isPartOfAnonObjectGraph()) {
                    watcher.setPartOfAnonObjectGraph(true);
                } else if (!parentWatcher.shouldWriteChildren()) {
                    watcher.setShouldWriteChildren(false);
                }
                parentWatcher.addChild(watcher);
            }
        }
        this.watcherList.addLast(watcher);
        watcher.addBindingExpression(this.currentBindingExpression);
        return watcher;
    }

    private PropertyWatcher watchRootProperty(String propertyName) {
        PropertyWatcher result;
        Map<String, Watcher> rootWatchers = this.dataBindingInfo.getRootWatchers();
        String key = propertyName;
        String srcType = this.srcTypeStack.peek();
        String className = null;
        if (this.srcTypeStack.size() > 1 && srcType != null && this.srcTypeStack.firstElement() != srcType) {
            className = srcType;
            key = className + "." + propertyName;
        }
        if ((result = (PropertyWatcher)rootWatchers.get(key)) == null) {
            Model destination = this.currentBindingExpression.getDestination();
            result = destination != null && destination.getRepeaterLevel() > 1 ? new RepeaterComponentWatcher(this.currentWatcherId++, propertyName, destination.getRepeaterLevel()) : new PropertyWatcher(this.currentWatcherId++, propertyName);
            if (className != null) {
                result.setClassName(className);
            }
            rootWatchers.put(key, result);
        }
        return result;
    }

    public class UnableToDetectSquareBracketChanges
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 5936329878115867103L;
    }

    public class UnableToDetectChanges
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -2290221228589394685L;
        public String name;

        public UnableToDetectChanges(String name) {
            this.name = name;
        }
    }
}

