/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.CompilationUnit;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.NameFormatter;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

class HostComponentEvaluator
extends EvaluatorAdapter {
    private CompilationUnit unit;
    private SymbolTable symbolTable;
    private static final String SKINHOSTCOMPONENT = "hostComponent".intern();
    private static final String BINDABLE = "Bindable".intern();

    HostComponentEvaluator(CompilationUnit unit, SymbolTable symbolTable) {
        this.unit = unit;
        this.symbolTable = symbolTable;
    }

    public Value evaluate(Context context, MetaDataNode node) {
        if ("HostComponent".equals(node.id) && NodeMagic.isClassDefinition(node)) {
            this.processHostComponentMetaData(context, node);
        }
        return null;
    }

    private void processHostComponentMetaData(Context cx, MetaDataNode node) {
        DefinitionNode def;
        if (node.count() == 1 && (def = node.def) instanceof ClassDefinitionNode) {
            this.unit.expressions.add(NameFormatter.toMultiName(node.getValue(0)));
            ClassDefinitionNode classDef = (ClassDefinitionNode)def;
            if (!this.classDeclaresIdentifier(cx, classDef, SKINHOSTCOMPONENT)) {
                NodeFactory nf = cx.getNodeFactory();
                MetaDataNode bindingMetaData = AbstractSyntaxTreeUtil.generateMetaData(nf, BINDABLE);
                bindingMetaData.id = BINDABLE;
                StatementListNode statementList = nf.statementList(classDef.statements, (Node)bindingMetaData);
                int listSize = node.def.metaData.items.size();
                if (listSize > 1) {
                    for (int ix = 0; ix < listSize; ++ix) {
                        DocCommentNode hostComponentComment;
                        String comment;
                        Node temp;
                        Node tempMeta = (Node)node.def.metaData.items.get(ix);
                        if (!(tempMeta instanceof MetaDataNode)) continue;
                        MetaDataNode tempMetaData = (MetaDataNode)tempMeta;
                        if (!"HostComponent".equals(tempMetaData.id) || ix >= listSize - 1 || !((temp = (Node)node.def.metaData.items.get(ix + 1)) instanceof DocCommentNode)) continue;
                        DocCommentNode tempDoc = (DocCommentNode)temp;
                        MetaDataEvaluator evaluator = new MetaDataEvaluator();
                        evaluator.evaluate(cx, tempDoc);
                        if (evaluator.doccomments == null || evaluator.doccomments.size() == 0 || (comment = ((DocCommentNode)evaluator.doccomments.get((int)0)).id) == null || (hostComponentComment = AbstractSyntaxTreeUtil.generateDocComment(nf, comment.intern())) == null) break;
                        statementList = nf.statementList(statementList, (Node)hostComponentComment);
                        break;
                    }
                }
                TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nf, node.getValue(0), true);
                Node variableDefinition = AbstractSyntaxTreeUtil.generatePublicVariable(cx, typeExpression, SKINHOSTCOMPONENT);
                classDef.statements = nf.statementList(statementList, variableDefinition);
            }
        }
    }

    private boolean classDeclaresIdentifier(Context cx, ClassDefinitionNode classDef, String identifier) {
        TypeAnalyzer typeAnalyzer = this.symbolTable.getTypeAnalyzer();
        String className = NodeMagic.getClassName(classDef);
        typeAnalyzer.evaluate(cx, classDef);
        ClassInfo classInfo = typeAnalyzer.getClassInfo(className);
        return classInfo != null && (classInfo.definesVariable(identifier) || classInfo.definesFunction(identifier, true) || classInfo.definesGetter(identifier, true) || classInfo.definesSetter(identifier, true));
    }
}

