/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tags.DefineBinaryData;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Transcoder;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.as3.EmbedEvaluator;
import flex2.compiler.as3.EmbedSkinClassEvaluator;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Iterator;
import java.util.Map;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.util.Context;

public final class EmbedExtension
implements Extension {
    private Transcoder[] transcoders;
    private String generatedOutputDir;
    private boolean checkDeprecation;

    public EmbedExtension(Transcoder[] transcoders, String generatedOutputDir, boolean checkDeprecation) {
        this.generatedOutputDir = generatedOutputDir;
        this.transcoders = transcoders;
        this.checkDeprecation = checkDeprecation;
    }

    public void parse1(CompilationUnit unit, TypeTable typeTable) {
        if (unit.metadata.size() > 0) {
            Node node = (Node)unit.getSyntaxTree();
            CompilerContext context = unit.getContext();
            Context cx = context.getAscContext();
            EmbedSkinClassEvaluator embedSkinClassEvaluator = new EmbedSkinClassEvaluator(unit);
            node.evaluate(cx, (Evaluator)embedSkinClassEvaluator);
        }
    }

    public void parse2(CompilationUnit unit, TypeTable typeTable) {
        if (unit.metadata.size() > 0) {
            EmbedEvaluator embedEvaluator = new EmbedEvaluator(unit, typeTable.getSymbolTable(), this.transcoders, this.generatedOutputDir, this.checkDeprecation);
            embedEvaluator.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
            Node node = (Node)unit.getSyntaxTree();
            CompilerContext context = unit.getContext();
            Context cx = context.getAscContext();
            node.evaluate(cx, (Evaluator)embedEvaluator);
        }
    }

    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    public void generate(CompilationUnit unit, TypeTable typeTable) {
        if (unit.hasAssets()) {
            Iterator<Map.Entry<String, AssetInfo>> ai = unit.getAssets().iterator();
            while (ai.hasNext()) {
                Map.Entry<String, AssetInfo> e = ai.next();
                String className = e.getKey();
                DefineTag defineTag = e.getValue().getDefineTag();
                AbcClass c = typeTable.getClass(className);
                if (c == null) continue;
                if (c.getAttributes() == null || !c.getAttributes().hasPublic()) {
                    ThreadLocalToolkit.log((CompilerMessage)new NonPublicAssetClass(c.getName()), unit.getSource().getNameForReporting());
                }
                IncompatibleAssetClass incompatibleAssetClass = null;
                if (defineTag instanceof DefineSprite && !c.isSubclassOf("flash.display:Sprite")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineSprite", "flash.display.Sprite");
                } else if (defineTag instanceof DefineBits && !c.isSubclassOf("flash.display:Bitmap")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineBits", "flash.display.Bitmap");
                } else if (defineTag instanceof DefineSound && !c.isSubclassOf("flash.media:Sound")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineSound", "flash.media.Sound");
                } else if (defineTag instanceof DefineFont && !c.isSubclassOf("flash.text:Font")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineFont", "flash.text.Font");
                } else if (defineTag instanceof DefineText && !c.isSubclassOf("flash.display:StaticText")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineText", "flash.display.StaticText");
                } else if (defineTag instanceof DefineEditText && !c.isSubclassOf("flash.display:TextField")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineEditText", "flash.display.TextField");
                } else if (defineTag instanceof DefineShape && !c.isSubclassOf("flash.display:Shape")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineShape", "flash.display.Shape");
                } else if (defineTag instanceof DefineButton && !c.isSubclassOf("flash.display:SimpleButton")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineButton", "flash.display.SimpleButton");
                } else if (defineTag instanceof DefineBinaryData && !c.isSubclassOf("flash.utils:ByteArray")) {
                    incompatibleAssetClass = new IncompatibleAssetClass(c.getName(), "DefineBinaryData", "flash.utils.ByteArray");
                }
                if (incompatibleAssetClass == null) continue;
                ThreadLocalToolkit.log((CompilerMessage)incompatibleAssetClass, unit.getSource().getNameForReporting());
            }
        }
    }

    public static class IncompatibleAssetClass
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 7943386121665703853L;
        public final String assetClass;
        public final String assetType;
        public final String requiredBase;

        public IncompatibleAssetClass(String assetClass, String assetType, String requiredBase) {
            this.assetClass = assetClass;
            this.assetType = assetType;
            this.requiredBase = requiredBase;
        }
    }

    public static class NonPublicAssetClass
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 1300245254451431087L;
        public final String assetClass;

        public NonPublicAssetClass(String assetClass) {
            this.assetClass = assetClass;
        }
    }
}

