/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.localization.LocalizationManager;
import flash.swf.tags.DefineTag;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcPathResolver;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Mxmlc;
import flex2.tools.oem.Script;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSwcContext {
    private static final String DOT_CSS = ".css";
    private static final String DOT_PROPERTIES = ".properties";
    private static final String LOCALE_SLASH = "locale/";
    private boolean locked = false;
    private SwcGroup swcGroup;
    private QNameMap<Source> def2source = new QNameMap();
    private QNameMap<SwcScript> def2script = new QNameMap();
    private Map<String, Source> name2source = new HashMap<String, Source>();
    private Map name2script = new HashMap();
    private QNameMap<Source> rb2source = new QNameMap();
    private QNameMap<Map<String, VirtualFile>> rb2file = new QNameMap();
    private Set<SwcComponent> components;
    private Set<String> packageNames = new HashSet<String>();
    private Set<String> externs = new HashSet<String>();
    private Set<String> includes = new LinkedHashSet<String>();
    private Map<String, VirtualFile> resourceIncludes = new HashMap<String, VirtualFile>();
    private Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();
    private int loaded = 0;
    private List<VirtualFile> themeStyles = new LinkedList<VirtualFile>();
    private List<String> errlocations = new LinkedList<String>();
    private StringBuilder ts = new StringBuilder();
    private boolean cacheSwcCompilationUnits;
    private Map<Source, String> obsoletedSources = new HashMap<Source, String>();
    private Set<Source> removedSources = new HashSet<Source>();

    public CompilerSwcContext() {
        this(false);
    }

    public CompilerSwcContext(boolean cacheSwcCompilationUnits) {
        this.cacheSwcCompilationUnits = cacheSwcCompilationUnits;
    }

    public int load(VirtualFile[] libPath, VirtualFile[] rslPath, VirtualFile[] themeFiles, VirtualFile[] includeLibraries, NameMappings mappings, TranslationFormat format, SwcCache swcCache) {
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark2("start loading swcs", true);
        }
        SwcGroup libGroup = null;
        if (libPath != null && libPath.length > 0) {
            libGroup = swcCache.getSwcGroup(libPath);
            this.addTimeStamps(libGroup);
        }
        SwcGroup rslGroup = null;
        if (rslPath != null && rslPath.length > 0) {
            rslGroup = swcCache.getSwcGroup(rslPath);
            this.externs.addAll(rslGroup.getScriptMap().keySet());
            this.addTimeStamps(rslGroup);
        }
        SwcGroup includeGroup = null;
        if (includeLibraries != null && includeLibraries.length > 0) {
            includeGroup = swcCache.getSwcGroup(includeLibraries);
            this.includes.addAll(includeGroup.getScriptMap().keySet());
            this.addResourceIncludes(includeGroup.getFiles());
            this.addTimeStamps(includeGroup);
            this.files.putAll(includeGroup.getFiles());
        }
        LinkedList<SwcGroup> groupList = new LinkedList<SwcGroup>();
        groupList.add(libGroup);
        groupList.add(rslGroup);
        groupList.add(includeGroup);
        for (int i = 0; themeFiles != null && i < themeFiles.length; ++i) {
            if (themeFiles[i].getName().endsWith(DOT_CSS)) {
                this.themeStyles.add(themeFiles[i]);
                this.ts.append(themeFiles[i].getLastModified());
                continue;
            }
            SwcGroup tmpThemeGroup = swcCache.getSwcGroup(new VirtualFile[]{themeFiles[i]});
            groupList.add(tmpThemeGroup);
            for (VirtualFile f : tmpThemeGroup.getFiles().values()) {
                this.ts.append(f.getLastModified());
                if (!f.getName().endsWith(DOT_CSS)) continue;
                this.themeStyles.add(f);
            }
        }
        this.swcGroup = swcCache.getSwcGroup(groupList);
        if (this.swcGroup == null) {
            return 0;
        }
        this.toQNameMap(this.def2script, this.name2script, this.swcGroup.getScriptMap());
        this.updateResourceBundles(this.swcGroup.getFiles(), format);
        this.updateObsoletedSources();
        Set<QName> qnames = this.swcGroup.getQNames();
        for (QName qName : qnames) {
            this.packageNames.add(qName.getNamespace());
        }
        ThreadLocalToolkit.getPathResolver().addSinglePathResolver(new SwcPathResolver(this.swcGroup));
        mappings.addMappings(this.swcGroup.getNameMappings());
        int num = this.swcGroup.getNumberLoaded();
        this.loaded += num;
        if (ThreadLocalToolkit.getBenchmark() != null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new Mxmlc.LoadedSWCs(this.loaded)));
        }
        return num;
    }

    public int load(VirtualFile[] libPath, NameMappings mappings, String resourceFileExt, SwcCache swcCache) {
        int retval = this.load(libPath, null, null, null, mappings, null, swcCache);
        if (this.swcGroup != null) {
            this.updateResourceBundles(this.swcGroup.getFiles(), resourceFileExt);
        }
        return retval;
    }

    private void addResourceIncludes(Map<String, VirtualFile> files) {
        for (String fileName : files.keySet()) {
            if (!fileName.startsWith(LOCALE_SLASH) || !fileName.endsWith(DOT_PROPERTIES)) continue;
            int begin = LOCALE_SLASH.length();
            begin = fileName.indexOf("/", begin) + 1;
            int end = fileName.length() - DOT_PROPERTIES.length();
            this.resourceIncludes.put(fileName.substring(begin, end).replace('/', '.'), files.get(fileName));
        }
    }

    public VirtualFile getFile(String name) {
        return this.swcGroup != null ? this.swcGroup.getFile(name) : null;
    }

    public Map<String, VirtualFile> getFiles() {
        return this.swcGroup != null ? this.swcGroup.getFiles() : Collections.emptyMap();
    }

    private void addTimeStamps(SwcGroup libGroup) {
        if (libGroup != null) {
            List<Long> lastModified = libGroup.getSwcTimes();
            int size = lastModified.size();
            for (int i = 0; i < size; ++i) {
                this.ts.append(lastModified.get(i));
            }
        }
    }

    public VirtualFile[] getVirtualFiles(String[] locales, String namespaceURI, String localPart) {
        Map<String, VirtualFile> rbFiles = this.rb2file.get(namespaceURI, localPart);
        if (rbFiles == null || locales.length == 0) {
            return null;
        }
        VirtualFile[] rbList = locales.length == 0 ? null : new VirtualFile[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            rbList[i] = rbFiles.get(locales[i]);
        }
        return rbList;
    }

    public Source getResourceBundle(String[] locales, String namespaceURI, String localPart) {
        if (locales.length == 0) {
            return null;
        }
        if (this.rb2source.containsKey(namespaceURI, localPart)) {
            return this.rb2source.get(namespaceURI, localPart);
        }
        Source s = null;
        VirtualFile[] rbList = this.getVirtualFiles(locales, namespaceURI, localPart);
        if (rbList != null && rbList.length > 0) {
            String name = null;
            for (int i = 0; i < rbList.length; ++i) {
                if (rbList[i] == null) continue;
                name = rbList[i].getName();
                break;
            }
            if (name != null) {
                s = new Source(new ResourceFile(name, locales, rbList, new VirtualFile[rbList.length]), null, namespaceURI.replace('.', '/'), localPart, this, false, false, false);
                this.rb2source.put(namespaceURI, localPart, s);
            }
        }
        return s;
    }

    public Map<Source, String> getObsoletedSources() {
        return this.obsoletedSources;
    }

    public Set<Source> getRemovedSources() {
        return this.removedSources;
    }

    public Source getSource(String name) {
        if (this.name2source.containsKey(name)) {
            return this.name2source.get(name);
        }
        SwcScript script = (SwcScript)this.name2script.get(name);
        Source s = null;
        if (script != null && (s = this.createSource(script)) != null) {
            this.name2source.put(name, s);
            for (QName qName : s.getCompilationUnit().topLevelDefinitions) {
                this.def2source.put(qName.getNamespace(), qName.getLocalPart(), s);
            }
        }
        return s;
    }

    public Source getSource(String namespaceURI, String localPart) {
        SwcScript script;
        Source s = this.def2source.get(namespaceURI, localPart);
        if (s == null && (script = this.def2script.get(namespaceURI, localPart)) != null && (s = this.createSource(script)) != null) {
            Iterator<String> iterator = script.getDefinitionIterator();
            while (iterator.hasNext()) {
                this.def2source.put(new QName(iterator.next()), s);
            }
            this.name2source.put(s.getName(), s);
            CompilationUnit cachedCompilationUnit = script.getCompilationUnit();
            if (cachedCompilationUnit != null && (s.isInternal() || cachedCompilationUnit.hasTypeInfo)) {
                Source.copyCompilationUnit(cachedCompilationUnit, s.getCompilationUnit());
            }
            if (this.cacheSwcCompilationUnits) {
                script.setCompilationUnit(s.getCompilationUnit());
            }
        }
        return s;
    }

    private Source createSource(SwcScript script) {
        String loc = script.getLibrary().getSwcLocation();
        InMemoryFile f = new InMemoryFile(script.getDoABC().abc, script.toString(), "application/x-actionscript-bytecode", script.getLastModified());
        Source s = loc.endsWith("playerglobal.swc") || loc.endsWith("airglobal.swc") || loc.endsWith("avmplus.swc") ? new Source((VirtualFile)f, "", "", script, true, false, false) : new Source((VirtualFile)f, "", "", script, false, false, false);
        s.setPathResolver(null);
        CompilationUnit u = s.newCompilationUnit(null, new CompilerContext());
        u.setSignatureChecksum(script.getSignatureChecksum());
        Iterator<String> i = script.getDefinitionIterator();
        while (i.hasNext()) {
            u.topLevelDefinitions.add(new QName(i.next()));
        }
        SwcDependencySet set = script.getDependencySet();
        Iterator<String> i2 = set.getDependencyIterator("i");
        while (i2 != null && i2.hasNext()) {
            u.inheritance.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("s");
        while (i2 != null && i2.hasNext()) {
            u.types.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("n");
        while (i2 != null && i2.hasNext()) {
            u.namespaces.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("e");
        while (i2 != null && i2.hasNext()) {
            u.expressions.add(new MultiName(i2.next()));
        }
        i2 = script.getSymbolClasses().iterator();
        while (i2.hasNext()) {
            u.expressions.add(new MultiName(i2.next()));
        }
        i2 = script.getDefinitionIterator();
        while (i2.hasNext()) {
            String name = i2.next();
            DefineTag tag = script.getLibrary().getSymbol(name);
            if (tag == null) continue;
            u.getAssets().add(name, tag);
        }
        if (loc.trim().length() < loc.length()) {
            this.errlocations.add(loc.trim());
            return null;
        }
        return s;
    }

    public int getNumberLoaded() {
        return this.loaded;
    }

    public Set<String> getExterns() {
        return this.externs;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Map<String, VirtualFile> getResourceIncludes() {
        return this.resourceIncludes;
    }

    public Map<String, VirtualFile> getIncludeFiles() {
        return this.files;
    }

    public boolean hasPackage(String packageName) {
        return this.packageNames.contains(packageName);
    }

    public boolean hasDefinition(QName qName) {
        return this.def2script.get(qName.getNamespace(), qName.getLocalPart()) != null;
    }

    public List<VirtualFile> getThemeStyleSheets() {
        return this.themeStyles;
    }

    public List<String> errorLocations() {
        return this.errlocations;
    }

    public int checksum() {
        byte[] b = null;
        try {
            b = this.ts.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            b = this.ts.toString().getBytes();
        }
        int checksum = 0;
        for (int i = 0; i < b.length; ++i) {
            checksum += b[i];
        }
        return checksum;
    }

    public void close() {
        if (!this.locked && this.swcGroup != null) {
            this.swcGroup.close();
        }
    }

    public void setLock(boolean lock) {
        this.locked = lock;
    }

    public Swc getSwc(String name) {
        return this.swcGroup != null ? this.swcGroup.getSwc(name) : null;
    }

    private void toQNameMap(QNameMap<SwcScript> qNameMap, Map scriptNameMap, Map scriptMap) {
        for (String key : scriptMap.keySet()) {
            SwcScript value = (SwcScript)scriptMap.get(key);
            qNameMap.put(new QName(key), value);
        }
    }

    private void updateObsoletedSources() {
        Map<SwcScript, String> obsoleted = this.swcGroup.getObsoleted();
        for (Map.Entry<SwcScript, String> entry : obsoleted.entrySet()) {
            Source source;
            SwcScript swcScript = entry.getKey();
            CompilationUnit compilationUnit = swcScript.getCompilationUnit();
            if (compilationUnit == null || (source = compilationUnit.getSource()) == null || source.getOwner() != swcScript) continue;
            this.obsoletedSources.put(source, entry.getValue());
        }
    }

    private void updateResourceBundles(Map files, TranslationFormat format) {
        Iterator i = files.keySet().iterator();
        while (format != null && i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(LOCALE_SLASH)) continue;
            VirtualFile file = (VirtualFile)files.get(name);
            int prefixLength = LOCALE_SLASH.length();
            int index = name.indexOf(47, prefixLength);
            String mimeType = file.getMimeType();
            if (index == -1 || !format.isSupported(mimeType)) continue;
            String locale = name.substring(prefixLength, index);
            String ext = MimeMappings.getExtension(mimeType);
            QName rbName = new QName(NameFormatter.toColon(name.substring(index + 1, name.length() - ext.length()).replace('/', '.')));
            HashMap<String, VirtualFile> rbFiles = (HashMap<String, VirtualFile>)this.rb2file.get(rbName);
            if (rbFiles == null) {
                rbFiles = new HashMap<String, VirtualFile>();
                this.rb2file.put(rbName, rbFiles);
            }
            rbFiles.put(locale, file);
        }
    }

    private void updateResourceBundles(Map files, String ext) {
        Iterator i = files.keySet().iterator();
        while (ext != null && i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(LOCALE_SLASH) || !name.endsWith(ext)) continue;
            VirtualFile file = (VirtualFile)files.get(name);
            int prefixLength = LOCALE_SLASH.length();
            int index = name.indexOf(47, prefixLength);
            if (index == -1) continue;
            String locale = name.substring(prefixLength, index);
            QName rbName = new QName(NameFormatter.toColon(name.substring(index + 1, name.length() - ext.length()).replace('/', '.')));
            HashMap<String, VirtualFile> rbFiles = (HashMap<String, VirtualFile>)this.rb2file.get(rbName);
            if (rbFiles == null) {
                rbFiles = new HashMap<String, VirtualFile>();
                this.rb2file.put(rbName, rbFiles);
            }
            rbFiles.put(locale, file);
        }
    }

    public Iterator<QName> getDefinitionIterator() {
        return this.def2script.keySet().iterator();
    }

    SwcScript getScript(QName qName) {
        return (SwcScript)this.def2script.get(qName);
    }

    public Script getScript(QName def, boolean includeBytecodes) {
        SwcScript s = (SwcScript)this.def2script.get(def);
        return s != null ? s.toScript(includeBytecodes) : null;
    }

    public Iterator<SwcComponent> getComponentIterator() {
        if (this.components == null) {
            this.components = new HashSet<SwcComponent>();
            Iterator<QName> i = this.getDefinitionIterator();
            while (i.hasNext()) {
                QName def = i.next();
                SwcScript script = (SwcScript)this.def2script.get(def);
                SwcComponent c = script.getLibrary().getSwc().getComponent(def.toString());
                if (c == null) continue;
                this.components.add(c);
            }
        }
        return this.components.iterator();
    }

    public NameMappings getNameMappings() {
        return this.swcGroup != null ? this.swcGroup.getNameMappings() : null;
    }

    public Long getChecksum(QName def) {
        if (def == null) {
            throw new NullPointerException("getCheckSum: def may not be null");
        }
        SwcScript script = (SwcScript)this.def2script.get(def);
        if (script != null) {
            return script.getSignatureChecksum();
        }
        return null;
    }

    SwcScript getCachedScript(QName qName) {
        return (SwcScript)this.def2script.get(qName);
    }

    Set<Source> cachedSources() {
        HashSet<Source> result = new HashSet<Source>();
        for (SwcScript swcScript : this.def2script.values()) {
            Source source;
            CompilationUnit compilationUnit = swcScript.getCompilationUnit();
            if (compilationUnit == null || (source = compilationUnit.getSource()) == null || source.getCompilationUnit() == null || !source.isInternal() && !source.getCompilationUnit().hasTypeInfo) continue;
            result.add(source);
        }
        return result;
    }

    public static class Loaded
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 250929749146786933L;
        public final int loaded;

        public Loaded(int loaded) {
            this.loaded = loaded;
        }
    }
}

