/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Descriptor;
import flash.css.StyleProperty;
import flash.css.StyleSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.css.sac.LexicalUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleDeclaration {
    private int lineNumber;
    private String path;
    private List<String> effectStyles = new ArrayList<String>();
    private LinkedHashMap<String, Descriptor> descriptors = new LinkedHashMap();
    private String subject;
    private StyleSelector selector;
    private List<StyleProperty> properties = new ArrayList<StyleProperty>();

    public StyleDeclaration(String path, int lineNumber) {
        this.path = path;
        this.lineNumber = lineNumber;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public StyleSelector getSelector() {
        return this.selector;
    }

    public void setSelector(StyleSelector selector) {
        this.selector = selector;
    }

    public List<StyleProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<StyleProperty> properties) {
        this.properties = properties;
    }

    public List<String> getEffectStyles() {
        return this.effectStyles;
    }

    public void addEffectStyle(String propertyName) {
        this.effectStyles.add(propertyName);
    }

    public Descriptor getDescriptorValue(String name) {
        return this.descriptors.get(name);
    }

    public void setDescriptor(String propertyName, LexicalUnit value, String priority) {
        this.descriptors.put(propertyName, new Descriptor(propertyName, value, this.path));
    }

    public Descriptor removeDescriptor(String name) {
        return (Descriptor)this.descriptors.remove(name);
    }

    public Iterator<Map.Entry<String, Descriptor>> iterator() {
        return this.descriptors.entrySet().iterator();
    }

    public StyleDeclaration shallowCopy() {
        StyleDeclaration decl = new StyleDeclaration(this.path, this.lineNumber);
        decl.subject = this.subject;
        decl.selector = this.selector;
        decl.effectStyles = this.effectStyles;
        decl.descriptors = this.descriptors;
        decl.properties = this.properties;
        return decl;
    }
}

