/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flex2.compiler.CompilerAPI;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Mxmlc;
import flex2.tools.ToolsConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineConfiguration
extends ToolsConfiguration {
    private String resourceModulePath;
    private String dumpConfigFile = null;
    private List<String> fileSpecs = new ArrayList<String>();
    private List<String> resourceBundles = new LinkedList<String>();
    private VirtualFile configFile;
    private String output = null;
    private VirtualFile projector;

    public String getTargetFile() {
        if (this.compilingResourceModule()) {
            return this.resourceModulePath;
        }
        return this.fileSpecs.size() > 0 ? this.fileSpecs.get(this.fileSpecs.size() - 1) : null;
    }

    public List<String> getFileList() {
        if (this.compilingResourceModule()) {
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(this.resourceModulePath);
            return fileList;
        }
        return this.fileSpecs;
    }

    public boolean compilingResourceModule() {
        boolean b;
        boolean bl = b = this.fileSpecs.size() == 0 && this.getIncludeResourceBundles().size() > 0;
        if (b && this.resourceModulePath == null) {
            this.resourceModulePath = I18nUtils.getGeneratedResourceModule(this).getPath();
        }
        return b;
    }

    @Override
    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        String targetFile;
        super.validate(cfgbuf);
        if (this.dumpConfigFile != null) {
            ThreadLocalToolkit.log(new Mxmlc.DumpConfig(this.dumpConfigFile));
            File f = new File(this.dumpConfigFile);
            String text = FileConfigurator.formatBuffer(cfgbuf, "flex-config", ThreadLocalToolkit.getLocalizationManager(), "flex2.configuration");
            try {
                PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(f)));
                out.write(text);
                out.close();
            }
            catch (Exception e) {
                throw new ConfigurationException.IOError(this.dumpConfigFile);
            }
        }
        if ((targetFile = this.getTargetFile()) == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        VirtualFile virt = this.getVirtualFile(targetFile);
        if (virt == null && this.checkTargetFileInFileSystem()) {
            throw new ConfigurationException.IOError(targetFile);
        }
        if (virt != null && this.getCompilerConfiguration().keepGeneratedActionScript()) {
            String dir = FileUtils.addPathComponents((String)virt.getParent(), (String)"generated", (char)File.separatorChar);
            this.getCompilerConfiguration().setGeneratedDirectory(FileUtils.canonicalPath((File)new File(dir)));
            File gd = new File(this.getCompilerConfiguration().getGeneratedDirectory());
            gd.mkdirs();
        }
    }

    protected VirtualFile getVirtualFile(String targetFile) throws ConfigurationException {
        return CompilerAPI.getVirtualFile(targetFile);
    }

    protected boolean checkTargetFileInFileSystem() {
        return true;
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) {
        try {
            return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cfgval);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    public void cfgDumpConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.dumpConfigFile = Configuration.getOutputPath(cv, filename);
    }

    public static ConfigurationInfo getDumpConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public List<String> getFileSpecs() {
        return this.fileSpecs;
    }

    public void cfgFileSpecs(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    public static ConfigurationInfo getFileSpecsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public List<String> getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List<String> includeResourceBundles) {
        this.resourceBundles.addAll(this.toQNameString(includeResourceBundles));
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getLoadConfig() {
        return this.configFile;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cv);
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public String getOutput() {
        return this.output;
    }

    public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.output = Configuration.getOutputPath(val, output);
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean isRequired() {
                return false;
            }
        };
    }

    public VirtualFile getProjector() {
        return this.projector;
    }

    public void cfgProjector(ConfigurationValue cfgval, String path) {
        this.projector = this.getVirtualFile(path, cfgval);
    }

    public static ConfigurationInfo getProjectorInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }
}

