/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.SwcDependencyInfo;
import flex2.compiler.util.SwcDependencyInfoImpl;
import flex2.compiler.util.SwcExternalScriptInfo;
import flex2.compiler.util.SwcExternalScriptInfoImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcDependencyUtil {
    public static SwcDependencyInfo getSwcDependencyInfo(VirtualFile[] swcs, String[] dependencyTypesArray, boolean minimizeDependencySet) {
        String swcLocation;
        HashSet<String> scriptDependencyTypes = dependencyTypesArray != null ? new HashSet<String>(Arrays.asList(dependencyTypesArray)) : null;
        SwcCache cache = new SwcCache();
        SwcGroup swcGroup = cache.getSwcGroup(swcs);
        cache.setLazyRead(true);
        SwcDependencyInfoImpl depInfo = new SwcDependencyInfoImpl();
        HashMap swcDefMap = new HashMap(swcGroup.getNumberLoaded());
        HashMap<String, SwcExternalScriptInfoImpl> swcExternMap = new HashMap<String, SwcExternalScriptInfoImpl>(swcGroup.getNumberLoaded());
        for (Map.Entry<String, Swc> swcEntry : swcGroup.getSwcs().entrySet()) {
            if (swcDefMap.get(swcEntry.getValue().getLocation()) != null) continue;
            HashMap<String, SwcScript> defMap = new HashMap<String, SwcScript>();
            swcLocation = swcEntry.getValue().getLocation();
            SwcExternalScriptInfoImpl externalScripts = new SwcExternalScriptInfoImpl(swcLocation);
            swcDefMap.put(swcLocation, defMap);
            swcExternMap.put(swcLocation, externalScripts);
            depInfo.addSwcExternals(swcLocation, externalScripts);
            Iterator<SwcLibrary> swcLibraryIter = swcEntry.getValue().getLibraryIterator();
            while (swcLibraryIter.hasNext()) {
                SwcScript swcScript;
                SwcLibrary swcLibrary = swcLibraryIter.next();
                Iterator<SwcScript> scriptIter = swcLibrary.getScriptIterator();
                while (scriptIter.hasNext()) {
                    swcScript = scriptIter.next();
                    Iterator<String> defIter = swcScript.getDefinitionIterator();
                    while (defIter.hasNext()) {
                        String definition = defIter.next();
                        defMap.put(definition, swcScript);
                    }
                }
                scriptIter = swcLibrary.getScriptIterator();
                while (scriptIter.hasNext()) {
                    swcScript = scriptIter.next();
                    Iterator<String> typeIter = swcScript.getDependencySet().getTypeIterator();
                    while (typeIter.hasNext()) {
                        String type = typeIter.next();
                        if (scriptDependencyTypes != null && !scriptDependencyTypes.contains(type)) continue;
                        Iterator scriptDepIter = swcScript.getDependencySet().getDependencyIterator(type);
                        while (scriptDepIter.hasNext()) {
                            String scriptDep = (String)scriptDepIter.next();
                            SwcScript dependentScript = (SwcScript)defMap.get(scriptDep);
                            if (dependentScript != null) continue;
                            externalScripts.addScriptDependencyType(scriptDep, type);
                        }
                    }
                }
            }
        }
        HashMap<String, Set<String>> dependencyMap = null;
        if (minimizeDependencySet) {
            dependencyMap = new HashMap<String, Set<String>>(swcGroup.getNumberLoaded());
        }
        for (Map.Entry swcExternEntry : swcExternMap.entrySet()) {
            swcLocation = (String)swcExternEntry.getKey();
            SwcExternalScriptInfoImpl externalInfo = (SwcExternalScriptInfoImpl)swcExternEntry.getValue();
            HashSet<String> dependencyList = null;
            if (minimizeDependencySet && (dependencyList = (HashSet<String>)dependencyMap.get(swcLocation)) == null) {
                dependencyList = new HashSet<String>();
                dependencyMap.put(swcLocation, dependencyList);
            }
            for (String externName : externalInfo.getExternalScripts()) {
                for (Map.Entry swcDefEntry : swcDefMap.entrySet()) {
                    Map externMap2;
                    String swcLocation2 = (String)swcDefEntry.getKey();
                    if (swcLocation2.equals(swcLocation) || (externMap2 = (Map)swcDefEntry.getValue()).get(externName) == null) continue;
                    if (minimizeDependencySet) {
                        dependencyList.add(swcLocation2);
                    } else {
                        depInfo.addDependency(swcLocation, swcLocation2);
                    }
                    externalInfo.addResolvingSwc(externName, swcLocation2);
                }
            }
        }
        if (minimizeDependencySet) {
            for (Map.Entry swcExternEntry : swcExternMap.entrySet()) {
                swcLocation = (String)swcExternEntry.getKey();
                SwcDependencyUtil.removeDependencySubsets(swcLocation, dependencyMap, depInfo);
                for (String swcDependLocation : (Set)dependencyMap.get(swcLocation)) {
                    depInfo.addDependency(swcLocation, swcDependLocation);
                }
            }
        }
        return depInfo;
    }

    private static void removeDependencySubsets(String swcLocation, Map<String, Set<String>> dependencyMap, SwcDependencyInfoImpl depInfo) {
        HashSet<String> removeSet = new HashSet<String>();
        SwcExternalScriptInfo externalInfo = depInfo.getSwcExternalScriptInfo(swcLocation);
        HashMap<String, Set<String>> externalsBySwc = new HashMap<String, Set<String>>();
        block0: for (String swcDependLocation : dependencyMap.get(swcLocation)) {
            for (String swcDependLocation2 : dependencyMap.get(swcLocation)) {
                if (swcDependLocation.equals(swcDependLocation2)) continue;
                Set<String> externalScripts = (Set<String>)externalsBySwc.get(swcDependLocation);
                Set<String> externalScripts2 = (Set<String>)externalsBySwc.get(swcDependLocation2);
                if (externalScripts == null) {
                    externalScripts = externalInfo.getExternalScripts(swcDependLocation);
                    externalsBySwc.put(swcDependLocation, externalScripts);
                }
                if (externalScripts2 == null) {
                    externalScripts2 = externalInfo.getExternalScripts(swcDependLocation2);
                    externalsBySwc.put(swcDependLocation2, externalScripts2);
                }
                if (externalScripts2.size() <= externalScripts.size() || !externalScripts2.containsAll(externalScripts)) continue;
                removeSet.add(swcDependLocation);
                continue block0;
            }
        }
        Set<String> dependencySet = dependencyMap.get(swcLocation);
        dependencySet.removeAll(removeSet);
    }
}

