/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.Map;

public final class MultiName
extends Name {
    private static final String Empty = "".intern();
    private static final String[] EmptyNS = new String[]{Empty};
    private static final Map<String, String[]> nsMap = new HashMap<String, String[]>();
    public String[] namespaceURI;

    MultiName() {
        this(EmptyNS, Empty);
    }

    public MultiName(String qname) {
        int index = qname.indexOf(58);
        if (index == -1) {
            this.namespaceURI = EmptyNS;
            this.localPart = qname;
        } else {
            String ns = qname.substring(0, index);
            String[] nsSet = nsMap.get(ns);
            if (nsSet == null) {
                nsSet = new String[]{ns};
                nsMap.put(ns, nsSet);
            }
            this.namespaceURI = nsSet;
            this.localPart = qname.substring(index + 1);
            assert (this.localPart.indexOf(":") < 0);
        }
    }

    public MultiName(String namespaceURI, String localPart) {
        assert (localPart.indexOf(":") < 0);
        String[] nsSet = nsMap.get(namespaceURI);
        if (nsSet == null) {
            nsSet = new String[]{namespaceURI};
            nsMap.put(namespaceURI, nsSet);
        }
        this.namespaceURI = nsSet;
        this.localPart = localPart;
    }

    public MultiName(String[] namespaceURI, String localPart) {
        assert (localPart.indexOf(":") < 0);
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
    }

    public String[] getNamespace() {
        return this.namespaceURI;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiName) {
            MultiName mName = (MultiName)obj;
            String[] nsURI = mName.namespaceURI;
            if (nsURI.length != this.namespaceURI.length) {
                return false;
            }
            boolean match = false;
            if (nsURI == this.namespaceURI) {
                match = true;
            } else if (nsURI.length > 0) {
                int length = this.namespaceURI.length;
                for (int i = 0; i < length; ++i) {
                    if (!nsURI[i].equals(this.namespaceURI[i])) {
                        match = false;
                        break;
                    }
                    match = true;
                }
            } else {
                match = true;
            }
            if (match && super.equals(obj)) {
                return true;
            }
        }
        return false;
    }

    public int getNumQNames() {
        return this.namespaceURI.length;
    }

    public QName getQName(int which) {
        return new QName(this.namespaceURI[which], this.localPart);
    }

    public int hashCode() {
        if (this.namespaceURI.length > 0) {
            int hash = this.namespaceURI[0].hashCode();
            int length = this.namespaceURI.length;
            for (int i = 1; i < length; ++i) {
                hash ^= this.namespaceURI[i].hashCode();
            }
            return hash ^ super.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        int length = this.namespaceURI.length;
        for (int i = 0; i < length; ++i) {
            b.append(this.namespaceURI[i]);
            if (i >= length - 1) continue;
            b.append(", ");
        }
        b.append("]::");
        b.append(this.localPart);
        return b.toString();
    }

    static {
        nsMap.put(Empty, EmptyNS);
    }
}

