/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.catalog;

import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFeatures;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.swc.Versions;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.VersionInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CatalogWriter {
    protected Writer writer;
    protected Versions versions;
    protected SwcFeatures swcFeatures;
    protected Collection components;
    protected Collection libraries;
    protected Collection files;
    protected boolean forceLibraryVersion1;
    public static String ls = System.getProperty("line.separator");

    public CatalogWriter(Writer stream, Versions versions, SwcFeatures swcFeatures, Collection components, Collection libraries, Collection files) {
        this.writer = stream;
        this.versions = versions;
        this.swcFeatures = swcFeatures;
        this.components = components;
        this.libraries = libraries;
        this.files = files;
        this.forceLibraryVersion1 = false;
        if (VersionInfo.LIB_VERSION_1_0.equals(versions.getLibVersion())) {
            this.forceLibraryVersion1 = true;
        }
    }

    public void write() throws IOException {
        assert (this.writer != null);
        this.writer.write("<?xml version=\"1.0\" encoding =\"utf-8\"?>" + ls);
        this.writer.write("<swc xmlns=\"http://www.adobe.com/flash/swccatalog/9\">" + ls);
        if (this.versions != null) {
            this.writeVersions();
        }
        if (this.swcFeatures != null) {
            this.writeFeatures();
        }
        if (this.components != null && this.components.size() > 0) {
            this.writeComponents();
        }
        if (this.libraries != null && this.libraries.size() > 0) {
            this.writeLibraries();
        }
        if (this.files != null && this.files.size() > 0) {
            this.writeFiles();
        }
        this.writer.write("</swc>" + ls);
        this.writer.flush();
    }

    protected void writeVersions() throws IOException {
        this.writer.write("  <versions>" + ls);
        this.writer.write("    <swc ");
        this.writeAttribute("version", "" + this.versions.getLibVersion(), "versions", true, this.writer);
        this.writer.write("/>" + ls);
        this.writer.write("    <flex ");
        this.writeAttribute("version", "" + this.versions.getFlexVersion(), "versions", true, this.writer);
        this.writeAttribute("build", "" + this.versions.getFlexBuild(), "versions", true, this.writer);
        this.writer.write("/>" + ls);
        this.writer.write("  </versions>" + ls);
    }

    protected void writeFeatures() throws IOException {
        this.writer.write("  <features>" + ls);
        this.writeFeature(this.writer, "feature-debug", this.swcFeatures.isDebug());
        this.writeFeature(this.writer, "feature-script-deps", this.swcFeatures.isScriptDeps());
        this.writeFeature(this.writer, "feature-external-deps", this.swcFeatures.hasExternalDeps());
        this.writeFeature(this.writer, "feature-components", this.swcFeatures.isComponents());
        this.writeFeature(this.writer, "feature-files", this.swcFeatures.isFiles());
        this.writer.write("  </features>" + ls);
    }

    protected void writeFeature(Writer writer, String feature, boolean enabled) throws IOException {
        if (enabled) {
            writer.write("    <" + feature + " />" + ls);
        }
    }

    protected void writeComponents() throws IOException {
        this.writer.write("  <components>" + ls);
        String cls = "component";
        for (SwcComponent comp : this.components) {
            this.writer.write("    <component ");
            this.writeAttribute("className", comp.getClassName(), cls, true, this.writer);
            this.writeAttribute("name", comp.getName(), cls, false, this.writer);
            this.writeAttribute("uri", comp.getUri(), cls, false, this.writer);
            this.writeAttribute("icon", comp.getIcon(), cls, false, this.writer);
            this.writeAttribute("docs", comp.getDocs(), cls, false, this.writer);
            this.writeAttribute("preview", comp.getPreview(), cls, false, this.writer);
            this.writer.write(" />" + ls);
        }
        this.writer.write("  </components>" + ls);
    }

    protected void writeLibraries() throws IOException {
        this.writer.write("  <libraries>" + ls);
        for (SwcLibrary swcLibrary : this.libraries) {
            this.writer.write("    <library path=\"" + swcLibrary.getPath() + "\">" + ls);
            Iterator<String> extit = swcLibrary.getExterns().iterator();
            while (extit.hasNext()) {
                this.writer.write("      <ext>" + extit.next() + "</ext>" + ls);
            }
            HashSet<String> scriptSet = new HashSet<String>();
            Iterator<SwcScript> scriptit = swcLibrary.getScriptIterator();
            while (scriptit.hasNext()) {
                SwcScript swcScript = scriptit.next();
                String scriptName = swcScript.getName();
                if (scriptSet.contains(scriptName)) {
                    throw new SwcException.ScriptUsedMultipleTimes(scriptName);
                }
                scriptSet.add(scriptName);
                this.writer.write("      <script ");
                this.writeAttribute("name", scriptName, "script", true, this.writer);
                this.writeAttribute("mod", new Long(swcScript.getLastModified()), "script", true, this.writer);
                Long signatureChecksum = swcScript.getSignatureChecksum();
                if (!this.forceLibraryVersion1 && signatureChecksum != null) {
                    this.writeAttribute("signatureChecksum", signatureChecksum, "script", false, this.writer);
                }
                this.writer.write(">" + ls);
                Iterator<String> it = swcScript.getDefinitionIterator();
                while (it.hasNext()) {
                    String defname = it.next();
                    this.writer.write("        <def id=\"" + defname + "\" /> " + ls);
                }
                SwcDependencySet depset = swcScript.getDependencySet();
                Iterator<String> typeit = depset.getTypeIterator();
                while (typeit.hasNext()) {
                    String type = typeit.next();
                    Iterator depit = depset.getDependencyIterator(type);
                    while (depit.hasNext()) {
                        String dep = (String)depit.next();
                        this.writer.write("        <dep id=\"" + dep + "\" type=\"" + type + "\" /> " + ls);
                    }
                }
                this.writer.write("      </script>" + ls);
            }
            this.writeMetadata(swcLibrary);
            this.writeDigests(swcLibrary);
            this.writer.write("    </library>" + ls);
        }
        this.writer.write("  </libraries>" + ls);
    }

    protected void writeMetadata(SwcLibrary swcLibrary) throws IOException {
        Set<String> metadata = swcLibrary.getMetadata();
        if (this.forceLibraryVersion1) {
            if (!metadata.isEmpty()) {
                ThreadLocalToolkit.log(new SwcException.MetadataNotWritten());
            }
            return;
        }
        if (!metadata.isEmpty()) {
            this.writer.write("      <keep-as3-metadata>" + ls);
            Iterator<String> iter = metadata.iterator();
            while (iter.hasNext()) {
                this.writer.write("        <metadata ");
                this.writeAttribute("name", iter.next(), "metadata", true, this.writer);
                this.writer.write("/>" + ls);
            }
            this.writer.write("      </keep-as3-metadata>" + ls);
        }
    }

    protected void writeFiles() throws IOException {
        this.writer.write("  <files>" + ls);
        for (Map.Entry entry : this.files) {
            String name = (String)entry.getKey();
            VirtualFile vFile = (VirtualFile)entry.getValue();
            if (Swc.CATALOG_XML.equals(name) || Swc.LIBRARY_SWF.equals(name)) continue;
            this.writer.write("    <file path=\"" + name + "\" mod=\"" + vFile.getLastModified() + "\" />" + ls);
        }
        this.writer.write("  </files>" + ls);
    }

    protected void writeDigests(SwcLibrary swcLibrary) throws IOException {
        Map<String, Digest> digestMap = swcLibrary.getDigests();
        if (this.forceLibraryVersion1) {
            if (!digestMap.isEmpty()) {
                ThreadLocalToolkit.log(new SwcException.DigestsNotWritten());
            }
            return;
        }
        if (!digestMap.isEmpty()) {
            this.writer.write("      <digests>" + ls);
            for (Digest digest : digestMap.values()) {
                this.writer.write("        <digest ");
                this.writeAttribute("type", digest.getType(), "digest", true, this.writer);
                this.writeAttribute("signed", Boolean.toString(digest.isSigned()), "digest", true, this.writer);
                this.writeAttribute("value", digest.getValue(), "digest", true, this.writer);
                this.writer.write("  />" + ls);
            }
            this.writer.write("      </digests>" + ls);
        }
    }

    protected void writeAttribute(String name, Object val, String cls, boolean required, Writer writer) throws IOException {
        if (val == null) {
            if (required) {
                throw new SwcException.NoElementValueFound(name, cls);
            }
        } else {
            writer.write(name + "=\"" + val.toString() + "\" ");
        }
    }
}

