/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.tags.DoABC;
import flex2.compiler.CompilationUnit;
import flex2.compiler.swc.ScriptImpl;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.tools.oem.Script;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcScript {
    private final SwcLibrary library;
    private final long modtime;
    private final Long signatureChecksum;
    private final Set<String> defs;
    private final String name;
    private final SwcDependencySet deps;
    private Set<String> symbolClasses;
    private QNameMap<CompilationUnit> compilationUnits;
    private DoABC doABC;

    public SwcScript(SwcLibrary library, String name, Set<String> defs, SwcDependencySet deps, long modtime, Long signatureChecksum) {
        this.library = library;
        this.name = name;
        this.defs = defs;
        this.deps = deps;
        this.modtime = modtime;
        this.signatureChecksum = signatureChecksum;
    }

    public void setDoABC(DoABC doABC) {
        this.doABC = doABC;
    }

    public DoABC getDoABC() {
        if (this.doABC == null) {
            this.library.parse();
            assert (this.doABC != null);
        }
        return this.doABC;
    }

    public SwcLibrary getLibrary() {
        this.library.parse();
        return this.library;
    }

    public String getSwcLocation() {
        return this.library.getSwcLocation();
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.modtime;
    }

    public Iterator<String> getDefinitionIterator() {
        return this.defs.iterator();
    }

    public SwcDependencySet getDependencySet() {
        return this.deps;
    }

    public void clearCompilationUnits() {
        this.compilationUnits.clear();
    }

    public CompilationUnit getCompilationUnit(QName qName) {
        CompilationUnit result = null;
        if (this.compilationUnits != null) {
            result = (CompilationUnit)this.compilationUnits.get(qName);
        }
        return result;
    }

    public CompilationUnit getCompilationUnit(String namespace, String localPart) {
        CompilationUnit result = null;
        if (this.compilationUnits != null) {
            result = this.compilationUnits.get(namespace, localPart);
        }
        return result;
    }

    public Map<QName, CompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    public void putCompilationUnit(QName qName, CompilationUnit compilationUnit) {
        if (this.compilationUnits == null) {
            this.compilationUnits = new QNameMap(this.defs.size());
        }
        this.compilationUnits.put(qName, compilationUnit);
    }

    public void putCompilationUnit(String namespace, String localPart, CompilationUnit compilationUnit) {
        if (this.compilationUnits == null) {
            this.compilationUnits = new QNameMap(this.defs.size());
        }
        this.compilationUnits.put(namespace, localPart, compilationUnit);
    }

    public Set<String> getSymbolClasses() {
        if (this.symbolClasses == null) {
            this.symbolClasses = new HashSet<String>();
            Iterator<String> i = this.getDefinitionIterator();
            while (i.hasNext()) {
                this.library.getSymbolClasses(i.next(), this.symbolClasses);
            }
        }
        return this.symbolClasses;
    }

    public Script toScript(boolean includeBytecodes) {
        return new ScriptImpl(this, includeBytecodes);
    }

    public Long getSignatureChecksum() {
        return this.signatureChecksum;
    }

    public String toString() {
        return this.getSwcLocation() + "(" + this.getName() + ")";
    }
}

