/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcLazyReadArchive;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.tools.CompcConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcAPI {
    public static List<SwcComponent> setupNamespaceComponents(CompcConfiguration configuration, NameMappings mappings, SourcePath sourcePath, Map<String, Source> classes) throws ConfigurationException, CompilerException {
        return SwcAPI.setupNamespaceComponents(configuration.getNamespaces(), mappings, sourcePath, classes, configuration.getIncludeLookupOnly(), false);
    }

    public static List<SwcComponent> setupNamespaceComponents(List targets, NameMappings mappings, SourcePath sourcePath, Map<String, Source> classes) throws ConfigurationException, CompilerException {
        return SwcAPI.setupNamespaceComponents(targets, mappings, sourcePath, classes, false, false);
    }

    public static List<SwcComponent> setupNamespaceComponents(List targets, NameMappings mappings, SourcePath sourcePath, Map<String, Source> classes, boolean includeLookupOnly, boolean includeAllForAsdoc) throws ConfigurationException, CompilerException {
        LinkedList<SwcComponent> nsComponents = new LinkedList<SwcComponent>();
        try {
            for (String nsTarget : targets) {
                if (nsTarget == null) continue;
                Map<String, String> map = mappings.getNamespace(nsTarget);
                if (map == null) {
                    throw new ConfigurationException.UnknownNamespace(nsTarget, null, null, -1);
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String compName = entry.getKey();
                    String className = entry.getValue();
                    String packageName = NameFormatter.retrievePackageName(className);
                    String leafName = NameFormatter.retrieveClassName(className);
                    if (!mappings.isLookupOnly(className) || includeAllForAsdoc) {
                        Source s = sourcePath.findSource(packageName, leafName);
                        if (s == null) {
                            if (includeAllForAsdoc) continue;
                            SwcException.NoSourceForClass e = new SwcException.NoSourceForClass(className, nsTarget);
                            ThreadLocalToolkit.log(e);
                            throw e;
                        }
                        classes.put(s.getName(), s);
                        SwcComponent component = new SwcComponent(className, compName, nsTarget);
                        nsComponents.add(component);
                        continue;
                    }
                    if (!includeLookupOnly) continue;
                    nsComponents.add(new SwcComponent(className, compName, nsTarget));
                }
            }
        }
        catch (CompilerException ce) {
            ThreadLocalToolkit.logError(ce.getMessage());
            throw ce;
        }
        return nsComponents;
    }

    public static void setupClasses(CompcConfiguration configuration, SourcePath sourcePath, Map<String, Source> classes) throws CompilerException {
        SwcAPI.setupClasses(configuration.getClasses(), sourcePath, classes);
    }

    public static void setupClasses(List list, SourcePath sourcePath, Map<String, Source> classes) throws CompilerException {
        if (list != null) {
            try {
                for (String className : list) {
                    String leafName;
                    String tempName = className.replace('/', '.').replace('\\', '.');
                    String packageName = NameFormatter.retrievePackageName(tempName);
                    Source s = sourcePath.findSource(packageName, leafName = NameFormatter.retrieveClassName(tempName));
                    if (s == null) {
                        SwcException msg = className.endsWith(".as") || className.endsWith(".mxml") ? new SwcException.CouldNotFindFileSource(className) : new SwcException.CouldNotFindSource(className);
                        ThreadLocalToolkit.log(msg);
                        throw msg;
                    }
                    classes.put(s.getName(), s);
                }
            }
            catch (CompilerException ce) {
                ThreadLocalToolkit.logError(ce.getMessage());
                throw ce;
            }
        }
    }

    public static SwcMovie link(LinkerConfiguration linkerConfiguration, List<CompilationUnit> units) throws LinkerException {
        SwcMovie movie = new SwcMovie(linkerConfiguration);
        movie.generate(units);
        return movie;
    }

    public static void exportSwc(CompcConfiguration configuration, List<CompilationUnit> units, List nsComponents, SwcCache cache, Map<String, VirtualFile> rbFiles) throws Exception {
        TreeMap<String, VirtualFile> m = new TreeMap<String, VirtualFile>();
        if (configuration.getCSSArchiveFiles() != null) {
            m.putAll(configuration.getCSSArchiveFiles());
        }
        if (configuration.getL10NArchiveFiles() != null) {
            m.putAll(configuration.getL10NArchiveFiles());
        }
        if (configuration.getFiles() != null) {
            m.putAll(configuration.getFiles());
        }
        SwcAPI.exportSwc(configuration.getOutput(), configuration.isDirectory(), m, configuration.getStylesheets(), configuration, units, nsComponents, cache, rbFiles);
    }

    public static void exportSwc(String swcStr, boolean isDirectory, Map<String, VirtualFile> files, Map<String, VirtualFile> stylesheets, LinkerConfiguration linkerConfiguration, List<CompilationUnit> units, List nsComponents, SwcCache cache, Map<String, VirtualFile> rbFiles) throws Exception {
        SwcArchive archive = isDirectory ? new SwcDirectoryArchive(swcStr) : new SwcLazyReadArchive(swcStr);
        SwcAPI.exportSwc(archive, files, stylesheets, linkerConfiguration, units, nsComponents, cache, rbFiles);
    }

    private static void exportSwc(SwcArchive archive, Map<String, VirtualFile> files, Map<String, VirtualFile> stylesheets, LinkerConfiguration linkerConfiguration, List<CompilationUnit> units, List nsComponents, SwcCache cache, Map<String, VirtualFile> rbFiles) throws Exception {
        SwcMovie m = SwcAPI.link(linkerConfiguration, units);
        SwcAPI.exportSwc(archive, files, stylesheets, linkerConfiguration, m, nsComponents, cache, rbFiles);
    }

    public static void exportSwc(SwcArchive archive, Map<String, VirtualFile> files, Map<String, VirtualFile> stylesheets, LinkerConfiguration linkerConfiguration, SwcMovie m, List nsComponents, SwcCache cache, Map<String, VirtualFile> rbFiles) throws Exception {
        try {
            Swc swc = new Swc(archive);
            if (linkerConfiguration.generateLinkReport() && linkerConfiguration.getLinkReportFileName() != null) {
                FileUtil.writeFile(linkerConfiguration.getLinkReportFileName(), m.getLinkReport());
            }
            if (linkerConfiguration.generateRBList() && linkerConfiguration.getRBListFileName() != null) {
                FileUtil.writeFile(linkerConfiguration.getRBListFileName(), m.getRBList());
            }
            if (ThreadLocalToolkit.errorCount() > 0) {
                return;
            }
            HashMap<String, SwcComponent> allClassComp = new HashMap<String, SwcComponent>();
            for (CompilationUnit unit : m.getExportedUnits()) {
                if (!unit.getSource().isSwcScriptOwner()) continue;
                Swc unitswc = ((SwcScript)unit.getSource().getOwner()).getLibrary().getSwc();
                Iterator<SwcComponent> ci = unitswc.getComponentIterator();
                while (ci.hasNext()) {
                    SwcComponent c = ci.next();
                    allClassComp.put(c.getClassName(), c);
                }
            }
            for (SwcComponent c : nsComponents) {
                allClassComp.put(c.getClassName(), c);
            }
            for (CompilationUnit unit : m.getExportedUnits()) {
                int s = unit.topLevelDefinitions.size();
                for (int i = 0; i < s; ++i) {
                    String def = ((QName)unit.topLevelDefinitions.get(i)).toString();
                    if (!allClassComp.containsKey(def)) continue;
                    swc.addComponent((SwcComponent)allClassComp.get(def));
                }
            }
            swc.buildLibrary("library", linkerConfiguration, m);
            SwcAPI.addArchiveFiles(files, swc);
            SwcAPI.addArchiveFiles(rbFiles, swc);
            SwcAPI.addArchiveFiles(stylesheets, swc);
            cache.export(swc);
            if (ThreadLocalToolkit.errorCount() > 0) {
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof CompilerException || e instanceof LinkerException || e instanceof SwcException.SwcNotExported) {
                throw e;
            }
            if (Trace.error) {
                e.printStackTrace();
            }
            SwcException ex = e instanceof SwcException ? (SwcException)e : new SwcException.SwcNotExported(archive.getLocation(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark("Exporting " + archive.getLocation() + "...");
        }
    }

    private static void addArchiveFiles(Map<String, VirtualFile> files, Swc swc) throws IOException {
        for (Map.Entry<String, VirtualFile> entry : files.entrySet()) {
            String fileName = entry.getKey();
            VirtualFile f = entry.getValue();
            if (swc.getArchive().getFile(fileName) != null) continue;
            try {
                InMemoryFile swcFile = new InMemoryFile(f.getInputStream(), fileName, f.getMimeType(), f.getLastModified());
                swc.addFile(swcFile);
            }
            catch (IOException ioException) {
                throw new SwcException.ArchiveFileException(ioException.getMessage());
            }
        }
    }
}

