/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.rep.MxmlDocument;

public abstract class ValueNodeHandler {
    protected abstract void componentNode(Node var1, MxmlDocument var2);

    protected abstract void arrayNode(ArrayNode var1);

    protected abstract void primitiveNode(PrimitiveNode var1);

    protected abstract void xmlNode(XMLNode var1);

    protected abstract void xmlListNode(XMLListNode var1);

    protected abstract void modelNode(ModelNode var1);

    protected abstract void reparentNode(ReparentNode var1);

    protected abstract void stateNode(StateNode var1);

    protected abstract void inlineComponentNode(InlineComponentNode var1);

    protected abstract void cdataNode(CDATANode var1);

    protected abstract void vectorNode(VectorNode var1);

    protected abstract void unknown(Node var1);

    public static boolean isValueNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return nodeClass == Node.class || nodeClass == DocumentNode.class || nodeClass == ArrayNode.class || node instanceof PrimitiveNode || nodeClass == XMLNode.class || nodeClass == XMLListNode.class || nodeClass == ModelNode.class || nodeClass == ReparentNode.class || nodeClass == InlineComponentNode.class || nodeClass == VectorNode.class;
    }

    public void invoke(Node node, MxmlDocument document) {
        Class<?> nodeClass = node.getClass();
        if (nodeClass == Node.class || nodeClass == DocumentNode.class) {
            this.componentNode(node, document);
        } else if (nodeClass == ArrayNode.class) {
            this.arrayNode((ArrayNode)node);
        } else if (node instanceof PrimitiveNode) {
            this.primitiveNode((PrimitiveNode)node);
        } else if (nodeClass == XMLNode.class) {
            this.xmlNode((XMLNode)node);
        } else if (nodeClass == XMLListNode.class) {
            this.xmlListNode((XMLListNode)node);
        } else if (nodeClass == ModelNode.class) {
            this.modelNode((ModelNode)node);
        } else if (nodeClass == InlineComponentNode.class) {
            this.inlineComponentNode((InlineComponentNode)node);
        } else if (nodeClass == ReparentNode.class) {
            this.reparentNode((ReparentNode)node);
        } else if (nodeClass == StateNode.class) {
            this.stateNode((StateNode)node);
        } else if (nodeClass == CDATANode.class) {
            this.cdataNode((CDATANode)node);
        } else if (nodeClass == VectorNode.class) {
            this.vectorNode((VectorNode)node);
        } else {
            assert (!ValueNodeHandler.isValueNode(node)) : "value node class not handled by invoke()";
            this.unknown(node);
        }
    }
}

