/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ClassNode;
import flex2.compiler.mxml.dom.FunctionNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MxmlCommentUtil;
import flex2.compiler.util.NameFormatter;

class PrimitiveBuilder
extends AbstractBuilder {
    protected Model parent;
    protected boolean topLevel;
    protected BindingHandler bindingHandler;
    Primitive value;
    private String name;
    private String state;

    PrimitiveBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent, boolean topLevel, String name, String state, BindingHandler bindingHandler) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.topLevel = topLevel;
        this.bindingHandler = bindingHandler;
        this.name = name;
        this.state = state;
    }

    public void analyze(StringNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(NumberNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(IntNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(UIntNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(BooleanNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(ClassNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(FunctionNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(CDATANode node) {
        this.processPrimitiveEntry(node);
    }

    private void processPrimitiveEntry(Node node) {
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        Primitive primitive = this.initPrimitiveValue(type, node);
        CDATANode cdata = null;
        cdata = node instanceof CDATANode ? (CDATANode)node : this.getTextContent(node.getChildren(), false);
        if (cdata != null) {
            this.processTextInitializer(cdata.image, type, cdata.inCDATA, cdata.beginLine);
        } else if (!this.topLevel) {
            if (this.typeTable.stringType.isAssignableTo(type)) {
                this.processTextInitializer("", type, true, node.beginLine);
            } else {
                this.log(node.beginLine, (CompilerMessage)new InitializerRequired());
            }
        }
        this.processStateAttributes(node, primitive);
        String id = (String)this.getLanguageAttributeValue(node, "id");
        if (id != null || this.topLevel || primitive.isDeclarationEnsured()) {
            if (primitive.getValue() != null) {
                if (node.comment == null) {
                    node.comment = "";
                }
                primitive.comment = !this.mxmlConfiguration.getGenerateAbstractSyntaxTree() ? node.comment : MxmlCommentUtil.commentToXmlComment(node.comment);
                this.registerModel(id, (Model)primitive, this.topLevel);
            } else {
                boolean autogenerated = false;
                if (id == null) {
                    autogenerated = true;
                    id = primitive.getId();
                }
                String tempComment = null;
                if (node.comment == null) {
                    node.comment = "";
                }
                tempComment = !this.mxmlConfiguration.getGenerateAbstractSyntaxTree() ? node.comment : MxmlCommentUtil.commentToXmlComment(node.comment);
                this.document.addDeclaration(id, type.getName(), node.beginLine, true, this.topLevel, autogenerated, tempComment);
            }
        }
    }

    private Primitive initPrimitiveValue(Type type, Node node) {
        Primitive primitive = new Primitive(this.document, type, this.parent, node.beginLine);
        primitive.setParentIndex(this.name, this.state);
        primitive.setInspectable(true);
        this.value = primitive;
        return primitive;
    }

    public void processTextInitializer(String text, Type type, boolean cdata, int line) {
        int flags = cdata ? 1 : 0;
        Object result = this.textParser.parseValue(text, type, flags, line, NameFormatter.toDot(type.getName()));
        if (result != null) {
            if (result instanceof BindingExpression) {
                if (this.bindingHandler != null) {
                    this.bindingHandler.invoke((BindingExpression)result, this.value);
                } else {
                    this.log(new AbstractBuilder.BindingNotAllowed());
                }
            }
            this.value.setValue(result);
        }
    }

    public static class InitializerRequired
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3741993271908572909L;
    }
}

