/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.builder.VectorBuilder;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import java.util.Collection;
import java.util.Iterator;

class ArrayBuilder
extends AbstractBuilder {
    private ElementNodeHandler elementNodeHandler = new ElementNodeHandler();
    private ElementBindingHandler elementBindingHandler = new ElementBindingHandler();
    private Type elementType;
    private Model parent;
    private String name;
    private String state;
    private boolean allowBinding;
    Array array;

    ArrayBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        this(unit, typeTable, mxmlConfiguration, document, null, null, null, true, typeTable.objectType);
    }

    ArrayBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent, String name, String state, boolean allowBinding, Type elementType) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.elementType = elementType;
        this.parent = parent;
        this.name = name;
        this.state = state;
        this.allowBinding = allowBinding;
    }

    public void analyze(ArrayNode node) {
        this.createArrayModel(node.beginLine);
        this.processStateAttributes(node, this.array);
        this.ensureId(node);
        this.processChildren(node.getChildren());
        this.registerModel(node, (Model)this.array, this.parent == null);
    }

    public void createArrayModel(int line) {
        this.array = new Array(this.document, this.parent, line, this.elementType);
        this.array.setParentIndex(this.name, this.state);
    }

    void createSyntheticArrayModel(int line) {
        this.createArrayModel(line);
    }

    private void ensureId(ArrayNode node) {
        String id = (String)this.getLanguageAttributeValue(node, "id");
        if (id != null) {
            this.array.setId(id, false);
        }
    }

    void processChildren(Collection nodes) {
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            this.processTextInitializer(cdata.image, this.typeTable.objectType, cdata.inCDATA, cdata.beginLine);
        } else {
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                this.elementNodeHandler.invoke((Node)iter.next(), this.document);
            }
        }
    }

    public void processTextInitializer(String text, Type arrayElementType, boolean cdata, int line) {
        int flags = cdata ? 1 : 0;
        Object result = this.textParser.parseValue(text, this.typeTable.arrayType, arrayElementType, flags, line, this.typeTable.arrayType.getName());
        if (result != null) {
            if (result instanceof BindingExpression) {
                if (this.allowBinding) {
                    BindingExpression bindingExpression = (BindingExpression)result;
                    if (this.parent != null) {
                        bindingExpression.setDestination(this.parent);
                    } else {
                        bindingExpression.setDestination(this.array);
                    }
                    bindingExpression.setDestinationLValue(this.name);
                    bindingExpression.setDestinationProperty(this.name);
                } else {
                    this.log(line, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
                }
            } else {
                assert (result instanceof Array);
                this.array.setEntries(((Array)result).getEntries());
            }
        }
    }

    public static class UnknownNode
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3924881722877853113L;
        public String image;

        public UnknownNode(String image) {
            this.image = image;
        }
    }

    public static class ElementNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8466102389418978639L;
        public String image;

        public ElementNotSupported(String image) {
            this.image = image;
        }
    }

    protected class ElementBindingHandler
    implements BindingHandler {
        protected ElementBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(ArrayBuilder.this.array);
            bindingExpression.setDestinationLValue(Integer.toString(ArrayBuilder.this.array.size()));
            bindingExpression.setDestinationProperty(ArrayBuilder.this.array.size());
            return bindingExpression;
        }
    }

    protected class ElementNodeHandler
    extends ValueNodeHandler {
        protected ElementNodeHandler() {
        }

        protected void componentNode(Node node, MxmlDocument document) {
            ComponentBuilder builder = new ComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, document, ArrayBuilder.this.array, null, null, false, ArrayBuilder.this.elementBindingHandler);
            node.analyze(builder);
            builder.component.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.component);
        }

        protected void arrayNode(ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, ArrayBuilder.this.array, null, null, ArrayBuilder.this.allowBinding, ArrayBuilder.this.typeTable.objectType);
            node.analyze(builder);
            builder.array.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.array);
        }

        protected void vectorNode(VectorNode node) {
            Type elementType = ArrayBuilder.this.typeTable.getType((String)node.getAttribute("type").getValue());
            VectorBuilder builder = new VectorBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, elementType, ArrayBuilder.this.array, null, null, ArrayBuilder.this.allowBinding);
            node.analyze(builder);
            builder.vector.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.vector);
        }

        protected void primitiveNode(PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, ArrayBuilder.this.array, false, null, null, ArrayBuilder.this.elementBindingHandler);
            node.analyze(builder);
            ArrayBuilder.this.array.addEntry(builder.value);
        }

        protected void xmlNode(XMLNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void xmlListNode(XMLListNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void modelNode(ModelNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void inlineComponentNode(InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, false);
            node.analyze(builder);
            ArrayBuilder.this.array.addEntry(builder.getRValue());
        }

        protected void reparentNode(ReparentNode node) {
            ComponentBuilder builder = new ComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, ArrayBuilder.this.array, null, null, false, null);
            node.analyze(builder);
            builder.component.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.component);
        }

        protected void cdataNode(CDATANode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, ArrayBuilder.this.array, false, null, null, ArrayBuilder.this.elementBindingHandler);
            node.analyze(builder);
            ArrayBuilder.this.array.addEntry(builder.value);
        }

        protected void stateNode(StateNode node) {
            ComponentBuilder builder = new ComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.mxmlConfiguration, ArrayBuilder.this.document, ArrayBuilder.this.array, null, null, false, null);
            node.analyze(builder);
            builder.component.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.component);
        }

        protected void unknown(Node node) {
            ArrayBuilder.this.log(node, new UnknownNode(node.image));
        }
    }
}

