/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGParser;
import com.adobe.fxg.FXGParserFactory;
import com.adobe.fxg.dom.FXGNode;
import flash.swf.tags.DefineSprite;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.fxg.FlexFXG2SWFTranscoder;
import flex2.compiler.fxg.FlexResourceResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXGTranscoder
extends AbstractTranscoder {
    private static final String IGNORE_TEXT = "ignoreText";

    public FXGTranscoder() {
        super(new String[]{"text/fxg"}, DefineSprite.class, true);
    }

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver resolver, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        VirtualFile source = this.resolveSource(resolver, args);
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(source);
        DefineSprite sprite = this.fxgWithoutText(resolver, source);
        results.defineTag = sprite;
        if (generateSource) {
            this.generateSource(results, className, args);
        }
        return results;
    }

    @Override
    public boolean isSupportedAttribute(String name) {
        return IGNORE_TEXT.equals(name);
    }

    private DefineSprite fxgWithoutText(PathResolver resolver, VirtualFile source) throws TranscoderException {
        FXGNode node = FXGTranscoder.parseFXG(source);
        FlexFXG2SWFTranscoder transcoder = new FlexFXG2SWFTranscoder(null);
        FlexResourceResolver fxgResolver = new FlexResourceResolver(resolver);
        transcoder.setResourceResolver(fxgResolver);
        DefineSprite sprite = (DefineSprite)transcoder.transcode(node);
        return sprite;
    }

    private static FXGNode parseFXG(VirtualFile source) throws TranscoderException {
        try {
            FXGParser parser = FXGParserFactory.createDefaultParser();
            FXGNode node = parser.parse(source.getInputStream());
            return node;
        }
        catch (FXGException ex) {
            throw new AbstractTranscoder.ExceptionWhileTranscoding((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new AbstractTranscoder.ExceptionWhileTranscoding(ex);
        }
        catch (Throwable ex) {
            throw new AbstractTranscoder.ExceptionWhileTranscoding(null);
        }
    }
}

