/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.fxg;

import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.swf.FXG2SWFTranscoder;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.text.BRNode;
import com.adobe.internal.fxg.dom.text.CDATANode;
import com.adobe.internal.fxg.dom.text.SpanNode;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.util.StringUtils;
import flex2.compiler.fxg.FXGSymbolClass;
import flex2.compiler.fxg.FlexGraphicNode;
import flex2.compiler.fxg.FlexParagraphNode;
import flex2.compiler.fxg.FlexSpanNode;
import flex2.compiler.fxg.FlexTextGraphicNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexFXG2SWFTranscoder
extends FXG2SWFTranscoder {
    private FXGSymbolClass graphicClass;
    private String packageName;
    private static int textGraphicCount;
    private TypeTable typeTable;
    private Type textGraphicType;
    private Type paragraphType;
    private Type spanType;

    public FlexFXG2SWFTranscoder(TypeTable typeTable) {
        this.typeTable = typeTable;
        if (typeTable != null) {
            this.textGraphicType = typeTable.getType(StandardDefs.CLASS_TEXT_TEXTGRAPIC);
            this.paragraphType = typeTable.getType(StandardDefs.CLASS_TEXT_PARAGRAPH);
            this.spanType = typeTable.getType(StandardDefs.CLASS_TEXT_SPAN);
        }
    }

    public FXGSymbolClass transcode(FXGNode node, String packageName, String className) {
        this.packageName = packageName;
        if (node instanceof FlexGraphicNode) {
            FlexGraphicNode graphicNode = (FlexGraphicNode)node;
            SourceContext context = new SourceContext(packageName, className);
            this.graphicClass = new FXGSymbolClass();
            this.graphicClass.setPackageName(context.packageName);
            this.graphicClass.setClassName(context.className);
            this.beginClass(context, false);
            DefineSprite sprite = (DefineSprite)this.transcode((FXGNode)graphicNode);
            this.graphicClass.setSprite(sprite);
            this.generateConstructor(context);
            this.endClass(context);
            this.graphicClass.setGeneratedSource(context.getGeneratedSource());
            return this.graphicClass;
        }
        return null;
    }

    public FXG2SWFTranscoder newInstance() {
        FlexFXG2SWFTranscoder graphics = new FlexFXG2SWFTranscoder(this.typeTable);
        graphics.packageName = this.packageName;
        graphics.graphicClass = this.graphicClass;
        graphics.definitions = this.definitions;
        return graphics;
    }

    protected PlaceObject text(TextGraphicNode node) {
        if (node instanceof FlexTextGraphicNode) {
            String className = this.graphicClass.getClassName() + "_TextSprite" + ++textGraphicCount;
            SourceContext context = new SourceContext(this.packageName, className);
            FXGSymbolClass spriteSymbolClass = new FXGSymbolClass();
            spriteSymbolClass.setPackageName(context.packageName);
            spriteSymbolClass.setClassName(context.className);
            this.beginClass(context, true);
            this.graphicClass.addAdditionalSymbolClass(spriteSymbolClass);
            DefineSprite textSprite = this.createDefineSprite();
            PlaceObject po3 = this.placeObject((DefineTag)textSprite, node.createGraphicContext());
            this.spriteStack.push(textSprite);
            StringBuilder textSource = this.generateTextGraphic((FlexTextGraphicNode)node, textGraphicCount);
            this.generateTextInitFunction(textSource, context);
            this.generateConstructor(context);
            this.endClass(context);
            spriteSymbolClass.setGeneratedSource(context.getGeneratedSource());
            spriteSymbolClass.setSprite(textSprite);
            this.spriteStack.pop();
            return po3;
        }
        return null;
    }

    private void beginClass(SourceContext context, boolean hasTextGraphic) {
        StringBuilder buf = context.buffer;
        buf.append("package ").append(context.packageName).append("\n{\n\n");
        if (hasTextGraphic) {
            buf.append("import flashx.textLayout.elements.*;\n");
            buf.append("import spark.primitives.RichText;\n");
        }
        buf.append("import spark.core.SpriteVisualElement;\n\n");
        buf.append("public class ").append(context.className).append(" extends SpriteVisualElement\n{\n");
    }

    private void endClass(SourceContext context) {
        StringBuilder buf = context.buffer;
        buf.append("\n}\n");
        buf.append("}\n");
    }

    private void generateConstructor(SourceContext context) {
        StringBuilder buf = context.buffer;
        buf.append("\n\tpublic function " + context.className + "()\n\t{\n");
        buf.append("\t\tsuper();\n");
        if (context.generatedFunctions != null) {
            for (String functionName : context.generatedFunctions) {
                buf.append("\t\t" + functionName + "();\n");
            }
        }
        buf.append("\t}\n");
    }

    private void generateTextInitFunction(StringBuilder textSource, SourceContext context) {
        String functionName = "createText" + context.functionCount++;
        StringBuilder buf = context.buffer;
        buf.append("\n\tprivate function " + functionName + "():void\n\t{\n");
        buf.append((CharSequence)textSource);
        buf.append("\n\t}\n");
        context.addGeneratedFunction(functionName);
    }

    private StringBuilder generateTextGraphic(FlexTextGraphicNode node, int textGraphicCounter) {
        StringBuilder sb = new StringBuilder();
        boolean[] pFlag = new boolean[]{false};
        boolean[] sFlag = new boolean[]{false};
        String variableName = "textGraphic" + textGraphicCounter;
        sb.append("\t\tvar ").append(variableName).append(":RichText = new RichText();\r\n");
        this.generatePropertyInitializers(this.textGraphicType, node.cachedAttributes, sb, variableName);
        List content = node.content;
        if (content != null) {
            sb.append("\t\tvar textContent:Array = [];\r\n");
            for (TextNode t : content) {
                if (t instanceof CDATANode) {
                    CDATANode c = (CDATANode)t;
                    String text = this.formatString(c.content);
                    sb.append("\t\ttextContent.push(").append(text).append(");\r\n");
                    continue;
                }
                if (t instanceof BRNode) {
                    sb.append("\t\ttextContent.push(new BreakElement());\r\n");
                    continue;
                }
                if (t instanceof FlexSpanNode) {
                    this.generateSpan((FlexSpanNode)t, sb, sFlag);
                    sb.append("\t\ttextContent.push(spanElement);\r\n");
                    continue;
                }
                if (!(t instanceof FlexParagraphNode)) continue;
                this.generateParagraph((FlexParagraphNode)t, sb, pFlag, sFlag);
                sb.append("\t\ttextContent.push(paragraphElement);\r\n");
            }
        }
        sb.append("\t\t").append(variableName).append(".content = textContent;\r\n");
        sb.append("\t\tif (").append(variableName).append(".setSharedDisplayObject(this))\r\n");
        sb.append("\t\t\t").append(variableName).append(".sharedIndex = 0;\r\n\t\telse\r\n");
        sb.append("\t\t{\r\n\t\t\t").append(variableName).append(".createDisplayObject();\r\n");
        sb.append("\t\t\taddChild(").append(variableName).append(".displayObject);\r\n");
        sb.append("\t\t\t").append(variableName).append(".sharedIndex = -1;\r\n\t\t}\r\n");
        sb.append("\t\t").append(variableName).append(".regenerateStyleCache(true);\r\n");
        sb.append("\t\t").append(variableName).append(".stylesInitialized();\r\n");
        sb.append("\t\t").append(variableName).append(".validateProperties();\r\n");
        sb.append("\t\t").append(variableName).append(".validateSize();\r\n");
        sb.append("\t\t").append(variableName).append(".setLayoutBoundsSize(NaN, NaN);\r\n");
        sb.append("\t\t").append(variableName).append(".validateDisplayList();\r\n");
        return sb;
    }

    private void generateParagraph(FlexParagraphNode node, StringBuilder sb, boolean[] pFlag, boolean[] sFlag) {
        if (!pFlag[0]) {
            sb.append("\t\tvar paragraphElement:ParagraphElement = new ParagraphElement();\r\n");
            sb.append("\t\tvar paragraphContent:Array = [];\r\n");
            pFlag[0] = true;
        } else {
            sb.append("\t\tparagraphElement = new ParagraphElement();\r\n");
            sb.append("\t\tparagraphContent = [];\r\n");
        }
        String variableName = "paragraphElement";
        this.generatePropertyInitializers(this.paragraphType, node.cachedAttributes, sb, variableName);
        List paraChild = node.content;
        if (paraChild != null && paraChild.size() > 0) {
            for (TextNode pChild : paraChild) {
                if (pChild instanceof SpanNode) {
                    this.generateSpan((FlexSpanNode)pChild, sb, sFlag);
                    sb.append("\t\tparagraphContent.push(spanElement);\r\n");
                    continue;
                }
                if (pChild instanceof BRNode) {
                    sb.append("\t\tparagraphContent.push(new BreakElement());\r\n");
                    continue;
                }
                if (!(pChild instanceof CDATANode)) continue;
                CDATANode c = (CDATANode)pChild;
                String text = this.formatString(c.content);
                sb.append("\t\tparagraphContent.push(").append(text).append(");\r\n");
            }
        }
        sb.append("\t\tparagraphElement.mxmlChildren = paragraphContent;\r\n");
    }

    private void generateSpan(FlexSpanNode node, StringBuilder sb, boolean[] sFlag) {
        if (!sFlag[0]) {
            sb.append("\t\tvar spanElement:SpanElement = new SpanElement();\r\n");
            sb.append("\t\tvar spanContent:Array = [];\r\n");
            sFlag[0] = true;
        } else {
            sb.append("\t\tspanElement = new SpanElement();\r\n");
            sb.append("\t\tspanContent = [];\r\n");
        }
        String variableName = "spanElement";
        this.generatePropertyInitializers(this.spanType, node.cachedAttributes, sb, variableName);
        List spanContent = node.content;
        if (spanContent != null) {
            for (int i = 0; i < spanContent.size(); ++i) {
                TextNode sChild = (TextNode)spanContent.get(i);
                if (sChild instanceof CDATANode) {
                    CDATANode c = (CDATANode)sChild;
                    String text = this.formatString(c.content);
                    sb.append("\t\tspanContent.push(").append(text).append(");\r\n");
                    continue;
                }
                if (!(sChild instanceof BRNode)) continue;
                sb.append("\t\tspanContent.push(new BreakElement());\r\n");
            }
        }
        sb.append("\t\tspanElement.mxmlChildren = spanContent;\r\n");
    }

    private void generatePropertyInitializers(Type type, Map<String, String> cachedAttributes, StringBuilder sb, String variableName) {
        if (cachedAttributes != null) {
            for (Map.Entry<String, String> entry : cachedAttributes.entrySet()) {
                String attribName = entry.getKey();
                String attribValue = entry.getValue();
                String thisAttrib = null;
                Property property = type.getProperty(attribName);
                if (property != null) {
                    Type propertyType = property.getType();
                    thisAttrib = propertyType.isAssignableTo(this.typeTable.stringType) || propertyType == this.typeTable.objectType || propertyType == this.typeTable.noType ? attribName + " = \"" + attribValue + "\"" : attribName + " = " + attribValue;
                } else if (type.getStyle(attribName) != null) {
                    thisAttrib = "setStyle(\"" + attribName + "\", \"" + attribValue + "\")";
                }
                if (thisAttrib == null) continue;
                sb.append("\t\t" + variableName + '.' + thisAttrib + ";\r\n");
            }
        }
    }

    private String formatString(String content) {
        if (content != null) {
            return StringUtils.formatString((String)content);
        }
        return content;
    }

    private static class SourceContext {
        private StringBuilder buffer;
        private final String className;
        private final String packageName;
        private List<String> generatedFunctions;
        private int functionCount;

        private SourceContext(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
            this.buffer = new StringBuilder(512);
        }

        public void addGeneratedFunction(String name) {
            if (this.generatedFunctions == null) {
                this.generatedFunctions = new ArrayList<String>(2);
            }
            this.generatedFunctions.add(name);
        }

        private String getGeneratedSource() {
            return this.buffer.toString();
        }
    }
}

