/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.FontFaceRule;
import flash.css.Rule;
import flash.css.StyleCondition;
import flash.css.StyleDeclaration;
import flash.css.StyleRule;
import flash.css.StyleSelector;
import flash.css.StyleSheet;
import flash.util.Trace;
import flex2.compiler.Source;
import flex2.compiler.css.ConditionTypeNotSupported;
import flex2.compiler.css.Import;
import flex2.compiler.css.SelectorTypeNotSupported;
import flex2.compiler.css.StyleDef;
import flex2.compiler.css.UnqualifiedTypeSelector;
import flex2.compiler.css.UnresolvedQualifiedTypeSelector;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;
import org.apache.batik.css.parser.AbstractSelector;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleModule {
    protected Map<String, AtEmbed> atEmbeds = new LinkedHashMap<String, AtEmbed>();
    protected List<FontFaceRule> fontFaceRules;
    protected boolean advanced = true;
    protected boolean qualifiedTypeSelectors = true;
    protected String name;
    protected ContextStatics perCompileData;
    protected Source source;
    protected Map<String, StyleDef> styleDefs;
    protected NameMappings nameMappings;
    private DualModeLineNumberMap lineNumberMap;

    public StyleModule(Source source, ContextStatics perCompileData) {
        this.source = source;
        this.perCompileData = perCompileData;
        this.fontFaceRules = new ArrayList<FontFaceRule>();
        this.styleDefs = new LinkedHashMap<String, StyleDef>();
    }

    public Collection<AtEmbed> getAtEmbeds() {
        for (StyleDef styleDef : this.styleDefs.values()) {
            for (AtEmbed atEmbed : styleDef.getAtEmbeds()) {
                if (this.atEmbeds.containsKey(atEmbed.getPropName())) continue;
                this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
            }
        }
        return this.atEmbeds.values();
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this.fontFaceRules;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean value) {
        this.advanced = value;
    }

    public boolean getQualifiedTypeSelectors() {
        return this.qualifiedTypeSelectors;
    }

    public void setQualifiedTypeSelectors(boolean value) {
        this.qualifiedTypeSelectors = value;
    }

    public Set<Import> getImports() {
        HashSet<Import> result = new HashSet<Import>();
        for (StyleDef styleDef : this.styleDefs.values()) {
            result.addAll(styleDef.getImports());
        }
        return result;
    }

    public DualModeLineNumberMap getLineNumberMap() {
        return this.lineNumberMap;
    }

    public void setLineNumberMap(DualModeLineNumberMap lineNumberMap) {
        this.lineNumberMap = lineNumberMap;
    }

    public NameMappings getNameMappings() {
        return this.nameMappings;
    }

    public void setNameMappings(NameMappings mappings) {
        this.nameMappings = mappings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Source getSource() {
        return this.source;
    }

    public Collection<StyleDef> getStyleDefs() {
        return this.styleDefs.values();
    }

    public void extractStyles(StyleSheet styleSheet, boolean isLocal) {
        List<Rule> sheetRules = styleSheet.getCssRules();
        if (sheetRules == null) {
            return;
        }
        for (Rule rule : sheetRules) {
            if (rule instanceof StyleRule) {
                SelectorList selectors = ((StyleRule)rule).getSelectorList();
                int nSelectors = selectors.getLength();
                for (int i = 0; i < nSelectors; ++i) {
                    Selector selector = selectors.item(i);
                    StyleDeclaration declaration = rule.getStyleDeclaration();
                    if (i > 0) {
                        declaration = declaration.shallowCopy();
                    }
                    int lineNumber = declaration.getLineNumber();
                    if (selector instanceof AbstractSelector) {
                        lineNumber = ((AbstractSelector)selector).getLineNumber();
                    }
                    if (selector.getSelectorType() == 4) {
                        this.addSimpleTypeSelector((ElementSelector)selector, declaration, lineNumber, isLocal);
                        continue;
                    }
                    if (selector.getSelectorType() == 0) {
                        this.addConditionalSelector((ConditionalSelector)selector, declaration, lineNumber);
                        continue;
                    }
                    if (selector.getSelectorType() == 10) {
                        this.addDescendantSelector((DescendantSelector)selector, declaration, lineNumber);
                        continue;
                    }
                    this.unsupportedSelector(selector, lineNumber);
                }
                continue;
            }
            if (!(rule instanceof FontFaceRule)) continue;
            this.addFontFaceRule((FontFaceRule)rule);
        }
    }

    protected void addConditionalSelector(ConditionalSelector selector, StyleDeclaration declaration, int lineNumber) {
        if (this.advanced) {
            StyleSelector baseSelector = this.convertSelector((Selector)selector, lineNumber);
            if (baseSelector != null) {
                String subject = baseSelector.getValue();
                this.addAdvancedSelectorToStyleDef(subject, declaration, baseSelector, false, lineNumber);
            }
        } else {
            Condition condition = selector.getCondition();
            if (condition.getConditionType() == 9) {
                String name = ((AttributeCondition)condition).getValue();
                assert (name != null) : "parsed CSS class selector name is null";
                this.addSelectorToStyleDef(name, declaration, false, false, lineNumber);
            } else {
                this.unsupportedCondition(condition, lineNumber);
            }
        }
    }

    protected void addDescendantSelector(DescendantSelector selector, StyleDeclaration declaration, int lineNumber) {
        if (this.advanced) {
            StyleSelector baseSelector = this.convertSelector((Selector)selector, lineNumber);
            if (baseSelector != null) {
                String subject = baseSelector.getValue();
                this.addAdvancedSelectorToStyleDef(subject, declaration, baseSelector, false, lineNumber);
            }
        } else {
            this.unsupportedSelector((Selector)selector, lineNumber);
        }
    }

    protected void addSimpleTypeSelector(ElementSelector selector, StyleDeclaration declaration, int lineNumber, boolean isLocal) {
        String name = selector.getLocalName();
        if (name != null) {
            if (this.advanced) {
                StyleSelector baseSelector = this.convertSelector((Selector)selector, lineNumber);
                if (baseSelector != null) {
                    String subject = baseSelector.getValue();
                    this.addAdvancedSelectorToStyleDef(subject, declaration, baseSelector, isLocal, lineNumber);
                }
            } else {
                this.addSelectorToStyleDef(name, declaration, true, isLocal, lineNumber);
            }
        }
    }

    protected void unsupportedSelector(Selector selector, int lineNumber) {
        SelectorTypeNotSupported selectorTypeNotSupported = new SelectorTypeNotSupported(this.getSource().getName(), lineNumber, selector.toString());
        ThreadLocalToolkit.log(selectorTypeNotSupported);
    }

    protected void unsupportedCondition(Condition condition, int lineNumber) {
        ConditionTypeNotSupported conditionTypeNotSupported = new ConditionTypeNotSupported(this.getSource().getName(), lineNumber, condition.toString());
        ThreadLocalToolkit.log(conditionTypeNotSupported);
    }

    protected void addSelectorToStyleDef(String subject, StyleDeclaration declaration, boolean isTypeSelector, boolean isLocal, int lineNumber) {
        StyleDef styleDef = this.styleDefs.get(subject);
        if (styleDef == null) {
            styleDef = new StyleDef(subject, isTypeSelector, null, this.source, lineNumber, this.perCompileData);
            this.styleDefs.put(subject, styleDef);
        }
        styleDef.addDeclaration(declaration);
    }

    protected void addAdvancedSelectorToStyleDef(String subject, StyleDeclaration declaration, StyleSelector selector, boolean isLocal, int lineNumber) {
        StyleDef styleDef;
        String styleDefKey = subject;
        if ("*".equals(subject)) {
            styleDefKey = "global";
            if (selector.getConditions() != null && selector.getConditions().size() > 0) {
                selector.setValue("");
            }
        }
        if (this.styleDefs.containsKey(styleDefKey)) {
            styleDef = this.styleDefs.get(styleDefKey);
        } else {
            styleDef = new StyleDef(subject, null, this.source, lineNumber, this.perCompileData);
            this.styleDefs.put(styleDefKey, styleDef);
        }
        styleDef.addDeclaration(subject, selector, declaration);
    }

    private StyleSelector convertSelector(Selector selector, int lineNumber) {
        StyleSelector simpleTypeSelector = null;
        if (selector instanceof ElementSelector) {
            simpleTypeSelector = this.convertTypeSelector((ElementSelector)selector, lineNumber);
        } else if (selector instanceof ConditionalSelector) {
            ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
            SimpleSelector simpleSelector = conditionalSelector.getSimpleSelector();
            if (simpleSelector instanceof ElementSelector) {
                simpleTypeSelector = this.convertTypeSelector((ElementSelector)simpleSelector, lineNumber);
            }
            if (simpleTypeSelector != null) {
                Condition condition = conditionalSelector.getCondition();
                boolean supportedCondition = this.convertCondition(simpleTypeSelector, condition);
                if (!supportedCondition) {
                    this.unsupportedCondition(condition, lineNumber);
                    return null;
                }
            } else {
                this.unsupportedSelector(selector, lineNumber);
            }
        } else if (selector instanceof DescendantSelector) {
            DescendantSelector descendantSelector = (DescendantSelector)selector;
            SimpleSelector simpleSelector = descendantSelector.getSimpleSelector();
            simpleTypeSelector = this.convertSelector((Selector)simpleSelector, lineNumber);
            if (simpleTypeSelector != null) {
                Selector ancestorSelector = descendantSelector.getAncestorSelector();
                simpleTypeSelector.setAncestor(this.convertSelector(ancestorSelector, lineNumber));
            }
        } else {
            this.unsupportedSelector(selector, lineNumber);
        }
        return simpleTypeSelector;
    }

    private StyleSelector convertTypeSelector(ElementSelector selector, int lineNumber) {
        StyleSelector result = null;
        if (selector != null && selector.getSelectorType() == 4) {
            String name = selector.getLocalName();
            String uri = selector.getNamespaceURI();
            if (name == null && "*".equals(selector.toString())) {
                name = "*";
            } else if (!"global".equals(name) && this.qualifiedTypeSelectors) {
                if (uri != null) {
                    String className = this.getQualifiedClassName(uri, name);
                    if (className != null) {
                        name = className;
                    } else {
                        UnresolvedQualifiedTypeSelector unresolvedType = new UnresolvedQualifiedTypeSelector(this.getSource().getName(), lineNumber, name, selector.toString());
                        ThreadLocalToolkit.log(unresolvedType);
                    }
                } else {
                    UnqualifiedTypeSelector unqualifiedTypeSelector = new UnqualifiedTypeSelector(this.getSource().getName(), lineNumber, name, selector.toString());
                    ThreadLocalToolkit.log(unqualifiedTypeSelector);
                }
            }
            if (name != null) {
                result = new StyleSelector();
                result.setValue(name);
            }
        }
        return result;
    }

    private boolean convertCondition(StyleSelector selector, Condition condition) {
        boolean supportedCondition = true;
        if (condition instanceof CombinatorCondition) {
            CombinatorCondition cc = (CombinatorCondition)condition;
            supportedCondition = this.convertCondition(selector, cc.getFirstCondition());
            if (supportedCondition) {
                supportedCondition = this.convertCondition(selector, cc.getSecondCondition());
            }
        } else if (condition instanceof AttributeCondition) {
            AttributeCondition attributeCondition = (AttributeCondition)condition;
            short conditionType = condition.getConditionType();
            StyleCondition styleCondition = null;
            if (conditionType == 9) {
                styleCondition = new StyleCondition("class", attributeCondition.getValue());
            } else if (conditionType == 5) {
                styleCondition = new StyleCondition("id", attributeCondition.getValue());
            } else if (conditionType == 10) {
                styleCondition = new StyleCondition("pseudo", attributeCondition.getValue());
            }
            if (styleCondition != null) {
                selector.addCondition(styleCondition);
            } else {
                supportedCondition = false;
            }
        } else {
            supportedCondition = false;
        }
        return supportedCondition;
    }

    protected String getQualifiedClassName(String uri, String name) {
        String className = null;
        if (uri != null) {
            assert (this.nameMappings != null);
            className = this.nameMappings.resolveClassName(uri, name);
            if (className != null) {
                className = className.replace(':', '.');
            }
        }
        return className;
    }

    protected void addFontFaceRule(FontFaceRule fontFaceRule) {
        boolean italic;
        boolean bold;
        assert (fontFaceRule != null);
        String family = fontFaceRule.getFamily();
        if (FontFaceRule.getRule(this.fontFaceRules, family, bold = fontFaceRule.isBold(), italic = fontFaceRule.isItalic()) == null) {
            this.fontFaceRules.add(fontFaceRule);
            String propName = "_embed__font_" + family + "_" + (bold ? "bold" : "medium") + "_" + (italic ? "italic" : "normal");
            Map<String, Object> embedParams = fontFaceRule.getEmbedParams();
            StyleDeclaration styleDeclaration = fontFaceRule.getStyleDeclaration();
            String path = styleDeclaration.getPath();
            if (path.indexOf(92) > -1) {
                embedParams.put("_file", path.replace('\\', '/'));
                embedParams.put("_pathsep", "true");
            } else {
                embedParams.put("_file", path);
            }
            embedParams.put("_line", Integer.toString(styleDeclaration.getLineNumber()));
            AtEmbed atEmbed = AtEmbed.create(propName, fontFaceRule.getStyleDeclaration().getLineNumber(), embedParams, false);
            this.addAtEmbed(atEmbed);
        } else if (Trace.font) {
            Trace.trace((String)("Font face already existed for " + family + " bold? " + bold + " italic? " + italic));
        }
    }

    protected void addAtEmbed(AtEmbed atEmbed) {
        this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
    }
}

