/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.managed;

import flex.messaging.config.ServicesDependencies;
import flex2.compiler.as3.genext.GenerativeClassInfo;
import flex2.compiler.as3.genext.GenerativeFirstPassEvaluator;
import flex2.compiler.as3.managed.ManagedClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedFirstPassEvaluator
extends GenerativeFirstPassEvaluator {
    private final Set metaData;
    private ManagedClassInfo currentInfo;
    private Map<String, ManagedClassInfo> managedClasses;
    private Map<DefinitionNode, ManagedClassInfo> managedProperties;
    private ServicesDependencies servicesDependencies;

    public ManagedFirstPassEvaluator(TypeTable typeTable, StandardDefs defs, Set metaData, ServicesDependencies servicesDependencies) {
        super(typeTable, defs);
        this.metaData = metaData;
        this.servicesDependencies = servicesDependencies;
    }

    public Map<String, ManagedClassInfo> getClassMap() {
        return this.managedClasses != null ? this.managedClasses : Collections.emptyMap();
    }

    @Override
    public boolean makeSecondPass() {
        return this.managedClasses != null;
    }

    @Override
    public Value evaluate(Context context, ProgramNode programNode) {
        for (MetaDataNode metaDataNode : this.metaData) {
            if (!"Managed".equals(metaDataNode.id) || !(metaDataNode.def instanceof ClassDefinitionNode)) continue;
            ClassDefinitionNode classDef = (ClassDefinitionNode)metaDataNode.def;
            this.currentInfo = new ManagedClassInfo(context, this.typeTable.getSymbolTable(), NodeMagic.getClassName(classDef));
            String destination = metaDataNode.getValue("destination");
            this.registerLazyAssociations(destination, metaDataNode, classDef, context);
            this.evaluate(context, classDef);
            this.currentInfo = null;
        }
        for (MetaDataNode metaDataNode : this.metaData) {
            ManagedClassInfo classInfo;
            if (!"Managed".equals(metaDataNode.id) || metaDataNode.def instanceof ClassDefinitionNode) continue;
            if (metaDataNode.def instanceof VariableDefinitionNode) {
                VariableDefinitionNode varNode = (VariableDefinitionNode)metaDataNode.def;
                classInfo = this.getClassOfManagedMember((DefinitionNode)varNode);
                if (classInfo != null) {
                    this.setPropertyMode(context, metaDataNode, classInfo, new QName(NodeMagic.getUserNamespace((DefinitionNode)varNode), NodeMagic.getVariableName(varNode)));
                    continue;
                }
                context.localizedWarning2(metaDataNode.pos(), (Object)new ManagedOnNonClassError());
                continue;
            }
            if (metaDataNode.def instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode node = (FunctionDefinitionNode)metaDataNode.def;
                classInfo = this.getClassOfManagedMember((DefinitionNode)node);
                if (classInfo != null) {
                    this.setPropertyMode(context, metaDataNode, classInfo, new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getFunctionName(node)));
                    continue;
                }
                context.localizedWarning2(metaDataNode.pos(), (Object)new ManagedOnNonClassError());
                continue;
            }
            context.localizedWarning2(metaDataNode.pos(), (Object)new ManagedOnNonClassError());
        }
        if (this.managedClasses != null) {
            for (ManagedClassInfo info : this.managedClasses.values()) {
                Map<QName, GenerativeClassInfo.AccessorInfo> accessors = info.getAccessors();
                if (accessors == null) continue;
                Iterator<Map.Entry<QName, GenerativeClassInfo.AccessorInfo>> propIter = accessors.entrySet().iterator();
                while (propIter.hasNext()) {
                    Map.Entry<QName, GenerativeClassInfo.AccessorInfo> entry = propIter.next();
                    QName propQName = entry.getKey();
                    int mode = info.getPropertyMode(propQName);
                    if (mode != 2) continue;
                    propIter.remove();
                }
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode node) {
        this.registerManagedClass(this.currentInfo);
        this.addManagedImports(context, node);
        if (node.statements != null) {
            if (node.instanceinits != null) {
                for (Node instanceinit : node.instanceinits) {
                    instanceinit.evaluate(context, (Evaluator)this);
                }
            }
            node.statements.evaluate(context, (Evaluator)this);
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, FunctionDefinitionNode node) {
        boolean isGetter = NodeMagic.functionIsGetter(node);
        if ((isGetter || NodeMagic.functionIsSetter(node)) && ManagedFirstPassEvaluator.canManage((DefinitionNode)node)) {
            assert (this.currentInfo != null) : "currentInfo == null";
            this.currentInfo.addAccessorFunction(node, false, isGetter);
            this.registerManagedProperty((DefinitionNode)node, this.currentInfo);
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, VariableDefinitionNode node) {
        if (ManagedFirstPassEvaluator.canManage((DefinitionNode)node)) {
            assert (this.currentInfo != null) : "currentInfo == null";
            this.currentInfo.addAccessorVariable(node, false);
            this.registerManagedProperty((DefinitionNode)node, this.currentInfo);
        }
        return null;
    }

    private static boolean canManage(DefinitionNode def) {
        return def.attrs != null && def.attrs.hasAttribute("public") && !def.attrs.hasAttribute("static") && !def.attrs.hasAttribute("const");
    }

    private void registerLazyAssociations(String destination, MetaDataNode node, ClassDefinitionNode classNode, Context context) {
        if (destination != null) {
            if (this.servicesDependencies == null) {
                context.localizedWarning2(node.pos(), (Object)new LazyAssociationsRequireServicesConfiguration(classNode.name.name));
            } else {
                Set lazyAssociations = this.servicesDependencies.getLazyAssociations(destination);
                this.currentInfo.setTransientProperties(lazyAssociations);
            }
        }
    }

    private void registerManagedClass(ManagedClassInfo info) {
        if (this.managedClasses == null) {
            this.managedClasses = new LinkedHashMap<String, ManagedClassInfo>();
        }
        this.managedClasses.put(info.getClassName(), info);
    }

    private void registerManagedProperty(DefinitionNode node, ManagedClassInfo classInfo) {
        if (this.managedProperties == null) {
            this.managedProperties = new HashMap<DefinitionNode, ManagedClassInfo>();
        }
        this.managedProperties.put(node, classInfo);
    }

    private ManagedClassInfo getClassOfManagedMember(DefinitionNode node) {
        return this.managedProperties == null ? null : this.managedProperties.get(node);
    }

    private void addManagedImports(Context context, ClassDefinitionNode node) {
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_EVENT));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_EVENTDISPATCHER));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_PROPERTYCHANGEEVENT));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_MANAGED));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.CLASS_UIDUTIL));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.INTERFACE_IMANAGED));
        NodeMagic.addImport(context, node, NameFormatter.toDot(this.standardDefs.NAMESPACE_MX_INTERNAL));
    }

    private void setPropertyMode(Context context, MetaDataNode node, ManagedClassInfo classInfo, QName propertyQName) {
        int mode = this.modeFromString(context, node);
        if (mode != -1) {
            if (classInfo.hasExplicitMode(propertyQName) && classInfo.getPropertyMode(propertyQName) != mode) {
                context.localizedError2(node.pos(), (Object)new ManagedModeConflictError());
            } else {
                classInfo.setPropertyMode(propertyQName, mode);
            }
        }
    }

    private int modeFromString(Context context, MetaDataNode node) {
        String mode = node.getValue("mode");
        if (mode == null || mode.equals("hierarchical")) {
            return 0;
        }
        if (mode.equals("association")) {
            return 1;
        }
        if (mode.equals("manual")) {
            return 2;
        }
        context.localizedError2(node.pos(), (Object)new InvalidManagedModeError(mode));
        return -1;
    }

    public static class LazyAssociationsRequireServicesConfiguration
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -987972581239930083L;
        public String className;

        public LazyAssociationsRequireServicesConfiguration(String className) {
            this.className = className;
        }
    }

    public static class ManagedModeConflictError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6158567885498343734L;
    }

    public static class InvalidManagedModeError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 538805303131124085L;
        public String mode;

        public InvalidManagedModeError(String mode) {
            this.mode = mode;
        }
    }

    public static class ManagedOnNonClassError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 7682841174699426465L;
    }
}

