/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flash.swf.tools.as3.EvaluatorAdapter;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.Info;
import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAnalyzer
extends EvaluatorAdapter {
    private static final String DELEGATE_UNIT = "DelegateUnit";
    private static final String REQUIRED = "required";
    private static final String SKINPART = "SkinPart";
    private static final String TRUE = "true";
    private SymbolTable symbolTable;
    private Map<String, ClassInfo> classInfoMap;
    private Map<String, InterfaceInfo> interfaceInfoMap;
    private Info currentInfo;
    private String currentPackageName;

    public TypeAnalyzer(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.classInfoMap = new HashMap<String, ClassInfo>();
        this.interfaceInfoMap = new HashMap<String, InterfaceInfo>();
    }

    private void analyzeInterfaces(Context context, List multiNames, Info info) {
        for (MultiName multiName : multiNames) {
            this.analyzeInterface(context, multiName, info);
        }
    }

    public InterfaceInfo analyzeInterface(Context context, MultiName multiName, Info info) {
        InterfaceInfo interfaceInfo = null;
        QName qName = this.findQName(multiName);
        if (qName != null) {
            Source source = this.symbolTable.findSourceByQName(qName);
            interfaceInfo = this.interfaceInfoMap.get(qName.toString());
            if (interfaceInfo == null) {
                CompilationUnit compilationUnit = source.getCompilationUnit();
                if (compilationUnit != null) {
                    AbcClass abcClass = compilationUnit.classTable.get(qName.toString());
                    if (abcClass != null) {
                        this.buildInterfaceInfo(context, qName, abcClass);
                    } else {
                        Node node = this.getNode(compilationUnit);
                        if (node != null) {
                            Info oldInfo = this.currentInfo;
                            this.currentInfo = null;
                            node.evaluate(context, (Evaluator)this);
                            this.currentInfo = oldInfo;
                        } else assert (false) : "Compilation unit had no type info and after parsing has no syntax tree";
                    }
                }
                interfaceInfo = this.interfaceInfoMap.get(qName.toString());
            }
            if (interfaceInfo != null) {
                info.addInterfaceInfo(interfaceInfo);
            } else if (Trace.binding) {
                Trace.trace((String)("TypeAnalyzer.analyzeInterfaces: unresolved qName " + qName));
            }
        } else if (Trace.binding) {
            Trace.trace((String)("TypeAnalyzer.analyzeInterfaces: unresolved multiName " + multiName));
        }
        return interfaceInfo;
    }

    private void analyzeBaseClass(Context context, MultiName multiName, ClassInfo classInfo) {
        ClassInfo baseClassInfo = this.analyzeClass(context, multiName);
        if (baseClassInfo != null) {
            classInfo.setBaseClassInfo(baseClassInfo);
        }
    }

    public ClassInfo analyzeClass(Context context, MultiName multiName) {
        ClassInfo classInfo = null;
        QName qName = this.findQName(multiName);
        if (qName != null) {
            classInfo = this.classInfoMap.get(qName.toString());
            if (classInfo == null) {
                Source source = this.symbolTable.findSourceByQName(qName);
                assert (source != null) : "no source for qname '" + qName + "', even though multiname was resolved";
                CompilationUnit compilationUnit = source.getCompilationUnit();
                AbcClass abcClass = compilationUnit.classTable.get(qName.toString());
                if (abcClass != null) {
                    this.buildClassInfo(context, qName, abcClass);
                } else {
                    Node node = this.getNode(compilationUnit);
                    if (node != null) {
                        Info oldInfo = this.currentInfo;
                        this.currentInfo = null;
                        node.evaluate(context, (Evaluator)this);
                        this.currentInfo = oldInfo;
                    } else if (Trace.error) {
                        Trace.trace((String)("Compilation unit had no type info and after parsing has no syntax tree: qname = '" + qName.toString() + "'"));
                    }
                }
                classInfo = this.classInfoMap.get(qName.toString());
            }
        } else if (Trace.binding) {
            Trace.trace((String)("TypeAnalyzer.analyzeBaseClass: unresolved multiName " + multiName));
        }
        return classInfo;
    }

    private void analyzeBaseInterface(Context context, MultiName multiName, InterfaceInfo interfaceInfo) {
        QName qName = this.findQName(multiName);
        if (qName != null) {
            Source source = this.symbolTable.findSourceByQName(qName);
            InterfaceInfo baseInterfaceInfo = this.interfaceInfoMap.get(qName.toString());
            if (baseInterfaceInfo == null) {
                CompilationUnit compilationUnit = source.getCompilationUnit();
                AbcClass abcClass = null;
                if (compilationUnit != null && (abcClass = compilationUnit.classTable.get(qName.toString())) != null) {
                    this.buildInterfaceInfo(context, qName, abcClass);
                }
                if (abcClass == null) {
                    Node node = this.getNode(compilationUnit);
                    if (node != null) {
                        Info oldInfo = this.currentInfo;
                        this.currentInfo = null;
                        node.evaluate(context, (Evaluator)this);
                        this.currentInfo = oldInfo;
                    } else assert (false) : "Compilation unit had no type info and after parsing has no syntax tree";
                }
                baseInterfaceInfo = this.interfaceInfoMap.get(qName.toString());
            }
            if (baseInterfaceInfo != null) {
                interfaceInfo.setBaseInterfaceInfo(baseInterfaceInfo);
            } else if (Trace.binding) {
                Trace.trace((String)("TypeAnalyzer.analyzeInterfaces: unresolved qName " + qName));
            }
        } else if (Trace.binding) {
            Trace.trace((String)("TypeAnalyzer.analyzeBaseInterface: unresolved multiName " + multiName));
        }
    }

    private void buildClassInfo(Context context, QName qName, AbcClass abcClass) {
        QName[] variableNames;
        QName[] setterNames;
        QName[] getterNames;
        QName[] methodNames;
        String[] interfaceNames;
        ClassInfo classInfo = new ClassInfo(abcClass.getName());
        if (this.currentPackageName != null) {
            this.currentInfo.addImport(this.currentPackageName);
        }
        this.classInfoMap.put(qName.toString(), classInfo);
        String superTypeName = abcClass.getSuperTypeName();
        if (superTypeName != null) {
            classInfo.setBaseClassName(superTypeName);
            this.analyzeBaseClass(context, classInfo.getBaseClassMultiName(), classInfo);
        }
        if ((interfaceNames = abcClass.getInterfaceNames()) != null) {
            for (int i = 0; i < interfaceNames.length; ++i) {
                classInfo.addInterfaceName(interfaceNames[i]);
            }
            this.analyzeInterfaces(context, classInfo.getInterfaceMultiNames(), classInfo);
        }
        if ((methodNames = abcClass.getMethodNames()) != null) {
            for (int i = 0; i < methodNames.length; ++i) {
                classInfo.addFunction(methodNames[i]);
            }
        }
        if ((getterNames = abcClass.getGetterNames()) != null) {
            for (int i = 0; i < getterNames.length; ++i) {
                classInfo.addGetter(getterNames[i]);
            }
        }
        if ((setterNames = abcClass.getSetterNames()) != null) {
            for (int i = 0; i < setterNames.length; ++i) {
                classInfo.addSetter(setterNames[i]);
            }
        }
        if ((variableNames = abcClass.getVariableNames()) != null) {
            for (int i = 0; i < variableNames.length; ++i) {
                classInfo.addVariable(variableNames[i]);
            }
        }
    }

    private void buildInterfaceInfo(Context context, QName qName, AbcClass abcClass) {
        QName[] methodNames;
        String[] interfaceNames;
        InterfaceInfo interfaceInfo = new InterfaceInfo(abcClass.getName());
        this.interfaceInfoMap.put(qName.toString(), interfaceInfo);
        String superTypeName = abcClass.getSuperTypeName();
        if (superTypeName != null) {
            interfaceInfo.setBaseInterfaceName(superTypeName);
            this.analyzeBaseInterface(context, interfaceInfo.getBaseInterfaceMultiName(), interfaceInfo);
        }
        if ((interfaceNames = abcClass.getInterfaceNames()) != null) {
            for (int i = 0; i < interfaceNames.length; ++i) {
                interfaceInfo.addInterfaceName(interfaceNames[i]);
            }
            this.analyzeInterfaces(context, interfaceInfo.getInterfaceMultiNames(), interfaceInfo);
        }
        if ((methodNames = abcClass.getMethodNames()) != null) {
            for (int i = 0; i < methodNames.length; ++i) {
                interfaceInfo.addFunction(methodNames[i]);
            }
        }
    }

    @Override
    public Value evaluate(Context context, BinaryInterfaceDefinitionNode binaryInterfaceDefinition) {
        if (binaryInterfaceDefinition.cframe != null && binaryInterfaceDefinition.cframe.name != null && binaryInterfaceDefinition.cframe.name.ns != null) {
            this.currentPackageName = binaryInterfaceDefinition.cframe.name.ns.name;
        }
        Value result = this.evaluateInterface(context, (ClassDefinitionNode)binaryInterfaceDefinition);
        this.currentPackageName = null;
        return result;
    }

    @Override
    public Value evaluate(Context context, BinaryClassDefNode binaryClassDefinition) {
        if (binaryClassDefinition.cframe != null && binaryClassDefinition.cframe.name != null && binaryClassDefinition.cframe.name.ns != null) {
            this.currentPackageName = binaryClassDefinition.cframe.name.ns.name;
        }
        Value result = this.evaluate(context, (ClassDefinitionNode)binaryClassDefinition);
        this.currentPackageName = null;
        return result;
    }

    @Override
    public Value evaluate(Context context, ClassDefinitionNode classDefinition) {
        String className = NodeMagic.getClassName(classDefinition);
        if (this.classInfoMap.get(className) == null) {
            Info oldInfo = this.currentInfo;
            this.currentInfo = new ClassInfo(className);
            this.classInfoMap.put(className, (ClassInfo)this.currentInfo);
            if (this.currentPackageName != null) {
                this.currentInfo.addImport(this.currentPackageName);
            }
            if (classDefinition.pkgdef != null) {
                this.processImports(classDefinition.pkgdef.statements.items.iterator(), this.currentInfo);
            }
            if (classDefinition.statements != null) {
                this.processImports(classDefinition.statements.items.iterator(), this.currentInfo);
            }
            if (classDefinition.baseclass != null) {
                ClassInfo classInfo = (ClassInfo)this.currentInfo;
                if (classDefinition.baseclass instanceof MemberExpressionNode) {
                    MemberExpressionNode memberExpression = (MemberExpressionNode)classDefinition.baseclass;
                    if (memberExpression.selector != null) {
                        IdentifierNode identifier = memberExpression.selector.getIdentifier();
                        String baseClassName = this.toString(identifier);
                        classInfo.setBaseClassName(baseClassName);
                        this.analyzeBaseClass(context, classInfo.getBaseClassMultiName(), classInfo);
                    }
                } else if (classDefinition.baseclass instanceof LiteralStringNode) {
                    String baseClassName = ((LiteralStringNode)classDefinition.baseclass).value;
                    classInfo.setBaseClassName(baseClassName);
                    this.analyzeBaseClass(context, classInfo.getBaseClassMultiName(), classInfo);
                } else assert (false);
            }
            this.processInterfaces(context, classDefinition);
            super.evaluate(context, classDefinition);
            this.currentInfo = oldInfo;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, InterfaceDefinitionNode interfaceDefinition) {
        return this.evaluateInterface(context, (ClassDefinitionNode)interfaceDefinition);
    }

    private Value evaluateInterface(Context context, ClassDefinitionNode interfaceDefinition) {
        String interfaceName = NodeMagic.getClassName(interfaceDefinition);
        if (this.interfaceInfoMap.get(interfaceName) == null) {
            Info oldInfo = this.currentInfo;
            this.currentInfo = new InterfaceInfo(interfaceName);
            this.interfaceInfoMap.put(interfaceName, (InterfaceInfo)this.currentInfo);
            if (interfaceDefinition.pkgdef != null) {
                this.processImports(interfaceDefinition.pkgdef.statements.items.iterator(), this.currentInfo);
            }
            if (interfaceDefinition.statements != null) {
                this.processImports(interfaceDefinition.statements.items.iterator(), this.currentInfo);
            }
            if (interfaceDefinition.baseclass != null) {
                if (interfaceDefinition.baseclass instanceof MemberExpressionNode) {
                    MemberExpressionNode memberExpression = (MemberExpressionNode)interfaceDefinition.baseclass;
                    if (memberExpression.selector != null) {
                        IdentifierNode identifier = memberExpression.selector.getIdentifier();
                        String baseInterfaceName = this.toString(identifier);
                        InterfaceInfo interfaceInfo = (InterfaceInfo)this.currentInfo;
                        interfaceInfo.setBaseInterfaceName(baseInterfaceName);
                        this.analyzeBaseInterface(context, interfaceInfo.getBaseInterfaceMultiName(), interfaceInfo);
                    }
                } else assert (false);
            }
            this.processInterfaces(context, interfaceDefinition);
            super.evaluate(context, interfaceDefinition);
            this.currentInfo = oldInfo;
        }
        return null;
    }

    @Override
    public Value evaluate(Context context, FunctionCommonNode functionCommon) {
        return null;
    }

    @Override
    public Value evaluate(Context context, FunctionDefinitionNode functionDefinition) {
        if (functionDefinition.name != null && functionDefinition.name.identifier != null && functionDefinition.name.identifier.name != null) {
            QName functionName = new QName(NodeMagic.getUserNamespace((DefinitionNode)functionDefinition), NodeMagic.getFunctionName(functionDefinition));
            if (this.currentInfo != null) {
                if (NodeMagic.functionIsGetter(functionDefinition)) {
                    this.currentInfo.addGetter(functionName);
                } else if (NodeMagic.functionIsSetter(functionDefinition)) {
                    this.currentInfo.addSetter(functionName);
                } else {
                    this.currentInfo.addFunction(functionName);
                }
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, PackageDefinitionNode packageDefinition) {
        PackageIdentifiersNode packageIdentifiers;
        PackageNameNode packageName = packageDefinition.name;
        if (packageName != null && (packageIdentifiers = packageName.id) != null && packageIdentifiers.pkg_part != null) {
            this.currentPackageName = packageIdentifiers.pkg_part;
        }
        super.evaluate(cx, packageDefinition);
        this.currentPackageName = null;
        return null;
    }

    @Override
    public Value evaluate(Context context, VariableDefinitionNode variableDefinition) {
        if (variableDefinition.list != null && variableDefinition.list.items != null && variableDefinition.list.items.get(0) instanceof VariableBindingNode) {
            QName variableName = new QName(NodeMagic.getUserNamespace((DefinitionNode)variableDefinition), NodeMagic.getVariableName(variableDefinition));
            if (this.currentInfo != null) {
                if (!(this.currentInfo instanceof ClassInfo)) {
                    System.err.println("TypeAnalyzer: currentInfo = " + this.currentInfo + ", variableName = " + variableName);
                }
                ((ClassInfo)this.currentInfo).addVariable(variableName);
            }
        }
        return null;
    }

    @Override
    public Value evaluate(Context cx, MetaDataNode node) {
        if (node.id.equals(SKINPART) && node.def instanceof VariableDefinitionNode) {
            VariableDefinitionNode varDataNode = (VariableDefinitionNode)node.def;
            VariableBindingNode varBindingNode = (VariableBindingNode)varDataNode.list.items.first();
            String fieldName = varBindingNode.variable.identifier.name;
            String sRequired = node.getValue(REQUIRED);
            Boolean required = false;
            if (sRequired != null) {
                required = sRequired.equalsIgnoreCase(TRUE);
            }
            ((ClassInfo)this.currentInfo).addSkinPart(fieldName, required);
        }
        return null;
    }

    private QName findQName(MultiName multiName) {
        String[] namespace = multiName.getNamespace();
        String localPart = multiName.getLocalPart();
        int length = namespace.length;
        QName result = null;
        for (int i = 0; i < length && result == null; ++i) {
            if (this.symbolTable.findSourceByQName(namespace[i], localPart) == null) continue;
            result = multiName.getQName(i);
        }
        return result;
    }

    public ClassInfo getClassInfo(String className) {
        return this.classInfoMap.get(className);
    }

    public Iterator<ClassInfo> getClassInfoIterator() {
        return this.classInfoMap.values().iterator();
    }

    private Node getNode(CompilationUnit compilationUnit) {
        assert (compilationUnit != null) : "null CompilationUnit passed to getNode()";
        Node result = null;
        Object syntaxTree = compilationUnit.getSyntaxTree();
        if (syntaxTree != null) {
            if (!(syntaxTree instanceof Node)) {
                CompilerContext context = compilationUnit.getContext();
                CompilationUnit delegateUnit = (CompilationUnit)context.getAttribute(DELEGATE_UNIT);
                if (delegateUnit != null) {
                    result = (Node)delegateUnit.getSyntaxTree();
                }
            } else {
                result = (Node)syntaxTree;
            }
        }
        return result;
    }

    private void processImports(Iterator iterator, Info info) {
        while (iterator.hasNext()) {
            Object node = iterator.next();
            if (!(node instanceof ImportDirectiveNode)) continue;
            ImportDirectiveNode importDirective = (ImportDirectiveNode)node;
            if (importDirective.name.id.def_part.length() == 0) {
                info.addImport(importDirective.name.id.pkg_part);
                continue;
            }
            info.addQualifiedImport(importDirective.name.id.def_part, importDirective.name.id.pkg_part);
        }
    }

    private void processInterfaces(Context context, ClassDefinitionNode definition) {
        if (definition.interfaces != null) {
            for (MemberExpressionNode memberExpression : definition.interfaces.items) {
                if (memberExpression.selector == null) continue;
                IdentifierNode identifier = memberExpression.selector.getIdentifier();
                String interfaceName = this.toString(identifier);
                if (identifier.ref != null && identifier.ref.namespaces != null) {
                    int size = identifier.ref.namespaces.size();
                    if (size == 0) {
                        NamespaceValue namespaceValue = (NamespaceValue)identifier.ref.namespaces.get(0);
                        if (namespaceValue.name.length() > 0) {
                            this.currentInfo.addInterfaceMultiName(namespaceValue.name, interfaceName);
                            continue;
                        }
                        this.currentInfo.addInterfaceName(interfaceName);
                        continue;
                    }
                    HashSet<String> namespacesSet = new HashSet<String>();
                    for (int i = 0; i < size; ++i) {
                        NamespaceValue namespaceValue = (NamespaceValue)identifier.ref.namespaces.get(i);
                        if (namespaceValue.name.length() <= 0) continue;
                        namespacesSet.add(namespaceValue.name);
                    }
                    String[] namespaces = new String[namespacesSet.size()];
                    namespacesSet.toArray(namespaces);
                    this.currentInfo.addInterfaceMultiName(namespaces, interfaceName);
                    continue;
                }
                this.currentInfo.addInterfaceName(interfaceName);
            }
            this.analyzeInterfaces(context, this.currentInfo.getInterfaceMultiNames(), this.currentInfo);
        }
    }

    public void removeClassInfo(String className) {
        this.classInfoMap.remove(className);
    }

    private String toString(IdentifierNode identifier) {
        String result = null;
        if (identifier instanceof QualifiedIdentifierNode) {
            QualifiedIdentifierNode qualifiedIdentifier = (QualifiedIdentifierNode)identifier;
            if (qualifiedIdentifier.qualifier instanceof LiteralStringNode) {
                LiteralStringNode literalString = (LiteralStringNode)qualifiedIdentifier.qualifier;
                result = literalString.value + ":" + qualifiedIdentifier.name;
            } else assert (false) : "Unhandled QualifiedIdentifierNode qualifier type: " + qualifiedIdentifier.qualifier.getClass().getName();
        } else {
            result = identifier.name;
        }
        return result;
    }
}

