/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.fonts.FontManager;
import flash.localization.LocalizationManager;
import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.MovieEncoder;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.swf.types.Rect;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.DeletedFile;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.LocalLogger;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import macromedia.asc.util.IntegerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersistenceStore {
    private static final int major_version = 4;
    private static final int minor_version = 3;
    private final Configuration configuration;
    private final RandomAccessFile file;
    private final ArrayKey key;
    private final FontManager fontManager;

    PersistenceStore(Configuration configuration, RandomAccessFile file) {
        this(configuration, file, null);
    }

    PersistenceStore(Configuration configuration, RandomAccessFile file, FontManager fontManager) {
        assert (file != null);
        this.file = file;
        this.key = new ArrayKey();
        this.fontManager = fontManager;
        this.configuration = configuration;
    }

    int write(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, Map<String, Long> archiveFileChecksums, String description) throws IOException {
        int count;
        HashMap<Object, Integer> pool = new HashMap<Object, Integer>();
        ByteArrayOutputStream fs = new ByteArrayOutputStream();
        ByteArrayOutputStream sl = new ByteArrayOutputStream();
        ByteArrayOutputStream sp = new ByteArrayOutputStream();
        ByteArrayOutputStream rbp = new ByteArrayOutputStream();
        ByteArrayOutputStream src = new ByteArrayOutputStream();
        ByteArrayOutputStream cu = new ByteArrayOutputStream();
        ByteArrayOutputStream cp = new ByteArrayOutputStream();
        ByteArrayOutputStream h = new ByteArrayOutputStream();
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        ByteArrayOutputStream cs1 = new ByteArrayOutputStream();
        ByteArrayOutputStream cs2 = new ByteArrayOutputStream();
        ByteArrayOutputStream af = new ByteArrayOutputStream();
        this.writeHeader(checksum, cmd_checksum, linker_checksum, swc_checksum, description, h);
        if (fileSpec != null) {
            this.writeFileSpec(fileSpec, pool, fs);
        }
        if (sourceList != null) {
            this.writeSourceList(sourceList, pool, sl);
        }
        if (sourcePath != null) {
            this.writeSourcePath(sourcePath, pool, sp);
        }
        if (bundlePath != null) {
            this.writeResourceBundlePath(bundlePath, pool, rbp);
        }
        int n = count = sources == null ? 0 : sources.size();
        if (sources != null) {
            this.writeSourceNames(sources, pool, s);
        }
        Collection<Object> c1 = fileSpec == null ? Collections.emptyList() : fileSpec.sources();
        Collection<Object> c2 = sourceList == null ? Collections.emptyList() : sourceList.sources();
        Map<Object, Object> c3 = sourcePath == null ? Collections.emptyMap() : sourcePath.sources();
        Collection<Object> c4 = resources == null ? Collections.emptyList() : resources.sources();
        Map<Object, Object> c5 = bundlePath == null ? Collections.emptyMap() : bundlePath.sources();
        int totalCount = c1.size() + c2.size() + c3.size() + c4.size() + c5.size();
        this.writeCompilationUnits(c1, pool, src, cu);
        this.writeCompilationUnits(c2, pool, src, cu);
        this.writeCompilationUnits(c3.values(), pool, src, cu);
        this.writeCompilationUnits(c5.values(), pool, src, cu);
        this.writeCompilationUnits(c4, pool, src, cu);
        if (swcDefSignatureChecksums != null) {
            this.writeSwcDefSignatureChecksums(swcDefSignatureChecksums, pool, cs1);
        }
        if (swcFileChecksums != null) {
            this.writeFileChecksums(swcFileChecksums, pool, cs2);
        }
        if (archiveFileChecksums != null) {
            this.writeFileChecksums(archiveFileChecksums, pool, af);
        }
        this.writeConstantPool(pool, cp);
        this.file.write(h.toByteArray());
        this.file.writeInt(cp.size());
        this.file.write(cp.toByteArray());
        this.file.writeInt(fs.size());
        this.file.write(fs.toByteArray());
        this.file.writeInt(sl.size());
        this.file.write(sl.toByteArray());
        this.file.writeInt(sp.size());
        this.file.write(sp.toByteArray());
        this.file.writeInt(rbp.size());
        this.file.write(rbp.toByteArray());
        this.file.writeInt(count);
        this.file.write(s.toByteArray());
        this.file.writeInt(swcDefSignatureChecksums == null ? 0 : swcDefSignatureChecksums.size());
        this.file.write(cs1.toByteArray());
        this.file.writeInt(swcFileChecksums == null ? 0 : swcFileChecksums.size());
        this.file.write(cs2.toByteArray());
        this.file.writeInt(archiveFileChecksums == null ? 0 : archiveFileChecksums.size());
        this.file.write(af.toByteArray());
        this.file.writeInt(totalCount);
        this.file.writeInt(src.size());
        this.file.writeInt(cu.size());
        this.file.write(src.toByteArray());
        this.file.write(cu.toByteArray());
        return totalCount;
    }

    private void writeSwcDefSignatureChecksums(Map<QName, Long> swcDefSignatureChecksums, Map<Object, Integer> pool, OutputStream cs1) throws IOException {
        for (QName qName : swcDefSignatureChecksums.keySet()) {
            Long ts = swcDefSignatureChecksums.get(qName);
            this.writeU32(cs1, this.addQName(pool, qName));
            this.writeLong(cs1, ts);
        }
    }

    private void writeFileChecksums(Map m, Map<Object, Integer> pool, OutputStream os) throws IOException {
        for (String fileName : m.keySet()) {
            Long ts = (Long)m.get(fileName);
            this.writeU32(os, this.addString(pool, fileName));
            this.writeLong(os, ts);
        }
    }

    private void writeHeader(int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, String description, OutputStream out) throws IOException {
        this.writeU32(out, 4);
        this.writeU32(out, 3);
        this.writeU32(out, checksum);
        this.writeU32(out, cmd_checksum);
        this.writeU32(out, linker_checksum);
        this.writeU32(out, swc_checksum);
        byte[] b = description.getBytes("UTF8");
        this.writeU32(out, b.length);
        this.writeBytes(out, b);
    }

    private void writeConstantPool(Map<Object, Integer> pool, OutputStream out) throws IOException {
        TreeMap<Integer, Object> sortedPool = new TreeMap<Integer, Object>();
        for (Map.Entry<Object, Integer> e : pool.entrySet()) {
            sortedPool.put(e.getValue(), e.getKey());
        }
        this.writeU32(out, sortedPool.size());
        for (Map.Entry<Object, Integer> value : sortedPool.values()) {
            int j;
            byte[] b;
            if (value instanceof String) {
                this.writeU8(out, 1);
                b = ((String)((Object)value)).getBytes("UTF8");
                this.writeU32(out, b.length);
                this.writeBytes(out, b);
                continue;
            }
            if (value instanceof ArrayKey) {
                int size;
                this.writeU8(out, 2);
                String[] a = ((ArrayKey)((Object)value)).a1;
                this.writeU32(out, a == null ? 0 : a.length);
                int n = size = a == null ? 0 : a.length;
                for (j = 0; j < size; ++j) {
                    this.writeU32(out, this.addString(pool, a[j]));
                }
                continue;
            }
            if (value instanceof byte[]) {
                this.writeU8(out, 3);
                b = (byte[])value;
                this.writeU32(out, b.length);
                if (b.length <= 0) continue;
                this.writeBytes(out, b);
                continue;
            }
            if (value instanceof QName) {
                this.writeU8(out, 4);
                QName qName = (QName)((Object)value);
                this.writeU32(out, this.addString(pool, qName.getNamespace()));
                this.writeU32(out, this.addString(pool, qName.getLocalPart()));
                continue;
            }
            if (value instanceof MultiName) {
                this.writeU8(out, 5);
                MultiName multiName = (MultiName)((Object)value);
                this.writeU32(out, this.addStrings(pool, multiName.namespaceURI));
                this.writeU32(out, this.addString(pool, multiName.localPart));
                continue;
            }
            if (value instanceof flex2.compiler.abc.MetaData) {
                this.writeU8(out, 6);
                flex2.compiler.abc.MetaData md = (flex2.compiler.abc.MetaData)((Object)value);
                this.writeU32(out, this.addString(pool, md.getID()));
                this.writeU32(out, md.count());
                int count = md.count();
                for (j = 0; j < count; ++j) {
                    String key = md.getKey(j);
                    String val = md.getValue(j);
                    this.writeU32(out, this.addString(pool, key == null ? "" : key));
                    this.writeU32(out, this.addString(pool, val));
                }
                continue;
            }
            assert (false);
        }
    }

    private void writeSourceNames(List sources, Map<Object, Integer> pool, OutputStream out) throws IOException {
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source s = (Source)sources.get(i);
            if (s != null) {
                this.writeU32(out, this.addString(pool, s.getName()));
                if (s.isFileSpecOwner()) {
                    this.writeU8(out, 0);
                    continue;
                }
                if (s.isSourceListOwner()) {
                    this.writeU8(out, 1);
                    continue;
                }
                if (s.isSourcePathOwner()) {
                    this.writeU8(out, 2);
                    continue;
                }
                if (s.isResourceContainerOwner()) {
                    this.writeU8(out, 3);
                    continue;
                }
                if (s.isResourceBundlePathOwner()) {
                    this.writeU8(out, 4);
                    continue;
                }
                this.writeU8(out, 5);
                continue;
            }
            this.writeU32(out, this.addString(pool, "null"));
        }
    }

    private void writeFileSpec(FileSpec fileSpec, Map<Object, Integer> pool, OutputStream fs) throws IOException {
        String[] mimeTypes = fileSpec.getMimeTypes();
        Collection<Source> sources = fileSpec.sources();
        this.writeU32(fs, mimeTypes.length);
        int length = mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            this.writeU32(fs, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(fs, sources.size());
        for (Source s : sources) {
            this.writeU32(fs, this.addString(pool, s.getName()));
        }
    }

    private void writeSourceList(SourceList sourceList, Map<Object, Integer> pool, OutputStream sl) throws IOException {
        int i;
        String[] mimeTypes = sourceList.getMimeTypes();
        List<File> paths = sourceList.getPaths();
        Collection<Source> sources = sourceList.sources();
        this.writeU32(sl, mimeTypes.length);
        int length = mimeTypes.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sl, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(sl, paths.size());
        length = paths.size();
        for (i = 0; i < length; ++i) {
            this.writeU32(sl, this.addString(pool, FileUtil.getCanonicalPath(paths.get(i))));
        }
        this.writeU32(sl, sources.size());
        for (Source s : sources) {
            this.writeU32(sl, this.addString(pool, s.getName()));
        }
    }

    private void writeSourcePath(SourcePath sourcePath, Map<Object, Integer> pool, OutputStream sp) throws IOException {
        int i;
        String[] mimeTypes = sourcePath.getMimeTypes();
        List<File> paths = sourcePath.getPaths();
        Map<String, Source> sources = sourcePath.sources();
        this.writeU32(sp, mimeTypes.length);
        int length = mimeTypes.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(sp, paths.size());
        length = paths.size();
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, FileUtil.getCanonicalPath(paths.get(i))));
        }
        this.writeU32(sp, sources.size());
        for (String className : sources.keySet()) {
            Source s = sources.get(className);
            this.writeU32(sp, this.addString(pool, className));
            this.writeU32(sp, this.addString(pool, s.getName()));
        }
    }

    private void writeResourceBundlePath(ResourceBundlePath bundlePath, Map<Object, Integer> pool, OutputStream sp) throws IOException {
        int i;
        String[] mimeTypes = bundlePath.getMimeTypes();
        String[] locales = bundlePath.getLocales();
        Map<String, List<File>> rbDirectories = bundlePath.getResourceBundlePaths();
        Map<String, Source> sources = bundlePath.sources();
        this.writeU32(sp, mimeTypes.length);
        int length = mimeTypes.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, mimeTypes[i]));
        }
        this.writeU32(sp, locales == null ? 0 : locales.length);
        int n = length = locales == null ? 0 : locales.length;
        for (i = 0; i < length; ++i) {
            this.writeU32(sp, this.addString(pool, locales[i]));
            List<File> paths = rbDirectories.get(locales[i]);
            this.writeU32(sp, paths == null ? 0 : paths.size());
            int size = paths.size();
            for (int j = 0; j < size; ++j) {
                this.writeU32(sp, this.addString(pool, FileUtil.getCanonicalPath(paths.get(j))));
            }
        }
        this.writeU32(sp, sources.size());
        for (String bundleName : sources.keySet()) {
            Source s = sources.get(bundleName);
            this.writeU32(sp, this.addString(pool, bundleName));
            this.writeU32(sp, this.addString(pool, s.getName()));
            ResourceFile rf = (ResourceFile)s.getBackingFile();
            VirtualFile[] rFiles = rf.getResourceFiles();
            VirtualFile[] rRoots = rf.getResourcePathRoots();
            this.writeU32(sp, rFiles.length);
            int size = rFiles.length;
            for (int j = 0; j < size; ++j) {
                this.writeU32(sp, this.addString(pool, rFiles[j] != null ? rFiles[j].getName() : "null"));
                this.writeU32(sp, this.addString(pool, rRoots[j] != null ? rRoots[j].getName() : "null"));
            }
        }
    }

    private void writeCompilationUnits(Collection<Source> sources, Map<Object, Integer> pool, OutputStream src, OutputStream cu) throws IOException {
        for (Source s : sources) {
            this.writeSource(s, pool, src);
            CompilationUnit u = s.getCompilationUnit();
            if (u == null) continue;
            this.writeCompilationUnit(u, pool, cu);
        }
    }

    private void writeSource(Source s, Map<Object, Integer> pool, OutputStream src) throws IOException {
        int size;
        CompilationUnit unit = s.getCompilationUnit();
        boolean hasUnit = unit != null;
        this.writeU32(src, this.addString(pool, s.getName()));
        this.writeU32(src, this.addString(pool, s.getRelativePath()));
        this.writeU32(src, this.addString(pool, s.getShortName()));
        if (s.isFileSpecOwner()) {
            this.writeU8(src, 0);
        } else if (s.isSourceListOwner()) {
            this.writeU8(src, 1);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        } else if (s.isSourcePathOwner()) {
            this.writeU8(src, 2);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        } else if (s.isResourceContainerOwner()) {
            this.writeU8(src, 3);
        } else {
            this.writeU8(src, 4);
            this.writeU32(src, this.addString(pool, s.getPathRoot().getName()));
        }
        this.writeU8(src, s.isInternal() ? 1 : 0);
        this.writeU8(src, s.isRoot() ? 1 : 0);
        this.writeU8(src, s.isDebuggable() ? 1 : 0);
        this.writeU8(src, hasUnit ? 1 : 0);
        this.writeLong(src, s.getFileTime());
        boolean hasSignatureChecksum = hasUnit && unit.hasSignatureChecksum();
        this.writeU8(src, hasSignatureChecksum ? 1 : 0);
        if (hasSignatureChecksum) {
            Long signatureChecksum = unit.getSignatureChecksum();
            this.writeLong(src, signatureChecksum);
        }
        this.writeU32(src, s.getFileIncludeSize());
        Iterator<VirtualFile> j = s.getFileIncludes();
        while (j.hasNext()) {
            VirtualFile f = j.next();
            this.writeU32(src, this.addString(pool, f.getName()));
            this.writeLong(src, s.getFileIncludeTime(f));
        }
        List<LocalLogger.Warning> warnings = null;
        if (s.getLogger() != null && (warnings = s.getLogger().getWarnings()) != null) {
            this.writeU32(src, warnings.size());
        } else {
            this.writeU32(src, 0);
        }
        int n = size = warnings == null ? 0 : warnings.size();
        for (int i = 0; i < size; ++i) {
            LocalLogger.Warning w = warnings.get(i);
            this.writeU32(src, this.addString(pool, w.path == null ? "" : w.path));
            this.writeU32(src, this.addString(pool, w.warning == null ? "" : w.warning));
            this.writeU32(src, this.addString(pool, w.source == null ? "" : w.source));
            this.writeU32(src, w.line == null ? -1 : w.line);
            this.writeU32(src, w.col == null ? -1 : w.col);
            this.writeU32(src, w.errorCode == null ? -1 : w.errorCode);
        }
    }

    private void writeCompilationUnit(CompilationUnit u, Map<Object, Integer> pool, OutputStream cu) throws IOException {
        QName qName;
        this.writeU32(cu, this.addBytes(pool, u.bytes.toByteArray()));
        this.writeU32(cu, u.getWorkflow());
        this.writeU32(cu, u.getState());
        this.writeU32(cu, u.topLevelDefinitions.size());
        Iterator i = u.topLevelDefinitions.iterator();
        while (i.hasNext()) {
            this.writeU32(cu, this.addQName(pool, (QName)i.next()));
        }
        this.writeU32(cu, u.inheritanceHistory.size());
        for (MultiName multiName : u.inheritanceHistory.keySet()) {
            qName = u.inheritanceHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.typeHistory.size());
        for (MultiName multiName : u.typeHistory.keySet()) {
            qName = u.typeHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.namespaceHistory.size());
        for (MultiName multiName : u.namespaceHistory.keySet()) {
            qName = u.namespaceHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        this.writeU32(cu, u.expressionHistory.size());
        for (MultiName multiName : u.expressionHistory.keySet()) {
            qName = u.expressionHistory.get(multiName);
            this.writeU32(cu, this.addMultiName(pool, multiName));
            this.writeU32(cu, this.addQName(pool, qName));
        }
        if (u.auxGenerateInfo != null && u.auxGenerateInfo.size() > 0) {
            this.writeU8(cu, 1);
            String baseLoaderClass = (String)u.auxGenerateInfo.get("baseLoaderClass");
            this.writeU32(cu, this.addString(pool, baseLoaderClass == null ? "" : baseLoaderClass));
            String generateLoaderClass = (String)u.auxGenerateInfo.get("generateLoaderClass");
            this.writeU32(cu, this.addString(pool, generateLoaderClass == null ? "" : generateLoaderClass));
            String className = (String)u.auxGenerateInfo.get("windowClass");
            this.writeU32(cu, this.addString(pool, className == null ? "" : className));
            String preLoader = (String)u.auxGenerateInfo.get("preloaderClass");
            this.writeU32(cu, this.addString(pool, preLoader == null ? "" : preLoader));
            Boolean usePreloader = (Boolean)u.auxGenerateInfo.get("usePreloader");
            this.writeU8(cu, usePreloader != false ? 1 : 0);
            Map rootAttributeMap = (Map)u.auxGenerateInfo.get("rootAttributes");
            this.writeU32(cu, rootAttributeMap.size());
            for (String key : rootAttributeMap.keySet()) {
                String value = (String)rootAttributeMap.get(key);
                if (value != null) {
                    this.writeU32(cu, this.addString(pool, key));
                    this.writeU32(cu, this.addString(pool, value));
                    continue;
                }
                assert (false) : key + " can't be null.";
            }
        } else {
            this.writeU8(cu, 0);
        }
        this.writeAssets(u, pool, cu);
    }

    private void writeAssets(CompilationUnit u, Map<Object, Integer> pool, OutputStream cu) throws IOException {
        if (u.hasAssets()) {
            this.writeU32(cu, u.getAssets().count());
            Movie movie = new Movie();
            movie.version = this.configuration.getTargetPlayerMajorVersion();
            assert (movie.version >= 9);
            movie.size = new Rect(2000, 2000);
            movie.framerate = 12;
            Frame frame = new Frame();
            movie.frames = new ArrayList();
            movie.frames.add(frame);
            this.writeU32(cu, u.getAssets().count());
            Iterator<Map.Entry<String, AssetInfo>> i = u.getAssets().iterator();
            while (i.hasNext()) {
                Map.Entry<String, AssetInfo> entry = i.next();
                String className = entry.getKey();
                AssetInfo assetInfo = entry.getValue();
                this.writeU32(cu, this.addString(pool, className));
                if (assetInfo.getPath() != null) {
                    this.writeU32(cu, this.addString(pool, assetInfo.getPath().getName()));
                } else {
                    this.writeU32(cu, this.addString(pool, ""));
                }
                this.writeLong(cu, assetInfo.getCreationTime());
                DefineTag asset = assetInfo.getDefineTag();
                frame.addSymbolClass(className, asset);
                if (asset.name == null) continue;
                frame.addExport(asset);
            }
            TagEncoder handler = new TagEncoder();
            MovieEncoder encoder = new MovieEncoder((TagHandler)handler);
            encoder.export(movie);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            handler.writeTo((OutputStream)baos);
            this.writeU32(cu, baos.size());
            this.writeBytes(cu, baos.toByteArray());
        } else {
            this.writeU32(cu, 0);
        }
    }

    int read(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List<CompilationUnit> units, int[] checksums, Map<QName, Long> swcDefSignatureChecksums, Map<String, Long> swcFileChecksums, Map<String, Long> archiveFileChecksums) throws IOException {
        if (!this.readVersion()) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new ObsoleteCacheFileFormat()));
        }
        if (!this.readChecksum(checksums)) {
            return -1;
        }
        Object[] pool = this.readConstantPool();
        if (!this.readFileSpec(pool, fileSpec)) {
            return -2;
        }
        if (!this.readSourceList(pool, sourceList)) {
            return -3;
        }
        if (!this.readSourcePath(pool, sourcePath)) {
            return -4;
        }
        if (!this.readResourceBundlePath(pool, bundlePath)) {
            return -5;
        }
        HashMap<String, Object> owners = new HashMap<String, Object>();
        if (!this.readSourceNames(pool, sources, units, owners)) {
            return -6;
        }
        if (!this.readSwcDefSignatureChecksums(pool, swcDefSignatureChecksums)) {
            return -7;
        }
        if (!this.readFileChecksums(pool, swcFileChecksums)) {
            return -8;
        }
        if (!this.readFileChecksums(pool, archiveFileChecksums)) {
            return -9;
        }
        int count = this.readCompilationUnits(pool, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, owners);
        resources.refresh();
        return count;
    }

    private boolean readVersion() throws IOException {
        int major = this.readU32();
        int minor = this.readU32();
        return major == 4 && minor == 3;
    }

    private boolean readChecksum(int[] checksums) throws IOException {
        int targetChecksum = this.readU32();
        int targetCmdChecksum = this.readU32();
        int targetLinkerChecksum = this.readU32();
        int targetSwcChecksum = this.readU32();
        new String(this.readBytes(this.readU32()));
        boolean result = checksums[1] == targetCmdChecksum;
        checksums[0] = targetChecksum;
        checksums[1] = targetCmdChecksum;
        checksums[2] = targetLinkerChecksum;
        checksums[3] = targetSwcChecksum;
        return result;
    }

    private Object[] readConstantPool() throws IOException {
        this.readU32();
        Object[] pool = new Object[this.readU32()];
        block8: for (int i = 0; i < pool.length; ++i) {
            switch (this.readU8()) {
                case 1: {
                    pool[i] = new String(this.readBytes(this.readU32()), "UTF8");
                    continue block8;
                }
                case 2: {
                    String[] strings = new String[this.readU32()];
                    for (int j = 0; j < strings.length; ++j) {
                        strings[j] = (String)pool[this.readU32()];
                    }
                    pool[i] = strings;
                    continue block8;
                }
                case 3: {
                    pool[i] = this.readBytes(this.readU32());
                    continue block8;
                }
                case 4: {
                    pool[i] = new QName((String)pool[this.readU32()], (String)pool[this.readU32()]);
                    continue block8;
                }
                case 5: {
                    pool[i] = new MultiName((String[])pool[this.readU32()], (String)pool[this.readU32()]);
                    continue block8;
                }
                case 6: {
                    MetaData md = new MetaData((String)pool[this.readU32()], this.readU32());
                    for (int j = 0; j < md.count(); ++j) {
                        String key = (String)pool[this.readU32()];
                        if (key.length() > 0) {
                            md.setKeyValue(j, key, (String)pool[this.readU32()]);
                            continue;
                        }
                        md.setValue(j, (String)pool[this.readU32()]);
                    }
                    pool[i] = md;
                    continue block8;
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
        return pool;
    }

    private boolean readSourceNames(Object[] pool, List<Object> sources, List<CompilationUnit> units, Map<String, Object> owners) throws IOException {
        int size = this.readU32();
        if (sources != null) {
            sources.clear();
        }
        if (units != null) {
            units.clear();
        }
        for (int i = 0; i < size; ++i) {
            String name = (String)pool[this.readU32()];
            if (!"null".equals(name)) {
                owners.put(name, new Integer(this.readU8()));
                if (sources != null) {
                    sources.add(name);
                }
            } else if (sources != null) {
                sources.add(null);
            }
            if (units == null) continue;
            units.add(null);
        }
        return true;
    }

    private boolean readSwcDefSignatureChecksums(Object[] pool, Map<QName, Long> swcDefSignatureChecksums) throws IOException {
        int size = this.readU32();
        for (int i = 0; i < size; ++i) {
            QName qName = (QName)pool[this.readU32()];
            long ts = this.readLong();
            if (swcDefSignatureChecksums == null) continue;
            swcDefSignatureChecksums.put(qName, new Long(ts));
        }
        return true;
    }

    private boolean readFileChecksums(Object[] pool, Map<String, Long> m) throws IOException {
        int size = this.readU32();
        for (int i = 0; i < size; ++i) {
            String fileName = (String)pool[this.readU32()];
            long ts = this.readLong();
            if (m == null) continue;
            m.put(fileName, new Long(ts));
        }
        return true;
    }

    private boolean readFileSpec(Object[] pool, FileSpec fileSpec) throws IOException {
        int size = this.readU32();
        if (size > 0 && fileSpec == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoFileSpec()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        for (int i = 0; i < length; ++i) {
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = fileSpec.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        Collection<Source> c = fileSpec.sources();
        if (c.size() == sources.length) {
            Iterator<Source> it = c.iterator();
            for (int i = 0; it.hasNext() && i < sources.length; ++i) {
                Source s = it.next();
                if (s.getName().equals(sources[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean readSourceList(Object[] pool, SourceList sourceList) throws IOException {
        int size = this.readU32();
        if (size > 0 && sourceList == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoSourceList()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] paths = new String[length];
        for (int i = 0; i < length; ++i) {
            paths[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        for (int i = 0; i < length; ++i) {
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = sourceList.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        Collection<Source> c = sourceList.sources();
        if (c.size() == sources.length) {
            Iterator<Source> it = c.iterator();
            for (int i = 0; it.hasNext() && i < sources.length; ++i) {
                Source s = it.next();
                if (s.getName().equals(sources[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean readSourcePath(Object[] pool, SourcePath sourcePath) throws IOException {
        int size = this.readU32();
        if (size > 0 && sourcePath == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoSourcePath()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] paths = new String[length];
        for (int i = 0; i < length; ++i) {
            paths[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] sources = new String[length];
        String[] classNames = new String[length];
        for (int i = 0; i < length; ++i) {
            classNames[i] = (String)pool[this.readU32()];
            sources[i] = (String)pool[this.readU32()];
        }
        String[] targetMimeTypes = sourcePath.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        List<File> targetPaths = sourcePath.getPaths();
        length = targetPaths.size();
        if (length == paths.length) {
            for (int i = 0; i < length; ++i) {
                if (paths[i].equals(FileUtil.getCanonicalPath(targetPaths.get(i)))) continue;
                return false;
            }
        } else {
            return false;
        }
        Map<String, Source> c = sourcePath.sources();
        for (int i = 0; i < classNames.length; ++i) {
            c.put(classNames[i], (Source)((Object)sources[i]));
        }
        return true;
    }

    private boolean readResourceBundlePath(Object[] pool, ResourceBundlePath bundlePath) throws IOException {
        int size = this.readU32();
        if (size > 0 && bundlePath == null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new IOException(l10n.getLocalizedTextString((Object)new NoSourcePath()));
        }
        if (size == 0) {
            return true;
        }
        int length = this.readU32();
        String[] mimeTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            mimeTypes[i] = (String)pool[this.readU32()];
        }
        length = this.readU32();
        String[] locales = new String[length];
        HashMap<String, String[]> rbDirectories = new HashMap<String, String[]>();
        for (int i = 0; i < length; ++i) {
            locales[i] = (String)pool[this.readU32()];
            size = this.readU32();
            String[] paths = new String[size];
            for (int j = 0; j < size; ++j) {
                paths[j] = (String)pool[this.readU32()];
            }
            rbDirectories.put(locales[i], paths);
        }
        length = this.readU32();
        String[] bundleNames = new String[length];
        String[] sources = new String[length];
        String[] list = null;
        String[] list2 = null;
        Object[] rFiles = new Object[length];
        Object[] rRoots = new Object[length];
        for (int i = 0; i < length; ++i) {
            bundleNames[i] = (String)pool[this.readU32()];
            sources[i] = (String)pool[this.readU32()];
            size = this.readU32();
            rFiles[i] = list = new String[size];
            rRoots[i] = list2 = new String[size];
            for (int j = 0; j < size; ++j) {
                list[j] = (String)pool[this.readU32()];
                if ("null".equals(list[j])) {
                    list[j] = null;
                }
                list2[j] = (String)pool[this.readU32()];
                if (!"null".equals(list2[j])) continue;
                list2[j] = null;
            }
        }
        String[] targetMimeTypes = bundlePath.getMimeTypes();
        length = targetMimeTypes.length;
        if (length == mimeTypes.length) {
            for (int i = 0; i < length; ++i) {
                if (mimeTypes[i].equals(targetMimeTypes[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        String[] targetLocales = bundlePath.getLocales();
        length = targetLocales.length;
        if (length == locales.length) {
            for (int i = 0; i < length; ++i) {
                if (locales[i].equals(targetLocales[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        Map<String, List<File>> targetRBDirectories = bundlePath.getResourceBundlePaths();
        size = targetRBDirectories.size();
        if (size == rbDirectories.size()) {
            for (int i = 0; i < size; ++i) {
                List<File> targetPaths = targetRBDirectories.get(targetLocales[i]);
                String[] paths = (String[])rbDirectories.get(locales[i]);
                length = targetPaths.size();
                if (length == paths.length) {
                    for (int j = 0; j < length; ++j) {
                        if (paths[j].equals(FileUtil.getCanonicalPath(targetPaths.get(j)))) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        Map<String, Source> c = bundlePath.sources();
        assert (c.size() == 0);
        for (int i = 0; i < bundleNames.length; ++i) {
            c.put(bundleNames[i], (Source)new Object[]{sources[i], rFiles[i], rRoots[i]});
        }
        return true;
    }

    private int readCompilationUnits(Object[] pool, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List<Object> sources, List<CompilationUnit> units, Map<String, Object> owners) throws IOException {
        int len;
        int i;
        int src_count = this.readU32();
        int src_size = this.readU32();
        int cu_size = this.readU32();
        ByteArrayInputStream src_in = new ByteArrayInputStream(this.readBytes(src_size));
        ByteArrayInputStream cu_in = new ByteArrayInputStream(this.readBytes(cu_size));
        Map<String, Source> m = sourcePath.sources();
        HashMap<String, String> mappings = new HashMap<String, String>();
        HashMap<String, Object> rbMappings = new HashMap<String, Object>();
        for (String className : m.keySet()) {
            String fileName = (String)((Object)m.get(className));
            mappings.put(fileName, className);
        }
        m.clear();
        m = bundlePath.sources();
        for (String className : m.keySet()) {
            Object[] value = (Object[])m.get(className);
            String fileName = (String)value[0];
            String[] rFiles = (String[])value[1];
            String[] rRoots = (String[])value[2];
            rbMappings.put(fileName, new Object[]{className, rFiles, rRoots});
        }
        m.clear();
        for (i = 0; i < src_count; ++i) {
            this.readCompilationUnit(pool, mappings, rbMappings, src_in, cu_in, fileSpec, sourceList, sourcePath, resources, bundlePath, owners);
        }
        int n = len = sources == null ? 0 : sources.size();
        for (i = 0; i < len; ++i) {
            String n2 = (String)sources.get(i);
            Object obj = owners.get(n2);
            if (!(obj instanceof Source)) continue;
            Source s = (Source)obj;
            sources.set(i, s);
            units.set(i, s.getCompilationUnit());
        }
        return src_count;
    }

    private void readCompilationUnit(Object[] pool, Map<String, String> mappings, Map<String, Object> rbMappings, InputStream src_in, InputStream cu_in, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, Map<String, Object> owners) throws IOException {
        PathResolver resolver = ThreadLocalToolkit.getPathResolver();
        String name = (String)pool[this.readU32(src_in)];
        String relativePath = (String)pool[this.readU32(src_in)];
        String shortName = (String)pool[this.readU32(src_in)];
        int owner = this.readU8(src_in);
        VirtualFile pathRoot = null;
        if (owner == 1 || owner == 2 || owner == 4) {
            pathRoot = resolver.resolve((String)pool[this.readU32(src_in)]);
        }
        boolean isInternal = this.readU8(src_in) == 1;
        boolean isRoot = this.readU8(src_in) == 1;
        boolean isDebuggable = this.readU8(src_in) == 1;
        boolean hasUnit = this.readU8(src_in) == 1;
        long fileTime = this.readLong(src_in);
        boolean hasSignatureChecksum = this.readU8(src_in) == 1;
        Long signatureChecksum = null;
        if (hasSignatureChecksum) {
            assert (hasUnit);
            signatureChecksum = new Long(this.readLong(src_in));
        }
        int size = this.readU32(src_in);
        HashSet<VirtualFile> includes = new HashSet<VirtualFile>(1);
        HashMap<VirtualFile, Long> includeTimes = new HashMap<VirtualFile, Long>(1);
        for (int i = 0; i < size; ++i) {
            String fileName = (String)pool[this.readU32(src_in)];
            VirtualFile f = resolver.resolve(fileName);
            long ts = this.readLong(src_in);
            if (f == null) {
                f = new DeletedFile(fileName);
            }
            includes.add(f);
            includeTimes.put(f, new Long(ts));
        }
        size = this.readU32(src_in);
        LocalLogger logger = size == 0 ? null : new LocalLogger(null);
        for (int i = 0; i < size; ++i) {
            String source;
            String warning;
            String path = (String)pool[this.readU32(src_in)];
            if (path.length() == 0) {
                path = null;
            }
            if ((warning = (String)pool[this.readU32(src_in)]).length() == 0) {
                warning = null;
            }
            if ((source = (String)pool[this.readU32(src_in)]).length() == 0) {
                source = null;
            }
            int line = this.readU32(src_in);
            int col = this.readU32(src_in);
            int errorCode = this.readU32(src_in);
            logger.recordWarning(path, line == -1 ? null : IntegerPool.getNumber((int)line), col == -1 ? null : IntegerPool.getNumber((int)col), warning, source, errorCode == -1 ? null : IntegerPool.getNumber((int)errorCode));
        }
        byte[] abc = hasUnit ? (byte[])pool[this.readU32(cu_in)] : null;
        Source s2 = null;
        if (owner == 0) {
            Collection<Source> c = fileSpec.sources();
            for (Source s2 : c) {
                if (!s2.getName().equals(name)) continue;
                Source.populateSource(s2, fileTime, pathRoot, relativePath, shortName, fileSpec, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                break;
            }
        } else if (owner == 1) {
            Collection<Source> c = sourceList.sources();
            for (Source s2 : c) {
                if (!s2.getName().equals(name)) continue;
                Source.populateSource(s2, fileTime, pathRoot, relativePath, shortName, sourceList, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                break;
            }
        } else if (owner == 2) {
            Map<String, Source> c = sourcePath.sources();
            String className = mappings.get(name);
            if (className != null) {
                VirtualFile f = resolver.resolve(name);
                if (f == null) {
                    f = new DeletedFile(name);
                }
                s2 = Source.newSource(f, fileTime, pathRoot, relativePath, shortName, sourcePath, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                c.put(className, s2);
            } else assert (false) : name;
        } else if (owner == 3) {
            if (resources == null) {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                throw new IOException(l10n.getLocalizedTextString((Object)new NoResourceContainer()));
            }
            s2 = Source.newSource(abc, name, fileTime, pathRoot, relativePath, shortName, resources, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
            s2 = resources.addResource(s2);
        } else {
            Map<String, Source> c = bundlePath.sources();
            Object[] value = (Object[])rbMappings.get(name);
            String bundleName = (String)value[0];
            String[] rNames = (String[])value[1];
            String[] rRoots = (String[])value[2];
            if (bundleName != null) {
                VirtualFile[] rFiles = new VirtualFile[rNames.length];
                for (int i = 0; i < rFiles.length; ++i) {
                    if (rNames[i] == null) continue;
                    rFiles[i] = resolver.resolve(rNames[i]);
                    if (rFiles[i] != null) continue;
                    rFiles[i] = new DeletedFile(rNames[i]);
                }
                VirtualFile[] rRootFiles = new VirtualFile[rRoots.length];
                for (int i = 0; i < rRootFiles.length; ++i) {
                    if (rRoots[i] == null) continue;
                    rRootFiles[i] = resolver.resolve(rRoots[i]);
                    if (rRootFiles[i] != null) continue;
                    rRootFiles[i] = new DeletedFile(rRoots[i]);
                }
                ResourceFile f = new ResourceFile(name, bundlePath.getLocales(), rFiles, rRootFiles);
                s2 = Source.newSource(f, fileTime, pathRoot, relativePath, shortName, bundlePath, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
                c.put(bundleName, s2);
            } else assert (false) : name;
        }
        if (logger != null) {
            logger.setSource(s2);
        }
        if (hasUnit) {
            boolean hasAuxGenerateInfo;
            int i;
            CompilationUnit u = s2.newCompilationUnit(null, new CompilerContext());
            u.setSignatureChecksum(signatureChecksum);
            u.bytes.addAll(abc);
            u.setWorkflow(this.readU32(cu_in));
            u.setState(this.readU32(cu_in));
            size = this.readU32(cu_in);
            for (i = 0; i < size; ++i) {
                u.topLevelDefinitions.add((QName)pool[this.readU32(cu_in)]);
            }
            size = this.readU32(cu_in);
            for (i = 0; i < size; ++i) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.inheritanceHistory.put(mName, qName);
                u.inheritance.add(qName);
            }
            size = this.readU32(cu_in);
            for (i = 0; i < size; ++i) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.typeHistory.put(mName, qName);
                u.types.add(qName);
            }
            size = this.readU32(cu_in);
            for (i = 0; i < size; ++i) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.namespaceHistory.put(mName, qName);
                u.namespaces.add(qName);
            }
            size = this.readU32(cu_in);
            for (i = 0; i < size; ++i) {
                MultiName mName = (MultiName)pool[this.readU32(cu_in)];
                QName qName = (QName)pool[this.readU32(cu_in)];
                u.expressionHistory.put(mName, qName);
                u.expressions.add(qName);
            }
            boolean bl = hasAuxGenerateInfo = this.readU8(cu_in) == 1;
            if (hasAuxGenerateInfo) {
                u.auxGenerateInfo = new HashMap<String, Object>();
                String baseLoaderClass = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("baseLoaderClass", baseLoaderClass.length() > 0 ? baseLoaderClass : null);
                String generateLoaderClass = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("generateLoaderClass", generateLoaderClass.length() > 0 ? generateLoaderClass : null);
                String className = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("windowClass", className.length() > 0 ? className : null);
                String preLoader = (String)pool[this.readU32(cu_in)];
                u.auxGenerateInfo.put("preloaderClass", preLoader.length() > 0 ? preLoader : null);
                u.auxGenerateInfo.put("usePreloader", new Boolean(this.readU8(cu_in) == 1));
                HashMap<String, String> rootAttributeMap = new HashMap<String, String>();
                u.auxGenerateInfo.put("rootAttributes", rootAttributeMap);
                size = this.readU32(cu_in);
                for (int i2 = 0; i2 < size; ++i2) {
                    String key = (String)pool[this.readU32(cu_in)];
                    String value = (String)pool[this.readU32(cu_in)];
                    rootAttributeMap.put(key, value);
                }
            }
            this.readAssets(pool, u, cu_in);
        }
        if (s2 != null) {
            name = s2.getName();
            Object obj = owners.get(name);
            if (obj == null || obj instanceof Source) {
                return;
            }
            int value = (Integer)obj;
            if (s2.isFileSpecOwner() && value == 0 || s2.isSourceListOwner() && value == 1 || s2.isSourcePathOwner() && value == 2 || s2.isResourceContainerOwner() && value == 3 || s2.isResourceBundlePathOwner() && value == 4) {
                owners.put(name, s2);
            }
        }
    }

    private void readAssets(Object[] pool, CompilationUnit u, InputStream cu_in) throws IOException {
        int size = this.readU32(cu_in);
        if (size > 0) {
            int assetCount = this.readU32(cu_in);
            HashMap<String, AssetInfo> assets = new HashMap<String, AssetInfo>();
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            for (int i = 0; i < assetCount; ++i) {
                String className = (String)pool[this.readU32(cu_in)];
                String pathName = (String)pool[this.readU32(cu_in)];
                VirtualFile f = null;
                if (pathName.length() == 0) {
                    f = null;
                } else {
                    f = resolver.resolve(pathName);
                    if (f == null) {
                        f = new DeletedFile(pathName);
                    }
                }
                assets.put(className, new AssetInfo(null, f, this.readLong(cu_in), null));
            }
            int swfSize = this.readU32(cu_in);
            ByteArrayInputStream in = new ByteArrayInputStream(this.readBytes(cu_in, swfSize));
            Movie movie = new Movie();
            MovieDecoder movieDecoder = new MovieDecoder(movie);
            TagDecoder tagDecoder = new TagDecoder((InputStream)in);
            tagDecoder.parse((TagHandler)movieDecoder);
            for (Frame frame : movie.frames) {
                for (Map.Entry e : frame.symbolClass.class2tag.entrySet()) {
                    String className = (String)e.getKey();
                    DefineTag tag = (DefineTag)e.getValue();
                    AssetInfo assetInfo = (AssetInfo)assets.get(className);
                    assetInfo.setDefineTag(tag);
                    u.getAssets().add(className, assetInfo);
                    if (this.fontManager == null || !(tag instanceof DefineFont)) continue;
                    VirtualFile f = assetInfo.getPath();
                    String path = null;
                    if (f != null) {
                        path = f.getURL();
                    }
                    this.fontManager.loadDefineFont((DefineFont)tag, (Object)path);
                }
            }
        }
    }

    private int addObject(Map<Object, Integer> pool, Object obj) {
        assert (obj != null);
        Integer index = pool.get(obj);
        if (index == null) {
            index = IntegerPool.getNumber((int)pool.size());
            pool.put(obj, index);
        }
        return index;
    }

    private int addBytes(Map<Object, Integer> pool, byte[] b) {
        return this.addObject(pool, b);
    }

    private int addString(Map<Object, Integer> pool, String s) {
        return this.addObject(pool, s);
    }

    private int addStrings(Map<Object, Integer> pool, String[] array) {
        assert (array != null);
        ArrayKey.access$002(this.key, array);
        Integer index = pool.get(this.key);
        if (index == null) {
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                this.addString(pool, array[i]);
            }
            index = IntegerPool.getNumber((int)pool.size());
            pool.put(new ArrayKey(array), index);
        }
        return index;
    }

    private int addQName(Map<Object, Integer> pool, QName qName) {
        assert (qName != null);
        Integer index = pool.get(qName);
        if (index == null) {
            this.addString(pool, qName.getNamespace());
            this.addString(pool, qName.getLocalPart());
            index = IntegerPool.getNumber((int)pool.size());
            pool.put(qName, index);
        }
        return index;
    }

    private int addMultiName(Map<Object, Integer> pool, MultiName multiName) {
        assert (multiName != null);
        Integer index = pool.get(multiName);
        if (index == null) {
            this.addStrings(pool, multiName.namespaceURI);
            this.addString(pool, multiName.localPart);
            index = IntegerPool.getNumber((int)pool.size());
            pool.put(multiName, index);
        }
        return index;
    }

    private void writeBytes(OutputStream out, byte[] b) throws IOException {
        out.write(b);
    }

    private void writeLong(OutputStream out, long num) throws IOException {
        out.write((int)(num >>> 56) & 0xFF);
        out.write((int)(num >>> 48) & 0xFF);
        out.write((int)(num >>> 40) & 0xFF);
        out.write((int)(num >>> 32) & 0xFF);
        out.write((int)(num >>> 24) & 0xFF);
        out.write((int)(num >>> 16) & 0xFF);
        out.write((int)(num >>> 8) & 0xFF);
        out.write((int)num & 0xFF);
    }

    private void writeU32(OutputStream out, int num) throws IOException {
        out.write(num >>> 24 & 0xFF);
        out.write(num >>> 16 & 0xFF);
        out.write(num >>> 8 & 0xFF);
        out.write(num & 0xFF);
    }

    private void writeU8(OutputStream out, int num) throws IOException {
        out.write(num & 0xFF);
    }

    private byte[] readBytes(int length) throws IOException {
        byte[] b = new byte[length];
        this.file.readFully(b);
        return b;
    }

    private int readU32() throws IOException {
        return this.file.readInt();
    }

    private int readU8() throws IOException {
        return this.file.read();
    }

    private byte[] readBytes(InputStream in, int length) throws IOException {
        byte[] b = new byte[length];
        int size = 0;
        int start = 0;
        int len = length - size;
        while ((size = in.read(b, start, len)) != -1 && start + size < length) {
            start += size;
            len -= size;
        }
        return b;
    }

    private long readLong() throws IOException {
        return ((long)this.readU32() << 32) + ((long)this.readU32() & 0xFFFFFFFFL);
    }

    private long readLong(InputStream in) throws IOException {
        return ((long)this.readU32(in) << 32) + ((long)this.readU32(in) & 0xFFFFFFFFL);
    }

    private int readU32(InputStream in) throws IOException {
        return (in.read() << 24) + (in.read() << 16) + (in.read() << 8) + in.read();
    }

    private int readU8(InputStream in) throws IOException {
        return in.read();
    }

    public static class NoResourceContainer
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -384784734412773490L;
    }

    public static class NoSourcePath
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -4989314191998065597L;
    }

    public static class NoSourceList
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 1489613684797688310L;
    }

    public static class NoFileSpec
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -5780228997078423591L;
    }

    public static class ObsoleteCacheFileFormat
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8594915455219662842L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MetaData
    implements flex2.compiler.abc.MetaData {
        private String id;
        private String[] keys;
        private String[] values;

        public MetaData(String id, int count) {
            this.id = id;
            this.keys = new String[count];
            this.values = new String[count];
        }

        @Override
        public String getID() {
            return this.id;
        }

        public void setValue(int index, String value) {
            this.values[index] = value;
        }

        public void setKeyValue(int index, String key, String value) {
            this.keys[index] = key;
            this.values[index] = value;
        }

        @Override
        public String getKey(int index) {
            if (index < 0 || index >= this.count()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.keys[index];
        }

        @Override
        public String getValue(String key) {
            int length = this.count();
            for (int i = 0; i < length; ++i) {
                if (!key.equals(this.keys[i])) continue;
                return this.values[i];
            }
            return null;
        }

        @Override
        public String getValue(int index) {
            if (index < 0 || index >= this.count()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.values[index];
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            int length = this.count();
            for (int i = 0; i < length; ++i) {
                result.put(this.keys[i], this.values[i]);
            }
            return result;
        }

        @Override
        public int count() {
            return this.values != null ? this.values.length : 0;
        }
    }

    private class ArrayKey {
        private String[] a1;

        ArrayKey() {
        }

        ArrayKey(String[] array) {
            this.a1 = array;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ArrayKey) {
                String[] a2 = ((ArrayKey)obj).a1;
                if (this.a1 == a2) {
                    return true;
                }
                if (this.a1.length != a2.length) {
                    return false;
                }
                int size = this.a1.length;
                for (int i = 0; i < size; ++i) {
                    if (this.a1[i].equals(a2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int c = 0;
            int size = this.a1.length;
            for (int i = 0; i < size; ++i) {
                c = i == 0 ? this.a1[i].hashCode() : c ^ this.a1[i].hashCode();
            }
            return c;
        }

        static /* synthetic */ String[] access$002(ArrayKey x0, String[] x1) {
            x0.a1 = x1;
            return x1;
        }
    }
}

