/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.InputBuffer;

public class CodeFragmentsInputBuffer
extends InputBuffer {
    private List<CodeFragment> codeFragments = new ArrayList<CodeFragment>();
    private int length = 1;
    private Map<Integer, Integer> positionToLineNumberMap = new HashMap<Integer, Integer>();

    public CodeFragmentsInputBuffer(String path) {
        this.origin = path;
    }

    public void addCodeFragment(int fragmentLength, InputBuffer inputBuffer, int lineNumberOffset) {
        int startPosition = this.length;
        int endPosition = this.length + fragmentLength;
        this.codeFragments.add(new CodeFragment(startPosition, endPosition, inputBuffer, lineNumberOffset - 1));
        this.length = endPosition;
    }

    public int getColPos(int pos) {
        return -1;
    }

    public int getColPos(int pos, int lineNumber) {
        return -1;
    }

    public int getLnNum(int pos) {
        int result = -1;
        Integer lineNumber = this.positionToLineNumberMap.get(pos);
        if (lineNumber != null) {
            result = lineNumber;
        } else {
            CodeFragment codeFragment = this.lookupCodeFragment(pos);
            if (codeFragment != null) {
                int codeFragmentLineNumber = codeFragment.inputBuffer.getLnNum(pos);
                result = codeFragmentLineNumber + codeFragment.lineNumberOffset;
            }
        }
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public String getLineText(int pos) {
        String result = null;
        CodeFragment codeFragment = this.lookupCodeFragment(pos);
        if (codeFragment != null) {
            result = codeFragment.inputBuffer.getLineText(pos - codeFragment.startPosition);
        }
        return result;
    }

    private CodeFragment lookupCodeFragment(int pos) {
        CodeFragment result = null;
        if (pos != -1) {
            for (CodeFragment codeFragment : this.codeFragments) {
                if (codeFragment.startPosition > pos || pos >= codeFragment.endPosition) continue;
                result = codeFragment;
                break;
            }
        }
        return result;
    }

    public int positionOfMark() {
        return 0;
    }

    public void addLineNumber(int lineNumber) {
        this.positionToLineNumberMap.put(this.length++, lineNumber);
    }

    public static class CodeFragment {
        public int startPosition;
        public int endPosition;
        public InputBuffer inputBuffer;
        public int lineNumberOffset;

        public CodeFragment(int startPosition, int endPosition, InputBuffer inputBuffer, int lineNumberOffset) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.inputBuffer = inputBuffer;
            this.lineNumberOffset = lineNumberOffset;
        }
    }
}

