/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util.graph;

import flex2.compiler.util.graph.Edge;
import flex2.compiler.util.graph.Graph;
import flex2.compiler.util.graph.Vertex;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraph<EdgeWeight>
extends Graph<String, EdgeWeight> {
    private Map<String, EdgeWeight> map = new HashMap<String, EdgeWeight>(300);
    private Map<String, Vertex<String, EdgeWeight>> vertices = new HashMap<String, Vertex<String, EdgeWeight>>(300);

    public void put(String key, EdgeWeight value) {
        this.map.put(key, value);
    }

    public EdgeWeight get(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsVertex(String key) {
        return this.vertices.containsKey(key);
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
        this.vertices.clear();
    }

    @Override
    public void addVertex(Vertex<String, EdgeWeight> v) {
        super.addVertex(v);
        this.vertices.put(v.getWeight(), v);
    }

    public Vertex<String, EdgeWeight> getVertex(String weight) {
        return this.vertices.get(weight);
    }

    public void removeVertex(String weight) {
        Vertex<String, EdgeWeight> v = this.vertices.remove(weight);
        if (v != null) {
            super.removeVertex(v);
        }
    }

    public void addDependency(String name, String dep) {
        Vertex<String, EdgeWeight> tail = null;
        Vertex<String, EdgeWeight> head = null;
        head = this.vertices.get(name);
        if (head == null) {
            head = new Vertex(name);
            this.addVertex(head);
        }
        if ((tail = this.vertices.get(dep)) == null) {
            tail = new Vertex(dep);
            this.addVertex(tail);
        }
        this.addEdge(new Edge<String, Object>(tail, head, null));
    }

    public boolean dependencyExists(String name, String dep) {
        Vertex<String, EdgeWeight> tail = null;
        Vertex<String, EdgeWeight> head = null;
        head = this.vertices.get(name);
        if (head == null) {
            return false;
        }
        tail = this.vertices.get(dep);
        if (tail == null) {
            return false;
        }
        Set<Vertex<String, EdgeWeight>> predecessors = head.getPredecessors();
        if (predecessors != null) {
            return predecessors.contains(tail);
        }
        return false;
    }

    public Set<String> getDependencies(String name) {
        Vertex<String, EdgeWeight> head = null;
        head = this.vertices.get(name);
        if (head == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        Set<Vertex<String, EdgeWeight>> predecessors = head.getPredecessors();
        if (predecessors != null) {
            for (Vertex<String, EdgeWeight> pred : predecessors) {
                dependencies.add(pred.getWeight());
            }
        }
        return dependencies;
    }
}

