/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.asdoc.ClassTable;
import flex2.compiler.asdoc.ComparatorImpl;
import flex2.compiler.asdoc.TopLevelGenerator;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ASDocExtension
implements Extension {
    private static String EXCLUDE_CLASS = "ExcludeClass";
    private StringBuilder out;
    private String xml;
    private List excludeClasses;
    private Set includeOnly;
    private Set packages;
    private ClassTable tab;

    public ASDocExtension(List excludeClasses, Set includeOnly, Set packages, boolean restoreBuiltinClasses) {
        this.excludeClasses = excludeClasses;
        this.includeOnly = includeOnly;
        this.packages = packages;
        this.tab = new ClassTable(restoreBuiltinClasses);
    }

    public void finish(boolean restoreBuiltinClasses) {
        TopLevelGenerator g = new TopLevelGenerator();
        g.generate(this.tab);
        this.xml = ((Object)g).toString();
        g = null;
        if (restoreBuiltinClasses && this.xml != null) {
            this.xml = this.xml.replaceAll("_ASDoc2", "");
            this.xml = this.xml.replaceAll("_ASDoc", "");
            this.xml = this.xml.replaceAll("Infinity_Neg_Inf", "-Infinity");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveFile(File file) {
        BufferedOutputStream outputStream = null;
        try {
            try {
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(this.xml.getBytes("UTF-8"));
                outputStream.flush();
            }
            catch (IOException ex) {
                if (!Trace.error) throw new RuntimeException("Could not save " + file + ": " + ex);
                ex.printStackTrace();
                throw new RuntimeException("Could not save " + file + ": " + ex);
            }
            Object var5_3 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (Trace.asdoc) {
                System.out.println("Wrote doc file: " + file);
            }
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        outputStream.close();
        return;
    }

    public String getXML() {
        return this.xml;
    }

    public void parse1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void parse2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    public void generate(CompilationUnit unit, TypeTable typeTable) {
        String n;
        CompilerContext flexCx = unit.getContext();
        Context cx = flexCx.getAscContext();
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        if (unit.topLevelDefinitions.first() == null) {
            return;
        }
        String className = NameFormatter.toDot(unit.topLevelDefinitions.first());
        boolean exclude = false;
        if (this.includeOnly != null && !this.includeOnly.contains(className)) {
            exclude = true;
        } else if (this.excludeClasses.contains(className)) {
            this.excludeClasses.remove(className);
            exclude = true;
        } else if (unit.metadata != null) {
            for (MetaDataNode metaDataNode : unit.metadata) {
                if (!EXCLUDE_CLASS.equals(metaDataNode.id)) continue;
                exclude = true;
                break;
            }
        }
        TreeSet<QName> inheritance = new TreeSet<QName>(new ComparatorImpl());
        for (Name name : unit.inheritance) {
            if (!(name instanceof QName)) continue;
            inheritance.add((QName)name);
        }
        boolean flag = false;
        if (!exclude && !unit.getSource().isInternal()) {
            if (Trace.asdoc) {
                System.out.println("Generating XML for " + unit.getSource().getName());
            }
            flag = false;
        } else {
            if (Trace.asdoc) {
                System.out.println("Skipping generating XML for " + unit.getSource().getName());
            }
            flag = true;
        }
        if (this.packages.size() != 0 && (n = unit.topLevelDefinitions.first().getNamespace()) != null) {
            this.packages.remove(n);
        }
        cx.pushScope(node.frame);
        MetaDataEvaluator printer = new MetaDataEvaluator();
        node.evaluate(cx, (Evaluator)printer);
        ObjectList comments = printer.doccomments;
        AbcClass abcClass = typeTable.getClass(unit.topLevelDefinitions.first().toString());
        this.tab.addComments(unit.topLevelDefinitions.first(), (List)comments, inheritance, flag, cx, abcClass);
        cx.popScope();
    }
}

